/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springboot.autoconfigure.data.jest;

import com.github.vanroy.springboot.autoconfigure.data.jest.ElasticsearchJestProperties;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ElasticsearchJestProperties.class, ElasticsearchProperties.class})
public class ElasticsearchJestAutoConfiguration
implements DisposableBean {
    private static final Log logger = LogFactory.getLog(ElasticsearchJestAutoConfiguration.class);
    private static final String INTERNAL_TEST_CLUSTER_NAME = "internal-test-cluster-name";
    @Autowired
    private ElasticsearchJestProperties properties;
    @Autowired(required=false)
    private ElasticsearchProperties esNodeproperties;
    private Releasable releasable;

    @Bean
    @ConditionalOnMissingBean(value={JestClient.class})
    @ConditionalOnMissingClass(value={"org.elasticsearch.node.Node"})
    public JestClient client() {
        return this.createJestClient(this.properties.getUri());
    }

    @Bean
    @ConditionalOnMissingBean(value={JestClient.class})
    @ConditionalOnClass(value={Node.class})
    public JestClient testClient() {
        if (StringUtils.isEmpty((Object)this.properties.getUri())) {
            int httpPort = this.createInternalNode();
            return this.createJestClient("http://localhost:" + httpPort);
        }
        return this.createJestClient(this.properties.getUri());
    }

    private JestClient createJestClient(String uri) {
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(uri).maxTotalConnection(this.properties.getMaxTotalConnection()).defaultMaxTotalConnectionPerRoute(this.properties.getDefaultMaxTotalConnectionPerRoute()).readTimeout(this.properties.getReadTimeout())).multiThreaded(this.properties.getMultiThreaded().booleanValue());
        if (StringUtils.hasText((String)this.properties.getUsername())) {
            builder.defaultCredentials(this.properties.getUsername(), this.properties.getPassword());
        }
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(builder.build());
        return factory.getObject();
    }

    private int createInternalNode() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Create test ES node");
        }
        int port = SocketUtils.findAvailableTcpPort();
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put("http.enabled", String.valueOf(true)).put("http.port", String.valueOf(port));
        String clusterName = INTERNAL_TEST_CLUSTER_NAME + UUID.randomUUID();
        if (this.esNodeproperties != null) {
            settings.put(this.esNodeproperties.getProperties());
            clusterName = this.esNodeproperties.getClusterName();
        }
        this.releasable = new NodeBuilder().settings((Settings.Builder)settings).clusterName(clusterName).local(true).node();
        return port;
    }

    public void destroy() throws Exception {
        block6: {
            if (this.releasable != null) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Closing Elasticsearch client");
                    }
                    try {
                        this.releasable.close();
                    }
                    catch (NoSuchMethodError var2) {
                        ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(Releasable.class, (String)"release"), (Object)this.releasable);
                    }
                }
                catch (Exception var3) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error((Object)"Error closing Elasticsearch client: ", (Throwable)var3);
                }
            }
        }
    }
}

