/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springboot.autoconfigure.data.jest;

import com.github.vanroy.springboot.autoconfigure.data.jest.ElasticsearchJestProperties;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.Version;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.plugins.Plugin;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ElasticsearchJestProperties.class, ElasticsearchProperties.class})
public class ElasticsearchJestAutoConfiguration
implements DisposableBean {
    private static final Log logger = LogFactory.getLog(ElasticsearchJestAutoConfiguration.class);
    private static final String INTERNAL_TEST_CLUSTER_NAME = "internal-test-cluster-name";
    @Autowired
    private ElasticsearchJestProperties properties;
    @Autowired(required=false)
    private ElasticsearchProperties esNodeproperties;
    @Autowired(required=false)
    private JestClientFactory jestClientFactory;
    private Releasable releasable;

    @Bean
    @ConditionalOnMissingBean(value={JestClient.class})
    @ConditionalOnMissingClass(value={"org.elasticsearch.node.Node"})
    public JestClient client() {
        return this.createJestClient(this.properties.getUri());
    }

    @Bean
    @ConditionalOnMissingBean(value={JestClient.class})
    @ConditionalOnClass(value={Node.class})
    public JestClient testClient() {
        if (StringUtils.isEmpty((Object)this.properties.getUri())) {
            int httpPort = this.createInternalNode();
            return this.createJestClient("http://localhost:" + httpPort);
        }
        return this.createJestClient(this.properties.getUri());
    }

    public void destroy() throws Exception {
        block6: {
            if (this.releasable != null) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Closing Elasticsearch client");
                    }
                    try {
                        this.releasable.close();
                    }
                    catch (NoSuchMethodError var2) {
                        ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(Releasable.class, (String)"release"), (Object)this.releasable);
                    }
                }
                catch (Exception var3) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error((Object)"Error closing Elasticsearch client: ", (Throwable)var3);
                }
            }
        }
    }

    private JestClient createJestClient(String uri) {
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(uri).maxTotalConnection(this.properties.getMaxTotalConnection()).defaultMaxTotalConnectionPerRoute(this.properties.getDefaultMaxTotalConnectionPerRoute()).readTimeout(this.properties.getReadTimeout())).multiThreaded(this.properties.getMultiThreaded().booleanValue());
        if (StringUtils.hasText((String)this.properties.getUsername())) {
            builder.defaultCredentials(this.properties.getUsername(), this.properties.getPassword());
        }
        JestClientFactory factory = this.jestClientFactory != null ? this.jestClientFactory : new JestClientFactory();
        factory.setHttpClientConfig(builder.build());
        return factory.getObject();
    }

    private int createInternalNode() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Create test ES node");
        }
        int port = SocketUtils.findAvailableTcpPort();
        Settings.Builder settingsBuilder = Settings.settingsBuilder().put("http.enabled", String.valueOf(true)).put("http.port", String.valueOf(port));
        if (this.esNodeproperties != null) {
            settingsBuilder.put(this.esNodeproperties.getProperties());
        }
        String clusterName = INTERNAL_TEST_CLUSTER_NAME + UUID.randomUUID();
        Settings settings = new NodeBuilder().settings(settingsBuilder).clusterName(clusterName).local(true).getSettings().build();
        Version version = this.properties.getInternalNodeVersion() == null ? Version.CURRENT : Version.fromString((String)this.properties.getInternalNodeVersion());
        this.releasable = new InternalNode(settings, version, ElasticsearchJestAutoConfiguration.scanPlugins()).start();
        return port;
    }

    private static Collection<Class<? extends Plugin>> scanPlugins() {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Plugin.class));
        return componentProvider.findCandidateComponents("org.elasticsearch.plugin").stream().map(BeanDefinition::getBeanClassName).map(name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Cannot load class on plugin detection", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toSet());
    }

    private static class InternalNode
    extends Node {
        private final Version version;

        InternalNode(Settings settings, Version version, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment((Settings)settings, null), version, classpathPlugins);
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

