/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springboot.autoconfigure.data.jest;

import com.github.vanroy.springboot.autoconfigure.data.jest.ElasticsearchJestProperties;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.autoconfigure.elasticsearch.jest.HttpClientConfigBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ElasticsearchJestProperties.class, ElasticsearchProperties.class})
public class ElasticsearchJestAutoConfiguration
implements DisposableBean {
    private static final Log logger = LogFactory.getLog(ElasticsearchJestAutoConfiguration.class);
    private static final String INTERNAL_TEST_CLUSTER_NAME = "internal-test-cluster-name";
    @Autowired
    private ElasticsearchJestProperties properties;
    @Autowired(required=false)
    private ElasticsearchProperties esNodeproperties;
    @Autowired(required=false)
    private JestClientFactory jestClientFactory;
    @Autowired(required=false)
    private ObjectProvider<List<HttpClientConfigBuilderCustomizer>> builderCustomizers;
    private Closeable node;

    @Bean
    @ConditionalOnMissingBean(value={JestClient.class})
    @ConditionalOnMissingClass(value={"org.elasticsearch.node.Node"})
    public JestClient client() {
        return this.createJestClient(this.properties.getUri());
    }

    @Bean
    @ConditionalOnMissingBean(value={JestClient.class})
    @ConditionalOnClass(value={Node.class})
    public JestClient testClient() throws NodeValidationException {
        if (StringUtils.isEmpty((Object)this.properties.getUri())) {
            int httpPort = this.createInternalNode();
            return this.createJestClient("http://localhost:" + httpPort);
        }
        return this.createJestClient(this.properties.getUri());
    }

    public void destroy() throws Exception {
        block4: {
            if (this.node != null) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Closing Elasticsearch client");
                    }
                    this.node.close();
                }
                catch (Exception ex) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error((Object)"Error closing Elasticsearch client: ", (Throwable)ex);
                }
            }
        }
    }

    private JestClient createJestClient(String uri) {
        List configBuilderCustomizers;
        String proxyHost;
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(uri).maxTotalConnection(this.properties.getMaxTotalConnection()).defaultMaxTotalConnectionPerRoute(this.properties.getDefaultMaxTotalConnectionPerRoute()).maxConnectionIdleTime(this.properties.getMaxConnectionIdleTime(), TimeUnit.MILLISECONDS)).readTimeout(this.properties.getReadTimeout())).multiThreaded(this.properties.getMultiThreaded().booleanValue());
        if (StringUtils.hasText((String)this.properties.getUsername())) {
            builder.defaultCredentials(this.properties.getUsername(), this.properties.getPassword());
        }
        if (StringUtils.hasText((String)(proxyHost = this.properties.getProxy().getHost()))) {
            Integer proxyPort = this.properties.getProxy().getPort();
            Assert.notNull((Object)proxyPort, (String)"Proxy port must not be null");
            builder.proxy(new HttpHost(proxyHost, proxyPort.intValue()));
        }
        List list = configBuilderCustomizers = this.builderCustomizers != null ? (List)this.builderCustomizers.getIfAvailable() : new ArrayList();
        if (!CollectionUtils.isEmpty(configBuilderCustomizers)) {
            logger.info((Object)"Custom HttpClientConfigBuilderCustomizers detected. Applying these to the HttpClientConfig builder.");
            configBuilderCustomizers.stream().forEach(customizer -> customizer.customize(builder));
            logger.info((Object)"Custom HttpClientConfigBuilderCustomizers applied.");
        }
        JestClientFactory factory = this.jestClientFactory != null ? this.jestClientFactory : new JestClientFactory();
        factory.setHttpClientConfig(builder.build());
        return factory.getObject();
    }

    private int createInternalNode() throws NodeValidationException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Create test ES node");
        }
        int port = SocketUtils.findAvailableTcpPort();
        String clusterName = INTERNAL_TEST_CLUSTER_NAME + UUID.randomUUID();
        Settings.Builder settingsBuilder = Settings.builder().put("cluster.name", clusterName).put("http.type", "netty4").put("http.port", String.valueOf(port));
        if (this.esNodeproperties != null) {
            this.esNodeproperties.getProperties().forEach((arg_0, arg_1) -> ((Settings.Builder)settingsBuilder).put(arg_0, arg_1));
        }
        Collection<Class<? extends Plugin>> plugins = ElasticsearchJestAutoConfiguration.scanPlugins();
        plugins.add(Netty4Plugin.class);
        this.node = new InternalNode(settingsBuilder.build(), plugins).start();
        return Integer.parseInt(settingsBuilder.get("http.port"));
    }

    private static Collection<Class<? extends Plugin>> scanPlugins() {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Plugin.class));
        return componentProvider.findCandidateComponents("org.elasticsearch.plugin").stream().map(BeanDefinition::getBeanClassName).map(name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Cannot load class on plugin detection", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toSet());
    }

    private static class InternalNode
    extends Node {
        InternalNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment((Settings)settings, null), classpathPlugins);
        }
    }
}

