/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.mapper;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.vanroy.springdata.jest.aggregation.AggregatedPage;
import com.github.vanroy.springdata.jest.aggregation.impl.AggregatedPageImpl;
import com.github.vanroy.springdata.jest.internal.ExtendedSearchResult;
import com.github.vanroy.springdata.jest.internal.MultiDocumentResult;
import com.github.vanroy.springdata.jest.internal.SearchScrollResult;
import com.github.vanroy.springdata.jest.mapper.JestResultsMapper;
import com.google.gson.JsonObject;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.SearchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.DefaultEntityMapper;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.StringUtils;

public class DefaultJestResultsMapper
implements JestResultsMapper {
    private EntityMapper entityMapper;
    private MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public DefaultJestResultsMapper(EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
    }

    public DefaultJestResultsMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.entityMapper = new DefaultEntityMapper(mappingContext);
        this.mappingContext = mappingContext;
    }

    public DefaultJestResultsMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
        this.mappingContext = mappingContext;
    }

    @Override
    public EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    @Override
    public <T> T mapResult(DocumentResult response, Class<T> clazz) {
        T result = this.mapEntity(response.getSourceAsString(), clazz);
        if (result != null) {
            this.setPersistentEntityId(result, response.getId(), clazz);
        }
        return result;
    }

    @Override
    public <T> LinkedList<T> mapResults(MultiDocumentResult multiResponse, Class<T> clazz) {
        LinkedList<T> results = new LinkedList<T>();
        for (MultiDocumentResult.MultiDocumentResultItem item : multiResponse.getItems()) {
            T result = this.mapEntity(item.getSource(), clazz);
            this.setPersistentEntityId(result, item.getId(), clazz);
            results.add(result);
        }
        return results;
    }

    @Override
    public <T> Page<T> mapResults(SearchScrollResult response, Class<T> clazz) {
        LinkedList<T> results = new LinkedList<T>();
        for (SearchScrollResult.Hit<JsonObject, Void> hit : response.getHits(JsonObject.class)) {
            if (hit == null) continue;
            T result = this.mapSource((JsonObject)hit.source, clazz);
            this.setPersistentEntityScore(result, hit.score, clazz);
            results.add(result);
        }
        return new AggregatedPageImpl(results, Pageable.unpaged(), (long)response.getTotal().intValue(), response.getScrollId());
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResult response, Class<T> clazz, Pageable pageable) {
        return this.mapResults(response, clazz, null, pageable);
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResult response, Class<T> clazz, List<AbstractAggregationBuilder> aggregations, Pageable pageable) {
        LinkedList<T> results = new LinkedList<T>();
        for (SearchResult.Hit hit : response.getHits(JsonObject.class)) {
            if (hit == null) continue;
            T result = this.mapSource((JsonObject)hit.source, clazz);
            this.setPersistentEntityScore(result, hit.score, clazz);
            results.add(result);
        }
        String scrollId = null;
        if (response instanceof ExtendedSearchResult) {
            scrollId = ((ExtendedSearchResult)response).getScrollId();
        }
        return new AggregatedPageImpl(results, pageable, response.getTotal(), response.getAggregations(), scrollId);
    }

    private <T> T mapSource(JsonObject source, Class<T> clazz) {
        String sourceString = source.toString();
        T result = null;
        if (!StringUtils.isEmpty((Object)sourceString)) {
            result = this.mapEntity(sourceString, clazz);
            this.setPersistentEntityId(result, source.get("es_metadata_id").getAsString(), clazz);
        }
        return result;
    }

    private <T> T mapEntity(Collection<DocumentField> values, Class<T> clazz) {
        return this.mapEntity(this.buildJSONFromFields(values), clazz);
    }

    private <T> T mapEntity(String source, Class<T> clazz) {
        if (!StringUtils.hasText((String)source)) {
            return null;
        }
        try {
            return (T)this.entityMapper.mapToObject(source, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to map source [ " + source + "] to class " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String buildJSONFromFields(Collection<DocumentField> values) {
        JsonFactory nodeFactory = new JsonFactory();
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            String string;
            block16: {
                JsonGenerator generator = nodeFactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
                try {
                    generator.writeStartObject();
                    for (DocumentField value : values) {
                        if (value.getValues().size() > 1) {
                            generator.writeArrayFieldStart(value.getName());
                            for (Object val : value.getValues()) {
                                generator.writeObject(val);
                            }
                            generator.writeEndArray();
                            continue;
                        }
                        generator.writeObjectField(value.getName(), value.getValue());
                    }
                    generator.writeEndObject();
                    generator.flush();
                    string = new String(stream.toByteArray(), Charset.forName("UTF-8"));
                    if (generator == null) break block16;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    private <T> void setPersistentEntityId(Object entity, String id, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, (Object)id);
        }
    }

    private <T> void setPersistentEntityScore(T result, Double score, Class<T> clazz) {
        ElasticsearchPersistentEntity entity;
        if (score != null && clazz.isAnnotationPresent(Document.class) && (entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz)).hasScoreProperty() && entity.getScoreProperty() != null) {
            entity.getPropertyAccessor(result).setProperty((PersistentProperty)entity.getScoreProperty(), (Object)Float.valueOf(score.floatValue()));
        }
    }
}

