/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.mapper;

import com.github.vanroy.springdata.jest.aggregation.AggregatedPage;
import com.github.vanroy.springdata.jest.aggregation.impl.AggregatedPageImpl;
import com.github.vanroy.springdata.jest.internal.ExtendedSearchResult;
import com.github.vanroy.springdata.jest.internal.MultiDocumentResult;
import com.github.vanroy.springdata.jest.internal.SearchScrollResult;
import com.github.vanroy.springdata.jest.mapper.JestResultsMapper;
import com.google.gson.JsonObject;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.SearchResult;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.DefaultEntityMapper;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.StringUtils;

public class DefaultJestResultsMapper
implements JestResultsMapper {
    private EntityMapper entityMapper;
    private MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public DefaultJestResultsMapper(EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
    }

    public DefaultJestResultsMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.entityMapper = new DefaultEntityMapper(mappingContext);
        this.mappingContext = mappingContext;
    }

    public DefaultJestResultsMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
        this.mappingContext = mappingContext;
    }

    @Override
    public EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    @Override
    public <T> T mapResult(DocumentResult response, Class<T> clazz) {
        T result = this.mapEntity(response.getSourceAsString(), clazz);
        if (result != null) {
            this.setPersistentEntityId(result, response.getId(), clazz);
        }
        return result;
    }

    @Override
    public <T> LinkedList<T> mapResults(MultiDocumentResult multiResponse, Class<T> clazz) {
        LinkedList<T> results = new LinkedList<T>();
        for (MultiDocumentResult.MultiDocumentResultItem item : multiResponse.getItems()) {
            T result = this.mapEntity(item.getSource(), clazz);
            this.setPersistentEntityId(result, item.getId(), clazz);
            results.add(result);
        }
        return results;
    }

    public <T> AggregatedPage<T> mapResults(SearchScrollResult response, Class<T> clazz) {
        LinkedList<T> results = new LinkedList<T>();
        for (SearchScrollResult.Hit<JsonObject, Void> hit : response.getHits(JsonObject.class)) {
            if (hit == null || hit.source == null) continue;
            T result = this.mapSource((JsonObject)hit.source, clazz);
            this.setPersistentEntityScore(result, hit.score, clazz);
            results.add(result);
        }
        return new AggregatedPageImpl(results, Pageable.unpaged(), (long)response.getTotal().intValue(), response.getScrollId());
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResult response, Class<T> clazz, Pageable pageable) {
        return this.mapResults(response, clazz, null, pageable);
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResult response, Class<T> clazz, List<AbstractAggregationBuilder> aggregations, Pageable pageable) {
        LinkedList<T> results = new LinkedList<T>();
        for (SearchResult.Hit hit : response.getHits(JsonObject.class)) {
            if (hit == null) continue;
            T result = this.mapSource((JsonObject)hit.source, clazz);
            this.setPersistentEntityScore(result, hit.score, clazz);
            results.add(result);
        }
        String scrollId = null;
        if (response instanceof ExtendedSearchResult) {
            scrollId = ((ExtendedSearchResult)response).getScrollId();
        }
        return new AggregatedPageImpl(results, pageable, response.getTotal(), response.getAggregations(), scrollId);
    }

    private <T> T mapSource(JsonObject source, Class<T> clazz) {
        String sourceString = source.toString();
        T result = null;
        if (!StringUtils.isEmpty((Object)sourceString)) {
            result = this.mapEntity(sourceString, clazz);
            this.setPersistentEntityId(result, source.get("es_metadata_id").getAsString(), clazz);
        }
        return result;
    }

    private <T> T mapEntity(Collection<DocumentField> values, Class<T> clazz) {
        return this.mapEntity(this.buildJSONFromFields(values), clazz);
    }

    private <T> T mapEntity(String source, Class<T> clazz) {
        if (!StringUtils.hasText((String)source)) {
            return null;
        }
        try {
            return (T)this.entityMapper.mapToObject(source, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to map source [ " + source + "] to class " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String buildJSONFromFields(Collection<DocumentField> values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> void setPersistentEntityId(Object entity, String id, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, (Object)id);
        }
    }

    private <T> void setPersistentEntityScore(T result, Double score, Class<T> clazz) {
        ElasticsearchPersistentEntity entity;
        if (score != null && clazz.isAnnotationPresent(Document.class) && (entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz)).hasScoreProperty() && entity.getScoreProperty() != null) {
            entity.getPropertyAccessor(result).setProperty((PersistentProperty)entity.getScoreProperty(), (Object)Float.valueOf(score.floatValue()));
        }
    }
}

