/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.github.vantonov1.basalt.BasaltRepoConfiguration;
import com.github.vantonov1.basalt.repo.impl.RepositoryDAO;
import java.sql.SQLException;
import org.junit.After;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.JdbcTest;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest
@ContextConfiguration(classes={BasaltRepoConfiguration.class})
@TestPropertySource(value={"classpath:application.properties"})
@JdbcTest
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public abstract class BaseTest {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RepositoryDAO repositoryDAO;

    @After
    public void after() throws SQLException {
        Object tx = this.beginTx(false);
        this.repositoryDAO.clear();
        this.commit(tx);
    }

    protected Object beginTx(boolean readOnly) throws SQLException {
        DefaultTransactionDefinition d = new DefaultTransactionDefinition();
        d.setReadOnly(readOnly);
        return this.transactionManager.getTransaction((TransactionDefinition)d);
    }

    protected void commit(Object tx) throws SQLException {
        if (tx != null) {
            this.transactionManager.commit((TransactionStatus)tx);
        }
    }

    protected void rollback(Object tx) throws SQLException {
        if (tx != null) {
            this.transactionManager.rollback((TransactionStatus)tx);
        }
    }
}

