/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.github.vantonov1.basalt.repo.Assoc;
import com.github.vantonov1.basalt.repo.Node;
import com.github.vantonov1.basalt.repo.NodeService;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import test.BaseTest;

public class NodeServiceTest
extends BaseTest {
    @Autowired
    private NodeService nodeService;
    @Autowired
    PlatformTransactionManager transactionManager;

    @Test
    public void testNodeCRUD() throws SQLException {
        Object tx = this.beginTx(false);
        Node node = new Node("testNode", Collections.singletonMap("title", "abc"));
        String id = this.nodeService.createNode(null, node, null, null);
        Assert.assertTrue((boolean)this.nodeService.exists(id));
        Assert.assertNotNull((Object)id);
        Node created = this.nodeService.getProperties(id);
        Assert.assertNotNull((Object)created);
        Assert.assertEquals((Object)"testNode", (Object)created.type);
        Assert.assertEquals((Object)"abc", (Object)created.get("title"));
        Node updated = new Node(id, "testNode", Collections.singletonMap("title", "def"));
        this.nodeService.updateProperties(updated, true);
        updated = this.nodeService.getProperties(id);
        Assert.assertNotNull((Object)updated);
        Assert.assertEquals((Object)"testNode", (Object)updated.type);
        Assert.assertEquals((Object)"def", (Object)updated.get("title"));
        this.nodeService.deleteNode(id);
        Assert.assertFalse((boolean)this.nodeService.exists(id));
        Node deleted = this.nodeService.getProperties(id);
        Assert.assertNull((Object)deleted);
        this.commit(tx);
    }

    @Test
    public void testProperties() throws SQLException {
        Object tx = this.beginTx(false);
        Map<String, String> abc = Collections.singletonMap("title", "abc");
        String id = this.nodeService.createNode(null, new Node("type", abc), null, null);
        Assert.assertEquals((Object)"abc", (Object)this.nodeService.getProperty(id, "title"));
        this.nodeService.setProperty(id, "title", null);
        Assert.assertNull((Object)this.nodeService.getProperty(id, "title"));
        this.nodeService.setProperty(id, "title", (Serializable)((Object)"def"));
        Assert.assertEquals((Object)"def", (Object)this.nodeService.getProperty(id, "title"));
        Map<String, String> update = Collections.singletonMap("prop1", "1");
        this.nodeService.updateProperties(new Node(id, "type", update), false);
        Node updated = this.nodeService.getProperties(id);
        Assert.assertEquals((Object)"def", (Object)updated.get("title"));
        Assert.assertEquals((Object)"1", (Object)updated.get("prop1"));
        Assert.assertEquals((Object)id, (Object)updated.id);
        this.nodeService.removeProperty(id, "prop1");
        Assert.assertNull((Object)this.nodeService.getProperty(id, "prop1"));
        Node node2 = new Node(id, "type", abc);
        this.nodeService.updateProperties(node2, true);
        Assert.assertEquals((Object)"abc", (Object)this.nodeService.getProperty(id, "title"));
        Assert.assertNull((Object)this.nodeService.getProperty(id, "prop1"));
        Assert.assertEquals((long)1L, (long)this.nodeService.getProperties(Collections.singletonList(id)).size());
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            Node node = new Node("type", abc);
            ids.add(this.nodeService.createNode(null, node, null, null));
        }
        Assert.assertEquals((long)10L, (long)this.nodeService.getProperties(ids).size());
        this.commit(tx);
    }

    @Test
    public void testBulk() throws SQLException {
        int i;
        Object tx = this.beginTx(false);
        String parent = this.nodeService.createNode(null, new Node("type", Collections.emptyMap()), null, null);
        String anotherParent = this.nodeService.createNode(null, new Node("type", Collections.emptyMap()), null, null);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i2 = 0; i2 < 10; ++i2) {
            nodes.add(new Node("type", new HashMap<String, String>(Collections.singletonMap("title", "abc" + i2))));
        }
        List ids = this.nodeService.createNodes(parent, nodes, "children");
        List created = this.nodeService.getProperties((Collection)ids);
        Assert.assertEquals((long)ids.size(), (long)created.size());
        for (Object node : created) {
            Assert.assertTrue((boolean)ids.contains(((Node)node).id));
        }
        for (int i3 = 0; i3 < 10; ++i3) {
            ((Node)nodes.get((int)i3)).id = (String)ids.get(i3);
            ((Node)nodes.get(i3)).put("title", (Serializable)((Object)("def" + i3)));
        }
        this.nodeService.updateProperties(nodes, true);
        List updated = this.nodeService.getProperties((Collection)ids);
        for (Object node : updated) {
            Assert.assertTrue((boolean)((String)((Object)node.get("title"))).startsWith("def"));
        }
        for (i = 0; i < 10; ++i) {
            ((Node)nodes.get((int)i)).id = null;
        }
        for (i = 0; i < 10; ++i) {
            nodes.add(new Node("anotherType", Collections.singletonMap("title", "xyz" + i)));
        }
        this.nodeService.createNodes(anotherParent, nodes, "babies");
        Assert.assertEquals((long)10L, (long)this.nodeService.getAllAssocByType("children").size());
        Assert.assertEquals((long)10L, (long)this.nodeService.getChildAssoc(Arrays.asList(parent, anotherParent), "children", null).size());
        Assert.assertEquals((long)30L, (long)this.nodeService.getChildAssoc(Arrays.asList(parent, anotherParent), null, null).size());
        this.nodeService.setProperty((Collection)ids, "title", (Serializable)((Object)"123"));
        Map set = this.nodeService.getProperty((Collection)ids, "title");
        Assert.assertEquals((long)ids.size(), (long)set.size());
        for (String id : set.keySet()) {
            Assert.assertTrue((boolean)ids.contains(id));
        }
        for (Object o : set.values()) {
            Assert.assertEquals((Object)"123", o);
        }
        this.nodeService.setProperty((Collection)ids, "title", null);
        Map removed = this.nodeService.getProperty((Collection)ids, "title");
        Assert.assertEquals((long)0L, (long)removed.size());
        this.commit(tx);
    }

    @Test
    public void testArrays() throws SQLException {
        Object tx = this.beginTx(false);
        List<String> value = Arrays.asList("abc", "def");
        Node node = new Node("type", Collections.singletonMap("value", (Serializable)((Object)value)));
        String id = this.nodeService.createNode(null, node, null, null);
        Assert.assertNotNull((Object)id);
        Node created = this.nodeService.getProperties(id);
        Assert.assertNotNull((Object)created);
        Serializable v = created.get("value");
        Assert.assertNotNull((Object)v);
        Assert.assertTrue((boolean)(v instanceof Collection));
        Iterator it = ((Collection)((Object)v)).iterator();
        Assert.assertEquals((Object)"abc", it.next());
        Assert.assertEquals((Object)"def", it.next());
        Assert.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        List<String> v2 = Arrays.asList("abc", "123");
        Node updateNode = new Node(id, "type", Collections.singletonMap("value", (Serializable)((Object)v2)));
        this.nodeService.updateProperties(updateNode, true);
        Node updated = this.nodeService.getProperties(id);
        Assert.assertNotNull((Object)updated);
        Object v3 = updated.get("value");
        Assert.assertNotNull((Object)v3);
        Assert.assertTrue((boolean)(v3 instanceof Collection));
        Iterator it2 = ((Collection)v3).iterator();
        Assert.assertEquals((Object)"abc", it2.next());
        Assert.assertEquals((Object)"123", it2.next());
        Assert.assertTrue((!it2.hasNext() ? 1 : 0) != 0);
        List<String> v32 = Arrays.asList("abc", "xyz", "123");
        this.nodeService.setProperty(id, "value", (Serializable)((Object)v32));
        v3 = (Collection)((Object)this.nodeService.getProperty(id, "value"));
        Assert.assertTrue((boolean)v3.contains("abc"));
        Assert.assertTrue((boolean)v3.contains("xyz"));
        Assert.assertTrue((boolean)v3.contains("123"));
        this.nodeService.setProperty(id, "value", (Serializable)Integer.valueOf(1));
        Assert.assertTrue((1L == (long)((Integer)this.nodeService.getProperty(id, "value")).intValue() ? 1 : 0) != 0);
        this.nodeService.setProperty(id, "value", (Serializable)((Object)v32));
        this.nodeService.setProperty(id, "value", null);
        Assert.assertNull((Object)this.nodeService.getProperty(id, "value"));
        this.commit(tx);
    }

    @Test
    public void testAssoc() throws SQLException {
        Object tx = this.beginTx(false);
        String assocName = "111";
        Node parentNode = new Node("type", Collections.singletonMap("title", "abc"));
        Node childNode = new Node("type", Collections.singletonMap("title", "def"));
        String parent = this.nodeService.createNode(null, parentNode, null, null);
        String child = this.nodeService.createNode(parent, childNode, null, "assocType");
        String anotherParent = this.nodeService.createNode(null, new Node("type", Collections.emptyMap()), null, null);
        Assert.assertEquals((Object)parent, (Object)this.nodeService.getPrimaryParent(child));
        this.nodeService.addChild(parent, child, "assocType", "111", true);
        Assert.assertEquals((long)1L, (long)this.nodeService.countAllChildAssocs(parent));
        Assoc childAssoc = (Assoc)this.nodeService.getChildAssoc(parent, "assocType", "111").iterator().next();
        Assert.assertTrue((boolean)childAssoc.target.equals(child));
        Assert.assertTrue((boolean)childAssoc.source.equals(parent));
        Assert.assertTrue((boolean)childAssoc.type.equals("assocType"));
        Assert.assertTrue((boolean)childAssoc.name.equals("111"));
        Assoc parentAssoc = (Assoc)this.nodeService.getParentAssoc(child, "assocType", "111").iterator().next();
        Assert.assertTrue((boolean)parentAssoc.target.equals(child));
        Assert.assertTrue((boolean)parentAssoc.source.equals(parent));
        Assert.assertTrue((boolean)parentAssoc.type.equals("assocType"));
        Assert.assertTrue((boolean)parentAssoc.name.equals("111"));
        Assoc allAssoc = (Assoc)this.nodeService.getAllAssoc(child).iterator().next();
        Assert.assertTrue((boolean)allAssoc.target.equals(child));
        Assert.assertTrue((boolean)allAssoc.source.equals(parent));
        Assert.assertTrue((boolean)allAssoc.type.equals("assocType"));
        Assert.assertTrue((boolean)allAssoc.name.equals("111"));
        this.nodeService.move(child, anotherParent, "assocType", null);
        Assoc movedParentAssoc = (Assoc)this.nodeService.getParentAssoc(child, "assocType", null).iterator().next();
        Assert.assertEquals((Object)anotherParent, (Object)movedParentAssoc.source);
        Assert.assertEquals((long)0L, (long)this.nodeService.getChildAssoc(parent, "assocType", null).size());
        Assert.assertEquals((long)1L, (long)this.nodeService.getChildAssoc(anotherParent, "assocType", null).size());
        this.nodeService.deleteChild(parent, child, "assocType", null);
        List deleted = this.nodeService.getAllAssoc(parent);
        Assert.assertTrue((boolean)deleted.isEmpty());
        this.commit(tx);
    }
}

