/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.github.vantonov1.basalt.repo.Node;
import com.github.vantonov1.basalt.repo.NodeService;
import com.github.vantonov1.basalt.repo.QueryBuilder;
import com.github.vantonov1.basalt.repo.SearchService;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import test.BaseTest;

public class SearchServiceTest
extends BaseTest {
    @Autowired
    private SearchService searchService;
    @Autowired
    private NodeService nodeService;
    private String id;
    private String id2;
    private String id3;

    @Before
    public void before() throws SQLException {
        Object set = this.beginTx(false);
        Map<String, String> abc = Collections.singletonMap("name", "abc");
        HashMap<String, Serializable> def = new HashMap<String, Serializable>(){
            {
                this.put("name", "def");
                this.put("int", 1);
                this.put("date", new Date());
                this.put("double", -1.0);
            }
        };
        this.id = this.nodeService.createNode(null, new Node("content", abc), null, null);
        this.id2 = this.nodeService.createNode(null, new Node("content", (Map)def), null, null);
        this.id3 = this.nodeService.createNode(this.id, new Node("content", null), "child", null);
        this.commit(set);
    }

    @Test
    public void testByName() {
        List byProp = this.searchService.search(null, "name", (Serializable)((Object)"def"));
        Assert.assertTrue((boolean)byProp.contains(this.id2));
        Assert.assertFalse((boolean)byProp.contains(this.id));
        List mustHave = this.searchService.search(new QueryBuilder().type(Arrays.asList("base", "content")).is("name", (Object)"def"));
        Assert.assertTrue((boolean)mustHave.contains(this.id2));
        Assert.assertFalse((boolean)mustHave.contains(this.id));
        Assert.assertEquals((long)1L, (long)this.searchService.count(new QueryBuilder().type(new String[]{"content"}).is("name", (Object)"def")));
        List mustNotHave = this.searchService.search(new QueryBuilder().isNot("name", (Object)"def"));
        Assert.assertTrue((boolean)mustNotHave.contains(this.id));
        Assert.assertFalse((boolean)mustNotHave.contains(this.id2));
        List shouldHave = this.searchService.search(new QueryBuilder().oneOf().is("name", (Object)"def").is("name", (Object)"abc"));
        Assert.assertEquals((long)2L, (long)shouldHave.size());
    }

    @Test
    public void testNull() throws SQLException {
        List isNull = this.searchService.search(new QueryBuilder().isNull(new String[]{"name"}));
        Assert.assertFalse((boolean)isNull.contains(this.id));
        Assert.assertFalse((boolean)isNull.contains(this.id2));
        Assert.assertTrue((boolean)isNull.contains(this.id3));
        List isNotNull = this.searchService.search(new QueryBuilder().isNotNull(new String[]{"name"}));
        Assert.assertTrue((boolean)isNotNull.contains(this.id));
        Assert.assertTrue((boolean)isNotNull.contains(this.id2));
        Assert.assertFalse((boolean)isNotNull.contains(this.id3));
    }

    @Test
    public void testRanges() throws SQLException {
        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
        Date tomorrow = new Date(System.currentTimeMillis() + 86400000L);
        List openRight = this.searchService.search(new QueryBuilder().range("date", (Object)yesterday, null));
        Assert.assertTrue((boolean)openRight.contains(this.id2));
        Assert.assertFalse((boolean)openRight.contains(this.id));
        List dateClosed = this.searchService.search(new QueryBuilder().range("date", (Object)yesterday, (Object)tomorrow));
        Assert.assertTrue((boolean)dateClosed.contains(this.id2));
        Assert.assertFalse((boolean)dateClosed.contains(this.id));
        List intClosed = this.searchService.search(new QueryBuilder().range("int", (Object)1, (Object)10));
        Assert.assertTrue((boolean)intClosed.contains(this.id2));
        Assert.assertFalse((boolean)intClosed.contains(this.id));
        List doubleClosed = this.searchService.search(new QueryBuilder().range("double", (Object)-0.5, (Object)-1.5));
        Assert.assertTrue((boolean)doubleClosed.contains(this.id2));
        Assert.assertFalse((boolean)doubleClosed.contains(this.id));
    }

    @Test
    public void testAssoc() {
        List mustHaveParent = this.searchService.search(new QueryBuilder().parentAssoc(new String[]{this.id}));
        Assert.assertTrue((boolean)mustHaveParent.contains(this.id3));
        Assert.assertFalse((boolean)mustHaveParent.contains(this.id));
        Assert.assertFalse((boolean)mustHaveParent.contains(this.id2));
        List shouldHaveParent = this.searchService.search(new QueryBuilder().oneOf().parentAssoc(new String[]{this.id}));
        Assert.assertTrue((boolean)shouldHaveParent.contains(this.id3));
        Assert.assertFalse((boolean)shouldHaveParent.contains(this.id));
        Assert.assertFalse((boolean)shouldHaveParent.contains(this.id2));
        List mustHaveChildren = this.searchService.search(new QueryBuilder().childAssoc(new String[]{this.id3}));
        Assert.assertTrue((boolean)mustHaveChildren.contains(this.id));
        Assert.assertFalse((boolean)mustHaveChildren.contains(this.id3));
        Assert.assertFalse((boolean)mustHaveChildren.contains(this.id2));
        List mustNotHaveParent = this.searchService.search(new QueryBuilder().parentAssocNot(new String[]{this.id}));
        Assert.assertTrue((boolean)mustNotHaveParent.contains(this.id));
        Assert.assertTrue((boolean)mustNotHaveParent.contains(this.id2));
        Assert.assertFalse((boolean)mustNotHaveParent.contains(this.id3));
        List mustNotHaveChildren = this.searchService.search(new QueryBuilder().childAssocNot(new String[]{this.id3}));
        Assert.assertFalse((boolean)mustNotHaveChildren.contains(this.id));
        Assert.assertTrue((boolean)mustNotHaveChildren.contains(this.id3));
        Assert.assertTrue((boolean)mustNotHaveChildren.contains(this.id2));
    }

    @Test
    public void testGroups() {
        List shouldHaveGroups = this.searchService.search(new QueryBuilder().group().is("int", (Object)1).is("name", (Object)"def"));
        Assert.assertTrue((boolean)shouldHaveGroups.contains(this.id2));
        Assert.assertFalse((boolean)shouldHaveGroups.contains(this.id));
        Assert.assertFalse((boolean)shouldHaveGroups.contains(this.id3));
        List mustHaveGroups = this.searchService.search(new QueryBuilder().oneOf().group().is("name", (Object)"abc").group().is("int", (Object)1).is("name", (Object)"def"));
        Assert.assertTrue((boolean)mustHaveGroups.contains(this.id));
        Assert.assertTrue((boolean)mustHaveGroups.contains(this.id2));
        Assert.assertFalse((boolean)mustHaveGroups.contains(this.id3));
    }
}

