/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers;

import com.github.vatbub.randomusers.internal.Random;
import com.github.vatbub.randomusers.result.AvatarPicture;
import com.github.vatbub.randomusers.result.Gender;
import com.github.vatbub.randomusers.result.Location;
import com.github.vatbub.randomusers.result.Login;
import com.github.vatbub.randomusers.result.Name;
import com.github.vatbub.randomusers.result.Nationality;
import com.github.vatbub.randomusers.result.RandomUser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class Generator {
    public static List<RandomUser> generateRandomUsers(RandomUser.RandomUserSpec spec, int numberOfResultsToGenerate) {
        ArrayList<RandomUser> res = new ArrayList<RandomUser>(numberOfResultsToGenerate);
        for (int i = 0; i < numberOfResultsToGenerate; ++i) {
            res.add(Generator.generateRandomUser(spec));
        }
        return res;
    }

    public static RandomUser generateRandomUser(RandomUser.RandomUserSpec spec) {
        Nationality nationality;
        if (spec.getSeed() != Long.MIN_VALUE) {
            Random.setSeed(spec.getSeed());
        }
        Gender gender = !((nationality = spec.getNationalities() == null ? Generator.generateRandomNationality() : (Nationality)Random.randomItem(spec.getNationalities().toArray())) instanceof Nationality.Lego) ? (spec.getGenders() == null ? Generator.generateRandomGender() : (Gender)((Object)Random.randomItem(spec.getGenders().toArray()))) : Gender.lego;
        Name name = nationality.generateName(gender);
        Location location = nationality.generateLocation();
        String email = name.getFirstName() + "." + name.getLastName().replaceAll(" ", "") + "@example.com";
        Login login = spec.getPasswordSpec() == null ? Login.generateLogin() : Login.generateLogin(spec.getPasswordSpec());
        Calendar birthDateCalendar = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        birthDateCalendar.set(1, Random.range(now.get(1) - 100, now.get(1)));
        birthDateCalendar.set(2, Random.range(0, 11));
        birthDateCalendar.set(5, Random.range(1, birthDateCalendar.getActualMaximum(5)));
        Date dateOfBirth = birthDateCalendar.getTime();
        Calendar registrationDateCalendar = Calendar.getInstance();
        registrationDateCalendar.set(1, Random.range(now.get(1) - 100, now.get(1)));
        registrationDateCalendar.set(2, Random.range(0, 11));
        registrationDateCalendar.set(5, Random.range(1, registrationDateCalendar.getActualMaximum(5)));
        Date registrationDate = registrationDateCalendar.getTime();
        String phone = nationality.generatePhoneNumber();
        String cell = nationality.generateCellPhoneNumber();
        int imageID = gender.equals((Object)Gender.lego) ? Random.range(0, 9) : Random.range(0, 99);
        AvatarPicture picture = new AvatarPicture(imageID, gender);
        return new RandomUser(gender, name, location, email, login, dateOfBirth, registrationDate, phone, cell, picture, nationality);
    }

    private static Nationality generateRandomNationality() {
        return (Nationality)Random.randomItem(new Nationality[]{new Nationality.American(), new Nationality.Australian(), new Nationality.Brazilian(), new Nationality.British(), new Nationality.Canadian(), new Nationality.Danish(), new Nationality.Dutch(), new Nationality.Finnish(), new Nationality.French(), new Nationality.German(), new Nationality.Iranian(), new Nationality.Irish(), new Nationality.New_zealand(), new Nationality.Spanish(), new Nationality.Swiss(), new Nationality.Turkish()});
    }

    private static Gender generateRandomGender() {
        return (Gender)((Object)Random.randomItem((Object[])new Gender[]{Gender.male, Gender.female}));
    }

    public static class PasswordSpec {
        private List<PasswordCharset> charsets;
        private int minLength;
        private int maxLength;

        public int getMinLength() {
            return this.minLength;
        }

        public void setMinLength(int minLength) {
            this.minLength = minLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public int getExactLength() {
            if (this.getMinLength() != this.getMaxLength()) {
                throw new IllegalStateException("Exact password length not specified, specified range is " + this.getMinLength() + "-" + this.getMaxLength());
            }
            return this.getMinLength();
        }

        public void setExactLength(int exactLength) {
            this.setMinLength(exactLength);
            this.setMaxLength(exactLength);
        }

        public List<PasswordCharset> getCharsets() {
            return this.charsets;
        }

        public void setCharsets(List<PasswordCharset> charsets) {
            this.charsets = charsets;
        }

        public static enum PasswordCharset {
            special,
            upper,
            lower,
            number;


            public static String getAvailableChars(List<PasswordCharset> charsets) {
                StringBuilder res = new StringBuilder();
                for (PasswordCharset charset : charsets) {
                    res.append(PasswordCharset.getAvailableChars(charset));
                }
                return res.toString();
            }

            public static String getAvailableChars(PasswordCharset charset) {
                String res = "";
                switch (charset) {
                    case special: {
                        res = "!\"#$%&'()*+,- ./:;<=>?@[\\]^_`{|}~";
                        break;
                    }
                    case upper: {
                        res = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                        break;
                    }
                    case lower: {
                        res = "abcdefghijklmnopqrstuvwxyz";
                        break;
                    }
                    case number: {
                        res = "0123456789";
                    }
                }
                return res;
            }
        }
    }
}

