/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers.data;

import com.github.vatbub.randomusers.result.Nationality;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class DataSet {
    private static final Map<Nationality, DataSet> dataCache = new HashMap<Nationality, DataSet>();
    private List<String> cities;
    private List<String> femaleFirst;
    private List<String> maleFirst;
    private List<String> last;
    private List<String> states;
    private List<String> street;

    public static DataSet load(Nationality nationality) {
        if (!dataCache.containsKey(nationality)) {
            dataCache.put(nationality, DataSet.loadWithoutCache(nationality));
        }
        return dataCache.get(nationality);
    }

    public static DataSet loadWithoutCache(Nationality nationality) {
        DataSet res = new DataSet();
        String resourcePackage = nationality.getShortCode() + "/lists";
        Scanner scanner = new Scanner(DataSet.class.getResourceAsStream(resourcePackage + "/cities.txt"), "UTF-8");
        res.cities = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            res.cities.add(scanner.nextLine());
        }
        scanner = new Scanner(DataSet.class.getResourceAsStream(resourcePackage + "/female_first.txt"), "UTF-8");
        res.femaleFirst = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            res.femaleFirst.add(scanner.nextLine());
        }
        scanner = new Scanner(DataSet.class.getResourceAsStream(resourcePackage + "/male_first.txt"), "UTF-8");
        res.maleFirst = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            res.maleFirst.add(scanner.nextLine());
        }
        scanner = new Scanner(DataSet.class.getResourceAsStream(resourcePackage + "/last.txt"), "UTF-8");
        res.last = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            res.last.add(scanner.nextLine());
        }
        scanner = new Scanner(DataSet.class.getResourceAsStream(resourcePackage + "/states.txt"), "UTF-8");
        res.states = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            res.states.add(scanner.nextLine());
        }
        scanner = new Scanner(DataSet.class.getResourceAsStream(resourcePackage + "/street.txt"), "UTF-8");
        res.street = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            res.street.add(scanner.nextLine());
        }
        return res;
    }

    public List<String> getCities() {
        return this.cities;
    }

    public List<String> getFemaleFirst() {
        return this.femaleFirst;
    }

    public List<String> getMaleFirst() {
        return this.maleFirst;
    }

    public List<String> getLast() {
        return this.last;
    }

    public List<String> getStates() {
        return this.states;
    }

    public List<String> getStreet() {
        return this.street;
    }

    public static class CommonDataSet {
        private static List<String> passwords;
        private static List<String> title;
        private static List<String> user1;
        private static List<String> user2;

        private static void loadPasswords() {
            Scanner scanner = new Scanner(DataSet.class.getResourceAsStream("common/lists/passwords.txt"), "UTF-8");
            passwords = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                passwords.add(scanner.nextLine());
            }
        }

        private static void loadTitle() {
            Scanner scanner = new Scanner(DataSet.class.getResourceAsStream("common/lists/title.txt"), "UTF-8");
            title = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                title.add(scanner.nextLine());
            }
        }

        private static void loadUser1() {
            Scanner scanner = new Scanner(DataSet.class.getResourceAsStream("common/lists/user1.txt"), "UTF-8");
            user1 = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                user1.add(scanner.nextLine());
            }
        }

        private static void loadUser2() {
            Scanner scanner = new Scanner(DataSet.class.getResourceAsStream("common/lists/user2.txt"), "UTF-8");
            user2 = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                user2.add(scanner.nextLine());
            }
        }

        public static List<String> getPasswords() {
            if (passwords == null) {
                CommonDataSet.loadPasswords();
            }
            return passwords;
        }

        public static List<String> getTitle() {
            if (title == null) {
                CommonDataSet.loadTitle();
            }
            return title;
        }

        public static List<String> getUser1() {
            if (user1 == null) {
                CommonDataSet.loadUser1();
            }
            return user1;
        }

        public static List<String> getUser2() {
            if (user2 == null) {
                CommonDataSet.loadUser2();
            }
            return user2;
        }
    }
}

