/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers.internal;

public class Random {
    private static java.util.Random randomNumberGenerator = new java.util.Random();

    public static String random(RandomMode mode, int length) {
        String chars = "";
        StringBuilder res = new StringBuilder();
        switch (mode) {
            case lower: {
                chars = "abcdef1234567890";
                break;
            }
            case lowerUpperNumbers: {
                chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                break;
            }
            case numbers: {
                chars = "0123456789";
                break;
            }
            case upper: {
                chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            }
        }
        for (int i = 0; i < length; ++i) {
            res.append(chars.charAt((int)Math.round(randomNumberGenerator.nextDouble() * (double)(chars.length() - 1))));
        }
        return res.toString();
    }

    public static int range(int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("to must be higher than from (from: " + from + ", to:" + to);
        }
        return (int)(Math.round(randomNumberGenerator.nextDouble() * (double)(to - from)) + (long)from);
    }

    public static Object randomItem(Object[] array) {
        return array[Random.range(0, array.length - 1)];
    }

    public static void setSeed(long seed) {
        randomNumberGenerator = new java.util.Random(seed);
    }

    public static enum RandomMode {
        lower,
        lowerUpperNumbers,
        upper,
        numbers;

    }
}

