/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers.result;

import com.github.vatbub.randomusers.result.Gender;
import java.net.MalformedURLException;
import java.net.URL;

public class AvatarPicture {
    static final String largePrefix = "";
    static final String mediumPrefix = "med/";
    static final String thumbnailPrefix = "thumb/";
    private static final String baseURL = "https://randomuser.me/api/portraits/";
    private int imageID;
    private Gender gender;

    public AvatarPicture(int imageID, Gender gender) {
        this.setImageID(imageID);
        this.setGender(gender);
    }

    public boolean equals(Object obj) {
        return obj instanceof AvatarPicture && ((AvatarPicture)obj).getImageID() == this.getImageID() && ((AvatarPicture)obj).getGender() == this.getGender();
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public int getImageID() {
        return this.imageID;
    }

    public void setImageID(int imageID) {
        this.imageID = imageID;
    }

    public URL getLargePicture() throws MalformedURLException {
        return new URL(baseURL + this.getGender().getGenderText() + "/" + this.getImageID() + ".jpg");
    }

    public URL getMediumPicture() throws MalformedURLException {
        return new URL("https://randomuser.me/api/portraits/med/" + this.getGender().getGenderText() + "/" + this.getImageID() + ".jpg");
    }

    public URL getThumbnailPicture() throws MalformedURLException {
        return new URL("https://randomuser.me/api/portraits/thumb/" + this.getGender().getGenderText() + "/" + this.getImageID() + ".jpg");
    }
}

