/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers.result;

import com.github.vatbub.randomusers.data.DataSet;
import com.github.vatbub.randomusers.internal.Random;
import com.github.vatbub.randomusers.result.Nationality;

public class Location {
    private String street;
    private String city;
    private String state;
    private String postCode;

    public static Location generateRandomDefaultLocation(Nationality nationality) {
        Location res = new Location();
        res.setStreet(Random.range(1000, 9999) + " " + Random.randomItem(DataSet.load(nationality).getStreet().toArray()));
        res.setCity((String)Random.randomItem(DataSet.load(nationality).getCities().toArray()));
        res.setState((String)Random.randomItem(DataSet.load(nationality).getStates().toArray()));
        res.setPostCode(String.valueOf(Random.range(10000, 99999)));
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location cast = (Location)obj;
        return cast.getStreet().equals(this.getStreet()) && cast.getCity().equals(this.getCity()) && cast.getState().equals(this.getState()) && cast.getPostCode().equals(this.getPostCode());
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String toString() {
        return this.getStreet() + ", " + this.getPostCode() + " " + this.getCity() + ", " + this.getState();
    }
}

