/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers.result;

import com.github.vatbub.randomusers.Generator;
import com.github.vatbub.randomusers.data.DataSet;
import com.github.vatbub.randomusers.internal.Random;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;

public class Login {
    private final String salt = Random.random(Random.RandomMode.lowerUpperNumbers, 8);
    private String username;
    private String password;

    public static Login generateLogin() {
        Login res = new Login();
        res.setUsername(Login.generateUsername());
        res.setPassword((String)Random.randomItem(DataSet.CommonDataSet.getPasswords().toArray()));
        return res;
    }

    private static String generateUsername() {
        return (String)Random.randomItem(DataSet.CommonDataSet.getUser1().toArray()) + Random.randomItem(DataSet.CommonDataSet.getUser2().toArray()) + Random.range(100, 999);
    }

    public static Login generateLogin(Generator.PasswordSpec passwordSpec) {
        Login res = new Login();
        res.setUsername(Login.generateUsername());
        int length = Random.range(passwordSpec.getMinLength(), passwordSpec.getMaxLength());
        StringBuilder password = new StringBuilder();
        char[] array = Generator.PasswordSpec.PasswordCharset.getAvailableChars(passwordSpec.getCharsets()).toCharArray();
        while (password.length() < length) {
            password.append(array[Random.range(0, array.length - 1)]);
        }
        res.setPassword(password.toString());
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Login)) {
            return false;
        }
        Login cast = (Login)obj;
        return cast.getUsername().equals(this.getUsername()) && cast.getPassword().equals(this.getPassword()) && cast.getSalt().equals(this.getSalt());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSalt() {
        return this.salt;
    }

    private HashCode getHashCode(Hasher hasher) {
        return hasher.putString((CharSequence)(this.getPassword() + this.getSalt()), Charsets.UTF_8).hash();
    }

    public String getMD5() {
        return this.getHashCode(Hashing.md5().newHasher()).toString();
    }

    public String getSHA1() {
        return this.getHashCode(Hashing.sha1().newHasher()).toString();
    }

    public String getSHA256() {
        return this.getHashCode(Hashing.sha256().newHasher()).toString();
    }

    public String toString() {
        return "username: " + this.getUsername() + ", password: " + this.getPassword() + ", salt: " + this.getSalt();
    }
}

