/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.randomusers.result;

import com.github.vatbub.randomusers.data.DataSet;
import com.github.vatbub.randomusers.internal.Random;
import com.github.vatbub.randomusers.result.Gender;
import com.github.vatbub.randomusers.result.Nationality;

public class Name {
    private String title;
    private String firstName;
    private String lastName;

    public static Name generateDefaultName(Gender gender, Nationality nationality) {
        DataSet dataSet = DataSet.load(nationality);
        Name res = new Name();
        if (gender == Gender.male) {
            res.setTitle("mr");
            res.setFirstName((String)Random.randomItem(dataSet.getMaleFirst().toArray()));
        } else {
            res.setTitle((String)Random.randomItem(DataSet.CommonDataSet.getTitle().toArray()));
            res.setFirstName((String)Random.randomItem(dataSet.getFemaleFirst().toArray()));
        }
        res.setLastName((String)Random.randomItem(dataSet.getLast().toArray()));
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Name)) {
            return false;
        }
        Name cast = (Name)obj;
        return cast.getTitle().equals(this.getTitle()) && cast.getFirstName().equals(this.getFirstName()) && cast.getLastName().equals(this.getLastName());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String toString() {
        return this.getTitle() + ". " + this.getFirstName() + " " + this.getLastName();
    }
}

