/*
 * Decompiled with CFR 0.152.
 */
package com.github.vbmacher.cup;

import com.github.vbmacher.cup.CupParameters;
import com.github.vbmacher.cup.CupParserGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GoalGenerate
extends AbstractMojo
implements CupParameters {
    public static final String DEFAULT_CUP_DIR = "src/main/cup";
    private boolean symbolsInterface;
    private File cupDefinition;
    private String className;
    private String symbolsName;
    private File outputDirectory;
    private MavenProject project;
    private String packageName;
    private boolean dumpGrammar;
    private boolean dumpStates;
    private boolean dumpTables;
    private boolean time;
    private boolean progress;
    private boolean noScanner;
    private boolean noPositions;
    private boolean noSummary;
    private boolean noWarn;
    private boolean compactRed;
    private int expectedConflicts;
    private boolean nontermsToSymbols;
    private String typeArgs;
    private int staleMillis;
    private boolean locations;
    private boolean xmlActions;
    private boolean genericLabels;

    public void execute() throws MojoExecutionException {
        String projectAbsolutePath = this.project.getBasedir().getAbsolutePath();
        if (this.outputDirectory != null && !this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(projectAbsolutePath, this.outputDirectory.getPath());
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        if (this.cupDefinition == null) {
            this.cupDefinition = new File(projectAbsolutePath, "src/main/cup/parser.cup");
        }
        CupParserGenerator cupParserGenerator = new CupParserGenerator(this.getLog(), this);
        cupParserGenerator.process();
    }

    @Override
    public File getCupDefinition() {
        return this.cupDefinition;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getSymbolsName() {
        return this.symbolsName;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public int getStaleMillis() {
        return this.staleMillis;
    }

    @Override
    public List<String> prepareCommandLine(File cupFile, File generatedFile) {
        ArrayList<String> params = new ArrayList<String>();
        if (this.packageName != null) {
            params.add("-package");
            params.add(this.packageName);
        }
        if (this.className != null) {
            params.add("-parser");
            params.add(this.className);
        }
        if (this.symbolsName != null) {
            params.add("-symbols");
            params.add(this.symbolsName);
        }
        if (this.symbolsInterface) {
            params.add("-interface");
        }
        if (this.dumpGrammar) {
            params.add("-dump_grammar");
        }
        if (this.dumpStates) {
            params.add("-dump_states");
        }
        if (this.dumpTables) {
            params.add("-dump_tables");
        }
        if (this.time) {
            params.add("-time");
        }
        if (this.nontermsToSymbols) {
            params.add("-nonterms");
        }
        if (this.compactRed) {
            params.add("-compact_red");
        }
        if (this.noWarn) {
            params.add("-nowarn");
        }
        if (this.noSummary) {
            params.add("-nosummary");
        }
        if (this.progress) {
            params.add("-progress");
        }
        if (this.noPositions) {
            params.add("-nopositions");
        }
        if (this.noScanner) {
            params.add("-noscanner");
        }
        if (this.locations) {
            params.add("-locations");
        }
        if (this.xmlActions) {
            params.add("-xmlactions");
        }
        if (this.genericLabels) {
            params.add("-genericlabels");
        }
        if (this.expectedConflicts > 0) {
            params.add("-expect");
            params.add(String.valueOf(this.expectedConflicts));
        }
        if (this.typeArgs != null) {
            params.add("-typearg");
            params.add(this.typeArgs);
        }
        params.add("-destdir");
        File dir = generatedFile.getParentFile();
        if (dir != null) {
            params.add(dir.getAbsolutePath());
        } else {
            params.add(this.outputDirectory.getAbsolutePath());
        }
        params.add(cupFile.getAbsolutePath());
        return params;
    }
}

