/*
 * Decompiled with CFR 0.152.
 */
package com.github.vbmacher.cup;

import com.github.vbmacher.cup.CupParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java_cup.Main;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class CupParserGenerator {
    private static final String PACKAGE = "package";
    private static final String CLASS = "class";
    private final Log log;
    private final CupParameters cupParameters;
    private final File cupDefinition;

    public CupParserGenerator(Log log, CupParameters cupParameters) {
        this.log = Objects.requireNonNull(log);
        this.cupParameters = Objects.requireNonNull(cupParameters);
        this.cupDefinition = cupParameters.getCupDefinition();
    }

    public void process() throws MojoExecutionException {
        if (this.cupDefinition.isDirectory()) {
            this.parseCupDirectory();
        } else {
            this.parseCupFile(this.cupDefinition);
        }
    }

    private void parseCupDirectory() throws MojoExecutionException {
        this.log.debug((CharSequence)("Processing directory: " + this.cupDefinition.getAbsolutePath()));
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.cupDefinition.toPath(), new CupFileFilter());){
            for (Path cupFile : stream) {
                this.parseCupFile(cupFile.toFile());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not process directory " + this.cupDefinition.getName(), (Exception)e);
        }
    }

    private void parseCupFile(File cupFile) throws MojoExecutionException {
        this.log.debug((CharSequence)("Processing CUP file " + cupFile.getName()));
        String packageName = this.determinePackageName(cupFile);
        String className = this.determineClassName(cupFile);
        this.verifyParameters(cupFile, packageName, className);
        File outputDirectory = this.cupParameters.getOutputDirectory();
        File outputFile = this.prepareOutputFile(packageName, className, outputDirectory);
        if (this.sourceNeedsProcessing(cupFile, outputFile)) {
            List<String> params = this.cupParameters.prepareCommandLine(cupFile, outputFile);
            try {
                Main.main((String[])params.toArray(new String[0]));
                this.log.info((CharSequence)("  generated " + outputFile));
                String symbolsName = this.cupParameters.getSymbolsName();
                if (symbolsName != null) {
                    File symFile = new File(outputDirectory, this.getOutputFilename(packageName, symbolsName));
                    this.log.info((CharSequence)("  generated " + symFile));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not process CUP file " + cupFile.getAbsolutePath(), e);
            }
        }
    }

    private File prepareOutputFile(String packageName, String className, File outputDirectory) {
        File generatedFile = new File(outputDirectory, this.getOutputFilename(packageName, className));
        if (generatedFile.getParentFile() != null) {
            generatedFile.getParentFile().mkdirs();
        }
        return generatedFile;
    }

    private boolean sourceNeedsProcessing(File cupFile, File generatedFile) {
        long staleMillis = this.cupParameters.getStaleMillis();
        if (cupFile.lastModified() - generatedFile.lastModified() <= staleMillis) {
            this.log.info((CharSequence)("  " + generatedFile.getName() + " is up to date."));
            this.log.debug((CharSequence)("StaleMillis = " + staleMillis + "ms"));
            return false;
        }
        return true;
    }

    private String determinePackageName(File cupFile) throws MojoExecutionException {
        String globalPackageName = this.cupParameters.getPackageName();
        if (globalPackageName == null) {
            try {
                return this.readCupEntity(PACKAGE, cupFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not read package name from CUP file " + cupFile.getName(), (Exception)e);
            }
        }
        return globalPackageName;
    }

    private String determineClassName(File cupFile) throws MojoExecutionException {
        String globalClassName = this.cupParameters.getClassName();
        if (globalClassName == null) {
            try {
                return this.readCupEntity(CLASS, cupFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not read class name from CUP file " + cupFile.getName(), (Exception)e);
            }
        }
        return globalClassName;
    }

    private String readCupEntity(String entityName, File cupFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(cupFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                int end;
                String trimmed = line.trim();
                if (!trimmed.startsWith(entityName) || (end = trimmed.indexOf(59)) <= 0) continue;
                String string = line.substring(entityName.length(), end).trim();
                return string;
            }
            String string = null;
            return string;
        }
    }

    private String getOutputFilename(String packageName, String className) {
        String packageDirectory = packageName.replace('.', File.separatorChar);
        if (!packageDirectory.isEmpty()) {
            packageDirectory = packageDirectory + File.separatorChar;
        }
        return packageDirectory + className + ".java";
    }

    private void verifyParameters(File cupFile, String packageName, String className) throws MojoExecutionException {
        if (cupFile == null) {
            throw new MojoExecutionException("<cupDefinition> is empty. Please define input file with <cupDefinition>input.cup</cupDefinition>");
        }
        if (!cupFile.isFile()) {
            throw new MojoExecutionException("Input file does not exist: " + cupFile.getAbsolutePath());
        }
        if (packageName == null) {
            throw new MojoExecutionException("Package name is not defined");
        }
        if (className == null) {
            throw new MojoExecutionException("Class name is not defined");
        }
        if (this.cupParameters.getOutputDirectory() == null) {
            throw new MojoExecutionException("Output directory is not defined");
        }
    }

    private static class CupFileFilter
    implements DirectoryStream.Filter<Path> {
        private CupFileFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            File file = entry.toFile();
            return file.isFile() && file.getName().toUpperCase().endsWith(".cup");
        }
    }
}

