/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode;

import com.googlecode.LogHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityMojo
extends AbstractMojo {
    private MavenProject project;
    private String encoding;
    private File outputDirectory;
    private FileSet templateFiles;
    private Properties templateValues;
    private String removeExtension;
    private VelocityEngine velocity;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"velocity....");
        try {
            this.velocity = new VelocityEngine();
            this.velocity.setProperty("runtime.log.logsystem", (Object)new LogHandler(this));
            this.velocity.setProperty("file.resource.loader.path", (Object)this.project.getBasedir().getAbsolutePath());
            this.velocity.init();
            VelocityContext context = new VelocityContext();
            this.addPropertiesToContext(context, this.templateValues);
            context.put("project", (Object)this.project);
            List<?> fileNames = this.expandFileSet();
            if (fileNames == null) {
                this.getLog().warn((CharSequence)"Emtpy fileset");
            } else {
                this.getLog().debug((CharSequence)"Translating files");
                for (String templateFile : fileNames) {
                    this.getLog().debug((CharSequence)("templateFile -> " + templateFile));
                    this.translateFile(this.templateFiles.getDirectory(), templateFile, context);
                }
            }
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException("Resource not found", (Exception)((Object)e));
        }
        catch (VelocityException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save result", (Exception)e);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Unexpected", e);
        }
    }

    private void addPropertiesToContext(VelocityContext context, Properties prop) {
        this.getLog().debug((CharSequence)("Exporting properties to context: " + prop));
        if (prop == null) {
            return;
        }
        Enumeration<?> propEnumeration = prop.propertyNames();
        while (propEnumeration.hasMoreElements()) {
            String key = (String)propEnumeration.nextElement();
            String value = prop.getProperty(key);
            this.getLog().debug((CharSequence)(key + "=" + value));
            context.put(key, (Object)value);
        }
    }

    private List<?> expandFileSet() throws IOException {
        File baseDir = new File(this.project.getBasedir().getAbsolutePath() + File.separator + this.templateFiles.getDirectory());
        this.getLog().debug((CharSequence)baseDir.getAbsolutePath());
        String includes = this.list2CvsString(this.templateFiles.getIncludes());
        this.getLog().debug((CharSequence)("includes: " + includes));
        String excludes = this.list2CvsString(this.templateFiles.getExcludes());
        this.getLog().debug((CharSequence)("excludes: " + excludes));
        return FileUtils.getFileNames((File)baseDir, (String)includes, (String)excludes, (boolean)false);
    }

    private String list2CvsString(List<?> patterns) {
        String delim = "";
        StringBuffer buf = new StringBuffer();
        if (patterns != null) {
            Iterator<?> i = patterns.iterator();
            while (i.hasNext()) {
                buf.append(delim).append(i.next());
                delim = ", ";
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateFile(String basedir, String templateFile, VelocityContext context) throws ResourceNotFoundException, VelocityException, MojoExecutionException, IOException {
        File result;
        File dir;
        Template template = null;
        String tmpTemplateFile = templateFile;
        String inputFile = basedir + File.separator + tmpTemplateFile;
        this.getLog().debug((CharSequence)("inputFile -> " + inputFile));
        try {
            template = this.velocity.getTemplate(inputFile, this.encoding == null ? "UTF-8" : this.encoding);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Failed to load: " + inputFile));
            throw new MojoExecutionException("Get template failed: " + inputFile, e);
        }
        StringWriter sw = new StringWriter();
        try {
            template.merge((Context)context, (Writer)sw);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Failed to merge: " + inputFile + ":" + e.getMessage()));
            throw new MojoExecutionException("Fail to merge template: " + inputFile, e);
        }
        if (this.removeExtension != null && !this.removeExtension.trim().equals("") && tmpTemplateFile.endsWith(this.removeExtension)) {
            String tmp = tmpTemplateFile.substring(0, tmpTemplateFile.length() - this.removeExtension.length());
            if (tmp.endsWith("/")) {
                this.getLog().warn((CharSequence)("removePrefix equals filename will not remove it. " + tmpTemplateFile));
            } else {
                tmpTemplateFile = tmp;
            }
        }
        if (!(dir = (result = new File(this.outputDirectory.getAbsoluteFile() + File.separator + tmpTemplateFile)).getParentFile()).exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Failed to create outputDirectory");
        }
        FileOutputStream os = new FileOutputStream(result);
        try {
            os.write(sw.toString().getBytes(this.encoding == null ? "UTF-8" : this.encoding));
        }
        finally {
            os.close();
        }
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    void setTemplateFiles(FileSet templateFiles) {
        this.templateFiles = templateFiles;
    }

    void setTemplateValues(Properties templateValues) {
        this.templateValues = templateValues;
    }
}

