/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class ExternalProgramConfig {
    private static TN5250jLogger log = TN5250jLogFactory.getLogger("org.tn5250j.ExternalProgramConfig");
    private static ExternalProgramConfig etnConfig;
    public static final String EXTERNAL_PROGRAM_REGISTRY_KEY = "etnPgmProps";
    public static final String EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME = "tn5250jExternalProgram.properties";
    public static final String EXTERNAL_PROGRAM_HEADER = "External Program Settings";
    private Properties etnPgmProps = this.loadExternalProgramSettings();
    private static Properties props;
    private static JTextField name;
    private static JTextField wCommand;
    private static JTextField uCommand;
    private static JDialog dialog;
    private static Object[] options;
    private static String num;

    public static ExternalProgramConfig getInstance() {
        if (etnConfig == null) {
            etnConfig = new ExternalProgramConfig();
        }
        return etnConfig;
    }

    private ExternalProgramConfig() {
    }

    public Properties getEtnPgmProps() {
        return this.etnPgmProps;
    }

    private final Properties loadExternalProgramSettings() {
        Properties etnProps = null;
        try {
            etnProps = ConfigureFactory.getInstance().getProperties(EXTERNAL_PROGRAM_REGISTRY_KEY, EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME, false, "Default Settings");
            log.info("begin loading external program settings");
            if (etnProps.size() == 0) {
                Properties defaultProps = new Properties();
                URL file = null;
                ClassLoader cl = this.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                file = cl.getResource(EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME);
                defaultProps.load(file.openStream());
                Enumeration<Object> e = defaultProps.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    etnProps.setProperty(key, defaultProps.getProperty(key));
                }
                ConfigureFactory.getInstance().saveSettings(EXTERNAL_PROGRAM_REGISTRY_KEY, EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME, EXTERNAL_PROGRAM_HEADER);
            }
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
        }
        catch (SecurityException se) {
            log.error(se.getMessage());
        }
        return etnProps;
    }

    public static String doEntry(Frame parent, String propKey, Properties props2) {
        String title;
        props = props2;
        name = new JTextField(20);
        wCommand = new JTextField(40);
        uCommand = new JTextField(40);
        if (propKey != null) {
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!propKey.equals(props.getProperty(key))) continue;
                String subKey = key.substring(8);
                int index = subKey.indexOf(".");
                num = subKey.substring(0, index);
                name.setText(props.getProperty("etn.pgm." + num + ".command.name"));
                wCommand.setText(props.getProperty("etn.pgm." + num + ".command.window"));
                uCommand.setText(props.getProperty("etn.pgm." + num + ".command.unix"));
            }
        }
        JPanel etnp = new JPanel();
        AlignLayout snpLayout = new AlignLayout(2, 5, 5);
        etnp.setLayout(snpLayout);
        etnp.setBorder(BorderFactory.createEtchedBorder());
        ExternalProgramConfig.addLabelComponent(LangTool.getString("customized.name"), name, etnp);
        ExternalProgramConfig.addLabelComponent(LangTool.getString("customized.window"), wCommand, etnp);
        ExternalProgramConfig.addLabelComponent(LangTool.getString("customized.unix"), uCommand, etnp);
        name.setAlignmentX(0.5f);
        Object[] message = new Object[]{etnp};
        options = new JButton[2];
        final String propKey2 = propKey;
        if (propKey2 == null) {
            AbstractAction add = new AbstractAction(LangTool.getString("conf.optAdd")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalProgramConfig.doConfigureAction(propKey2);
                }
            };
            ExternalProgramConfig.options[0] = new JButton(add);
            ((JButton)options[0]).setEnabled(false);
            title = LangTool.getString("customized.addEntryTitle");
            name.setDocument(new SomethingEnteredDocument());
        } else {
            AbstractAction edit = new AbstractAction(LangTool.getString("conf.optEdit")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalProgramConfig.doConfigureAction(propKey2);
                }
            };
            ExternalProgramConfig.options[0] = new JButton(edit);
            title = LangTool.getString("customized.editEntryTitle");
            name.setEditable(false);
        }
        AbstractAction cancel = new AbstractAction(LangTool.getString("conf.optCancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        ExternalProgramConfig.options[1] = new JButton(cancel);
        JOptionPane pane = new JOptionPane(message, -1, -1, null, options, options[0]);
        Frame parentComponent = parent;
        pane.setInitialValue(options[0]);
        pane.setComponentOrientation(parentComponent.getComponentOrientation());
        dialog = pane.createDialog(parentComponent, title);
        dialog.setVisible(true);
        return name.getText();
    }

    private static void addLabelComponent(String text, Component comp, Container container) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        label.setHorizontalTextPosition(2);
        container.add(label);
        container.add(comp);
    }

    private static void doConfigureAction(String propKey) {
        if (propKey == null) {
            String count = props.getProperty("etn.pgm.support.total.num");
            int maxNum = Integer.parseInt(count) + 1;
            props.setProperty("etn.pgm.support.total.num", String.valueOf(maxNum));
            props.setProperty("etn.pgm." + maxNum + ".command.name", name.getText());
            props.setProperty("etn.pgm." + maxNum + ".command.window", wCommand.getText());
            props.setProperty("etn.pgm." + maxNum + ".command.unix", uCommand.getText());
        } else {
            props.setProperty("etn.pgm." + num + ".command.name", name.getText());
            props.setProperty("etn.pgm." + num + ".command.window", wCommand.getText());
            props.setProperty("etn.pgm." + num + ".command.unix", uCommand.getText());
        }
        dialog.dispose();
    }

    private static void doSomethingEntered() {
        ((JButton)options[0]).setEnabled(true);
    }

    private static void doNothingEntered() {
        ((JButton)options[0]).setEnabled(false);
    }

    static {
        props = null;
        name = null;
        wCommand = null;
        uCommand = null;
        dialog = null;
        num = "1";
    }

    private static class SomethingEnteredDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private SomethingEnteredDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (this.getText(0, this.getLength()).length() > 0) {
                ExternalProgramConfig.doSomethingEntered();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            if (this.getText(0, this.getLength()).length() == 0) {
                ExternalProgramConfig.doNothingEntered();
            }
        }
    }
}

