/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class GlobalConfigure
extends ConfigureFactory {
    public static final String TN5250J_FOLDER = ".tn5250j";
    private static GlobalConfigure _instance;
    private static Properties settings;
    private static Hashtable registry;
    private static Hashtable headers;
    public static final File ses;
    private static final String settingsFile = "tn5250jstartup.cfg";
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public GlobalConfigure() {
        if (_instance == null) {
            this.initialize();
            _instance = this;
        }
    }

    public static GlobalConfigure instance() {
        if (_instance == null) {
            _instance = new GlobalConfigure();
        }
        return _instance;
    }

    private void initialize() {
        this.verifiySettingsFolder();
        this.loadSettings();
        this.loadSessions();
        this.loadMacros();
        this.loadKeyStrokes();
    }

    private void verifiySettingsFolder() {
        block4: {
            String settingsfolder = System.getProperty("user.home") + File.separator + TN5250J_FOLDER;
            File f = new File(settingsfolder);
            if (!f.exists()) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Settings folder '" + settingsfolder + "' doesn't exist. Will created now.");
                    }
                    f.mkdir();
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break block4;
                    this.log.warn("Couldn't create settings folder '" + settingsfolder + "'", e);
                }
            }
        }
    }

    private void loadSessions() {
        this.setProperties("sessions", "sessions", "------ Sessions --------", true);
    }

    private void loadMacros() {
        this.setProperties("macros", "macros", "------ Macros --------", true);
    }

    private void loadKeyStrokes() {
        this.setProperties("keymap", "keymap", "------ Key Map key=keycode,isShiftDown,isControlDown,isAltDown,isAltGrDown --------", true);
    }

    @Override
    public void reloadSettings() {
        if (this.log.isInfoEnabled()) {
            this.log.info("reloading settings");
        }
        this.loadSettings();
        this.loadSessions();
        this.loadMacros();
        this.loadKeyStrokes();
        if (this.log.isInfoEnabled()) {
            this.log.info("Done (reloading settings).");
        }
    }

    private void loadSettings() {
        FileInputStream in = null;
        FileInputStream again = null;
        settings = new Properties();
        if (System.getProperties().containsKey("emulator.settingsDirectory")) {
            settings.setProperty("emulator.settingsDirectory", System.getProperty("emulator.settingsDirectory") + File.separator);
            this.checkDirs();
        } else {
            settings.setProperty("emulator.settingsDirectory", System.getProperty("user.home") + File.separator + TN5250J_FOLDER + File.separator);
            try {
                in = new FileInputStream(settingsFile);
                settings.load(in);
            }
            catch (FileNotFoundException fnfe) {
                try {
                    again = new FileInputStream(this.settingsDirectory() + settingsFile);
                    settings.load(again);
                }
                catch (FileNotFoundException fnfea) {
                    this.log.info(" Information Message: " + fnfea.getMessage() + ".  The file " + settingsFile + " will be created for first time use.");
                    this.checkLegacy();
                    this.saveSettings();
                }
                catch (IOException ioea) {
                    this.log.warn("IO Exception accessing File tn5250jstartup.cfg for the following reason : " + ioea.getMessage());
                }
                catch (SecurityException sea) {
                    this.log.warn("Security Exception for file tn5250jstartup.cfg  This file can not be accessed because : " + sea.getMessage());
                }
            }
            catch (IOException ioe) {
                this.log.warn("IO Exception accessing File tn5250jstartup.cfg for the following reason : " + ioe.getMessage());
            }
            catch (SecurityException se) {
                this.log.warn("Security Exception for file tn5250jstartup.cfg  This file can not be accessed because : " + se.getMessage());
            }
        }
    }

    private void checkDirs() {
        File sd = new File(settings.getProperty("emulator.settingsDirectory"));
        if (!sd.isDirectory()) {
            sd.mkdirs();
        }
    }

    private void checkLegacy() {
        if (ses.exists()) {
            int cfc = JOptionPane.showConfirmDialog(null, "Dear User,\n\nSeems you are using an old version of tn5250j.\nIn meanwhile the application became multi-user capable,\nwhich means ALL the config- and settings-files are\nplaced in your home-dir to avoid further problems in\nthe near future.\n\nYou have the choice to choose if you want the files\nto be copied or not, please make your choice !\n\nShall we copy the files to the new location ?", "Old install detected", 2, 0);
            if (cfc == 0) {
                this.checkDirs();
                this.copyConfigs("sessions");
                this.copyConfigs("macros");
                this.copyConfigs("keymap");
            } else {
                JOptionPane.showMessageDialog(null, "Dear User,\n\nYou choosed not to copy the file.\nThis means the program will end here.\n\nTo use this NON-STANDARD behaviour start tn5250j\nwith -Demulator.settingsDirectory=<settings-dir> \nas a parameter to avoid this question all the time.", "Using NON-STANDARD behaviour", 2);
                System.exit(0);
            }
        }
    }

    private void copyConfigs(String sesFile) {
        String srcFile = System.getProperty("user.dir") + File.separator + sesFile;
        String dest = System.getProperty("user.home") + File.separator + TN5250J_FOLDER + File.separator + sesFile;
        File rmvFile = new File(sesFile);
        try {
            FileReader r = new FileReader(srcFile);
            BufferedReader b = new BufferedReader(r);
            FileWriter w = new FileWriter(dest);
            PrintWriter p = new PrintWriter(w);
            String regel = b.readLine();
            while (regel != null) {
                p.println(regel);
                regel = b.readLine();
            }
            b.close();
            p.close();
            rmvFile.delete();
        }
        catch (FileNotFoundException e) {
            this.log.warn(srcFile + " not found !");
        }
        catch (IOException e) {
            this.log.warn("Global io-error !");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void saveSettings() {
        try {
            FileOutputStream out = new FileOutputStream(this.settingsDirectory() + settingsFile);
            settings.store(out, "----------------- tn5250j Global Settings --------------");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void saveSettings(String regKey) {
        this.saveSettings(regKey, "");
    }

    @Override
    public void saveSettings(String regKey, String header) {
        this.saveSettings(regKey, regKey, header);
    }

    @Override
    public void saveSettings(String regKey, String fileName, String header) {
        if (registry.containsKey(regKey)) {
            try {
                FileOutputStream out = new FileOutputStream(this.settingsDirectory() + fileName);
                Properties props = (Properties)registry.get(regKey);
                props.store(out, header);
                out.flush();
                out.close();
            }
            catch (FileNotFoundException fnfe) {
                this.log.warn("File not found : writing file " + fileName + ".  Description of error is " + fnfe.getMessage());
            }
            catch (IOException ioe) {
                this.log.warn("IO Exception : writing file " + fileName + ".  Description of error is " + ioe.getMessage());
            }
            catch (SecurityException se) {
                this.log.warn("Security Exception : writing file " + fileName + ".  Description of error is " + se.getMessage());
            }
        }
    }

    @Override
    public void setProperties(String regKey, Properties regProps) {
        registry.put(regKey, regProps);
    }

    @Override
    public void setProperties(String regKey, String fileName, String header) {
        this.setProperties(regKey, fileName, header, false);
    }

    @Override
    public void setProperties(String regKey, String fileName, String header, boolean createFile) {
        FileInputStream in = null;
        Properties props = new Properties();
        headers.put(regKey, header);
        try {
            in = new FileInputStream(this.settingsDirectory() + fileName);
            props.load(in);
        }
        catch (FileNotFoundException fnfe) {
            if (createFile) {
                this.log.info(" Information Message: " + fnfe.getMessage() + ".  The file " + fileName + " will be created for first time use.");
                this.saveSettings(regKey, header);
            } else {
                this.log.info(" Information Message: " + fnfe.getMessage() + ".");
            }
        }
        catch (IOException ioe) {
            this.log.warn("IO Exception accessing File " + fileName + " for the following reason : " + ioe.getMessage());
        }
        catch (SecurityException se) {
            this.log.warn("Security Exception for file " + fileName + ".  This file can not be accessed because : " + se.getMessage());
        }
        registry.put(regKey, props);
    }

    @Override
    public Properties getProperties(String regKey) {
        if (registry.containsKey(regKey)) {
            return (Properties)registry.get(regKey);
        }
        return null;
    }

    public Properties getProperties() {
        return settings;
    }

    @Override
    public Properties getProperties(String regKey, String fileName) {
        return this.getProperties(regKey, fileName, false, "", false);
    }

    @Override
    public Properties getProperties(String regKey, String fileName, boolean createFile, String header) {
        return this.getProperties(regKey, fileName, false, "", false);
    }

    @Override
    public Properties getProperties(String regKey, String fileName, boolean createFile, String header, boolean reloadIfLoaded) {
        if (!registry.containsKey(regKey) || reloadIfLoaded) {
            FileInputStream in = null;
            Properties props = new Properties();
            headers.put(regKey, header);
            try {
                in = new FileInputStream(this.settingsDirectory() + fileName);
                props.load(in);
            }
            catch (FileNotFoundException fnfe) {
                if (createFile) {
                    this.log.info(" Information Message: " + fnfe.getMessage() + ".  The file " + fileName + " will be created for first time use.");
                    registry.put(regKey, props);
                    this.saveSettings(regKey, header);
                    return props;
                }
                this.log.info(" Information Message: " + fnfe.getMessage() + ".");
            }
            catch (IOException ioe) {
                this.log.warn("IO Exception accessing File " + fileName + " for the following reason : " + ioe.getMessage());
            }
            catch (SecurityException se) {
                this.log.warn("Security Exception for file " + fileName + ".  This file can not be accessed because : " + se.getMessage());
            }
            registry.put(regKey, props);
            return props;
        }
        return (Properties)registry.get(regKey);
    }

    @Override
    public String getProperty(String key, String def) {
        if (settings.containsKey(key)) {
            return settings.getProperty(key);
        }
        return def;
    }

    @Override
    public String getProperty(String key) {
        return settings.getProperty(key);
    }

    private String settingsDirectory() {
        return settings.getProperty("emulator.settingsDirectory");
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = GlobalConfigure.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    static {
        registry = new Hashtable();
        headers = new Hashtable();
        ses = new File("sessions");
    }
}

