/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tn5250j.My5250;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionJumpEvent;
import org.tn5250j.event.SessionJumpListener;
import org.tn5250j.event.SessionListener;
import org.tn5250j.event.TabClosedListener;
import org.tn5250j.gui.ButtonTabComponent;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.GUIViewInterface;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class Gui5250Frame
extends GUIViewInterface
implements ChangeListener,
TabClosedListener,
SessionListener,
SessionJumpListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane sessTabbedPane = new JTabbedPane();
    private boolean embedded = false;
    private boolean hideTabBar = false;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public Gui5250Frame(My5250 m) {
        super(m);
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.log.warn("Error during initializing!", e);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.frameSeq = sequence++;
        this.sessTabbedPane.setBorder(BorderFactory.createEtchedBorder());
        this.sessTabbedPane.setBounds(new Rectangle(78, 57, 5, 5));
        this.sessTabbedPane.setOpaque(true);
        this.sessTabbedPane.setRequestFocusEnabled(false);
        this.sessTabbedPane.setDoubleBuffered(false);
        this.sessTabbedPane.addChangeListener(this);
        Properties props = ConfigureFactory.getInstance().getProperties("sessions");
        if (props.getProperty("emul.hideTabBar", "no").equals("yes")) {
            this.hideTabBar = true;
        }
        if (!this.hideTabBar) {
            this.getContentPane().add((Component)this.sessTabbedPane, "Center");
        }
        if (this.packFrame) {
            this.pack();
        } else {
            this.validate();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            SessionPanel sesspanel;
            int i;
            int len;
            int oldidx = this.sessTabbedPane.getSelectedIndex();
            boolean close = true;
            if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
                len = this.getContentPane().getComponentCount();
                for (i = 0; i < len; ++i) {
                    if (!(this.getContentPane().getComponent(i) instanceof SessionPanel)) continue;
                    sesspanel = (SessionPanel)this.getContentPane().getComponent(i);
                    close &= sesspanel.confirmCloseSession(false);
                    break;
                }
            }
            len = this.sessTabbedPane.getTabCount();
            for (i = 0; i < len && close; close &= sesspanel.confirmCloseSession(false), ++i) {
                this.sessTabbedPane.setSelectedIndex(i);
                this.updateSessionTitle();
                sesspanel = (SessionPanel)this.sessTabbedPane.getSelectedComponent();
            }
            if (!close) {
                this.sessTabbedPane.setSelectedIndex(oldidx);
                this.updateSessionTitle();
                return;
            }
            super.processWindowEvent(e);
            me.closingDown(this);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void onSessionJump(SessionJumpEvent jumpEvent) {
        switch (jumpEvent.getJumpDirection()) {
            case 0: {
                this.prevSession();
                break;
            }
            case 1: {
                this.nextSession();
            }
        }
    }

    private void nextSession() {
        final int index = this.sessTabbedPane.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int index1 = index;
                if (index1 < Gui5250Frame.this.sessTabbedPane.getTabCount() - 1) {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(++index1);
                } else {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(0);
                }
                Gui5250Frame.this.updateSessionTitle();
            }
        });
    }

    private void prevSession() {
        final int index = this.sessTabbedPane.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int index1 = index;
                if (index1 == 0) {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(Gui5250Frame.this.sessTabbedPane.getTabCount() - 1);
                } else {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(--index1);
                }
                Gui5250Frame.this.updateSessionTitle();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane p = (JTabbedPane)e.getSource();
        this.setSessionTitle((SessionPanel)p.getSelectedComponent());
    }

    private void setSessionTitle(SessionPanel session) {
        if (session != null && session.isConnected()) {
            String name = this.determineTabName(session);
            if (sequence - 1 > 0) {
                this.setTitle(name + " - tn5250j <" + sequence + ">");
            } else {
                this.setTitle(name + " - tn5250j");
            }
        } else if (sequence - 1 > 0) {
            this.setTitle("tn5250j <" + sequence + ">");
        } else {
            this.setTitle("tn5250j");
        }
    }

    private String determineTabName(SessionPanel sessiongui) {
        assert (sessiongui != null);
        String name = sessiongui.getSession().isUseSystemName() ? sessiongui.getSessionName() : (sessiongui.getAllocDeviceName() != null ? sessiongui.getAllocDeviceName() : sessiongui.getHostName());
        return name;
    }

    private void updateSessionTitle() {
        SessionPanel selectedComponent = (SessionPanel)this.sessTabbedPane.getSelectedComponent();
        this.setSessionTitle(selectedComponent);
    }

    @Override
    public void addSessionView(String tabText, SessionPanel sesspanel) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0 && !this.embedded) {
            this.getContentPane().add((Component)sesspanel, "Center");
            sesspanel.addSessionListener(this);
            sesspanel.resizeMe();
            this.repaint();
            if (this.packFrame) {
                this.pack();
            } else {
                this.validate();
            }
            this.embedded = true;
            sesspanel.requestFocusInWindow();
            this.setSessionTitle(sesspanel);
        } else {
            if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
                SessionPanel firstsesgui = null;
                for (int x = 0; x < this.getContentPane().getComponentCount(); ++x) {
                    if (!(this.getContentPane().getComponent(x) instanceof SessionPanel)) continue;
                    firstsesgui = (SessionPanel)this.getContentPane().getComponent(x);
                    this.getContentPane().remove(x);
                    break;
                }
                this.createTabWithSessionContent(tabText, firstsesgui, false);
                this.sessTabbedPane.setTitleAt(0, this.determineTabName(firstsesgui));
                this.getContentPane().add((Component)this.sessTabbedPane, "Center");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Gui5250Frame.this.repaint();
                    }
                });
            }
            this.createTabWithSessionContent(tabText, sesspanel, true);
        }
    }

    private final void createTabWithSessionContent(String tabText, final SessionPanel sesgui, final boolean focus) {
        this.sessTabbedPane.addTab(tabText, Gui5250Frame.determineIconForSession(sesgui.session), sesgui);
        final int idx = this.sessTabbedPane.indexOfComponent(sesgui);
        ButtonTabComponent bttab = new ButtonTabComponent(this.sessTabbedPane);
        bttab.addTabCloseListener(this);
        this.sessTabbedPane.setTabComponentAt(idx, bttab);
        sesgui.addSessionListener(this);
        sesgui.addSessionJumpListener(this);
        sesgui.addSessionListener(bttab);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sesgui.resizeMe();
                sesgui.repaint();
                if (focus) {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(idx);
                    sesgui.requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public void onTabClosed(int tabToBeClosed) {
        SessionPanel sesspanel = this.getSessionAt(tabToBeClosed);
        sesspanel.confirmCloseSession(true);
    }

    @Override
    public void removeSessionView(SessionPanel targetSession) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int x = 0; x < this.getContentPane().getComponentCount(); ++x) {
                if (!(this.getContentPane().getComponent(x) instanceof SessionPanel)) continue;
                this.getContentPane().remove(x);
            }
        } else {
            int index = this.sessTabbedPane.indexOfComponent(targetSession);
            this.log.info("session found and closing down " + index);
            targetSession.removeSessionListener(this);
            targetSession.removeSessionJumpListener(this);
            this.sessTabbedPane.remove(index);
        }
    }

    @Override
    public int getSessionViewCount() {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int x = 0; x < this.getContentPane().getComponentCount(); ++x) {
                if (!(this.getContentPane().getComponent(x) instanceof SessionPanel)) continue;
                return 1;
            }
            return 0;
        }
        return this.sessTabbedPane.getTabCount();
    }

    @Override
    public SessionPanel getSessionAt(int index) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int x = 0; x < this.getContentPane().getComponentCount(); ++x) {
                if (!(this.getContentPane().getComponent(x) instanceof SessionPanel)) continue;
                return (SessionPanel)this.getContentPane().getComponent(x);
            }
            return null;
        }
        if (this.sessTabbedPane.getTabCount() <= 0) {
            return null;
        }
        return (SessionPanel)this.sessTabbedPane.getComponentAt(index);
    }

    @Override
    public void onSessionChanged(SessionChangeEvent changeEvent) {
        Session5250 ses5250 = (Session5250)changeEvent.getSource();
        final SessionPanel sesgui = ses5250.getGUI();
        final int tabidx = this.sessTabbedPane.indexOfComponent(sesgui);
        if (tabidx >= 0 && tabidx < this.sessTabbedPane.getTabCount()) {
            this.sessTabbedPane.setIconAt(tabidx, Gui5250Frame.determineIconForSession(ses5250));
        }
        switch (changeEvent.getState()) {
            case 1: {
                String devname = sesgui.getAllocDeviceName();
                if (devname == null) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SessionChangedEvent: " + changeEvent.getState() + " " + devname);
                }
                if (tabidx >= 0 && tabidx < this.sessTabbedPane.getTabCount()) {
                    Runnable tc = new Runnable(){

                        @Override
                        public void run() {
                            Gui5250Frame.this.sessTabbedPane.setTitleAt(tabidx, Gui5250Frame.this.determineTabName(sesgui));
                        }
                    };
                    SwingUtilities.invokeLater(tc);
                }
                this.updateSessionTitle();
            }
        }
    }

    private static final Icon determineIconForSession(Session5250 ses5250) {
        if (ses5250 != null && ses5250.isSslConfigured()) {
            if (ses5250.isSslSocket()) {
                return GUIGraphicsUtils.getClosedLockIcon();
            }
            return GUIGraphicsUtils.getOpenLockIcon();
        }
        return null;
    }

    @Override
    public boolean containsSession(SessionPanel session) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int x = 0; x < this.getContentPane().getComponentCount(); ++x) {
                if (!(this.getContentPane().getComponent(x) instanceof SessionPanel)) continue;
                return ((SessionPanel)this.getContentPane().getComponent(x)).equals(session);
            }
            return false;
        }
        return this.sessTabbedPane.indexOfComponent(session) >= 0;
    }
}

