/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.ScreenListener;
import org.tn5250j.event.ScreenOIAListener;
import org.tn5250j.event.SessionConfigEvent;
import org.tn5250j.event.SessionConfigListener;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenOIA;
import org.tn5250j.sessionsettings.ColumnSeparator;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class GuiGraphicBuffer
implements ScreenOIAListener,
ScreenListener,
PropertyChangeListener,
SessionConfigListener,
ActionListener {
    private static final transient char[] dupChar = new char[]{'*'};
    private BufferedImage bi;
    private final Object lock = new Object();
    private Line2D separatorLine = new Line2D.Float();
    private Rectangle2D tArea;
    private Rectangle2D aArea;
    private Rectangle2D cArea;
    private Rectangle2D sArea;
    private Rectangle2D pArea;
    private Rectangle2D mArea;
    private Rectangle2D iArea;
    private Rectangle2D kbArea;
    private Rectangle2D scriptArea;
    private Rectangle2D cursor = new Rectangle2D.Float();
    private static final String xSystem = "X - System";
    private static final String xError = "X - II";
    private int crossRow;
    private Rectangle crossRect = new Rectangle();
    private int offTop = 0;
    private int offLeft = 0;
    private boolean antialiased = true;
    private Graphics2D gg2d;
    private Screen5250 screen;
    private Data updateRect;
    protected int columnWidth;
    protected int rowHeight;
    private SessionPanel gui;
    private LineMetrics lm;
    Font font;
    private int lenScreen;
    private boolean showHex;
    private Color colorBlue;
    private Color colorWhite;
    private Color colorRed;
    private Color colorGreen;
    private Color colorPink;
    private Color colorYellow;
    Color colorBg;
    private Color colorTurq;
    private Color colorGUIField;
    private Color colorCursor;
    private Color colorSep;
    private Color colorHexAttr;
    protected int crossHair = 0;
    private boolean updateFont;
    private int cursorSize = 0;
    protected boolean hotSpots = false;
    private float sfh = 1.2f;
    private float sfw = 1.0f;
    private float ps132 = 0.0f;
    private boolean cfg_guiInterface = false;
    private boolean cfg_guiShowUnderline = true;
    private int cursorBottOffset;
    private boolean rulerFixed;
    private Timer blinker;
    private ColumnSeparator colSepLine;
    private final StringBuffer hsMore = new StringBuffer("More...");
    private final StringBuffer hsBottom = new StringBuffer("Bottom");
    private Rectangle workR = new Rectangle();
    private boolean colSep = false;
    private boolean underLine = false;
    private boolean nonDisplay = false;
    private Color fg;
    private Color bg;
    private SessionConfig config;
    protected Rectangle clipper;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger("GFX");

    public GuiGraphicBuffer(Screen5250 screen, SessionPanel gui, SessionConfig config) {
        this.screen = screen;
        this.config = config;
        this.gui = gui;
        config.addSessionConfigListener(this);
        this.loadProps();
        String fontName = null;
        if (config.isPropertyExists("font") && !GUIGraphicsUtils.isFontNameExists(fontName = this.getStringProperty("font"))) {
            fontName = null;
        }
        if (fontName == null) {
            this.font = new Font(GUIGraphicsUtils.getDefaultFont(), 0, 14);
            config.setProperty("font", this.font.getFontName());
        } else {
            this.font = new Font(fontName, 0, 14);
        }
        gui.setFont(this.font);
        this.getSettings();
        FontRenderContext frc = new FontRenderContext(this.font.getTransform(), true, true);
        this.lm = this.font.getLineMetrics("Wy", frc);
        this.columnWidth = (int)this.font.getStringBounds("W", frc).getWidth() + 1;
        this.rowHeight = (int)(this.font.getStringBounds("g", frc).getHeight() + (double)this.lm.getDescent() + (double)this.lm.getLeading());
        screen.getOIA().addOIAListener(this);
        screen.addScreenListener(this);
        this.tArea = new Rectangle2D.Float();
        this.cArea = new Rectangle2D.Float();
        this.aArea = new Rectangle2D.Float();
        this.sArea = new Rectangle2D.Float();
        this.pArea = new Rectangle2D.Float();
        this.mArea = new Rectangle2D.Float();
        this.iArea = new Rectangle2D.Float();
        this.kbArea = new Rectangle2D.Float();
        this.scriptArea = new Rectangle2D.Float();
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() instanceof Timer) {
            if (this.screen.isCursorActive()) {
                this.screen.setCursorActive(false);
            } else {
                this.screen.setCursorActive(true);
            }
        }
    }

    public boolean isBlinkCursor() {
        return this.blinker != null;
    }

    public void resize(int width, int height) {
        if (this.bi.getWidth() != width || this.bi.getHeight() != height) {
            this.bi = null;
            this.bi = new BufferedImage(width, height, 1);
            this.getSettings();
        }
    }

    private void getSettings() {
        this.lenScreen = this.screen.getScreenLength();
    }

    protected final void loadColors() {
        this.colorBlue = new Color(140, 120, 255);
        this.colorTurq = new Color(0, 240, 255);
        this.colorRed = Color.red;
        this.colorWhite = Color.white;
        this.colorYellow = Color.yellow;
        this.colorGreen = Color.green;
        this.colorPink = Color.magenta;
        this.colorGUIField = Color.white;
        this.colorSep = Color.white;
        this.colorHexAttr = Color.white;
        this.colorBg = this.cfg_guiInterface ? Color.lightGray : Color.black;
        this.colorCursor = Color.white;
        if (!this.config.isPropertyExists("colorBg")) {
            this.setProperty("colorBg", Integer.toString(this.colorBg.getRGB()));
        } else {
            this.colorBg = this.getColorProperty("colorBg");
        }
        this.gui.setBackground(this.colorBg);
        if (!this.config.isPropertyExists("colorBlue")) {
            this.setProperty("colorBlue", Integer.toString(this.colorBlue.getRGB()));
        } else {
            this.colorBlue = this.getColorProperty("colorBlue");
        }
        if (!this.config.isPropertyExists("colorTurq")) {
            this.setProperty("colorTurq", Integer.toString(this.colorTurq.getRGB()));
        } else {
            this.colorTurq = this.getColorProperty("colorTurq");
        }
        if (!this.config.isPropertyExists("colorRed")) {
            this.setProperty("colorRed", Integer.toString(this.colorRed.getRGB()));
        } else {
            this.colorRed = this.getColorProperty("colorRed");
        }
        if (!this.config.isPropertyExists("colorWhite")) {
            this.setProperty("colorWhite", Integer.toString(this.colorWhite.getRGB()));
        } else {
            this.colorWhite = this.getColorProperty("colorWhite");
        }
        if (!this.config.isPropertyExists("colorYellow")) {
            this.setProperty("colorYellow", Integer.toString(this.colorYellow.getRGB()));
        } else {
            this.colorYellow = this.getColorProperty("colorYellow");
        }
        if (!this.config.isPropertyExists("colorGreen")) {
            this.setProperty("colorGreen", Integer.toString(this.colorGreen.getRGB()));
        } else {
            this.colorGreen = this.getColorProperty("colorGreen");
        }
        if (!this.config.isPropertyExists("colorPink")) {
            this.setProperty("colorPink", Integer.toString(this.colorPink.getRGB()));
        } else {
            this.colorPink = this.getColorProperty("colorPink");
        }
        if (!this.config.isPropertyExists("colorGUIField")) {
            this.setProperty("colorGUIField", Integer.toString(this.colorGUIField.getRGB()));
        } else {
            this.colorGUIField = this.getColorProperty("colorGUIField");
        }
        if (!this.config.isPropertyExists("colorCursor")) {
            this.setProperty("colorCursor", Integer.toString(this.colorCursor.getRGB()));
        } else {
            this.colorCursor = this.getColorProperty("colorCursor");
        }
        if (!this.config.isPropertyExists("colorSep")) {
            this.colorSep = this.colorWhite;
            this.setProperty("colorSep", Integer.toString(this.colorSep.getRGB()));
        } else {
            this.colorSep = this.getColorProperty("colorSep");
        }
        if (!this.config.isPropertyExists("colorHexAttr")) {
            this.colorHexAttr = this.colorWhite;
            this.setProperty("colorHexAttr", Integer.toString(this.colorHexAttr.getRGB()));
        } else {
            this.colorHexAttr = this.getColorProperty("colorHexAttr");
        }
    }

    public void loadProps() {
        this.loadColors();
        this.colSepLine = ColumnSeparator.getFromName(this.getStringProperty("colSeparator"));
        if (this.config.isPropertyExists("showAttr") && this.getStringProperty("showAttr").equals("Hex")) {
            this.showHex = true;
        }
        if (this.config.isPropertyExists("guiInterface")) {
            if (this.getStringProperty("guiInterface").equals("Yes")) {
                this.screen.setUseGUIInterface(true);
                this.cfg_guiInterface = true;
            } else {
                this.screen.setUseGUIInterface(false);
                this.cfg_guiInterface = false;
            }
        }
        if (this.config.isPropertyExists("guiShowUnderline")) {
            this.cfg_guiShowUnderline = this.getStringProperty("guiShowUnderline").equals("Yes");
        }
        if (this.config.isPropertyExists("hotspots")) {
            this.hotSpots = this.getStringProperty("hotspots").equals("Yes");
        }
        if (this.config.isPropertyExists("hsMore") && this.getStringProperty("hsMore").length() > 0) {
            this.hsMore.setLength(0);
            this.hsMore.append(this.getStringProperty("hsMore"));
        }
        if (this.config.isPropertyExists("hsBottom") && this.getStringProperty("hsBottom").length() > 0) {
            this.hsBottom.setLength(0);
            this.hsBottom.append(this.getStringProperty("hsBottom"));
        }
        if (this.config.isPropertyExists("cursorSize")) {
            if (this.getStringProperty("cursorSize").equals("Full")) {
                this.cursorSize = 2;
            }
            if (this.getStringProperty("cursorSize").equals("Half")) {
                this.cursorSize = 1;
            }
            if (this.getStringProperty("cursorSize").equals("Line")) {
                this.cursorSize = 0;
            }
        }
        if (this.config.isPropertyExists("crossHair")) {
            if (this.getStringProperty("crossHair").equals("None")) {
                this.crossHair = 0;
            }
            if (this.getStringProperty("crossHair").equals("Horz")) {
                this.crossHair = 1;
            }
            if (this.getStringProperty("crossHair").equals("Vert")) {
                this.crossHair = 2;
            }
            if (this.getStringProperty("crossHair").equals("Both")) {
                this.crossHair = 3;
            }
        }
        if (this.config.isPropertyExists("rulerFixed")) {
            this.rulerFixed = this.getStringProperty("rulerFixed").equals("Yes");
        }
        if (this.config.isPropertyExists("fontScaleHeight")) {
            this.sfh = this.getFloatProperty("fontScaleHeight");
        }
        if (this.config.isPropertyExists("fontScaleWidth")) {
            this.sfw = this.getFloatProperty("fontScaleWidth");
        }
        if (this.config.isPropertyExists("fontPointSize")) {
            this.ps132 = this.getFloatProperty("fontPointSize");
        }
        if (this.config.isPropertyExists("cursorBottOffset")) {
            this.cursorBottOffset = this.getIntProperty("cursorBottOffset");
        }
        if (this.config.isPropertyExists("resetRequired")) {
            if (this.getStringProperty("resetRequired").equals("Yes")) {
                this.screen.setResetRequired(true);
            } else {
                this.screen.setResetRequired(false);
            }
        }
        if (this.config.isPropertyExists("useAntialias")) {
            this.antialiased = this.getStringProperty("useAntialias").equals("Yes");
        }
        if (this.config.getStringProperty("cursorBlink").equals("Yes")) {
            this.blinker = new Timer(500, this);
            this.blinker.start();
        }
        if (this.config.isPropertyExists("backspaceError")) {
            if (this.getStringProperty("backspaceError").equals("Yes")) {
                this.screen.setBackspaceError(true);
            } else {
                this.screen.setBackspaceError(false);
            }
        }
    }

    protected final String getStringProperty(String prop) {
        return this.config.getStringProperty(prop);
    }

    protected final Color getColorProperty(String prop) {
        return this.config.getColorProperty(prop);
    }

    protected final float getFloatProperty(String prop) {
        return this.config.getFloatProperty(prop);
    }

    protected final int getIntProperty(String prop) {
        return this.config.getIntegerProperty(prop);
    }

    protected final void setProperty(String key, String val) {
        this.config.setProperty(key, val);
    }

    @Override
    public void onConfigChanged(SessionConfigEvent pce) {
        this.propertyChange(pce);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String pn = pce.getPropertyName();
        boolean resetAttr = false;
        if (pn.equals("colorBg")) {
            this.colorBg = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorBlue")) {
            this.colorBlue = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorTurq")) {
            this.colorTurq = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorRed")) {
            this.colorRed = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorWhite")) {
            this.colorWhite = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorYellow")) {
            this.colorYellow = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorGreen")) {
            this.colorGreen = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorPink")) {
            this.colorPink = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorGUIField")) {
            this.colorGUIField = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorCursor")) {
            this.colorCursor = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorSep")) {
            this.colorSep = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("colorHexAttr")) {
            this.colorHexAttr = (Color)pce.getNewValue();
            resetAttr = true;
        }
        if (pn.equals("cursorSize")) {
            if (pce.getNewValue().equals("Full")) {
                this.cursorSize = 2;
            }
            if (pce.getNewValue().equals("Half")) {
                this.cursorSize = 1;
            }
            if (pce.getNewValue().equals("Line")) {
                this.cursorSize = 0;
            }
        }
        if (pn.equals("crossHair")) {
            if (pce.getNewValue().equals("None")) {
                this.crossHair = 0;
            }
            if (pce.getNewValue().equals("Horz")) {
                this.crossHair = 1;
            }
            if (pce.getNewValue().equals("Vert")) {
                this.crossHair = 2;
            }
            if (pce.getNewValue().equals("Both")) {
                this.crossHair = 3;
            }
        }
        if (pn.equals("rulerFixed")) {
            this.rulerFixed = pce.getNewValue().equals("Yes");
        }
        this.colSepLine = ColumnSeparator.getFromName(pce.getNewValue().toString());
        if (pn.equals("showAttr")) {
            this.showHex = pce.getNewValue().equals("Hex");
        }
        if (pn.equals("guiInterface")) {
            if (pce.getNewValue().equals("Yes")) {
                this.screen.setUseGUIInterface(true);
                this.cfg_guiInterface = true;
            } else {
                this.screen.setUseGUIInterface(true);
                this.cfg_guiInterface = false;
            }
        }
        if (pn.equals("guiShowUnderline")) {
            this.cfg_guiShowUnderline = pce.getNewValue().equals("Yes");
        }
        if (pn.equals("hotspots")) {
            this.hotSpots = pce.getNewValue().equals("Yes");
        }
        if (pn.equals("resetRequired")) {
            if (pce.getNewValue().equals("Yes")) {
                this.screen.setResetRequired(true);
            } else {
                this.screen.setResetRequired(false);
            }
        }
        if (pn.equals("hsMore")) {
            this.hsMore.setLength(0);
            this.hsMore.append((String)pce.getNewValue());
        }
        if (pn.equals("hsBottom")) {
            this.hsBottom.setLength(0);
            this.hsBottom.append((String)pce.getNewValue());
        }
        if (pn.equals("font")) {
            this.font = new Font((String)pce.getNewValue(), 0, 14);
            this.updateFont = true;
        }
        if (pn.equals("useAntialias")) {
            if (pce.getNewValue().equals("Yes")) {
                this.setUseAntialias(true);
            } else {
                this.setUseAntialias(false);
            }
            this.updateFont = true;
        }
        if (pn.equals("fontScaleHeight")) {
            this.sfh = Float.parseFloat((String)pce.getNewValue());
            this.updateFont = true;
        }
        if (pn.equals("fontScaleWidth")) {
            this.sfw = Float.parseFloat((String)pce.getNewValue());
            this.updateFont = true;
        }
        if (pn.equals("fontPointSize")) {
            this.ps132 = Float.parseFloat((String)pce.getNewValue());
            this.updateFont = true;
        }
        if (pn.equals("cursorBottOffset")) {
            this.cursorBottOffset = this.getIntProperty("cursorBottOffset");
        }
        if (pn.equals("cursorBlink")) {
            this.log.debug(this.getStringProperty("cursorBlink"));
            if (pce.getNewValue().equals("Yes")) {
                if (this.blinker == null) {
                    this.blinker = new Timer(500, this);
                    this.blinker.start();
                }
            } else if (this.blinker != null) {
                this.blinker.stop();
                this.blinker = null;
            }
        }
        if (pn.equals("backspaceError")) {
            if (pce.getNewValue().equals("Yes")) {
                this.screen.setBackspaceError(true);
            } else {
                this.screen.setBackspaceError(false);
            }
        }
        if (this.updateFont) {
            Rectangle r = this.gui.getDrawingBounds();
            this.resizeScreenArea(r.width, r.height);
            this.updateFont = false;
        }
        if (resetAttr) {
            this.drawOIA();
        }
        this.gui.validate();
        this.gui.repaint();
    }

    public int getPosFromView(int x, int y) {
        x -= this.offLeft;
        y -= this.offTop;
        if ((double)x > this.tArea.getMaxX()) {
            x = (int)this.tArea.getMaxX() - 1;
        }
        if ((double)y > this.tArea.getMaxY()) {
            y = (int)this.tArea.getMaxY() - 1;
        }
        if ((double)x < this.tArea.getMinX()) {
            x = 0;
        }
        if ((double)y < this.tArea.getMinY()) {
            y = 0;
        }
        int s0 = y / this.rowHeight;
        int s1 = x / this.columnWidth;
        return this.screen.getPos(s0, s1);
    }

    public int getRowColFromPoint(int x, int y) {
        if ((double)x > this.tArea.getMaxX()) {
            x = (int)this.tArea.getMaxX() - 1;
        }
        if ((double)y > this.tArea.getMaxY()) {
            y = (int)this.tArea.getMaxY() - 1;
        }
        if ((double)x < this.tArea.getMinX()) {
            x = 0;
        }
        if ((double)y < this.tArea.getMinY()) {
            y = 0;
        }
        int s0 = y / this.rowHeight;
        int s1 = x / this.columnWidth;
        return this.screen.getPos(s0, s1);
    }

    public void getPointFromRowCol(int r, int c, Point point) {
        point.x = this.columnWidth * c + this.offLeft;
        point.y = this.rowHeight * r + this.offTop;
    }

    public boolean isWithinScreenArea(int x, int y) {
        return this.tArea.contains(x, y);
    }

    public Point translateStart(Point start) {
        int pos = this.getPosFromView(start.x, start.y);
        int x = this.columnWidth * this.screen.getCol(pos);
        int y = this.rowHeight * this.screen.getRow(pos);
        start.setLocation(x, y);
        return start;
    }

    public Point translateEnd(Point end) {
        int pos = this.getPosFromView(end.x, end.y);
        if (pos >= this.lenScreen) {
            pos = this.lenScreen - 1;
        }
        int x = this.columnWidth * this.screen.getCol(pos) + this.columnWidth - 1;
        int y = this.rowHeight * this.screen.getRow(pos) + this.rowHeight - 1;
        end.setLocation(x, y);
        return end;
    }

    public void getBoundingArea(Rectangle bounds) {
        if (!this.gui.rubberband.isAreaSelected()) {
            bounds.setBounds(1, 1, this.screen.getColumns(), this.screen.getRows());
        } else {
            this.gui.rubberband.getBoundingArea(this.workR);
            int sPos = this.getRowColFromPoint(this.workR.x, this.workR.y);
            int ePos = this.getRowColFromPoint(this.workR.width, this.workR.height);
            int row = this.screen.getRow(sPos) + 1;
            int col = this.screen.getCol(sPos) + 1;
            bounds.setBounds(row, col, this.screen.getCol(ePos) + 1, this.screen.getRow(ePos) + 1);
        }
    }

    protected final void resizeScreenArea(int width, int height) {
        Font k = null;
        k = GUIGraphicsUtils.getDerivedFont(this.font, width, height, this.screen.getRows(), this.screen.getColumns(), this.sfh, this.sfw, this.ps132);
        if (this.font.getSize() != k.getSize() || this.updateFont || this.offLeft != (width - this.bi.getWidth()) / 2 || this.offTop != (height - this.bi.getHeight()) / 2) {
            this.font = k;
            FontRenderContext frc = new FontRenderContext(this.font.getTransform(), true, true);
            this.lm = this.font.getLineMetrics("Wy", frc);
            this.columnWidth = (int)this.font.getStringBounds("W", frc).getWidth() + 2;
            this.rowHeight = (int)(this.font.getStringBounds("g", frc).getHeight() + (double)this.lm.getDescent() + (double)this.lm.getLeading());
            this.resize(this.columnWidth * this.screen.getColumns(), this.rowHeight * (this.screen.getRows() + 2));
            this.offLeft = (width - this.getWidth()) / 2;
            this.offTop = (height - this.getHeight()) / 2;
            if (this.offLeft < 0) {
                this.offLeft = 0;
            }
            if (this.offTop < 0) {
                this.offTop = 0;
            }
            this.drawOIA();
            this.updateFont = false;
        }
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this.columnWidth * this.screen.getColumns(), this.rowHeight * (this.screen.getRows() + 2));
    }

    public BufferedImage getImageBuffer(int width, int height) {
        int width2 = this.columnWidth * this.screen.getColumns();
        int height2 = this.rowHeight * (this.screen.getRows() + 2);
        if (this.bi == null || this.bi.getWidth() != width2 || this.bi.getHeight() != height2) {
            this.bi = new BufferedImage(width2, height2, 1);
        }
        this.drawOIA();
        return this.bi;
    }

    public Graphics2D drawOIA() {
        int numRows = this.screen.getRows();
        Graphics2D g2d = this.getDrawingArea();
        if (this.antialiased) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setFont(this.font);
        g2d.setColor(this.colorBg);
        g2d.fillRect(0, 0, this.bi.getWidth(null), this.bi.getHeight(null));
        this.tArea.setRect(0.0, 0.0, this.bi.getWidth(null), this.rowHeight * numRows);
        this.cArea.setRect(0.0, this.rowHeight * (numRows + 1), this.bi.getWidth(null), this.rowHeight * (numRows + 1));
        this.aArea.setRect(0.0, 0.0, this.bi.getWidth(null), this.bi.getHeight(null));
        this.sArea.setRect(this.columnWidth * 9, this.rowHeight * (numRows + 1), this.columnWidth * 20, this.rowHeight);
        this.pArea.setRect(this.bi.getWidth(null) - this.columnWidth * 6, this.rowHeight * (numRows + 1), this.columnWidth * 6, this.rowHeight);
        this.mArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)this.columnWidth + (float)this.columnWidth, this.rowHeight * (numRows + 1), this.columnWidth + this.columnWidth, this.rowHeight);
        this.kbArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)(20 * this.columnWidth), this.rowHeight * (numRows + 1), this.columnWidth + this.columnWidth, this.rowHeight);
        this.scriptArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)(16 * this.columnWidth), this.rowHeight * (numRows + 1), this.columnWidth + this.columnWidth, this.rowHeight);
        this.iArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)(25 * this.columnWidth), this.rowHeight * (numRows + 1), this.columnWidth, this.rowHeight);
        this.separatorLine.setLine(0.0, this.rowHeight * (numRows + 1) - this.rowHeight / 2, this.bi.getWidth(null), this.rowHeight * (numRows + 1) - this.rowHeight / 2);
        g2d.setColor(this.colorBlue);
        g2d.draw(this.separatorLine);
        this.gg2d = g2d;
        return g2d;
    }

    public void drawCursor(int row, int col) {
        int botOffset = this.cursorBottOffset;
        boolean insertMode = this.screen.getOIA().isInsertMode();
        Graphics2D g2 = this.getDrawingArea();
        switch (this.cursorSize) {
            case 0: {
                this.cursor.setRect(this.columnWidth * col, this.rowHeight * (row + 1) - botOffset, this.columnWidth, 1.0);
                break;
            }
            case 1: {
                this.cursor.setRect(this.columnWidth * col, this.rowHeight * (row + 1) - this.rowHeight / 2, this.columnWidth, this.rowHeight / 2 - botOffset);
                break;
            }
            case 2: {
                this.cursor.setRect(this.columnWidth * col, this.rowHeight * row, this.columnWidth, this.rowHeight - botOffset);
            }
        }
        if (insertMode && this.cursorSize != 1) {
            this.cursor.setRect(this.columnWidth * col, this.rowHeight * (row + 1) - this.rowHeight / 2, this.columnWidth, this.rowHeight / 2 - botOffset);
        }
        Rectangle r = this.cursor.getBounds();
        r.setSize(r.width, r.height);
        g2.setColor(this.colorCursor);
        g2.setXORMode(this.colorBg);
        g2.fill(this.cursor);
        this.updateImage(r);
        if (!this.rulerFixed) {
            this.crossRow = row;
            this.crossRect.setBounds(r);
        } else if (this.crossHair == 0) {
            this.crossRow = row;
            this.crossRect.setBounds(r);
        }
        switch (this.crossHair) {
            case 1: {
                g2.drawLine(0, this.rowHeight * (this.crossRow + 1) - botOffset, this.bi.getWidth(null), this.rowHeight * (this.crossRow + 1) - botOffset);
                this.updateImage(0, this.rowHeight * (this.crossRow + 1) - botOffset, this.bi.getWidth(null), 1);
                break;
            }
            case 2: {
                g2.drawLine(this.crossRect.x, 0, this.crossRect.x, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
                this.updateImage(this.crossRect.x, 0, 1, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
                break;
            }
            case 3: {
                g2.drawLine(0, this.rowHeight * (this.crossRow + 1) - botOffset, this.bi.getWidth(null), this.rowHeight * (this.crossRow + 1) - botOffset);
                g2.drawLine(this.crossRect.x, 0, this.crossRect.x, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
                this.updateImage(0, this.rowHeight * (this.crossRow + 1) - botOffset, this.bi.getWidth(null), 1);
                this.updateImage(this.crossRect.x, 0, 1, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
            }
        }
        g2.dispose();
        g2 = this.getWritingArea(this.font);
        g2.setPaint(this.colorBg);
        g2.fill(this.pArea);
        g2.setColor(this.colorWhite);
        g2.drawString(row + 1 + "/" + (col + 1), (float)this.pArea.getX(), (float)this.pArea.getY() + (float)this.rowHeight);
        this.updateImage(this.pArea.getBounds());
        g2.dispose();
    }

    private void drawScriptRunning(Color color) {
        Graphics2D g2d = (Graphics2D)this.bi.getGraphics();
        g2d.setColor(color);
        int[] xs = new int[]{(int)this.scriptArea.getX(), (int)this.scriptArea.getX(), (int)this.scriptArea.getX() + (int)this.scriptArea.getWidth()};
        int[] ys = new int[]{(int)this.scriptArea.getY(), (int)this.scriptArea.getY() + (int)this.scriptArea.getHeight(), (int)this.scriptArea.getY() + (int)(this.scriptArea.getHeight() / 2.0)};
        g2d.fillPolygon(xs, ys, 3);
        g2d.setClip(this.scriptArea);
        g2d.dispose();
    }

    private void eraseScriptRunning(Color color) {
        Graphics2D g2d = (Graphics2D)this.bi.getGraphics();
        g2d.setColor(color);
        g2d.fill(this.scriptArea);
        g2d.dispose();
    }

    public Graphics2D getDrawingArea() {
        Graphics2D g2 = this.bi.createGraphics();
        return g2;
    }

    public synchronized void drawImageBuffer(Graphics2D gg2d, int x, int y, int width, int height) {
        if (gg2d == null) {
            this.log.debug(" we got a null graphic object ");
            return;
        }
        gg2d.drawImage(this.bi.getSubimage(x, y, width, height), null, x + this.offLeft, y + this.offTop);
    }

    protected void updateImage(int x, int y, int width, int height) {
        if (this.gui.rubberband != null && this.gui.rubberband.isAreaSelected()) {
            this.gui.rubberband.erase();
        }
        this.gg2d.setClip(x, y, width, height);
        if (this.gui.rubberband != null && this.gui.rubberband.isAreaSelected()) {
            this.gui.rubberband.draw();
        }
        if (x == 0) {
            width += this.offLeft;
        } else {
            x += this.offLeft;
        }
        if (y == 0) {
            height += this.offTop;
        } else {
            y += this.offTop;
        }
        final int heightf = height;
        final int widthf = width;
        final int xf = x;
        final int yf = y;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiGraphicBuffer.this.gui.repaint(xf, yf, widthf, heightf);
                }
            });
        }
        catch (Exception exc) {
            this.log.warn("setStatus(ON) " + exc.getMessage());
        }
    }

    protected void updateImage(Rectangle r) {
        this.updateImage(r.x, r.y, r.width, r.height);
    }

    public synchronized void drawImageBuffer(Graphics2D gg2d) {
        if (gg2d == null) {
            this.log.debug(" we got a null graphic object ");
            return;
        }
        gg2d.drawImage(this.bi, null, this.offLeft, this.offTop);
    }

    public Graphics2D getWritingArea(Font font) {
        Graphics2D g2 = this.bi.createGraphics();
        if (g2 != null) {
            if (this.antialiased) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setFont(font);
        }
        return g2;
    }

    public void setUseAntialias(boolean antialiased) {
        this.antialiased = antialiased;
    }

    private void setStatus(ScreenOIA oia) {
        int attr = oia.getLevel();
        int value = oia.getInputInhibited();
        String s = oia.getInhibitedText();
        Graphics2D g2d = this.getWritingArea(this.font);
        if (g2d == null) {
            return;
        }
        try {
            g2d.setColor(this.colorBg);
            g2d.fill(this.sArea);
            float Y = (float)((int)this.sArea.getY() + this.rowHeight) - (this.lm.getLeading() + this.lm.getDescent());
            switch (attr) {
                case 1: {
                    if (value != 1) break;
                    g2d.setColor(this.colorWhite);
                    if (s != null) {
                        g2d.drawString(s, (float)this.sArea.getX(), Y);
                        break;
                    }
                    g2d.drawString(xSystem, (float)this.sArea.getX(), Y);
                    break;
                }
                case 10: {
                    if (value != 1) break;
                    g2d.setColor(this.colorRed);
                    if (s != null) {
                        g2d.drawString(s, (float)this.sArea.getX(), Y);
                        break;
                    }
                    g2d.drawString(xError, (float)this.sArea.getX(), Y);
                }
            }
            this.updateImage(this.sArea.getBounds());
            g2d.dispose();
        }
        catch (Exception e) {
            this.log.warn(" gui graphics setStatus " + e.getMessage());
        }
    }

    public final void drawChar(Graphics2D g, int pos, int row, int col) {
        Rectangle csArea = new Rectangle();
        char[] sChar = new char[1];
        char attr = this.updateRect.attr[pos];
        sChar[0] = this.updateRect.text[pos];
        this.setDrawAttr(pos);
        boolean attributePlace = this.updateRect.isAttr[pos] != '\u0000';
        char whichGui = this.updateRect.graphic[pos];
        boolean useGui = whichGui != '\u0000';
        csArea = this.modelToView(row, col, csArea);
        int x = csArea.x;
        int y = csArea.y;
        int cy = (int)((float)(y + this.rowHeight) - (this.lm.getDescent() + this.lm.getLeading()));
        if (this.showHex && attributePlace) {
            Font f = g.getFont();
            Font k = f.deriveFont(f.getSize2D() / 2.0f);
            g.setFont(k);
            g.setColor(this.colorHexAttr);
            char[] a = Integer.toHexString(attr).toCharArray();
            g.drawChars(a, 0, 1, x, y + this.rowHeight / 2);
            g.drawChars(a, 1, 1, x + this.columnWidth / 2, (int)((float)(y + this.rowHeight) - (this.lm.getDescent() + this.lm.getLeading()) - 2.0f));
            g.setFont(f);
        }
        if (!this.nonDisplay && !attributePlace) {
            if (!useGui) {
                g.setColor(this.bg);
                g.fill(csArea);
            } else {
                if (this.bg == this.colorBg && whichGui >= '\t' && whichGui <= '\f') {
                    g.setColor(this.colorGUIField);
                } else {
                    g.setColor(this.bg);
                }
                g.fill(csArea);
            }
            if (useGui && whichGui < '\t') {
                g.setColor(this.fg);
                switch (whichGui) {
                    case '\u0001': {
                        if (sChar[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinUpperLeft(g, 4, this.colorBlue, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinUpperLeft(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0002': {
                        if (sChar[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinUpper(g, 4, this.colorBlue, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinUpper(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0003': {
                        if (sChar[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinUpperRight(g, 4, this.colorBlue, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinUpperRight(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0004': {
                        if (sChar[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinLeft(g, 4, this.bg, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinLeft(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        g.drawLine(x + this.columnWidth / 2, y, x + this.columnWidth / 2, y + this.rowHeight);
                        break;
                    }
                    case '\u0005': {
                        if (sChar[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinRight(g, 4, this.bg, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinRight(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0006': {
                        if (sChar[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinLowerLeft(g, 4, this.bg, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinLowerLeft(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0007': {
                        if (sChar[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinBottom(g, 4, this.bg, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinBottom(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\b': {
                        if (sChar[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinLowerRight(g, 4, this.bg, x, y, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinLowerRight(g, 3, this.fg, x, y, this.columnWidth, this.rowHeight);
                    }
                }
            } else {
                if (sChar[0] != '\u0000') {
                    if (useGui && whichGui < '\r' && this.fg == this.colorGUIField) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(this.fg);
                    }
                    try {
                        if (useGui) {
                            if (sChar[0] == '\u001c') {
                                g.drawChars(dupChar, 0, 1, x + 1, cy - 2);
                            } else {
                                g.drawChars(sChar, 0, 1, x + 1, cy - 2);
                            }
                        } else if (sChar[0] == '\u001c') {
                            g.drawChars(dupChar, 0, 1, x, cy - 2);
                        } else {
                            g.drawChars(sChar, 0, 1, x, cy - 2);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        System.out.println(" drawChar iae " + iae.getMessage());
                    }
                }
                if (this.underLine && (!useGui || this.cfg_guiShowUnderline)) {
                    g.setColor(this.fg);
                    g.drawLine(x, (int)((float)y + ((float)this.rowHeight - (this.lm.getLeading() + this.lm.getDescent()))), x + this.columnWidth, (int)((float)y + ((float)this.rowHeight - (this.lm.getLeading() + this.lm.getDescent()))));
                }
                if (this.colSep) {
                    g.setColor(this.colorSep);
                    switch (this.colSepLine) {
                        case Line: {
                            g.drawLine(x, y, x, y + this.rowHeight - 1);
                            g.drawLine(x + this.columnWidth - 1, y, x + this.columnWidth - 1, y + this.rowHeight);
                            break;
                        }
                        case ShortLine: {
                            g.drawLine(x, y + this.rowHeight - (int)this.lm.getLeading() - 4, x, y + this.rowHeight);
                            g.drawLine(x + this.columnWidth - 1, y + this.rowHeight - (int)this.lm.getLeading() - 4, x + this.columnWidth - 1, y + this.rowHeight);
                            break;
                        }
                        case Dot: {
                            g.drawLine(x, y + this.rowHeight - (int)this.lm.getLeading() - 3, x, y + this.rowHeight - (int)this.lm.getLeading() - 4);
                            g.drawLine(x + this.columnWidth - 1, y + this.rowHeight - (int)this.lm.getLeading() - 3, x + this.columnWidth - 1, y + this.rowHeight - (int)this.lm.getLeading() - 4);
                            break;
                        }
                    }
                }
            }
        }
        if (useGui & whichGui >= '\t') {
            switch (whichGui) {
                case '\t': {
                    GUIGraphicsUtils.draw3DLeft(g, 2, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u000b': {
                    GUIGraphicsUtils.draw3DMiddle(g, 2, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\n': {
                    GUIGraphicsUtils.draw3DRight(g, 2, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\f': {
                    GUIGraphicsUtils.draw3DOne(g, 2, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\r': 
                case '\u0011': 
                case '\u0015': 
                case '\u0019': {
                    GUIGraphicsUtils.draw3DLeft(g, 1, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u000f': 
                case '\u0013': 
                case '\u0017': 
                case '\u001b': {
                    GUIGraphicsUtils.draw3DMiddle(g, 1, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u000e': 
                case '\u0012': 
                case '\u0016': 
                case '\u001a': {
                    GUIGraphicsUtils.draw3DRight(g, 1, x, y, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u001c': {
                    GUIGraphicsUtils.drawScrollBar(g, 1, 1, x, y, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                    break;
                }
                case '\u001d': {
                    GUIGraphicsUtils.drawScrollBar(g, 1, 2, x, y, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                    break;
                }
                case '\u001e': {
                    GUIGraphicsUtils.drawScrollBar(g, 2, 0, x, y, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                    break;
                }
                case '\u001f': {
                    GUIGraphicsUtils.drawScrollBar(g, 2, 3, x, y, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                }
            }
        }
    }

    @Override
    public void onScreenSizeChanged(int rows, int cols) {
        this.log.info("screen size change");
        this.gui.resizeMe();
    }

    @Override
    public void onScreenChanged(int which, int sr, int sc, int er, int ec) {
        if (which == 3 || which == 4) {
            this.drawCursor(sr, sc);
            return;
        }
        if (this.hotSpots) {
            this.screen.checkHotSpots();
        }
        int cols = 0;
        int lc = 0;
        this.updateRect = new Data(sr, sc, er, ec);
        Rectangle clipper = new Rectangle();
        int pos = 0;
        lc = ec;
        clipper.x = sc * this.columnWidth;
        clipper.y = sr * this.rowHeight;
        clipper.width = (ec - sc + 1) * this.columnWidth;
        clipper.height = (er - sr + 1) * this.rowHeight;
        this.gg2d.setClip(clipper.getBounds());
        this.gg2d.setColor(this.colorBg);
        this.gg2d.fillRect(clipper.x, clipper.y, clipper.width, clipper.height);
        while (sr <= er) {
            cols = ec - sc;
            lc = sc;
            while (cols-- >= 0) {
                if (sc + cols > ec) continue;
                this.drawChar(this.gg2d, pos++, sr, lc);
                ++lc;
            }
            ++sr;
        }
        this.updateImage(clipper);
    }

    @Override
    public void onOIAChanged(ScreenOIA changedOIA, int change) {
        switch (changedOIA.getLevel()) {
            case 11: {
                if (changedOIA.isKeysBuffered()) {
                    Graphics2D g2d = this.getWritingArea(this.font);
                    float Y = (float)(this.rowHeight * (this.screen.getRows() + 2)) - (this.lm.getLeading() + this.lm.getDescent());
                    g2d.setColor(this.colorYellow);
                    g2d.drawString("KB", (float)this.kbArea.getX(), Y);
                    this.updateImage(this.kbArea.getBounds());
                    g2d.dispose();
                    break;
                }
                Graphics2D g2d = this.getWritingArea(this.font);
                g2d.setColor(this.colorBg);
                g2d.fill(this.kbArea);
                this.updateImage(this.kbArea.getBounds());
                g2d.dispose();
                break;
            }
            case 4: {
                Graphics2D g2d = this.getWritingArea(this.font);
                g2d.setColor(this.colorBg);
                g2d.fill(this.mArea);
                this.updateImage(this.mArea.getBounds());
                g2d.dispose();
                break;
            }
            case 3: {
                Graphics2D g2d = this.getWritingArea(this.font);
                float Y = (float)(this.rowHeight * (this.screen.getRows() + 2)) - (this.lm.getLeading() + this.lm.getDescent());
                g2d.setColor(this.colorBlue);
                g2d.drawString("MW", (float)this.mArea.getX(), Y);
                this.updateImage(this.mArea.getBounds());
                g2d.dispose();
                break;
            }
            case 12: {
                if (changedOIA.isScriptActive()) {
                    this.drawScriptRunning(this.colorGreen);
                    this.updateImage(this.scriptArea.getBounds());
                    break;
                }
                this.eraseScriptRunning(this.colorBg);
                this.updateImage(this.scriptArea.getBounds());
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                this.setStatus(changedOIA);
                break;
            }
            case 6: {
                if (changedOIA.isInsertMode()) {
                    Graphics2D g2d = this.getWritingArea(this.font);
                    float Y = (float)(this.rowHeight * (this.screen.getRows() + 2)) - (this.lm.getLeading() + this.lm.getDescent());
                    g2d.setColor(this.colorBlue);
                    g2d.drawLine((int)this.iArea.getX(), (int)Y, (int)(this.iArea.getX() + (this.iArea.getWidth() / 2.0 - 1.0)), (int)(Y - (float)(this.rowHeight / 2)));
                    g2d.drawLine((int)(this.iArea.getX() + this.iArea.getWidth() - 1.0), (int)Y, (int)(this.iArea.getX() + this.iArea.getWidth() / 2.0), (int)(Y - (float)(this.rowHeight / 2)));
                    this.updateImage(this.iArea.getBounds());
                    g2d.dispose();
                    break;
                }
                Graphics2D g2d = this.getWritingArea(this.font);
                g2d.setColor(this.colorBg);
                g2d.fill(this.iArea);
                this.updateImage(this.iArea.getBounds());
                g2d.dispose();
            }
        }
    }

    public Rectangle2D getTextArea() {
        return this.tArea;
    }

    public Rectangle2D getScreenArea() {
        return this.aArea;
    }

    public Rectangle2D getCommandLineArea() {
        return this.cArea;
    }

    public Rectangle2D getStatusArea() {
        return this.sArea;
    }

    public Rectangle2D getPositionArea() {
        return this.pArea;
    }

    public Rectangle2D getMessageArea() {
        return this.mArea;
    }

    public Rectangle2D getInsertIndicatorArea() {
        return this.iArea;
    }

    public Rectangle2D getKBIndicatorArea() {
        return this.kbArea;
    }

    public Rectangle2D getScriptIndicatorArea() {
        return this.scriptArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth(ImageObserver io) {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getWidth(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight(ImageObserver io) {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getHeight(io);
        }
    }

    protected Data fillData(int startRow, int startCol, int endRow, int endCol) {
        return new Data(startRow, startCol, endRow, endCol);
    }

    public final Rectangle modelToView(int row, int col) {
        return this.modelToView(row, col, new Rectangle());
    }

    public final Rectangle modelToView(int row, int col, Rectangle r) {
        r.x = col * this.columnWidth;
        r.y = row * this.rowHeight;
        r.width = this.columnWidth;
        r.height = this.rowHeight;
        return r;
    }

    protected Color getColor(char color, boolean background) {
        int c = 0;
        c = background ? (color & 0xFF00) >> 8 : color & 0xFF;
        switch (c) {
            case 0: {
                return this.colorBg;
            }
            case 2: {
                return this.colorGreen;
            }
            case 1: {
                return this.colorBlue;
            }
            case 4: {
                return this.colorRed;
            }
            case 6: {
                return this.colorYellow;
            }
            case 3: {
                return this.colorTurq;
            }
            case 7: {
                return this.colorWhite;
            }
            case 5: {
                return this.colorPink;
            }
        }
        return Color.orange;
    }

    private void setDrawAttr(int pos) {
        this.colSep = false;
        this.underLine = false;
        this.nonDisplay = false;
        this.fg = this.getColor(this.updateRect.color[pos], false);
        this.bg = this.getColor(this.updateRect.color[pos], true);
        this.underLine = (this.updateRect.extended[pos] & 8) != 0;
        this.colSep = (this.updateRect.extended[pos] & 2) != 0;
        this.nonDisplay = (this.updateRect.extended[pos] & '\u0001') != 0;
    }

    protected class Data {
        public char[] text;
        public char[] attr;
        public char[] isAttr;
        public char[] color;
        public char[] extended;
        public final char[] graphic;
        public final char[] field;

        public Data(char[] text, char[] attr, char[] color, char[] extended, char[] graphic) {
            this.text = text;
            this.color = color;
            this.extended = extended;
            this.graphic = graphic;
            this.attr = attr;
            this.field = null;
        }

        public Data(int startRow, int startCol, int endRow, int endCol) {
            int size = (++endCol - ++startCol + 1) * (++endRow - ++startRow + 1);
            this.text = new char[size];
            this.attr = new char[size];
            this.isAttr = new char[size];
            this.color = new char[size];
            this.extended = new char[size];
            this.graphic = new char[size];
            this.field = new char[size];
            if (size == GuiGraphicBuffer.this.lenScreen) {
                GuiGraphicBuffer.this.screen.GetScreen(this.text, size, 1);
                GuiGraphicBuffer.this.screen.GetScreen(this.attr, size, 7);
                GuiGraphicBuffer.this.screen.GetScreen(this.isAttr, size, 8);
                GuiGraphicBuffer.this.screen.GetScreen(this.color, size, 2);
                GuiGraphicBuffer.this.screen.GetScreen(this.extended, size, 4);
                GuiGraphicBuffer.this.screen.GetScreen(this.graphic, size, 5);
                GuiGraphicBuffer.this.screen.GetScreen(this.field, size, 3);
            } else {
                GuiGraphicBuffer.this.screen.GetScreenRect(this.text, size, startRow, startCol, endRow, endCol, 1);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.attr, size, startRow, startCol, endRow, endCol, 7);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.isAttr, size, startRow, startCol, endRow, endCol, 8);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.color, size, startRow, startCol, endRow, endCol, 2);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.extended, size, startRow, startCol, endRow, endCol, 4);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.graphic, size, startRow, startCol, endRow, endCol, 5);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.field, size, startRow, startCol, endRow, endCol, 3);
            }
        }
    }
}

