/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyMnemonicResolver;

public class OptionAccess
extends OptionAccessFactory {
    private static OptionAccess _instance;
    private static List<String> restricted;
    private final KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();

    public OptionAccess() {
        if (_instance == null) {
            this.initialize();
            _instance = this;
        }
    }

    public static OptionAccess instance() {
        if (_instance == null) {
            _instance = new OptionAccess();
        }
        return _instance;
    }

    private void initialize() {
        this.loadOptions();
    }

    private void loadOptions() {
        restricted.clear();
        String restrictedProp = ConfigureFactory.getInstance().getProperties("sessions").getProperty("emul.restricted");
        if (restrictedProp != null) {
            StringTokenizer tokenizer = new StringTokenizer(restrictedProp, ";");
            while (tokenizer.hasMoreTokens()) {
                restricted.add(tokenizer.nextToken());
            }
        }
    }

    @Override
    public boolean isValidOption(String option) {
        return !restricted.contains(option);
    }

    @Override
    public boolean isRestrictedOption(String option) {
        return restricted.contains(option);
    }

    @Override
    public int getNumberOfRestrictedOptions() {
        return restricted.size();
    }

    @Override
    public void reload() {
        this.loadOptions();
    }

    static {
        restricted = new ArrayList<String>();
    }
}

