/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionListener;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.SystemRequestDialog;
import org.tn5250j.interfaces.ScanListener;
import org.tn5250j.interfaces.SessionInterface;

public class Session5250
implements SessionInterface {
    private String configurationResource;
    private String sessionName;
    private int sessionType;
    protected Properties sesProps;
    private boolean heartBeat;
    private final String propFileName;
    private final SessionConfig sesConfig;
    private tnvt vt;
    private final Screen5250 screen;
    private SessionPanel guiComponent;
    private List<SessionListener> sessionListeners = null;
    private final ReadWriteLock sessionListenerLock = new ReentrantReadWriteLock();
    private boolean scan;
    private List<ScanListener> scanListeners = null;
    private final ReadWriteLock scanListenerLock = new ReentrantReadWriteLock();

    public Session5250(Properties props, String configurationResource, String sessionName, SessionConfig config) {
        this.propFileName = config.getConfigurationResource();
        this.sesConfig = config;
        this.configurationResource = configurationResource;
        this.sessionName = sessionName;
        this.sesProps = props;
        if (this.sesProps.containsKey("SESSION_KEEP_ALIVE_ENABLED")) {
            this.heartBeat = true;
        }
        this.screen = new Screen5250();
    }

    @Override
    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public SessionConfig getConfiguration() {
        return this.sesConfig;
    }

    public SessionManager getSessionManager() {
        return SessionManager.instance();
    }

    @Override
    public boolean isConnected() {
        if (this.vt == null) {
            return false;
        }
        return this.vt.isConnected();
    }

    public boolean isSslSocket() {
        if (this.vt != null) {
            return this.vt.isSslSocket();
        }
        return false;
    }

    public boolean isSslConfigured() {
        String sslType;
        return this.sesProps.get("-sslType") != null && !"NONE".equals(sslType = (String)this.sesProps.get("-sslType"));
    }

    public boolean isSendKeepAlive() {
        return this.heartBeat;
    }

    public boolean isUseSystemName() {
        return this.sesProps.getProperty("SESSION_TERM_NAME_SYSTEM") != null;
    }

    public Properties getConnectionProperties() {
        return this.sesProps;
    }

    public void setGUI(SessionPanel gui) {
        this.guiComponent = gui;
    }

    public SessionPanel getGUI() {
        return this.guiComponent;
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    public String getAllocDeviceName() {
        if (this.vt != null) {
            return this.vt.getAllocatedDeviceName();
        }
        return null;
    }

    @Override
    public int getSessionType() {
        return this.sessionType;
    }

    public String getHostName() {
        return this.vt.getHostName();
    }

    public Screen5250 getScreen() {
        return this.screen;
    }

    @Override
    public void signalBell() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public String showSystemRequest() {
        SystemRequestDialog sysreqdlg = new SystemRequestDialog(this.guiComponent);
        return sysreqdlg.show();
    }

    @Override
    public void connect() {
        String proxyPort = "1080";
        boolean enhanced = false;
        boolean support132 = false;
        int port = 23;
        enhanced = this.sesProps.containsKey("SESSION_TN_ENHANCED");
        if (this.sesProps.containsKey("SESSION_SCREEN_SIZE") && this.sesProps.getProperty("SESSION_SCREEN_SIZE").equals("1")) {
            support132 = true;
        }
        final tnvt vt = new tnvt(this, this.screen, enhanced, support132);
        this.setVT(vt);
        if (this.sesProps.containsKey("SESSION_PROXY_PORT")) {
            proxyPort = this.sesProps.getProperty("SESSION_PROXY_PORT");
        }
        if (this.sesProps.containsKey("SESSION_PROXY_HOST")) {
            vt.setProxy(this.sesProps.getProperty("SESSION_PROXY_HOST"), proxyPort);
        }
        String sslType = this.sesProps.containsKey("-sslType") ? this.sesProps.getProperty("-sslType") : "NONE";
        vt.setSSLType(sslType);
        if (this.sesProps.containsKey("SESSION_CODE_PAGE")) {
            vt.setCodePage(this.sesProps.getProperty("SESSION_CODE_PAGE"));
        }
        if (this.sesProps.containsKey("SESSION_DEVICE_NAME")) {
            vt.setDeviceName(this.sesProps.getProperty("SESSION_DEVICE_NAME"));
        }
        port = this.sesProps.containsKey("SESSION_HOST_PORT") ? Integer.parseInt(this.sesProps.getProperty("SESSION_HOST_PORT")) : 23;
        final String ses = this.sesProps.getProperty("SESSION_HOST");
        final int portp = port;
        Runnable connectIt = new Runnable(){

            @Override
            public void run() {
                vt.connect(ses, portp);
            }
        };
        Thread ct = new Thread(connectIt);
        ct.setDaemon(true);
        ct.start();
    }

    @Override
    public void disconnect() {
        this.vt.disconnect();
    }

    protected void setVT(tnvt v) {
        this.vt = v;
        this.screen.setVT(this.vt);
        if (this.vt != null) {
            this.vt.setScanningEnabled(this.scan);
        }
    }

    public tnvt getVT() {
        return this.vt;
    }

    public void setScanningEnabled(boolean scan) {
        this.scan = scan;
        if (this.vt != null) {
            this.vt.setScanningEnabled(scan);
        }
    }

    public boolean isScanningEnabled() {
        if (this.vt != null) {
            return this.vt.isScanningEnabled();
        }
        return this.scan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireScanned(String command, String remainder) {
        this.scanListenerLock.readLock().lock();
        try {
            if (this.scanListeners != null) {
                for (ScanListener listener : this.scanListeners) {
                    listener.scanned(command, remainder);
                }
            }
        }
        finally {
            this.scanListenerLock.readLock().unlock();
        }
    }

    public final void addScanListener(ScanListener listener) {
        this.scanListenerLock.writeLock().lock();
        try {
            if (this.scanListeners == null) {
                this.scanListeners = new ArrayList<ScanListener>(3);
            }
            this.scanListeners.add(listener);
        }
        finally {
            this.scanListenerLock.writeLock().unlock();
        }
    }

    public final void removeScanListener(ScanListener listener) {
        this.scanListenerLock.writeLock().lock();
        try {
            if (this.scanListeners != null) {
                this.scanListeners.remove(listener);
            }
        }
        finally {
            this.scanListenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireSessionChanged(int state) {
        this.sessionListenerLock.readLock().lock();
        try {
            if (this.sessionListeners != null) {
                for (SessionListener listener : this.sessionListeners) {
                    SessionChangeEvent sce = new SessionChangeEvent(this);
                    sce.setState(state);
                    listener.onSessionChanged(sce);
                }
            }
        }
        finally {
            this.sessionListenerLock.readLock().unlock();
        }
    }

    @Override
    public final void addSessionListener(SessionListener listener) {
        this.sessionListenerLock.writeLock().lock();
        try {
            if (this.sessionListeners == null) {
                this.sessionListeners = new ArrayList<SessionListener>(3);
            }
            this.sessionListeners.add(listener);
        }
        finally {
            this.sessionListenerLock.writeLock().unlock();
        }
    }

    @Override
    public final void removeSessionListener(SessionListener listener) {
        this.sessionListenerLock.writeLock().lock();
        try {
            if (this.sessionListeners != null) {
                this.sessionListeners.remove(listener);
            }
        }
        finally {
            this.sessionListenerLock.writeLock().unlock();
        }
    }
}

