/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JOptionPane;
import org.tn5250j.event.SessionConfigEvent;
import org.tn5250j.event.SessionConfigListener;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.KeyMnemonicSerializer;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;

public class SessionConfig {
    public static final float KEYPAD_FONT_SIZE_DEFAULT_VALUE = 12.0f;
    public static final String CONFIG_KEYPAD_FONT_SIZE = "keypadFontSize";
    public static final String CONFIG_KEYPAD_ENABLED = "keypad";
    public static final String CONFIG_KEYPAD_MNEMONICS = "keypadMnemonics";
    public static final String YES = "Yes";
    public static final String NO = "No";
    private final SessionConfiguration sessionConfiguration = new SessionConfiguration();
    private final KeyMnemonicSerializer keyMnemonicSerializer = new KeyMnemonicSerializer();
    private String configurationResource;
    private String sessionName;
    private Properties sesProps;
    private boolean usingDefaults;
    private List<SessionConfigListener> sessionCfglisteners = null;
    private final ReadWriteLock sessionCfglistenersLock = new ReentrantReadWriteLock();

    public SessionConfig(String configurationResource, String sessionName) {
        this.configurationResource = configurationResource;
        this.sessionName = sessionName;
        this.loadConfigurationResource();
    }

    public String getConfigurationResource() {
        if (this.configurationResource == null || this.configurationResource.trim().isEmpty()) {
            this.configurationResource = "TN5250JDefaults.props";
            this.usingDefaults = true;
        }
        return this.configurationResource;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void firePropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.sessionCfglistenersLock.readLock().lock();
        try {
            if (this.sessionCfglisteners != null) {
                SessionConfigEvent sce = new SessionConfigEvent(source, propertyName, oldValue, newValue);
                for (SessionConfigListener target : this.sessionCfglisteners) {
                    target.onConfigChanged(sce);
                }
            }
        }
        finally {
            this.sessionCfglistenersLock.readLock().unlock();
        }
    }

    @Deprecated
    public Properties getProperties() {
        return this.sesProps;
    }

    public void setModified() {
        this.sesProps.setProperty("saveme", "");
    }

    public void saveSessionProps(Container parent) {
        if (this.sesProps.containsKey("saveme")) {
            this.sesProps.remove("saveme");
            Object[] args = new Object[]{this.getConfigurationResource()};
            String message = MessageFormat.format(LangTool.getString("messages.saveSettings"), args);
            int result = JOptionPane.showConfirmDialog(parent, message);
            if (result == 0) {
                this.saveSessionProps();
            }
        }
    }

    public void saveSessionProps() {
        if (this.usingDefaults) {
            ConfigureFactory.getInstance().saveSettings("dfltSessionProps", this.getConfigurationResource(), "");
        } else {
            try {
                FileOutputStream out = new FileOutputStream(this.settingsDirectory() + this.getConfigurationResource());
                this.sesProps.store(out, "------ Defaults --------");
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadConfigurationResource() {
        this.sesProps = new Properties();
        if (this.configurationResource == null || this.configurationResource.trim().isEmpty()) {
            this.configurationResource = "TN5250JDefaults.props";
            this.usingDefaults = true;
            this.loadDefaults();
        } else {
            try {
                FileInputStream in = new FileInputStream(this.settingsDirectory() + this.getConfigurationResource());
                this.sesProps.load(in);
                if (this.sesProps.size() == 0) {
                    this.loadDefaults();
                }
            }
            catch (IOException ioe) {
                System.out.println("Information Message: Properties file is being created for first time use:  File name " + this.getConfigurationResource());
                this.loadDefaults();
            }
            catch (SecurityException se) {
                System.out.println(se.getMessage());
            }
        }
    }

    private String settingsDirectory() {
        return ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory");
    }

    private void loadDefaults() {
        ConfigureFactory configureFactory = ConfigureFactory.getInstance();
        try {
            this.sesProps = configureFactory.getProperties("dfltSessionProps", this.getConfigurationResource(), true, "Default Settings");
            if (this.sesProps.size() == 0) {
                this.sesProps.putAll((Map<?, ?>)this.loadPropertiesFromResource(this.getConfigurationResource()));
                Properties colorSchemaDefaults = this.loadPropertiesFromResource("tn5250jSchemas.properties");
                String prefix = colorSchemaDefaults.getProperty("schemaDefault");
                this.sesProps.setProperty("colorBg", colorSchemaDefaults.getProperty(prefix + ".colorBg"));
                this.sesProps.setProperty("colorRed", colorSchemaDefaults.getProperty(prefix + ".colorRed"));
                this.sesProps.setProperty("colorTurq", colorSchemaDefaults.getProperty(prefix + ".colorTurq"));
                this.sesProps.setProperty("colorCursor", colorSchemaDefaults.getProperty(prefix + ".colorCursor"));
                this.sesProps.setProperty("colorGUIField", colorSchemaDefaults.getProperty(prefix + ".colorGUIField"));
                this.sesProps.setProperty("colorWhite", colorSchemaDefaults.getProperty(prefix + ".colorWhite"));
                this.sesProps.setProperty("colorYellow", colorSchemaDefaults.getProperty(prefix + ".colorYellow"));
                this.sesProps.setProperty("colorGreen", colorSchemaDefaults.getProperty(prefix + ".colorGreen"));
                this.sesProps.setProperty("colorPink", colorSchemaDefaults.getProperty(prefix + ".colorPink"));
                this.sesProps.setProperty("colorBlue", colorSchemaDefaults.getProperty(prefix + ".colorBlue"));
                this.sesProps.setProperty("colorSep", colorSchemaDefaults.getProperty(prefix + ".colorSep"));
                this.sesProps.setProperty("colorHexAttr", colorSchemaDefaults.getProperty(prefix + ".colorHexAttr"));
                this.sesProps.setProperty("font", GUIGraphicsUtils.getDefaultFont());
                configureFactory.saveSettings("dfltSessionProps", this.getConfigurationResource(), "");
            }
        }
        catch (IOException ioe) {
            System.out.println("Information Message: Properties file is being created for first time use:  File name " + this.getConfigurationResource());
        }
        catch (SecurityException se) {
            System.out.println(se.getMessage());
        }
    }

    private Properties loadPropertiesFromResource(String resourceName) throws IOException {
        Properties properties = new Properties();
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        if (url != null) {
            properties.load(url.openStream());
        }
        return properties;
    }

    public boolean isPropertyExists(String prop) {
        return this.sesProps.containsKey(prop);
    }

    @Deprecated
    public String getStringProperty(String prop) {
        if (this.sesProps.containsKey(prop)) {
            return (String)this.sesProps.get(prop);
        }
        return "";
    }

    @Deprecated
    public int getIntegerProperty(String prop) {
        if (this.sesProps.containsKey(prop)) {
            try {
                return Integer.parseInt((String)this.sesProps.get(prop));
            }
            catch (NumberFormatException ne) {
                return 0;
            }
        }
        return 0;
    }

    @Deprecated
    public Color getColorProperty(String prop) {
        if (this.sesProps.containsKey(prop)) {
            return new Color(this.getIntegerProperty(prop));
        }
        return null;
    }

    public Rectangle getRectangleProperty(String key) {
        Rectangle rectProp = new Rectangle();
        if (this.sesProps.containsKey(key)) {
            String rect = this.sesProps.getProperty(key);
            StringTokenizer stringtokenizer = new StringTokenizer(rect, ",");
            if (stringtokenizer.hasMoreTokens()) {
                rectProp.x = Integer.parseInt(stringtokenizer.nextToken());
            }
            if (stringtokenizer.hasMoreTokens()) {
                rectProp.y = Integer.parseInt(stringtokenizer.nextToken());
            }
            if (stringtokenizer.hasMoreTokens()) {
                rectProp.width = Integer.parseInt(stringtokenizer.nextToken());
            }
            if (stringtokenizer.hasMoreTokens()) {
                rectProp.height = Integer.parseInt(stringtokenizer.nextToken());
            }
        }
        return rectProp;
    }

    public void setRectangleProperty(String key, Rectangle rect) {
        String rectStr = rect.x + "," + rect.y + "," + rect.width + "," + rect.height;
        this.sesProps.setProperty(key, rectStr);
    }

    @Deprecated
    public float getFloatProperty(String prop) {
        return this.getFloatProperty(prop, 0.0f);
    }

    @Deprecated
    public float getFloatProperty(String propertyName, float defaultValue) {
        if (this.sesProps.containsKey(propertyName)) {
            return Float.parseFloat((String)this.sesProps.get(propertyName));
        }
        return defaultValue;
    }

    public Object setProperty(String key, String value) {
        return this.sesProps.setProperty(key, value);
    }

    public Object removeProperty(String key) {
        return this.sesProps.remove(key);
    }

    public final void addSessionConfigListener(SessionConfigListener listener) {
        this.sessionCfglistenersLock.writeLock().lock();
        try {
            if (this.sessionCfglisteners == null) {
                this.sessionCfglisteners = new ArrayList<SessionConfigListener>(3);
            }
            this.sessionCfglisteners.add(listener);
        }
        finally {
            this.sessionCfglistenersLock.writeLock().unlock();
        }
    }

    public final void removeSessionConfigListener(SessionConfigListener listener) {
        this.sessionCfglistenersLock.writeLock().lock();
        try {
            if (this.sessionCfglisteners != null) {
                this.sessionCfglisteners.remove(listener);
            }
        }
        finally {
            this.sessionCfglistenersLock.writeLock().unlock();
        }
    }

    public SessionConfiguration getConfig() {
        return this.sessionConfiguration;
    }

    public void setKeypadMnemonicsAndFireChangeEvent(KeyMnemonic[] keyMnemonics) {
        String newValue = this.keyMnemonicSerializer.serialize(keyMnemonics);
        this.firePropertyChange(this, CONFIG_KEYPAD_MNEMONICS, this.getStringProperty(CONFIG_KEYPAD_MNEMONICS), newValue);
        this.setProperty(CONFIG_KEYPAD_MNEMONICS, newValue);
    }

    public class SessionConfiguration {
        public float getKeypadFontSize() {
            return SessionConfig.this.getFloatProperty(SessionConfig.CONFIG_KEYPAD_FONT_SIZE, 12.0f);
        }

        public boolean isKeypadEnabled() {
            return SessionConfig.YES.equals(SessionConfig.this.getStringProperty(SessionConfig.CONFIG_KEYPAD_ENABLED));
        }

        public KeyMnemonic[] getKeypadMnemonics() {
            String s = SessionConfig.this.getStringProperty(SessionConfig.CONFIG_KEYPAD_MNEMONICS);
            KeyMnemonic[] result = SessionConfig.this.keyMnemonicSerializer.deserialize(s);
            if (result.length == 0) {
                return this.getDefaultKeypadMnemonics();
            }
            return result;
        }

        public KeyMnemonic[] getDefaultKeypadMnemonics() {
            return new KeyMnemonic[]{KeyMnemonic.PF1, KeyMnemonic.PF2, KeyMnemonic.PF3, KeyMnemonic.PF4, KeyMnemonic.PF5, KeyMnemonic.PF6, KeyMnemonic.PF7, KeyMnemonic.PF8, KeyMnemonic.PF9, KeyMnemonic.PF10, KeyMnemonic.PF11, KeyMnemonic.PF12, KeyMnemonic.ENTER, KeyMnemonic.PAGE_UP, KeyMnemonic.CLEAR, KeyMnemonic.PF13, KeyMnemonic.PF14, KeyMnemonic.PF15, KeyMnemonic.PF16, KeyMnemonic.PF17, KeyMnemonic.PF18, KeyMnemonic.PF19, KeyMnemonic.PF20, KeyMnemonic.PF21, KeyMnemonic.PF22, KeyMnemonic.PF23, KeyMnemonic.PF24, KeyMnemonic.SYSREQ, KeyMnemonic.PAGE_DOWN};
        }
    }
}

