/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tn5250j.GuiGraphicBuffer;
import org.tn5250j.KeypadPanel;
import org.tn5250j.PrinterThread;
import org.tn5250j.RubberBand;
import org.tn5250j.RubberBandCanvasIF;
import org.tn5250j.Session5250;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPopup;
import org.tn5250j.SessionScroller;
import org.tn5250j.event.EmulatorActionEvent;
import org.tn5250j.event.EmulatorActionListener;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionConfigEvent;
import org.tn5250j.event.SessionConfigListener;
import org.tn5250j.event.SessionJumpEvent;
import org.tn5250j.event.SessionJumpListener;
import org.tn5250j.event.SessionListener;
import org.tn5250j.framework.tn5250.Rect;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.ConfirmTabCloseDialog;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.KeyMnemonicSerializer;
import org.tn5250j.keyboard.KeyboardHandler;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.sessionsettings.SessionSettings;
import org.tn5250j.spoolfile.SpoolExporter;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.Macronizer;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SessionPanel
extends JPanel
implements RubberBandCanvasIF,
SessionConfigListener,
SessionListener {
    private static final long serialVersionUID = 1L;
    private boolean firstScreen;
    private char[] signonSave;
    private Screen5250 screen;
    protected Session5250 session;
    private GuiGraphicBuffer guiGraBuf;
    protected TNRubberBand rubberband;
    private KeypadPanel keypadPanel;
    private String newMacName;
    private Vector<SessionJumpListener> sessionJumpListeners = null;
    private Vector<EmulatorActionListener> actionListeners = null;
    private boolean macroRunning;
    private boolean stopMacro;
    private boolean doubleClick;
    protected SessionConfig sesConfig;
    protected KeyboardHandler keyHandler;
    private final SessionScroller scroller = new SessionScroller();
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public SessionPanel(Session5250 session) {
        this.keypadPanel = new KeypadPanel(session.getConfiguration().getConfig());
        this.session = session;
        this.sesConfig = session.getConfiguration();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.log.warn("Error in constructor: " + e.getMessage());
        }
        session.getConfiguration().addSessionConfigListener(this);
        session.addSessionListener(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.session.setGUI(this);
        this.screen = this.session.getScreen();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SessionPanel.this.resizeMe();
            }
        });
        this.ensureGuiGraphicBufferInitialized();
        this.setRubberBand(new TNRubberBand(this));
        this.keyHandler = KeyboardHandler.getKeyboardHandlerInstance(this.session);
        if (!this.sesConfig.isPropertyExists("width") || !this.sesConfig.isPropertyExists("height")) {
            this.setSize(this.guiGraBuf.getPreferredSize());
        } else {
            this.setSize(this.sesConfig.getIntegerProperty("width"), this.sesConfig.getIntegerProperty("height"));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    SessionPanel.this.actionPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() == 2 & SessionPanel.this.doubleClick) {
                    SessionPanel.this.screen.sendKeys(KeyMnemonic.ENTER);
                } else {
                    boolean moved;
                    int pos = SessionPanel.this.guiGraBuf.getPosFromView(e.getX(), e.getY());
                    if (SessionPanel.this.log.isDebugEnabled()) {
                        SessionPanel.this.log.debug(SessionPanel.this.screen.getRow(pos) + "," + SessionPanel.this.screen.getCol(pos));
                        SessionPanel.this.log.debug(e.getX() + "," + e.getY() + "," + ((SessionPanel)SessionPanel.this).guiGraBuf.columnWidth + "," + ((SessionPanel)SessionPanel.this).guiGraBuf.rowHeight);
                    }
                    if (moved = SessionPanel.this.screen.moveCursor(pos)) {
                        if (SessionPanel.this.rubberband.isAreaSelected()) {
                            SessionPanel.this.rubberband.reset();
                        }
                        SessionPanel.this.screen.repaintScreen();
                    }
                    SessionPanel.this.getFocusForMe();
                }
            }
        });
        if ("Yes".equals(this.sesConfig.getStringProperty("mouseWheel"))) {
            this.scroller.addMouseWheelListener(this);
        }
        this.log.debug("Initializing macros");
        Macronizer.init();
        this.keypadPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionPanel.this.screen.sendKeys(((JButton)e.getSource()).getActionCommand());
                SessionPanel.this.getFocusForMe();
            }
        });
        this.keypadPanel.setVisible(this.sesConfig.getConfig().isKeypadEnabled());
        this.add((Component)this.keypadPanel, "South");
        this.requestFocus();
        this.doubleClick = "Yes".equals(this.sesConfig.getStringProperty("doubleClick"));
    }

    public void setRunningHeadless(boolean headless) {
        if (headless) {
            this.screen.getOIA().removeOIAListener(this.guiGraBuf);
            this.screen.removeScreenListener(this.guiGraBuf);
        } else {
            this.screen.getOIA().addOIAListener(this.guiGraBuf);
            this.screen.addScreenListener(this.guiGraBuf);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        this.keyHandler.processKeyEvent(evt);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void sendScreenEMail() {
        new SendEMailDialog((JFrame)SwingUtilities.getRoot(this), this);
    }

    public void doKeyBoundArea(KeyEvent ke, String last) {
        MouseEvent me;
        Point p = new Point();
        if (!this.rubberband.isAreaSelected()) {
            if (last.equals("[markleft]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 1, this.screen.getCurrentCol() + 1, p);
            }
            if (last.equals("[markright]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 1, this.screen.getCurrentCol() - 2, p);
            }
            if (last.equals("[markup]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() + 1, this.screen.getCurrentCol() - 1, p);
            }
            if (last.equals("[markdown]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 2, this.screen.getCurrentCol() - 1, p);
            }
            me = new MouseEvent(this, 501, System.currentTimeMillis(), 16, p.x, p.y, 1, false);
            this.dispatchEvent(me);
        }
        this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 1, this.screen.getCurrentCol() - 1, p);
        me = new MouseEvent(this, 506, System.currentTimeMillis(), 16, p.x, p.y, 1, false);
        this.dispatchEvent(me);
    }

    public boolean confirmCloseSession(boolean reallyclose) {
        boolean close;
        boolean bl = close = !this.isConnected() || this.confirmTabClose();
        if (close) {
            boolean bl2 = close = this.isOnSignOnScreen() || this.confirmSignOffClose();
        }
        if (close && reallyclose) {
            this.fireEmulatorAction(1);
        }
        return close;
    }

    private boolean confirmTabClose() {
        boolean result = true;
        if (this.session.getConfiguration().isPropertyExists("confirmTabClose")) {
            this.requestFocus();
            ConfirmTabCloseDialog tabclsdlg = new ConfirmTabCloseDialog(this);
            if ("Yes".equals(this.session.getConfiguration().getStringProperty("confirmTabClose")) && !tabclsdlg.show()) {
                result = false;
            }
        }
        return result;
    }

    private boolean confirmSignOffClose() {
        if (this.sesConfig.isPropertyExists("confirmSignoff") && "Yes".equals(this.sesConfig.getStringProperty("confirmSignoff"))) {
            this.requestFocus();
            int result = JOptionPane.showConfirmDialog(this.getParent(), LangTool.getString("messages.signOff"), LangTool.getString("cs.title"), 2);
            return result == 0;
        }
        return true;
    }

    public void getFocusForMe() {
        this.grabFocus();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void onConfigChanged(SessionConfigEvent configEvent) {
        String configName = configEvent.getPropertyName();
        if ("keypad".equals(configName)) {
            this.keypadPanel.setVisible("Yes".equals(configEvent.getNewValue()));
            this.validate();
        }
        if ("keypadMnemonics".equals(configName)) {
            this.keypadPanel.reInitializeButtons(new KeyMnemonicSerializer().deserialize((String)configEvent.getNewValue()));
        }
        if ("keypadFontSize".equals(configName)) {
            this.keypadPanel.updateButtonFontSize(Float.parseFloat((String)configEvent.getNewValue()));
        }
        if ("doubleClick".equals(configName)) {
            this.doubleClick = "Yes".equals(configEvent.getNewValue());
        }
        if ("mouseWheel".equals(configName)) {
            if ("Yes".equals(configEvent.getNewValue())) {
                this.scroller.addMouseWheelListener(this);
            } else {
                this.scroller.removeMouseWheelListener(this);
            }
        }
        this.resizeMe();
        this.repaint();
    }

    public tnvt getVT() {
        return this.session.getVT();
    }

    public void toggleDebug() {
        this.session.getVT().toggleDebug();
    }

    public void startNewSession() {
        this.fireEmulatorAction(2);
    }

    public void startDuplicateSession() {
        this.fireEmulatorAction(4);
    }

    public void toggleConnection() {
        if (this.isConnected()) {
            boolean disconnect;
            boolean bl = disconnect = this.confirmTabClose() && (this.isOnSignOnScreen() || this.confirmSignOffClose());
            if (disconnect) {
                this.session.getVT().disconnect();
            }
        } else {
            Runnable connectIt = new Runnable(){

                @Override
                public void run() {
                    SessionPanel.this.session.getVT().connect();
                }
            };
            Thread ct = new Thread(connectIt);
            ct.setDaemon(true);
            ct.start();
        }
    }

    public void nextSession() {
        this.fireSessionJump(1);
    }

    public void prevSession() {
        this.fireSessionJump(0);
    }

    private void fireSessionJump(int dir) {
        if (this.sessionJumpListeners != null) {
            int size = this.sessionJumpListeners.size();
            SessionJumpEvent jumpEvent = new SessionJumpEvent(this);
            jumpEvent.setJumpDirection(dir);
            for (int i = 0; i < size; ++i) {
                SessionJumpListener target = this.sessionJumpListeners.elementAt(i);
                target.onSessionJump(jumpEvent);
            }
        }
    }

    protected void fireEmulatorAction(int action) {
        if (this.actionListeners != null) {
            int size = this.actionListeners.size();
            for (int i = 0; i < size; ++i) {
                EmulatorActionListener target = this.actionListeners.elementAt(i);
                EmulatorActionEvent sae = new EmulatorActionEvent(this);
                sae.setAction(action);
                target.onEmulatorAction(sae);
            }
        }
    }

    public boolean isMacroRunning() {
        return this.macroRunning;
    }

    public boolean isStopMacroRequested() {
        return this.stopMacro;
    }

    public boolean isSessionRecording() {
        return this.keyHandler.isRecording();
    }

    public void setMacroRunning(boolean mr) {
        this.macroRunning = mr;
        if (this.macroRunning) {
            this.screen.getOIA().setScriptActive(true);
        } else {
            this.screen.getOIA().setScriptActive(false);
        }
        this.stopMacro = !this.macroRunning;
    }

    public void setStopMacroRequested() {
        this.setMacroRunning(false);
    }

    public void closeDown() {
        this.sesConfig.saveSessionProps(this.getParent());
        if (this.session.getVT() != null) {
            this.session.getVT().disconnect();
        }
        this.keyHandler.sessionClosed(this);
        this.keyHandler = null;
    }

    public void actionAttributes() {
        new SessionSettings((Frame)SwingUtilities.getRoot(this), this.sesConfig).showIt();
        this.getFocusForMe();
    }

    private void actionPopup(MouseEvent me) {
        new SessionPopup(this, me);
    }

    public void actionSpool() {
        try {
            SpoolExporter spooler = new SpoolExporter(this.session.getVT(), this);
            spooler.setVisible(true);
        }
        catch (NoClassDefFoundError ncdfe) {
            JOptionPane.showMessageDialog(this, LangTool.getString("messages.noAS400Toolbox"), "Error", 0, null);
        }
    }

    public void executeMacro(ActionEvent ae) {
        this.executeMacro(ae.getActionCommand());
    }

    public void executeMacro(String macro) {
        Macronizer.invoke(macro, this);
    }

    protected void stopRecordingMe() {
        if (this.keyHandler.getRecordBuffer().length() > 0) {
            Macronizer.setMacro(this.newMacName, this.keyHandler.getRecordBuffer());
            this.log.debug(this.keyHandler.getRecordBuffer());
        }
        this.keyHandler.stopRecording();
    }

    protected void startRecordingMe() {
        String macName = JOptionPane.showInputDialog(null, LangTool.getString("macro.message"), LangTool.getString("macro.title"), -1);
        if (macName != null && (macName = macName.trim()).length() > 0) {
            this.log.info(macName);
            this.newMacName = macName;
            this.keyHandler.startRecording();
        }
    }

    void resizeMe() {
        Rectangle r = this.getDrawingBounds();
        if (this.guiGraBuf != null) {
            this.guiGraBuf.resizeScreenArea(r.width, r.height);
        }
        this.screen.repaintScreen();
        Graphics g = this.getGraphics();
        if (g != null) {
            g.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public Rectangle getDrawingBounds() {
        Rectangle r = this.getBounds();
        if (this.keypadPanel != null && this.keypadPanel.isVisible()) {
            r.height -= this.keypadPanel.getHeight();
        }
        r.setSize(r.width, r.height);
        return r;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.log.debug("paint from screen");
        this.ensureGuiGraphicBufferInitialized();
        Graphics2D g2 = (Graphics2D)g;
        if (this.rubberband.isAreaSelected() && !this.rubberband.isDragging()) {
            this.rubberband.erase();
        }
        g2.setColor(this.guiGraBuf.colorBg);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.guiGraBuf.drawImageBuffer(g2);
        if (this.rubberband.isAreaSelected() && !this.rubberband.isDragging()) {
            this.rubberband.draw();
        }
    }

    @Override
    public void update(Graphics g) {
        this.log.info("update paint from gui");
        this.paint(g);
    }

    public boolean isHotSpots() {
        return this.guiGraBuf.hotSpots;
    }

    public void toggleHotSpots() {
        this.guiGraBuf.hotSpots = !this.guiGraBuf.hotSpots;
    }

    public void crossHair() {
        this.screen.setCursorActive(false);
        ++this.guiGraBuf.crossHair;
        if (this.guiGraBuf.crossHair > 3) {
            this.guiGraBuf.crossHair = 0;
        }
        this.screen.setCursorActive(true);
    }

    private void ensureGuiGraphicBufferInitialized() {
        if (this.guiGraBuf == null) {
            this.guiGraBuf = new GuiGraphicBuffer(this.screen, this, this.sesConfig);
            this.guiGraBuf.getImageBuffer(0, 0);
        }
    }

    public final void actionCopy() {
        Rect area = this.getBoundingArea();
        this.rubberband.reset();
        this.screen.repaintScreen();
        String textcontent = this.screen.copyText(area);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(textcontent);
        cb.setContents(contents, null);
    }

    protected final Vector<Double> sumThem(boolean which) {
        this.log.debug("Summing");
        return this.screen.sumThem(which, this.getBoundingArea());
    }

    public final void printMe() {
        PrinterThread printerThread = new PrinterThread(this.screen, this.guiGraBuf.font, this.screen.getColumns(), this.screen.getRows(), Color.black, true, this);
        printerThread.start();
    }

    public synchronized void addSessionJumpListener(SessionJumpListener listener) {
        if (this.sessionJumpListeners == null) {
            this.sessionJumpListeners = new Vector(3);
        }
        this.sessionJumpListeners.addElement(listener);
    }

    public synchronized void removeSessionJumpListener(SessionJumpListener listener) {
        if (this.sessionJumpListeners == null) {
            return;
        }
        this.sessionJumpListeners.removeElement(listener);
    }

    public synchronized void addEmulatorActionListener(EmulatorActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector(3);
        }
        this.actionListeners.addElement(listener);
    }

    public synchronized void removeEmulatorActionListener(EmulatorActionListener listener) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.removeElement(listener);
    }

    @Override
    public Graphics getDrawingGraphics() {
        return this.guiGraBuf.getDrawingArea();
    }

    protected final void setRubberBand(TNRubberBand newValue) {
        this.rubberband = newValue;
    }

    public Rect getBoundingArea() {
        Rectangle awt_rect = new Rectangle();
        this.guiGraBuf.getBoundingArea(awt_rect);
        Rect result = new Rect();
        result.setBounds(awt_rect.x, awt_rect.y, awt_rect.width, awt_rect.height);
        return result;
    }

    @Override
    public Point translateStart(Point start) {
        return this.guiGraBuf.translateStart(start);
    }

    @Override
    public Point translateEnd(Point end) {
        return this.guiGraBuf.translateEnd(end);
    }

    public int getPosFromView(int x, int y) {
        return this.guiGraBuf.getPosFromView(x, y);
    }

    public void getBoundingArea(Rectangle bounds) {
        this.guiGraBuf.getBoundingArea(bounds);
    }

    @Override
    public void areaBounded(RubberBand band, int x1, int y1, int x2, int y2) {
        this.repaint();
        if (this.log.isDebugEnabled()) {
            this.log.debug(" bound " + band.getEndPoint());
        }
    }

    @Override
    public boolean canDrawRubberBand(RubberBand b) {
        return this.guiGraBuf.isWithinScreenArea(b.getStartPoint().x, b.getStartPoint().y);
    }

    public Session5250 getSession() {
        return this.session;
    }

    public void setSession(Session5250 session) {
        this.session = session;
    }

    public boolean isConnected() {
        return this.session.getVT() != null && this.session.getVT().isConnected();
    }

    public boolean isOnSignOnScreen() {
        if (this.firstScreen) {
            char[] so = this.screen.getScreenAsChars();
            Rectangle region = this.sesConfig.getRectangleProperty("signOnRegion");
            int fromRow = region.x;
            int fromCol = region.y;
            int toRow = region.width;
            int toCol = region.height;
            if (fromRow == 0) {
                fromRow = 1;
            }
            if (fromCol == 0) {
                fromCol = 1;
            }
            if (toRow == 0) {
                toRow = 24;
            }
            if (toCol == 0) {
                toCol = 80;
            }
            int pos = 0;
            for (int r = fromRow; r <= toRow; ++r) {
                for (int c = fromCol; c <= toCol; ++c) {
                    pos = this.screen.getPos(r - 1, c - 1);
                    if (this.signonSave[pos] == so[pos]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String getSessionName() {
        return this.session.getSessionName();
    }

    public String getAllocDeviceName() {
        if (this.session.getVT() != null) {
            return this.session.getVT().getAllocatedDeviceName();
        }
        return null;
    }

    public String getHostName() {
        if (this.session.getVT() != null) {
            return this.session.getVT().getHostName();
        }
        return this.session.getConnectionProperties().getProperty("SESSION_HOST");
    }

    public Screen5250 getScreen() {
        return this.screen;
    }

    public void connect() {
        this.session.connect();
    }

    public void disconnect() {
        this.session.disconnect();
    }

    @Override
    public void onSessionChanged(SessionChangeEvent changeEvent) {
        switch (changeEvent.getState()) {
            case 1: {
                String mac;
                if (!this.firstScreen) {
                    this.firstScreen = true;
                    this.signonSave = this.screen.getScreenAsChars();
                }
                if ((mac = this.sesConfig.getStringProperty("connectMacro")).length() <= 0) break;
                this.executeMacro(mac);
                break;
            }
            default: {
                this.firstScreen = false;
                this.signonSave = null;
            }
        }
    }

    public synchronized void addSessionListener(SessionListener listener) {
        this.session.addSessionListener(listener);
    }

    public synchronized void removeSessionListener(SessionListener listener) {
        this.session.removeSessionListener(listener);
    }

    public class TNRubberBand
    extends RubberBand {
        public TNRubberBand(RubberBandCanvasIF c) {
            super(c);
        }

        @Override
        protected void drawBoundingShape(Graphics g, int startX, int startY, int width, int height) {
            g.drawRect(startX, startY, width, height);
        }

        protected Rectangle getBoundingArea() {
            Rectangle r = new Rectangle();
            this.getBoundingArea(r);
            return r;
        }

        protected void getBoundingArea(Rectangle r) {
            if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
                r.setBounds(this.getStartPoint().x, this.getStartPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getEndPoint().y - this.getStartPoint().y);
            } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
                r.setBounds(this.getEndPoint().x, this.getEndPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getStartPoint().y - this.getEndPoint().y);
            } else if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
                r.setBounds(this.getStartPoint().x, this.getEndPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getStartPoint().y - this.getEndPoint().y);
            } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
                r.setBounds(this.getEndPoint().x, this.getStartPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getEndPoint().y - this.getStartPoint().y);
            }
        }

        @Override
        protected Point getEndPoint() {
            if (this.endPoint == null) {
                Point p = new Point(0, 0);
                SessionPanel.this.guiGraBuf.getPointFromRowCol(0, 0, p);
                this.setEndPoint(p);
            }
            return this.endPoint;
        }

        @Override
        protected Point getStartPoint() {
            if (this.startPoint == null) {
                Point p = new Point(0, 0);
                SessionPanel.this.guiGraBuf.getPointFromRowCol(0, 0, p);
                this.setStartPoint(p);
            }
            return this.startPoint;
        }
    }
}

