/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.connectdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import org.tn5250j.tools.FixedCenterLayout;
import org.tn5250j.tools.LangTool;

class MultiSelectListComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String SELECT_ITEM = ">";
    private static final String SELECT_ALL = ">>|";
    private static final String DESELECT_ITEM = "<";
    private static final String DESELECT_ALL = "|<<";
    private static final Dimension BUTTON_SIZE = new Dimension(48, 32);
    private JList mainList = null;
    private JList sourceList = null;
    private JList selectionList = null;
    private JScrollPane sourcePane = null;
    private JScrollPane selectionPane = null;
    private SelectionButton selectItemButton = null;
    private SelectionButton selectAllButton = null;
    private SelectionButton deselectItemButton = null;
    private SelectionButton deselectAllButton = null;
    private JPanel buttonPanel = null;
    private EventHandler eventHandler = new EventHandler();
    private Dimension defaultListSize = new Dimension(100, 200);
    private FontMetrics lastFontMetrics = null;
    private JPanel sourcePanel;
    private JPanel selectionPanel;

    public MultiSelectListComponent(ListModel dataModel) {
        this();
        this.mainList.setModel(dataModel);
        this.init();
    }

    public MultiSelectListComponent(Object[] listData) {
        this();
        this.mainList.setListData(listData);
        this.init();
    }

    public MultiSelectListComponent(Vector listData) {
        this();
        this.mainList.setListData(listData);
        this.init();
    }

    public MultiSelectListComponent() {
        this(4);
    }

    public MultiSelectListComponent(int hgap) {
        this.mainList = new JList();
        this.mainList.addListSelectionListener(this.eventHandler);
        this.sourceList = new JList();
        this.sourceList.setSelectionMode(2);
        this.sourceList.addListSelectionListener(this.eventHandler);
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MultiSelectListComponent.this.selectItem();
                }
            }
        });
        this.selectionList = new JList();
        this.selectionList.setSelectionMode(2);
        this.selectionList.addListSelectionListener(this.eventHandler);
        this.selectionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MultiSelectListComponent.this.deselectItem();
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(11, 0, 0, 0));
        this.selectItemButton = this.initButton(new SelectionButton(SELECT_ITEM), LangTool.getString("oaa.AddSelected"));
        this.selectAllButton = this.initButton(new SelectionButton(SELECT_ALL), LangTool.getString("oaa.AddAll"));
        this.deselectItemButton = this.initButton(new SelectionButton(DESELECT_ITEM), LangTool.getString("oaa.RemoveSelected"));
        this.deselectAllButton = this.initButton(new SelectionButton(DESELECT_ALL), LangTool.getString("oaa.RemoveAll"));
        Dimension dimButton = BUTTON_SIZE;
        this.buttonPanel.setPreferredSize(new Dimension(dimButton.width, 4 * dimButton.height));
        this.setLayout(new FixedCenterLayout(hgap));
        this.sourcePanel = new JPanel();
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePane = new JScrollPane(this.sourceList);
        this.sourcePane.setPreferredSize(this.defaultListSize);
        this.sourcePanel.add((Component)this.sourcePane, "Center");
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(new BorderLayout());
        this.selectionPane = new JScrollPane(this.selectionList);
        this.selectionPane.setPreferredSize(this.defaultListSize);
        this.selectionPanel.add((Component)this.selectionPane, "Center");
        this.add((Component)this.sourcePanel, "West");
        this.add((Component)this.selectionPanel, "East");
        this.add((Component)this.buttonPanel, "Center");
        this.setUI(new MultiSelectListUI());
    }

    @Override
    public void updateUI() {
        this.setUI(new MultiSelectListUI());
    }

    public Object getPrototypeCellValue() {
        return this.mainList.getPrototypeCellValue();
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        this.mainList.setPrototypeCellValue(prototypeCellValue);
        this.sourceList.setPrototypeCellValue(prototypeCellValue);
        this.selectionList.setPrototypeCellValue(prototypeCellValue);
    }

    public int getFixedCellWidth() {
        return this.mainList.getFixedCellWidth();
    }

    public void setFixedCellWidth(int width) {
        this.mainList.setFixedCellWidth(width);
        this.sourceList.setFixedCellWidth(width);
        this.selectionList.setFixedCellWidth(width);
    }

    public int getFixedCellHeight() {
        return this.mainList.getFixedCellHeight();
    }

    public void setFixedCellHeight(int height) {
        this.mainList.setFixedCellHeight(height);
        this.sourceList.setFixedCellHeight(height);
        this.selectionList.setFixedCellHeight(height);
    }

    public ListCellRenderer getCellRenderer() {
        return this.mainList.getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.mainList.setCellRenderer(cellRenderer);
        this.sourceList.setCellRenderer(cellRenderer);
        this.selectionList.setCellRenderer(cellRenderer);
    }

    public Color getSelectionForeground() {
        return this.mainList.getSelectionForeground();
    }

    public void setSelectionForeground(Color selectionForeground) {
        this.mainList.setSelectionForeground(selectionForeground);
        this.sourceList.setSelectionForeground(selectionForeground);
        this.selectionList.setSelectionForeground(selectionForeground);
    }

    public Color getSelectionBackground() {
        return this.mainList.getSelectionBackground();
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.mainList.setSelectionBackground(selectionBackground);
        this.sourceList.setSelectionBackground(selectionBackground);
        this.selectionList.setSelectionBackground(selectionBackground);
    }

    public void setSourceColumnHeader(String header) {
        JViewport jvp = new JViewport();
        jvp.setView(new JLabel(header));
        this.sourcePane.setColumnHeader(jvp);
    }

    public void setSelectionColumnHeader(String header) {
        JViewport jvp = new JViewport();
        jvp.setView(new JLabel(header));
        this.selectionPane.setColumnHeader(jvp);
    }

    public void setSourceHeader(String header) {
        this.setSourceHeader(header, 2);
    }

    void setSourceHeader(String header, int horizontalAlignment) {
        this.sourcePanel.add((Component)new JLabel(header, horizontalAlignment), "North");
    }

    public void setSelectionHeader(String header) {
        this.setSelectionHeader(header, 2);
    }

    void setSelectionHeader(String header, int horizontalAlignment) {
        this.selectionPanel.add((Component)new JLabel(header, horizontalAlignment), "North");
    }

    public ListModel getModel() {
        return this.mainList.getModel();
    }

    public void setModel(ListModel model) {
        this.mainList.setModel(model);
        this.updateView();
    }

    void setListData(Object[] listData) {
        this.mainList.setListData(listData);
        this.updateView();
    }

    public void setListData(Vector listData) {
        this.mainList.setListData(listData);
        this.updateView();
    }

    public ListSelectionModel getSelectionModel() {
        return this.mainList.getSelectionModel();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    private void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public int getSelectionMode() {
        return this.mainList.getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.mainList.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.mainList.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.mainList.getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int index) {
        return this.mainList.isSelectedIndex(index);
    }

    public boolean isSelectionEmpty() {
        return this.mainList.isSelectionEmpty();
    }

    public void clearSelection() {
        this.mainList.clearSelection();
        this.updateView();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.mainList.setSelectionInterval(anchor, lead);
        this.updateView();
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.mainList.addSelectionInterval(anchor, lead);
        this.updateView();
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.mainList.removeSelectionInterval(index0, index1);
        this.updateView();
    }

    public int getSelectedIndex() {
        return this.mainList.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.mainList.setSelectedIndex(index);
        this.updateView();
    }

    public int[] getSelectedIndices() {
        return this.mainList.getSelectedIndices();
    }

    void setSelectedIndices(int[] indices) {
        this.mainList.setSelectedIndices(indices);
        this.updateView();
    }

    Object[] getSelectedValues() {
        return this.mainList.getSelectedValues();
    }

    public Object getSelectedValue() {
        return this.mainList.getSelectedValue();
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        this.mainList.setSelectedValue(anObject, shouldScroll);
        this.updateView();
    }

    @Override
    protected String paramString() {
        return super.paramString() + ", the list is: " + this.mainList;
    }

    private SelectionButton initButton(SelectionButton button, String toolTipText) {
        if (button != null) {
            this.buttonPanel.add(button);
            button.addActionListener(this.eventHandler);
            button.setToolTipText(toolTipText);
        }
        return button;
    }

    protected void init() {
        this.updateView();
    }

    private void updateView() {
        ListModel mainModel = this.mainList.getModel();
        int[] selected = this.mainList.getSelectedIndices();
        Vector sourceVector = new Vector(mainModel.getSize() - selected.length);
        Vector selectionVector = new Vector(selected.length);
        for (int i = 0; i < mainModel.getSize(); ++i) {
            if (this.mainList.isSelectedIndex(i)) {
                selectionVector.addElement(mainModel.getElementAt(i));
                continue;
            }
            sourceVector.addElement(mainModel.getElementAt(i));
        }
        this.sourceList.setListData(sourceVector);
        this.selectionList.setListData(selectionVector);
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.sourceList.isEnabled()) {
            this.selectItemButton.setEnabled(false);
            this.selectAllButton.setEnabled(false);
            this.deselectItemButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        } else {
            this.selectItemButton.setEnabled(!this.sourceList.isSelectionEmpty());
            this.selectAllButton.setEnabled(this.sourceList.getModel().getSize() > 0);
            this.deselectItemButton.setEnabled(!this.selectionList.isSelectionEmpty());
            this.deselectAllButton.setEnabled(this.selectionList.getModel().getSize() > 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimSource = this.sourcePane.getPreferredSize();
        Dimension dimSelection = this.selectionPane.getPreferredSize();
        Dimension dimButtons = this.buttonPanel.getPreferredSize();
        int w = dimButtons.width + 2 * this.getListPreferredWidth();
        int h = Math.max(dimButtons.height, Math.max(dimSource.height, dimSelection.height));
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimSource = this.sourceList.getMinimumSize();
        Dimension dimSelection = this.selectionList.getMinimumSize();
        Dimension dimButton = this.buttonPanel.getMinimumSize();
        int w = dimButton.width + dimSource.width + dimSelection.width;
        int h = Math.max(dimButton.height, Math.max(dimSource.height, dimSelection.height));
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimSource = this.sourceList.getMaximumSize();
        Dimension dimSelection = this.selectionList.getMaximumSize();
        Dimension dimButton = this.buttonPanel.getMaximumSize();
        int w = dimButton.width + dimSource.width + dimSelection.width;
        int h = Math.max(dimButton.height, Math.max(dimSource.height, dimSelection.height));
        return new Dimension(w, h);
    }

    @Override
    public void paint(Graphics g) {
        this.lastFontMetrics = g.getFontMetrics();
        super.paint(g);
    }

    private int getListPreferredWidth() {
        ListModel mainModel = this.mainList.getModel();
        int maxWidth = 0;
        if (this.lastFontMetrics != null) {
            for (int i = 0; i < mainModel.getSize(); ++i) {
                Object item = mainModel.getElementAt(i);
                if (!(item instanceof String)) continue;
                Math.max(this.lastFontMetrics.stringWidth((String)item), maxWidth);
            }
        }
        return maxWidth == 0 ? this.defaultListSize.width : maxWidth;
    }

    private void selectItem() {
        int[] indices = this.mainList.getSelectedIndices();
        Object[] values = this.sourceList.getSelectedValues();
        int[] newIndices = new int[indices.length + values.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        ListModel mainModel = this.mainList.getModel();
        int last = indices.length;
        for (int i = 0; i < mainModel.getSize(); ++i) {
            Object value = mainModel.getElementAt(i);
            for (int j = 0; j < values.length; ++j) {
                if (value != values[j]) continue;
                newIndices[last++] = i;
            }
        }
        this.doUpdate(this.sourceList, values, newIndices);
    }

    private void selectAll() {
        this.addSelectionInterval(0, this.mainList.getModel().getSize() - 1);
        this.updateView();
    }

    private void deselectItem() {
        int[] indices = this.mainList.getSelectedIndices();
        Object[] values = this.selectionList.getSelectedValues();
        int[] newIndices = new int[indices.length - values.length];
        ListModel mainModel = this.mainList.getModel();
        int last = 0;
        for (int i = 0; i < indices.length; ++i) {
            Object value = mainModel.getElementAt(indices[i]);
            boolean found = false;
            for (int j = 0; j < values.length; ++j) {
                if (value != values[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            newIndices[last++] = indices[i];
        }
        this.doUpdate(this.selectionList, values, newIndices);
    }

    private void doUpdate(JList list, Object[] values, int[] newIndices) {
        if (values != null && values.length > 0) {
            int nextIndex = this.getIndexFromItem(list, values[values.length - 1]);
            this.mainList.setSelectedIndices(newIndices);
            this.updateView();
            if ((nextIndex -= values.length - 1) < list.getModel().getSize()) {
                list.setSelectedIndex(nextIndex);
            } else {
                list.setSelectedIndex(list.getModel().getSize() - 1);
            }
        }
    }

    private int getIndexFromItem(JList list, Object item) {
        ListModel lm = list.getModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            Object o = lm.getElementAt(i);
            if (!o.equals(item)) continue;
            return i;
        }
        return -1;
    }

    private void deselectAll() {
        this.mainList.clearSelection();
        this.updateView();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.sourceList.setEnabled(enabled);
        this.selectionList.setEnabled(enabled);
        this.updateView();
    }

    private static class MultiSelectListUI
    extends ComponentUI {
        private MultiSelectListUI() {
        }
    }

    private static class SelectionButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        SelectionButton(String text) {
            super(text);
            this.setEnabled(false);
            this.setMargin(new Insets(8, 8, 8, 8));
        }

        @Override
        public Dimension getPreferredSize() {
            return BUTTON_SIZE;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof SelectionButton) {
                SelectionButton btn = (SelectionButton)event.getSource();
                if (btn.equals(MultiSelectListComponent.this.selectItemButton)) {
                    MultiSelectListComponent.this.selectItem();
                } else if (btn.equals(MultiSelectListComponent.this.selectAllButton)) {
                    MultiSelectListComponent.this.selectAll();
                } else if (btn.equals(MultiSelectListComponent.this.deselectItemButton)) {
                    MultiSelectListComponent.this.deselectItem();
                } else if (btn.equals(MultiSelectListComponent.this.deselectAllButton)) {
                    MultiSelectListComponent.this.deselectAll();
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == MultiSelectListComponent.this.mainList) {
                MultiSelectListComponent.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
            }
            MultiSelectListComponent.this.updateButtons();
        }
    }
}

