/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.tn5250j.encoding.BuiltInCodePageFactory;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.encoding.JavaCodePageFactory;
import org.tn5250j.encoding.ToolboxCodePageFactory;

public class CharMappings {
    public static final String DFT_ENC = "37";
    public static final int NATIVE_CP = 0;
    public static final int TOOLBOX_CP = 1;
    private static final HashMap<String, ICodePage> map = new HashMap();

    public static String[] getAvailableCodePages() {
        HashSet<String> cpset = new HashSet<String>();
        for (String cp : BuiltInCodePageFactory.getInstance().getAvailableCodePages()) {
            cpset.add(cp);
        }
        for (String cp : ToolboxCodePageFactory.getInstance().getAvailableCodePages()) {
            cpset.add(cp);
        }
        Object[] cparray = cpset.toArray(new String[cpset.size()]);
        Arrays.sort(cparray);
        return cparray;
    }

    public static ICodePage getCodePage(String encoding) {
        if (map.containsKey(encoding)) {
            return map.get(encoding);
        }
        ICodePage cp = BuiltInCodePageFactory.getInstance().getCodePage(encoding);
        if (cp != null) {
            map.put(encoding, cp);
            return cp;
        }
        cp = ToolboxCodePageFactory.getInstance().getCodePage(encoding);
        if (cp != null) {
            map.put(encoding, cp);
            return cp;
        }
        cp = JavaCodePageFactory.getCodePage(encoding);
        if (cp != null) {
            map.put(encoding, cp);
            return cp;
        }
        return BuiltInCodePageFactory.getInstance().getCodePage(DFT_ENC);
    }
}

