/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.tn5250j.encoding.AbstractCodePage;
import org.tn5250j.encoding.ICodePage;

class JavaCodePageFactory
extends AbstractCodePage {
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;

    JavaCodePageFactory(String encoding, CharsetEncoder encoder, CharsetDecoder decoder) {
        super(encoding);
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public char ebcdic2uni(int codepoint) {
        try {
            ByteBuffer in = ByteBuffer.wrap(new byte[]{(byte)codepoint});
            CharBuffer out = this.decoder.decode(in);
            return out.get(0);
        }
        catch (Exception cce) {
            return ' ';
        }
    }

    @Override
    public byte uni2ebcdic(char character) {
        try {
            CharBuffer in = CharBuffer.wrap(new char[]{character});
            ByteBuffer out = this.encoder.encode(in);
            return out.get(0);
        }
        catch (Exception cce) {
            return 0;
        }
    }

    static ICodePage getCodePage(String encoding) {
        CharsetDecoder dec = null;
        CharsetEncoder enc = null;
        try {
            Charset cs = Charset.forName(encoding);
            dec = cs.newDecoder();
            enc = cs.newEncoder();
        }
        catch (Exception e) {
            enc = null;
            dec = null;
        }
        if (enc != null && dec != null) {
            return new JavaCodePageFactory(encoding, enc, dec);
        }
        return null;
    }
}

