/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import org.tn5250j.GlobalConfigure;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.Tn5250jEvent;
import org.tn5250j.framework.Tn5250jKeyEvents;
import org.tn5250j.framework.Tn5250jListener;
import org.tn5250j.framework.Tn5250jSession;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.framework.common.Sessions;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class Tn5250jController
extends Thread {
    private File extensionDir;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private List<Tn5250jEvent> eventList;
    private List<Tn5250jListener> listeners;
    private SessionManager manager;
    Properties sesprops;
    private static Tn5250jController current;

    private Tn5250jController() {
        String maindir = System.getProperty("user.dir");
        this.extensionDir = new File(maindir + File.separatorChar + "ext");
        this.log.info("plugin directory is: " + this.extensionDir.getAbsolutePath());
        if (!this.extensionDir.exists()) {
            this.log.warn("Plugin path '" + this.extensionDir.getAbsolutePath() + "' does not exist. No plugins will be loaded.");
        }
        this.setDaemon(true);
        this.eventList = new ArrayList<Tn5250jEvent>();
        this.listeners = new ArrayList<Tn5250jListener>();
        current = this;
        this.log.info("Tn5250j plugin manager created");
        this.manager = SessionManager.instance();
        Sessions ses = this.manager.getSessions();
        this.log.debug("Sessions:" + ses.getCount());
        this.sesprops = ((GlobalConfigure)ConfigureFactory.getInstance()).getProperties("sessions");
        this.log.debug("Session configuration: " + this.sesprops.toString());
        this.start();
    }

    private void loadExt() {
        if (this.extensionDir.exists()) {
            File[] exts = this.extensionDir.listFiles();
            for (int x = 0; x < exts.length; ++x) {
                if (!exts[x].isDirectory()) continue;
                String jarName = exts[x].getAbsolutePath() + File.separatorChar + exts[x].getName() + ".jar";
                File jarFile = new File(jarName);
                if (jarFile.exists()) {
                    Properties config = this.loadConfig(jarFile);
                    this.load(jarFile, config.getProperty("mainentry"), config);
                    continue;
                }
                this.log.warn("extension could not be loaded as the jar was not found: " + jarName);
            }
        }
    }

    private void load(File jar, String name, Properties config) {
        URL[] urls = new URL[1];
        try {
            urls[0] = jar.toURI().toURL();
            this.log.info("Loading jar: " + jar.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.log.warn("The URL was malformed");
        }
        URLClassLoader loader = new URLClassLoader(urls);
        try {
            Class<?> ext = loader.loadClass(name);
            try {
                Tn5250jListener module = (Tn5250jListener)ext.newInstance();
                this.listeners.add(module);
                ModuleThread thrd = new ModuleThread(jar.getParentFile(), module, config);
                thrd.start();
            }
            catch (InstantiationException e2) {
                this.log.warn("Error instantiating class " + name);
            }
            catch (IllegalAccessException e2) {
                this.log.warn("The class " + name + " gives no access to the constructor");
            }
            catch (ClassCastException e2) {
                this.log.warn("Main module class does not derive from Tn5250jListener");
            }
        }
        catch (ClassNotFoundException e1) {
            this.log.warn("Extension could not be loaded, class: " + name + " not found");
        }
    }

    private Properties loadConfig(File jar) {
        JarFile jarfile = null;
        Properties config = null;
        try {
            jarfile = new JarFile(jar);
            JarEntry configfile = jarfile.getJarEntry("config.properties");
            InputStream stream = jarfile.getInputStream(configfile);
            config = new Properties();
            config.load(stream);
        }
        catch (IOException e) {
            this.log.warn("Failure trying to load configuration");
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info("Tn5250j plugin manager started");
        this.loadExt();
        while (true) {
            List<Tn5250jEvent> list = this.eventList;
            synchronized (list) {
                while (!this.eventList.isEmpty()) {
                    Tn5250jEvent event = this.eventList.remove(0);
                    this.broadcastEvent(event);
                }
                try {
                    this.eventList.wait();
                }
                catch (InterruptedException e) {
                    this.log.debug("Intertupted exception");
                }
            }
        }
    }

    private void broadcastEvent(Tn5250jEvent event) {
        for (Tn5250jListener listener : this.listeners) {
            listener.actionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Tn5250jEvent e) {
        this.log.debug("Received event: " + e.getClass().toString());
        if (e instanceof Tn5250jKeyEvents) {
            this.log.debug("Keys: " + ((Tn5250jKeyEvents)e).getKeystrokes());
        }
        this.eventList.add(e);
        List<Tn5250jEvent> list = this.eventList;
        synchronized (list) {
            this.eventList.notify();
        }
    }

    public static Tn5250jController getCurrent() {
        if (current == null) {
            current = new Tn5250jController();
        }
        return current;
    }

    public void createSession(Screen5250 screen, tnvt vt, SessionPanel ses) {
        Tn5250jSession session = new Tn5250jSession(screen, vt, ses);
        Iterator<Tn5250jListener> listenerIt = this.listeners.iterator();
        this.log.info("New session created and received");
        while (listenerIt.hasNext()) {
            Tn5250jListener listener = listenerIt.next();
            listener.sessionCreated(session);
        }
    }

    protected Properties getPropertiesForSession(String session) {
        return null;
    }

    public Screen5250 startSession(String name) {
        JFrame frame = new JFrame();
        String[] args = new String[15];
        this.parseArgs((String)this.sesprops.get(name), args);
        Properties fin = this.convertToProps(args);
        Session5250 newses = this.manager.openSession(fin, null, name);
        SessionPanel newGui = new SessionPanel(newses);
        frame.getContentPane().add(newGui);
        frame.setBounds(50, 50, 960, 700);
        frame.setVisible(true);
        newses.connect();
        return newses.getScreen();
    }

    public List<String> getSessions() {
        Enumeration<Object> e = this.sesprops.keys();
        ArrayList<String> list = new ArrayList<String>();
        String ses = null;
        while (e.hasMoreElements()) {
            ses = (String)e.nextElement();
            if (ses.startsWith("emul.")) continue;
            list.add(ses);
        }
        this.log.error(list.toString());
        return list;
    }

    protected void parseArgs(String theStringList, String[] s) {
        int x = 0;
        StringTokenizer tokenizer = new StringTokenizer(theStringList, " ");
        while (tokenizer.hasMoreTokens()) {
            s[x++] = tokenizer.nextToken();
        }
    }

    protected Properties convertToProps(String[] args) {
        Properties sesProps = new Properties();
        String session = args[0];
        sesProps.put("SESSION_HOST", session);
        if (this.isSpecified("-e", args)) {
            sesProps.put("SESSION_TN_ENHANCED", "1");
        }
        if (this.isSpecified("-p", args)) {
            sesProps.put("SESSION_HOST_PORT", this.getParm("-p", args));
        }
        if (this.isSpecified("-cp", args)) {
            sesProps.put("SESSION_CODE_PAGE", this.getParm("-cp", args));
        }
        if (this.isSpecified("-gui", args)) {
            sesProps.put("SESSION_USE_GUI", "1");
        }
        if (this.isSpecified("-t", args)) {
            sesProps.put("SESSION_TERM_NAME_SYSTEM", "1");
        }
        if (this.isSpecified("-132", args)) {
            sesProps.put("SESSION_SCREEN_SIZE", "1");
        } else {
            sesProps.put("SESSION_SCREEN_SIZE", "0");
        }
        if (this.isSpecified("-usp", args)) {
            if (this.isSpecified("-sph", args)) {
                sesProps.put("SESSION_PROXY_HOST", this.getParm("-sph", args));
            }
            if (this.isSpecified("-spp", args)) {
                sesProps.put("SESSION_PROXY_PORT", this.getParm("-spp", args));
            }
        }
        if (this.isSpecified("-sslType", args)) {
            sesProps.put("-sslType", this.getParm("-sslType", args));
        }
        if (this.isSpecified("-dn=hostname", args)) {
            String dnParam;
            try {
                dnParam = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                dnParam = "UNKNOWN_HOST";
            }
            sesProps.put("SESSION_DEVICE_NAME", dnParam);
        } else if (this.isSpecified("-dn", args)) {
            sesProps.put("SESSION_DEVICE_NAME", this.getParm("-dn", args));
        }
        if (this.isSpecified("-hb", args)) {
            sesProps.put("SESSION_KEEP_ALIVE_ENABLED", "1");
        }
        return sesProps;
    }

    boolean isSpecified(String parm, String[] args) {
        if (args == null) {
            return false;
        }
        for (int x = 0; x < args.length; ++x) {
            if (args[x] == null || !args[x].equals(parm)) continue;
            return true;
        }
        return false;
    }

    private String getParm(String parm, String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals(parm)) continue;
            return args[x + 1];
        }
        return null;
    }

    private class ModuleThread
    extends Thread {
        File dir;
        Tn5250jListener mod;
        Properties config;

        public ModuleThread(File directory, Tn5250jListener module, Properties config) {
            this.dir = directory;
            this.mod = module;
            this.config = config;
            this.setDaemon(true);
            this.setName(module.getName());
        }

        @Override
        public void run() {
            this.mod.init(this.dir, this.config);
            this.mod.setController(Tn5250jController.getCurrent());
            Tn5250jController.this.log.info("module initialized");
            this.mod.run();
            Tn5250jController.this.log.info("module stopped");
            this.mod.destroy();
            Tn5250jController.this.log.info("module destroyed");
        }
    }
}

