/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.tn5250j.Session5250;
import org.tn5250j.interfaces.SessionsInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class Sessions
implements SessionsInterface,
ActionListener {
    private List<Session5250> sessions = null;
    private int count = 0;
    private Timer heartBeater;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public Sessions() {
        this.sessions = new ArrayList<Session5250>();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int x = 0; x < this.sessions.size(); ++x) {
            try {
                Session5250 ses = this.sessions.get(x);
                if (!ses.isConnected() || !ses.isSendKeepAlive()) continue;
                ses.getVT().sendHeartBeat();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(" sent heartbeat to " + ses.getSessionName());
                continue;
            }
            catch (Exception ex) {
                this.log.warn(ex.getMessage());
            }
        }
    }

    protected void addSession(Session5250 newSession) {
        this.sessions.add(newSession);
        this.log.debug("adding Session: " + newSession.getSessionName());
        if (newSession.isSendKeepAlive() && this.heartBeater == null) {
            this.heartBeater = new Timer(15000, this);
            this.heartBeater.start();
        }
        ++this.count;
    }

    protected void removeSession(Session5250 session) {
        if (session != null) {
            this.log.debug("Removing session: " + session.getSessionName());
            if (session.isConnected()) {
                session.disconnect();
            }
            this.sessions.remove(session);
            --this.count;
        }
    }

    protected void removeSession(String sessionName) {
        this.log.debug("Remove session by name: " + sessionName);
        this.removeSession(this.item(sessionName));
    }

    protected void removeSession(int index) {
        this.log.debug("Remove session by index: " + index);
        this.removeSession(this.item(index));
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Session5250 item(int index) {
        return this.sessions.get(index);
    }

    @Override
    public Session5250 item(String sessionName) {
        Session5250 s = null;
        for (int x = 0; x < this.sessions.size(); ++x) {
            s = this.sessions.get(x);
            if (!s.getSessionName().equals(sessionName)) continue;
            return s;
        }
        return null;
    }

    public Session5250 item(Session5250 sessionObject) {
        Session5250 s = null;
        for (int x = 0; x < this.sessions.size(); ++x) {
            s = this.sessions.get(x);
            if (!s.equals(sessionObject)) continue;
            return s;
        }
        return null;
    }

    public ArrayList<Session5250> getSessionsList() {
        ArrayList<Session5250> newS = new ArrayList<Session5250>(this.sessions.size());
        for (int x = 0; x < this.sessions.size(); ++x) {
            newS.add(this.sessions.get(x));
        }
        return newS;
    }

    @Override
    public void refresh() {
    }
}

