/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class DataStreamDumper {
    private AtomicInteger counter = new AtomicInteger(0);
    private FileOutputStream fw;
    private BufferedOutputStream dw;
    private boolean dumpActive = false;
    private ICodePage codePage;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public void toggleDebug(ICodePage cp) {
        if (this.codePage == null) {
            this.codePage = cp;
        }
        boolean bl = this.dumpActive = !this.dumpActive;
        if (this.dumpActive) {
            try {
                if (this.fw == null) {
                    this.fw = new FileOutputStream("log.txt");
                    this.dw = new BufferedOutputStream(this.fw);
                }
            }
            catch (FileNotFoundException fnfe) {
                this.log.warn(fnfe.getMessage());
            }
        } else {
            try {
                if (this.dw != null) {
                    this.dw.close();
                }
                if (this.fw != null) {
                    this.fw.close();
                }
                this.dw = null;
                this.fw = null;
                this.codePage = null;
            }
            catch (IOException ioe) {
                this.log.warn(ioe.getMessage());
            }
        }
        this.log.info("Data Stream output is now " + this.dumpActive);
    }

    public void dump(byte[] abyte0) {
        if (!this.dumpActive) {
            return;
        }
        try {
            this.log.info("\n Buffer Dump of data from AS400: ");
            this.dw.write("\r\n Buffer Dump of data from AS400: ".getBytes());
            StringBuilder h = new StringBuilder();
            for (int x = 0; x < abyte0.length; ++x) {
                char ac;
                if (x % 16 == 0) {
                    System.out.println("  " + h.toString());
                    this.dw.write(("  " + h.toString() + "\r\n").getBytes());
                    h.setLength(0);
                    h.append("+0000");
                    h.setLength(5 - Integer.toHexString(x).length());
                    h.append(Integer.toHexString(x).toUpperCase());
                    System.out.print(h.toString());
                    this.dw.write(h.toString().getBytes());
                    h.setLength(0);
                }
                if ((ac = this.codePage.ebcdic2uni(abyte0[x])) < ' ') {
                    h.append('.');
                } else {
                    h.append(ac);
                }
                if (x % 4 == 0) {
                    System.out.print(" ");
                    this.dw.write(" ".getBytes());
                }
                if (Integer.toHexString(abyte0[x] & 0xFF).length() == 1) {
                    System.out.print("0" + Integer.toHexString(abyte0[x] & 0xFF).toUpperCase());
                    this.dw.write(("0" + Integer.toHexString(abyte0[x] & 0xFF).toUpperCase()).getBytes());
                    continue;
                }
                System.out.print(Integer.toHexString(abyte0[x] & 0xFF).toUpperCase());
                this.dw.write(Integer.toHexString(abyte0[x] & 0xFF).toUpperCase().getBytes());
            }
            System.out.println();
            this.dw.write("\r\n".getBytes());
            this.dw.flush();
        }
        catch (IOException e) {
            this.log.warn("Cannot dump from host! Message=" + e.getMessage());
        }
    }

    void dumpRaw(byte[] buffer) {
        try {
            String fname = "dump_" + this.counter.get() + ".data";
            this.log.debug("Dumping file: " + fname);
            FileOutputStream fos = new FileOutputStream(fname);
            fos.write(buffer);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

