/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import org.tn5250j.event.ScreenListener;
import org.tn5250j.framework.tn5250.KeyStrokenizer;
import org.tn5250j.framework.tn5250.Rect;
import org.tn5250j.framework.tn5250.ScreenField;
import org.tn5250j.framework.tn5250.ScreenFields;
import org.tn5250j.framework.tn5250.ScreenOIA;
import org.tn5250j.framework.tn5250.ScreenPlanes;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.KeyMnemonicResolver;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;
import org.tn5250j.tools.system.OperatingSystem;

public class Screen5250 {
    private static final int ERR_CURSOR_PROTECTED = 5;
    private static final int ERR_INVALID_SIGN = 17;
    private static final int ERR_NO_ROOM_INSERT = 18;
    private static final int ERR_NUMERIC_ONLY = 9;
    private static final int ERR_DUP_KEY_NOT_ALLOWED = 25;
    private static final int ERR_NUMERIC_09 = 16;
    private static final int ERR_FIELD_MINUS = 22;
    private static final int ERR_FIELD_EXIT_INVALID = 24;
    private static final int ERR_ENTER_NO_ALLOWED = 32;
    private static final int ERR_MANDITORY_ENTER = 33;
    static final byte STATUS_SYSTEM = 1;
    static final byte STATUS_ERROR_CODE = 2;
    static final byte STATUS_VALUE_ON = 1;
    static final byte STATUS_VALUE_OFF = 2;
    static final int initAttr = 32;
    static final char initChar = '\u0000';
    private final KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private ScreenFields screenFields;
    private int lastAttr;
    private int lastPos;
    private int lenScreen;
    private KeyStrokenizer strokenizer;
    private tnvt sessionVT;
    private int numRows = 0;
    private int numCols = 0;
    public boolean cursorActive = false;
    public boolean cursorShown = false;
    private boolean keyProcessed = false;
    private Rect dirtyScreen = new Rect();
    public int homePos = 0;
    private int saveHomePos = 0;
    private String bufferedKeys;
    private boolean pendingInsert = false;
    private StringBuffer hsMore = new StringBuffer("More...");
    private StringBuffer hsBottom = new StringBuffer("Bottom");
    private boolean guiInterface = false;
    private boolean resetRequired = true;
    private boolean backspaceError = true;
    private boolean feError;
    private Vector<ScreenListener> screenListeners = null;
    private ScreenOIA oia;
    protected ScreenPlanes planes;
    private StringBuffer keybuf = new StringBuffer();

    public Screen5250() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.warn("In constructor: ", ex);
        }
    }

    void jbInit() throws Exception {
        this.lastAttr = 32;
        this.numRows = 24;
        this.numCols = 80;
        this.setCursor(1, 1);
        this.oia = new ScreenOIA(this);
        this.oia.setKeyBoardLocked(true);
        this.lenScreen = this.numRows * this.numCols;
        this.planes = new ScreenPlanes(this, this.numRows);
        this.screenFields = new ScreenFields(this);
        this.strokenizer = new KeyStrokenizer();
    }

    protected ScreenPlanes getPlanes() {
        return this.planes;
    }

    public final ScreenOIA getOIA() {
        return this.oia;
    }

    protected final void setRowsCols(int rows, int cols) {
        int oldRows = this.numRows;
        int oldCols = this.numCols;
        this.numRows = rows;
        this.numCols = cols;
        this.lenScreen = this.numRows * this.numCols;
        this.planes.setSize(rows);
        if (oldRows != this.numRows || oldCols != this.numCols) {
            this.fireScreenSizeChanged();
        }
    }

    public boolean isCursorActive() {
        return this.cursorActive;
    }

    public boolean isCursorShown() {
        return this.cursorShown;
    }

    public void setUseGUIInterface(boolean gui) {
        this.guiInterface = gui;
    }

    public void toggleGUIInterface() {
        this.guiInterface = !this.guiInterface;
    }

    public void setResetRequired(boolean reset) {
        this.resetRequired = reset;
    }

    public void setBackspaceError(boolean onError) {
        this.backspaceError = onError;
    }

    public final String copyText(Rect area) {
        StringBuilder sb = new StringBuilder();
        Rect workR = new Rect();
        workR.setBounds(area);
        this.log.debug("Copying " + workR);
        int m = workR.x;
        int i = 0;
        int t = 0;
        while (workR.height-- > 0) {
            t = workR.width;
            i = workR.y;
            while (t-- > 0) {
                char c = this.planes.getChar(this.getPos(m - 1, i - 1));
                if (c >= ' ' && (this.planes.screenExtended[this.getPos(m - 1, i - 1)] & '\u0001') == 0) {
                    sb.append(c);
                } else {
                    sb.append(' ');
                }
                ++i;
            }
            sb.append('\n');
            ++m;
        }
        return sb.toString();
    }

    public final void pasteText(String content, boolean special) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Pasting, special:" + special);
        }
        this.setCursorActive(false);
        StringBuilder sb = new StringBuilder(content);
        StringBuilder pd = new StringBuilder();
        int nextChar = 0;
        int nChars = sb.length();
        int lr = this.getRow(this.lastPos);
        int lc = this.getCol(this.lastPos);
        this.resetDirty(this.lastPos);
        int cpos = this.lastPos;
        int length = this.getScreenLength();
        char c = '\u0000';
        this.screenFields.saveCurrentField();
        for (int x = nextChar; x < nChars; ++x) {
            c = sb.charAt(x);
            if (c == '\n' || c == '\r') {
                this.log.info("pasted cr-lf>" + pd + "<");
                pd.setLength(0);
                cpos = this.getPos(this.getRow(cpos) + 1, lc);
                if (cpos <= length) continue;
                cpos = 0;
                continue;
            }
            boolean setIt = true;
            if (special && !Character.isLetter(c) && !Character.isDigit(c)) {
                setIt = false;
            }
            if (this.isInField(cpos) && setIt) {
                this.planes.setChar(cpos, c);
                this.setDirty(cpos);
                this.screenFields.setCurrentFieldMDT();
            }
            if (setIt) {
                ++cpos;
            }
            pd.append(c);
        }
        if (pd.length() > 0) {
            this.log.info("pasted >" + pd + "<");
        }
        this.screenFields.restoreCurrentField();
        this.updateDirty();
        this.setCursor(lr + 1, lc + 1);
        this.setCursorActive(true);
    }

    public final String copyTextField(int position) {
        this.screenFields.saveCurrentField();
        this.isInField(position);
        String result = this.screenFields.getCurrentFieldText();
        this.screenFields.restoreCurrentField();
        return result;
    }

    public final Vector<Double> sumThem(boolean formatOption, Rect area) {
        StringBuilder sb = new StringBuilder();
        Rect workR = new Rect();
        workR.setBounds(area);
        this.log.debug("Summing");
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        if (formatOption) {
            dfs.setDecimalSeparator('.');
            dfs.setGroupingSeparator(',');
        } else {
            dfs.setDecimalSeparator(',');
            dfs.setGroupingSeparator('.');
        }
        df.setDecimalFormatSymbols(dfs);
        Vector<Double> sumVector = new Vector<Double>();
        int m = workR.x;
        int i = 0;
        int t = 0;
        double sum = 0.0;
        while (workR.height-- > 0) {
            t = workR.width;
            i = workR.y;
            while (t-- > 0) {
                char c = this.planes.getChar(this.getPos(m - 1, i - 1));
                if (c >= '0' && c <= '9' || c == '.' || c == ',' || c == '-') {
                    sb.append(c);
                }
                ++i;
            }
            if (sb.length() > 0) {
                if (sb.charAt(sb.length() - 1) == '-') {
                    sb.insert(0, '-');
                    sb.deleteCharAt(sb.length() - 1);
                }
                try {
                    Number n = df.parse(sb.toString());
                    sumVector.add(n.doubleValue());
                    sum += n.doubleValue();
                }
                catch (ParseException pe) {
                    this.log.warn(pe.getMessage() + " at " + pe.getErrorOffset());
                }
            }
            sb.setLength(0);
            ++m;
        }
        this.log.debug("" + sum);
        return sumVector;
    }

    public boolean moveCursor(int pos) {
        if (!this.oia.isKeyBoardLocked()) {
            if (pos < 0) {
                return false;
            }
            int g = this.planes.getWhichGUI(pos);
            if (g >= 13 && g <= 31) {
                StringBuffer aid = new StringBuffer();
                boolean aidFlag = true;
                switch (g) {
                    case 14: 
                    case 15: {
                        while (this.planes.getWhichGUI(--pos) != 13) {
                        }
                    }
                    case 13: {
                        if (this.planes.getChar(pos) == 'F') {
                            ++pos;
                        } else {
                            aidFlag = false;
                        }
                        if (this.planes.getChar(pos + 1) != '=' && this.planes.getChar(pos + 1) != '.' && this.planes.getChar(pos + 1) != '/') {
                            aid.append(this.planes.getChar(pos));
                            aid.append(this.planes.getChar(pos + 1));
                            break;
                        }
                        this.log.debug(" Hotspot clicked!!! we will send character " + this.planes.getChar(pos));
                        aid.append(this.planes.getChar(pos));
                    }
                }
                if (aidFlag) {
                    switch (g) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 28: 
                        case 30: {
                            this.sessionVT.sendAidKey(244);
                            break;
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 29: 
                        case 31: {
                            this.sessionVT.sendAidKey(245);
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 27: {
                            StringBuffer eb = new StringBuffer();
                            while (this.planes.getWhichGUI(pos--) != 25) {
                            }
                            while (this.planes.getWhichGUI(pos++) != 26) {
                                eb.append(this.planes.getChar(pos));
                            }
                            OperatingSystem.displayURL(eb.toString());
                            this.log.info("Send to external Browser: " + eb.toString());
                            break;
                        }
                        default: {
                            int aidKey = Integer.parseInt(aid.toString());
                            if (aidKey >= 1 && aidKey <= 12) {
                                this.sessionVT.sendAidKey(48 + aidKey);
                            }
                            if (aidKey >= 13 && aidKey <= 24) {
                                this.sessionVT.sendAidKey(176 + (aidKey - 12));
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.screenFields.getCurrentField() != null) {
                    int xPos = this.screenFields.getCurrentField().startPos();
                    for (int x = 0; x < aid.length(); ++x) {
                        this.planes.setChar(xPos + x, aid.charAt(x));
                    }
                    this.screenFields.setCurrentFieldMDT();
                    this.sessionVT.sendAidKey(241);
                }
                return false;
            }
            this.goto_XY(pos);
            this.isInField(this.lastPos);
            return true;
        }
        return false;
    }

    public void setVT(tnvt v) {
        this.sessionVT = v;
    }

    protected void setPrehelpState(boolean setErrorCode, boolean lockKeyboard, boolean unlockIfLocked) {
        if (this.oia.isKeyBoardLocked() && unlockIfLocked) {
            this.oia.setKeyBoardLocked(false);
        } else {
            this.oia.setKeyBoardLocked(lockKeyboard);
        }
        this.bufferedKeys = null;
        this.oia.setKeysBuffered(false);
    }

    public void setCursorActive(boolean activate) {
        if (this.cursorActive && !activate) {
            this.setCursorOff();
            this.cursorActive = activate;
        } else if (!this.cursorActive && activate) {
            this.cursorActive = activate;
            this.setCursorOn();
        }
    }

    public void setCursorOn() {
        this.cursorShown = true;
        this.updateCursorLoc();
    }

    public void setCursorOff() {
        this.cursorShown = false;
        this.updateCursorLoc();
    }

    private void updateCursorLoc() {
        if (this.cursorActive) {
            this.fireCursorChanged(3);
        }
    }

    public String getKeys() {
        String result = this.keybuf.toString();
        this.keybuf = new StringBuffer();
        return result;
    }

    public synchronized void sendKeys(KeyMnemonic keyMnemonic) {
        this.sendKeys(keyMnemonic.mnemonic);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void sendKeys(String text) {
        this.keybuf.append(text);
        if (this.isStatusErrorCode() && !this.resetRequired) {
            this.setCursorActive(false);
            this.simulateMnemonic(KeyMnemonic.RESET.value);
            this.setCursorActive(true);
        }
        if (this.oia.isKeyBoardLocked()) {
            if (KeyMnemonic.RESET.mnemonic.equals(text) || KeyMnemonic.SYSREQ.mnemonic.equals(text) || KeyMnemonic.ATTN.mnemonic.equals(text)) {
                this.setCursorActive(false);
                this.simulateMnemonic(this.keyMnemonicResolver.findMnemonicValue(text));
                this.setCursorActive(true);
                return;
            }
            if (this.isStatusErrorCode()) {
                this.sessionVT.signalBell();
                return;
            }
            this.oia.setKeysBuffered(true);
            if (this.bufferedKeys == null) {
                this.bufferedKeys = text;
                return;
            }
            this.bufferedKeys = this.bufferedKeys + text;
            return;
        }
        if (this.oia.isKeysBuffered()) {
            if (this.bufferedKeys != null) {
                text = this.bufferedKeys + text;
            }
            this.oia.setKeysBuffered(false);
            this.bufferedKeys = null;
        }
        this.isInField(this.lastPos, true);
        if (text.length() == 1 && !text.equals("[") && !text.equals("]")) {
            this.setCursorActive(false);
            this.simulateKeyStroke(text.charAt(0));
            this.setCursorActive(true);
            return;
        }
        this.strokenizer.setKeyStrokes(text);
        boolean done = false;
        this.setCursorActive(false);
        while (true) {
            if (done) {
                this.setCursorActive(true);
                return;
            }
            if (this.strokenizer.hasMoreKeyStrokes()) {
                this.isInField(this.lastPos, true);
                String s = this.strokenizer.nextKeyStroke();
                if (s.length() == 1) {
                    this.simulateKeyStroke(s.charAt(0));
                } else {
                    this.simulateMnemonic(this.keyMnemonicResolver.findMnemonicValue(s));
                }
                if (!this.oia.isKeyBoardLocked()) continue;
                this.bufferedKeys = this.strokenizer.getUnprocessedKeyStroked();
                if (this.bufferedKeys != null) {
                    this.oia.setKeysBuffered(true);
                }
                done = true;
                continue;
            }
            done = true;
        }
    }

    public void sendAid(int aidKey) {
        this.sessionVT.sendAidKey(aidKey);
    }

    protected void resetError() {
        this.restoreErrorLine();
        this.setStatus((byte)2, (byte)2, "");
    }

    protected boolean simulateMnemonic(int mnem) {
        boolean simulated = false;
        switch (mnem) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 217: 
            case 218: 
            case 241: 
            case 244: 
            case 245: {
                if (!this.screenFields.isCanSendAid()) {
                    this.displayError(32);
                } else {
                    this.sendAid(mnem);
                }
                simulated = true;
                break;
            }
            case 243: {
                this.sessionVT.sendHelpRequest();
                simulated = true;
                break;
            }
            case 246: {
                this.sessionVT.hostPrint(1);
                simulated = true;
                break;
            }
            case 1001: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    if (this.screenFields.getCurrentField().startPos() == this.lastPos) {
                        if (this.backspaceError) {
                            this.displayError(5);
                            break;
                        }
                        this.gotoFieldPrev();
                        this.goto_XY(this.screenFields.getCurrentField().endPos());
                        this.updateDirty();
                        break;
                    }
                    this.screenFields.getCurrentField().getKeyPos(this.lastPos);
                    this.screenFields.getCurrentField().changePos(-1);
                    this.resetDirty(this.screenFields.getCurrentField().getCurrentPos());
                    this.shiftLeft(this.screenFields.getCurrentField().getCurrentPos());
                    this.updateDirty();
                    this.screenFields.setCurrentFieldMDT();
                    simulated = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1002: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.isCurrentFieldHighlightedEntry()) {
                    this.resetDirty(this.screenFields.getCurrentField().startPos);
                    this.gotoFieldPrev();
                    this.updateDirty();
                } else {
                    this.gotoFieldPrev();
                }
                if (this.screenFields.isCurrentFieldContinued()) {
                    do {
                        this.gotoFieldPrev();
                    } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                }
                this.isInField(this.lastPos);
                simulated = true;
                break;
            }
            case 1003: 
            case 1038: {
                this.process_XY(this.lastPos - this.numCols);
                simulated = true;
                break;
            }
            case 1004: 
            case 1039: {
                this.process_XY(this.lastPos + this.numCols);
                simulated = true;
                break;
            }
            case 1005: 
            case 1040: {
                this.process_XY(this.lastPos - 1);
                simulated = true;
                break;
            }
            case 1006: 
            case 1041: {
                this.process_XY(this.lastPos + 1);
                simulated = true;
                break;
            }
            case 1033: {
                this.gotoNextWord();
                simulated = true;
                break;
            }
            case 1034: {
                this.gotoPrevWord();
                simulated = true;
                break;
            }
            case 1007: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    this.resetDirty(this.lastPos);
                    this.screenFields.getCurrentField().getKeyPos(this.lastPos);
                    this.shiftLeft(this.screenFields.getCurrentFieldPos());
                    this.screenFields.setCurrentFieldMDT();
                    this.updateDirty();
                    simulated = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1008: {
                if (this.screenFields.getCurrentField() != null && !this.screenFields.isCurrentFieldContinued()) {
                    if (this.screenFields.isCurrentFieldHighlightedEntry()) {
                        this.resetDirty(this.screenFields.getCurrentField().startPos);
                        this.gotoFieldNext();
                        this.updateDirty();
                    } else {
                        this.gotoFieldNext();
                    }
                } else {
                    do {
                        this.gotoFieldNext();
                    } while (this.screenFields.getCurrentField() != null && (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast()));
                }
                this.isInField(this.lastPos);
                simulated = true;
                break;
            }
            case 1009: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int where = this.endOfField(this.screenFields.getCurrentField().startPos(), true);
                    if (where > 0) {
                        this.setCursor(where / this.numCols + 1, where % this.numCols + 1);
                    }
                    simulated = true;
                } else {
                    this.displayError(5);
                }
                this.resetDirty(this.lastPos);
                break;
            }
            case 1010: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int where = this.lastPos;
                    this.resetDirty(this.lastPos);
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                                if (!this.screenFields.isCurrentFieldContinued()) continue;
                                this.fieldExit();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    this.goto_XY(where);
                    simulated = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1011: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int where = this.lastPos;
                    this.lastPos = this.screenFields.getCurrentField().startPos();
                    this.resetDirty(this.lastPos);
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                                if (!this.screenFields.isCurrentFieldContinued()) continue;
                                this.fieldExit();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    this.goto_XY(where);
                    simulated = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1012: {
                this.oia.setInsertMode(!this.oia.isInsertMode());
                break;
            }
            case 1013: {
                if (this.lastPos + this.numCols + 1 != this.homePos) {
                    this.goto_XY(this.homePos - this.numCols - 1);
                    this.isInField(this.lastPos);
                    break;
                }
                this.gotoField(1);
                break;
            }
            case 1014: {
                simulated = this.simulateKeyStroke('0');
                break;
            }
            case 1015: {
                simulated = this.simulateKeyStroke('1');
                break;
            }
            case 1016: {
                simulated = this.simulateKeyStroke('2');
                break;
            }
            case 1017: {
                simulated = this.simulateKeyStroke('3');
                break;
            }
            case 1018: {
                simulated = this.simulateKeyStroke('4');
                break;
            }
            case 1019: {
                simulated = this.simulateKeyStroke('5');
                break;
            }
            case 1020: {
                simulated = this.simulateKeyStroke('6');
                break;
            }
            case 1021: {
                simulated = this.simulateKeyStroke('7');
                break;
            }
            case 1022: {
                simulated = this.simulateKeyStroke('8');
                break;
            }
            case 1023: {
                simulated = this.simulateKeyStroke('9');
                break;
            }
            case 1024: {
                simulated = this.simulateKeyStroke('.');
                break;
            }
            case 1025: {
                simulated = this.simulateKeyStroke(',');
                break;
            }
            case 1026: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int s = this.screenFields.getCurrentField().getFieldShift();
                    if (s == 3 || s == 5 || s == 7) {
                        this.planes.setChar(this.lastPos, '-');
                        this.resetDirty(this.lastPos);
                        this.advancePos();
                        if (!this.fieldExit()) break;
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                        simulated = true;
                        this.updateDirty();
                        if (!this.screenFields.isCurrentFieldAutoEnter()) break;
                        this.sendAid(241);
                        break;
                    }
                    this.displayError(22);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1027: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    this.resetDirty(this.lastPos);
                    boolean autoFE = this.screenFields.isCurrentFieldAutoEnter();
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued() && !this.screenFields.isCurrentFieldAutoEnter()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                                if (!this.screenFields.isCurrentFieldContinued()) continue;
                                this.fieldExit();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    simulated = true;
                    if (!autoFE) break;
                    this.sendAid(241);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1028: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    this.resetDirty(this.lastPos);
                    boolean autoFE = this.screenFields.isCurrentFieldAutoEnter();
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued() && !this.screenFields.isCurrentFieldAutoEnter()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    simulated = true;
                    if (!autoFE) break;
                    this.sendAid(241);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1029: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int s = this.screenFields.getCurrentField().getFieldShift();
                    if (s == 3 || s == 5 || s == 7) {
                        this.planes.setChar(this.lastPos, '-');
                        this.resetDirty(this.lastPos);
                        this.advancePos();
                        boolean autoFE = this.screenFields.isCurrentFieldAutoEnter();
                        if (this.fieldExit()) {
                            this.screenFields.setCurrentFieldMDT();
                            if (!this.screenFields.isCurrentFieldContinued() && !this.screenFields.isCurrentFieldAutoEnter()) {
                                this.gotoFieldNext();
                            } else {
                                do {
                                    this.gotoFieldNext();
                                } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                            }
                        }
                        this.updateDirty();
                        simulated = true;
                        if (!autoFE) break;
                        this.sendAid(241);
                        break;
                    }
                    this.displayError(22);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1030: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int where = this.screenFields.getCurrentField().startPos();
                    if (where > 0) {
                        this.goto_XY(where);
                    }
                    simulated = true;
                } else {
                    this.displayError(5);
                }
                this.resetDirty(this.lastPos);
                break;
            }
            case 1031: {
                this.sessionVT.systemRequest();
                simulated = true;
                break;
            }
            case 1032: {
                if (this.isStatusErrorCode()) {
                    this.resetError();
                    this.isInField(this.lastPos);
                    this.updateDirty();
                } else {
                    this.setPrehelpState(false, this.oia.isKeyBoardLocked(), false);
                }
                simulated = true;
                break;
            }
            case 1037: {
                this.sessionVT.sendAttentionKey();
                simulated = true;
                break;
            }
            case 1042: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    if (this.screenFields.isCurrentFieldDupEnabled()) {
                        this.resetDirty(this.lastPos);
                        this.screenFields.getCurrentField().setFieldChar(this.lastPos, '\u001c');
                        this.screenFields.setCurrentFieldMDT();
                        this.gotoFieldNext();
                        this.updateDirty();
                        simulated = true;
                        break;
                    }
                    this.displayError(25);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1043: {
                if (this.screenFields.getSize() > 0) {
                    int startRow = this.getRow(this.lastPos) + 1;
                    int startPos = this.lastPos;
                    if (startRow == this.getRows()) {
                        startRow = 0;
                    }
                    this.setCursor(++startRow, 1);
                    if (!this.isInField() && this.screenFields.getCurrentField() != null && !this.screenFields.isCurrentFieldBypassField()) {
                        while (!this.isInField() && this.screenFields.getCurrentField() != null && !this.screenFields.isCurrentFieldBypassField()) {
                            this.advancePos();
                            if (this.lastPos != startPos) continue;
                            this.goto_XY(startPos);
                            break;
                        }
                    }
                }
                simulated = true;
                break;
            }
            case 5018: {
                int rowNow = this.getCurrentRow() - 1 + 3;
                if (rowNow > this.getRows() - 1) {
                    rowNow -= this.getRows();
                }
                this.goto_XY(this.getPos(rowNow, this.getCurrentCol() - 1));
                simulated = true;
                break;
            }
            case 5019: {
                int rowNow = this.getCurrentRow() - 1 - 3;
                if (rowNow < 0) {
                    rowNow = this.getRows() + rowNow;
                }
                this.goto_XY(this.getPos(rowNow, this.getCurrentCol() - 1));
                simulated = true;
                break;
            }
            case 5021: {
                int colNow = this.getCurrentCol() - 1 - 3;
                int rowNow = this.getCurrentRow() - 1;
                if (colNow <= 0) {
                    colNow = this.getColumns() + colNow;
                    --rowNow;
                }
                if (rowNow < 0) {
                    rowNow = this.getRows() - 1;
                }
                this.process_XY(this.getPos(rowNow, colNow));
                simulated = true;
                break;
            }
            case 5020: {
                int colNow = this.getCurrentCol() - 1 + 3;
                int rowNow = this.getCurrentRow() - 1;
                if (colNow >= this.getColumns()) {
                    colNow -= this.getColumns();
                    ++rowNow;
                }
                if (rowNow > this.getRows() - 1) {
                    rowNow = this.getRows() - rowNow;
                }
                this.process_XY(this.getPos(rowNow, colNow));
                simulated = true;
                break;
            }
            default: {
                this.log.info(" Mnemonic not supported " + mnem);
            }
        }
        return simulated;
    }

    protected boolean simulateKeyStroke(char c) {
        if (this.isStatusErrorCode() && !Character.isISOControl(c) && !this.keyProcessed) {
            if (this.resetRequired) {
                return false;
            }
            this.resetError();
        }
        boolean updateField = false;
        boolean numericError = false;
        boolean updatePos = false;
        boolean autoEnter = false;
        if (!Character.isISOControl(c)) {
            if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                if (this.screenFields.isCurrentFieldFER() && !this.screenFields.withinCurrentField(this.screenFields.getCurrentFieldPos()) && this.lastPos == this.screenFields.getCurrentField().endPos() && this.screenFields.getCurrentFieldPos() > this.screenFields.getCurrentField().endPos()) {
                    this.displayError(24);
                    this.feError = true;
                    return false;
                }
                switch (this.screenFields.getCurrentFieldShift()) {
                    case 0: 
                    case 2: 
                    case 4: {
                        updateField = true;
                        break;
                    }
                    case 1: {
                        if (!Character.isLetter(c) && c != ',' && c != '-' && c != '.' && c != ' ') break;
                        updateField = true;
                        break;
                    }
                    case 3: {
                        if (Character.isDigit(c) || c == '+' || c == ',' || c == '-' || c == '.' || c == ' ') {
                            updateField = true;
                            break;
                        }
                        numericError = true;
                        break;
                    }
                    case 5: {
                        if (Character.isDigit(c)) {
                            updateField = true;
                            break;
                        }
                        this.displayError(16);
                        break;
                    }
                    case 7: {
                        if (Character.isDigit(c) || c == '+' || c == '-') {
                            if (this.lastPos == this.screenFields.getCurrentField().endPos() && c != '+' && c != '-') {
                                this.displayError(17);
                                break;
                            }
                            updateField = true;
                            break;
                        }
                        this.displayError(16);
                    }
                }
                if (updateField) {
                    if (this.screenFields.isCurrentFieldToUpper()) {
                        c = Character.toUpperCase(c);
                    }
                    updatePos = true;
                    this.resetDirty(this.lastPos);
                    if (this.oia.isInsertMode()) {
                        if (this.endOfField(false) != this.screenFields.getCurrentField().endPos()) {
                            this.shiftRight(this.lastPos);
                        } else {
                            this.displayError(18);
                            updatePos = false;
                        }
                    }
                    if (updatePos) {
                        this.screenFields.getCurrentField().getKeyPos(this.getRow(this.lastPos), this.getCol(this.lastPos));
                        this.screenFields.getCurrentField().changePos(1);
                        this.planes.setChar(this.lastPos, c);
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.withinCurrentField(this.screenFields.getCurrentFieldPos())) {
                            if (this.screenFields.isCurrentFieldAutoEnter()) {
                                autoEnter = true;
                            } else if (!this.screenFields.isCurrentFieldFER()) {
                                this.gotoFieldNext();
                            }
                        } else {
                            this.setCursor(this.screenFields.getCurrentField().getCursorRow() + 1, this.screenFields.getCurrentField().getCursorCol() + 1);
                        }
                    }
                    this.fireScreenChanged(1);
                    if (autoEnter) {
                        this.sendAid(241);
                    }
                } else if (numericError) {
                    this.displayError(9);
                }
            } else {
                this.displayError(5);
            }
        }
        return updatePos;
    }

    private int endOfField(boolean posSpace) {
        return this.endOfField(this.lastPos, posSpace);
    }

    private int endOfField(int pos, boolean posSpace) {
        int endPos;
        int fePos = endPos = this.screenFields.getCurrentField().endPos();
        int count = endPos - pos;
        while (this.planes.getChar(endPos) <= ' ' && count-- > 0) {
            --endPos;
        }
        if (endPos == fePos) {
            return endPos;
        }
        this.screenFields.getCurrentField().getKeyPos(endPos);
        if (posSpace) {
            this.screenFields.getCurrentField().changePos(1);
        }
        return this.screenFields.getCurrentFieldPos();
    }

    private boolean fieldExit() {
        int adj;
        int s;
        int pos = this.lastPos;
        boolean mdt = false;
        int end = this.endOfField(false);
        ScreenField sf = this.screenFields.getCurrentField();
        if (sf.isMandatoryEnter() && end == sf.startPos()) {
            this.displayError(33);
            return false;
        }
        int currentPos = sf.getCurrentPos();
        int count = end - sf.startPos() - sf.getKeyPos(pos);
        if (count == 0 && sf.isFER() && currentPos > sf.endPos()) {
            mdt = true;
            return mdt;
        }
        while (count >= 0) {
            this.planes.setChar(pos, '\u0000');
            this.setDirty(pos);
            ++pos;
            mdt = true;
            --count;
        }
        if (count == -1 && ((s = sf.getFieldShift()) == 3 || s == 5 || s == 7)) {
            mdt = true;
        }
        if ((adj = sf.getAdjustment()) != 0) {
            switch (adj) {
                case 5: {
                    this.rightAdjustField('0');
                    sf.setRightAdjusted();
                    break;
                }
                case 6: {
                    this.rightAdjustField(' ');
                    sf.setRightAdjusted();
                    break;
                }
                case 7: {
                    sf.setManditoryEntered();
                }
            }
        } else if (sf.isSignedNumeric()) {
            this.rightAdjustField(' ');
        }
        return mdt;
    }

    private void rightAdjustField(char fill) {
        int end = this.endOfField(false);
        int count = this.screenFields.getCurrentField().endPos() - end;
        if (!this.screenFields.getCurrentField().isSignedNumeric() || this.planes.getChar(end - 1) != '-') {
            // empty if block
        }
        int pos = this.screenFields.getCurrentField().startPos();
        while (true) {
            int n = --count;
            --count;
            if (n < 0) break;
            this.shiftRight(pos);
            this.planes.setChar(pos, fill);
            this.setDirty(pos);
        }
    }

    private void shiftLeft(int sPos) {
        int count;
        int end;
        int endPos = 0;
        int pos = sPos;
        int pPos = sPos;
        ScreenField sf = this.screenFields.getCurrentField();
        do {
            end = this.endOfField(pPos, false);
            count = end - this.screenFields.getCurrentField().startPos() - this.screenFields.getCurrentField().getKeyPos(pPos);
            while (count-- > 0) {
                this.planes.setChar(pPos, this.planes.getChar(++pos));
                this.setDirty(pPos);
                pPos = pos;
            }
            if (!this.screenFields.isCurrentFieldContinued()) continue;
            this.gotoFieldNext();
            if (this.screenFields.getCurrentField().isContinuedFirst()) break;
            pos = this.screenFields.getCurrentField().startPos();
            this.planes.setChar(pPos, this.planes.getChar(pos));
            this.setDirty(pPos);
            pPos = pos;
        } while (this.screenFields.isCurrentFieldContinued() && !this.screenFields.getCurrentField().isContinuedFirst());
        endPos = end >= 0 && count >= -1 ? end : sPos;
        this.screenFields.setCurrentField(sf);
        this.planes.setChar(endPos, '\u0000');
        this.setDirty(endPos);
        this.goto_XY(this.screenFields.getCurrentFieldPos());
        sf = null;
    }

    private void shiftRight(int sPos) {
        int end;
        int pos = end = this.endOfField(true);
        int pPos = end;
        int count = end - sPos;
        while (count-- > 0) {
            this.planes.setChar(pPos, this.planes.getChar(--pos));
            this.setDirty(pPos);
            pPos = pos;
        }
    }

    public int getRow(int pos) {
        int row = pos / this.numCols;
        if (row < 0) {
            row = this.lastPos / this.numCols;
        }
        if (row > this.lenScreen / this.numCols - 1) {
            row = this.lenScreen / this.numCols - 1;
        }
        return row;
    }

    public int getCol(int pos) {
        int col = pos % this.getColumns();
        if (col > 0) {
            return col;
        }
        return 0;
    }

    public int getPos(int row, int col) {
        return row * this.numCols + col;
    }

    public int getCurrentPos() {
        return this.lastPos + 1;
    }

    private void displayError(int ec) {
        this.saveHomePos = this.homePos;
        this.homePos = this.lastPos + this.numCols + 1;
        this.pendingInsert = true;
        this.sessionVT.sendNegResponse2(ec);
    }

    private void process_XY(int pos) {
        if (pos < 0) {
            pos = this.lenScreen + pos;
        }
        if (pos > this.lenScreen - 1) {
            pos -= this.lenScreen;
        }
        ScreenField sf = this.screenFields.getCurrentField();
        if (this.feError) {
            this.feError = false;
            sf.changePos(-1);
        } else {
            if (sf != null && sf.isFER() && sf.getCurrentPos() > sf.endPos()) {
                if (sf.withinField(pos)) {
                    sf.getKeyPos(pos);
                    return;
                }
                sf.getKeyPos(sf.endPos());
            }
            this.goto_XY(pos);
        }
    }

    public boolean isUsingGuiInterface() {
        return this.guiInterface;
    }

    protected boolean isInField() {
        return this.isInField(this.lastPos, true);
    }

    public boolean isInField(int pos, boolean chgToField) {
        return this.screenFields.isInField(pos, chgToField);
    }

    public boolean isInField(int pos) {
        return this.screenFields.isInField(pos, true);
    }

    public boolean isInField(int row, int col) {
        return this.isInField(row, col, true);
    }

    public boolean isInField(int row, int col, boolean chgToField) {
        return this.screenFields.isInField(row * this.numCols + col, chgToField);
    }

    public int getScreenLength() {
        return this.lenScreen;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getCurrentRow() {
        return this.lastPos / this.numCols + 1;
    }

    public int getCurrentCol() {
        return this.lastPos % this.numCols + 1;
    }

    protected int getLastPos() {
        return this.lastPos;
    }

    public StringBuffer getHSMore() {
        return this.hsMore;
    }

    public StringBuffer getHSBottom() {
        return this.hsBottom;
    }

    public char[] getScreenAsAllChars() {
        char[] sac = new char[this.lenScreen];
        for (int x = 0; x < this.lenScreen; ++x) {
            int c = this.planes.getChar(x);
            sac[x] = c >= 32 && !this.planes.isAttributePlace(x) ? c : 32;
        }
        return sac;
    }

    public char[] getScreenAsChars() {
        char[] sac = new char[this.lenScreen];
        for (int x = 0; x < this.lenScreen; ++x) {
            int c = this.planes.getChar(x);
            sac[x] = c >= 32 && !this.planes.isAttributePlace(x) ? c : 32;
        }
        return sac;
    }

    public char[] getData(int startRow, int startCol, int endRow, int endCol, int plane) {
        try {
            int from = this.getPos(startRow, startCol);
            int to = this.getPos(endRow, endCol);
            if (from > to) {
                int f;
                to = f = from;
                from = f;
            }
            return this.planes.getPlaneData(from, to, plane);
        }
        catch (Exception oe) {
            return null;
        }
    }

    public synchronized int GetScreen(char[] buffer, int bufferLength, int plane) {
        return this.GetScreen(buffer, bufferLength, 0, this.lenScreen, plane);
    }

    public synchronized int GetScreen(char[] buffer, int bufferLength, int from, int length, int plane) {
        return this.planes.GetScreen(buffer, bufferLength, from, length, plane);
    }

    public synchronized int GetScreen(char[] buffer, int bufferLength, int row, int col, int length, int plane) {
        return this.planes.GetScreen(buffer, bufferLength, row, col, length, plane);
    }

    public synchronized int GetScreenRect(char[] buffer, int bufferLength, int startPos, int endPos, int plane) {
        return this.planes.GetScreenRect(buffer, bufferLength, startPos, endPos, plane);
    }

    public synchronized int GetScreenRect(char[] buffer, int bufferLength, int startRow, int startCol, int endRow, int endCol, int plane) {
        return this.planes.GetScreenRect(buffer, bufferLength, startRow, startCol, endRow, endCol, plane);
    }

    public synchronized boolean[] getActiveAidKeys() {
        return this.sessionVT.getActiveAidKeys();
    }

    protected synchronized void setScreenData(String text, int location) {
        int x;
        if (location < 0 || location > this.lenScreen) {
            return;
        }
        int l = text.length();
        boolean updated = false;
        boolean flag = false;
        for (x = 0; x < l; ++x) {
            if (!this.isInField(location + x, true) || this.screenFields.getCurrentField().isBypassField()) continue;
            if (!flag) {
                this.screenFields.getCurrentField().setMDT();
                updated = true;
                this.resetDirty(location + x);
                this.screenFields.setMasterMDT();
                flag = true;
            }
            this.planes.screen[location + x] = text.charAt(x);
            this.setDirty(location + x);
        }
        this.lastPos = location + x;
        if (updated) {
            this.fireScreenChanged(1);
        }
    }

    public void setCursor(int row, int col) {
        this.goto_XY((row - 1) * this.numCols + (col - 1));
    }

    protected void goto_XY(int pos) {
        this.updateCursorLoc();
        this.lastPos = pos;
        this.updateCursorLoc();
    }

    public boolean gotoField(int f) {
        int sizeFields = this.screenFields.getSize();
        if (f > sizeFields || f <= 0) {
            return false;
        }
        this.screenFields.setCurrentField(this.screenFields.getField(f - 1));
        while (this.screenFields.isCurrentFieldBypassField() && f < sizeFields) {
            this.screenFields.setCurrentField(this.screenFields.getField(f++));
        }
        return this.gotoField(this.screenFields.getCurrentField());
    }

    protected boolean gotoField(ScreenField screenField) {
        if (screenField != null) {
            this.goto_XY(screenField.startPos());
            return true;
        }
        return false;
    }

    private void gotoNextWord() {
        int pos = this.lastPos;
        if (this.planes.getChar(this.lastPos) > ' ') {
            this.advancePos();
            while (this.planes.getChar(this.lastPos) > ' ' && pos != this.lastPos) {
                this.advancePos();
            }
        } else {
            this.advancePos();
        }
        while (this.planes.getChar(this.lastPos) <= ' ' && pos != this.lastPos) {
            this.advancePos();
        }
    }

    private void gotoPrevWord() {
        int pos = this.lastPos;
        this.changePos(-1);
        while (this.planes.getChar(this.lastPos) <= ' ') {
            this.changePos(-1);
            if (pos != this.lastPos) continue;
        }
        this.changePos(-1);
        while (this.planes.getChar(this.lastPos) > ' ' && pos != this.lastPos) {
            this.changePos(-1);
        }
        this.advancePos();
    }

    private void gotoFieldNext() {
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.unsetFieldHighlighted(this.screenFields.getCurrentField());
        }
        this.screenFields.gotoFieldNext();
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.setFieldHighlighted(this.screenFields.getCurrentField());
        }
    }

    private void gotoFieldPrev() {
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.unsetFieldHighlighted(this.screenFields.getCurrentField());
        }
        this.screenFields.gotoFieldPrev();
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.setFieldHighlighted(this.screenFields.getCurrentField());
        }
    }

    protected void createWindow(int depth, int width, int type, boolean gui, int monoAttr, int colorAttr, int ul, int upper, int ur, int left, int right, int ll, int bottom, int lr) {
        int c = this.getCol(this.lastPos);
        int w = 0;
        w = ++width;
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, (char)ul, colorAttr, false);
        if (gui) {
            this.planes.setUseGUI(this.lastPos, 1);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        while (w-- >= 0) {
            this.planes.setScreenCharAndAttr(this.lastPos, (char)upper, colorAttr, false);
            if (gui) {
                this.planes.setUseGUI(this.lastPos, 2);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
        }
        this.planes.setScreenCharAndAttr(this.lastPos, (char)ur, colorAttr, false);
        if (gui) {
            this.planes.setUseGUI(this.lastPos, 3);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
        this.lastPos = (this.getRow(this.lastPos) + 1) * this.numCols + c;
        while (depth-- > 0) {
            this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
            this.setDirty(this.lastPos);
            this.advancePos();
            this.planes.setScreenCharAndAttr(this.lastPos, (char)left, colorAttr, false);
            if (gui) {
                this.planes.setUseGUI(this.lastPos, 4);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
            w = width;
            while (w-- >= 0) {
                this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
                this.planes.setUseGUI(this.lastPos, 0);
                this.setDirty(this.lastPos);
                this.advancePos();
            }
            this.planes.setScreenCharAndAttr(this.lastPos, (char)right, colorAttr, false);
            if (gui) {
                this.planes.setUseGUI(this.lastPos, 5);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
            this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
            this.setDirty(this.lastPos);
            this.lastPos = (this.getRow(this.lastPos) + 1) * this.numCols + c;
        }
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, (char)ll, colorAttr, false);
        if (gui) {
            this.planes.setUseGUI(this.lastPos, 6);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        w = width;
        while (w-- >= 0) {
            this.planes.setScreenCharAndAttr(this.lastPos, (char)bottom, colorAttr, false);
            if (gui) {
                this.planes.setUseGUI(this.lastPos, 7);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
        }
        this.planes.setScreenCharAndAttr(this.lastPos, (char)lr, colorAttr, false);
        if (gui) {
            this.planes.setUseGUI(this.lastPos, 8);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
    }

    protected void createScrollBar(int flag, int totalRowScrollable, int totalColScrollable, int sliderRowPos, int sliderColPos, int sbSize) {
        int sp = this.lastPos;
        int size = sbSize - 2;
        int thumbPos = (int)((float)size * ((float)sliderColPos / (float)totalColScrollable));
        this.planes.setScreenCharAndAttr(sp, ' ', 32, false);
        this.planes.setUseGUI(sp, 28);
        for (int ctr = 0; ctr < size; ++ctr) {
            this.planes.setScreenCharAndAttr(sp += this.numCols, ' ', 32, false);
            if (ctr == thumbPos) {
                this.planes.setUseGUI(sp, 31);
                continue;
            }
            this.planes.setUseGUI(sp, 30);
        }
        this.planes.setScreenCharAndAttr(sp += this.numCols, ' ', 32, false);
        this.planes.setUseGUI(sp, 29);
    }

    protected void writeWindowTitle(int pos, int depth, int width, byte orientation, int monoAttr, int colorAttr, StringBuffer title) {
        int len = title.length();
        switch (orientation & 0xC0) {
            case 64: {
                pos += 4 + width - len;
                break;
            }
            case 128: {
                pos += 2;
                break;
            }
            default: {
                pos += 3 + (width / 2 - len / 2);
            }
        }
        if ((orientation & 0x20) == 32) {
            pos += (depth + 1) * this.numCols;
        }
        for (int x = 0; x < len; ++x) {
            this.planes.setChar(pos, title.charAt(x));
            this.planes.setUseGUI(pos++, 0);
        }
    }

    protected void rollScreen(int direction, int topLine, int bottomLine) {
        int updown = direction & 0x80;
        int lines = direction & 0x7F;
        int start = this.getPos(topLine - 1, 0);
        int end = this.getPos(bottomLine - 1, this.numCols - 1);
        int len = end - start;
        switch (updown) {
            case 0: {
                for (int x = start; x < end + this.numCols; ++x) {
                    if (x + lines * this.numCols >= this.lenScreen) {
                        this.planes.setChar(x, ' ');
                        continue;
                    }
                    this.planes.setChar(x, this.planes.getChar(x + lines * this.numCols));
                }
                break;
            }
            case 1: {
                for (int x = end + this.numCols; x > 0; --x) {
                    if (x - lines * this.numCols < 0) continue;
                    this.planes.setChar(x - lines * this.numCols, this.planes.getChar(x));
                    this.planes.setChar(x, ' ');
                }
                break;
            }
            default: {
                this.log.warn(" Invalid roll parameter - please report this");
            }
        }
    }

    public void dumpScreen() {
        StringBuffer sb = new StringBuffer();
        char[] s = this.getScreenAsChars();
        int c = this.getColumns();
        int l = this.getRows() * c;
        int col = 0;
        int x = 0;
        while (x < l) {
            sb.append(s[x]);
            if (col == c) {
                sb.append('\n');
                col = 0;
            }
            ++x;
            ++col;
        }
        this.log.info(sb.toString());
    }

    public String getDumpScreen() {
        StringBuffer sb = new StringBuffer();
        char[] s = this.getScreenAsChars();
        int c = this.getColumns();
        int l = this.getRows() * c;
        int col = 0;
        int x = 0;
        while (x < l) {
            sb.append(s[x]);
            if (col == c) {
                sb.append('\n');
                col = 0;
            }
            ++x;
            ++col;
        }
        return sb.toString();
    }

    protected void addField(int attr, int len, int ffw1, int ffw2, int fcw1, int fcw2) {
        this.lastAttr = attr;
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', this.lastAttr, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        ScreenField sf = null;
        if (this.screenFields.existsAtPos(this.lastPos)) {
            this.screenFields.setCurrentFieldFFWs(ffw1, ffw2);
        } else {
            sf = this.screenFields.setField(attr, this.getRow(this.lastPos), this.getCol(this.lastPos), len, ffw1, ffw2, fcw1, fcw2);
            this.lastPos = sf.startPos();
            int x = len;
            boolean gui = this.guiInterface;
            if (sf.isBypassField()) {
                gui = false;
            }
            while (x-- > 0) {
                if (this.planes.getChar(this.lastPos) == '\u0000') {
                    this.planes.setScreenCharAndAttr(this.lastPos, ' ', this.lastAttr, false);
                } else {
                    this.planes.setScreenAttr(this.lastPos, this.lastAttr);
                }
                if (gui) {
                    this.planes.setUseGUI(this.lastPos, 11);
                }
                this.planes.setScreenFieldAttr(this.lastPos, ffw1);
                this.advancePos();
            }
            if (gui) {
                if (len > 1) {
                    this.planes.setUseGUI(sf.startPos(), 9);
                    if (this.lastPos > 0) {
                        this.planes.setUseGUI(this.lastPos - 1, 10);
                    } else {
                        this.planes.setUseGUI(this.lastPos, 10);
                    }
                } else {
                    this.planes.setUseGUI(this.lastPos - 1, 12);
                }
            }
            this.setEndingAttr(32);
            this.lastPos = sf.startPos();
        }
    }

    public ScreenFields getScreenFields() {
        return this.screenFields;
    }

    protected void drawFields() {
        int sizeFields = this.screenFields.getSize();
        for (int x = 0; x < sizeFields; ++x) {
            ScreenField sf = this.screenFields.getField(x);
            if (sf.isBypassField()) continue;
            int pos = sf.startPos();
            int l = sf.length;
            boolean f = true;
            if (l >= this.lenScreen) {
                l = this.lenScreen - 1;
            }
            if (l > 1) {
                while (l-- > 0) {
                    if (this.guiInterface && f) {
                        this.planes.setUseGUI(pos, 9);
                        f = false;
                    } else {
                        this.planes.setUseGUI(pos, 11);
                    }
                    if (this.guiInterface && l == 0) {
                        this.planes.setUseGUI(pos, 10);
                    }
                    this.setDirty(pos++);
                }
                continue;
            }
            this.planes.setUseGUI(pos, 12);
        }
    }

    protected void drawField(ScreenField screenField) {
        int pos = screenField.startPos();
        int x = screenField.length;
        while (x-- > 0) {
            this.setDirty(pos++);
        }
        this.updateDirty();
    }

    protected void setFieldHighlighted(ScreenField sf) {
        int pos = sf.startPos();
        int x = sf.length;
        int na = sf.getHighlightedAttr();
        while (x-- > 0) {
            this.planes.setScreenAttr(pos, na);
            this.setDirty(pos++);
        }
        this.fireScreenChanged(1);
    }

    protected void unsetFieldHighlighted(ScreenField sf) {
        int pos = sf.startPos();
        int x = sf.length;
        int na = sf.getAttr();
        while (x-- > 0) {
            this.planes.setScreenAttr(pos, na);
            this.setDirty(pos++);
        }
        this.fireScreenChanged(1);
    }

    public boolean checkHotSpots() {
        return this.planes.checkHotSpots();
    }

    protected void setChar(int cByte) {
        if (this.lastPos > 0) {
            this.lastAttr = this.planes.getCharAttr(this.lastPos - 1);
        }
        if (cByte > 0 && (char)cByte < ' ') {
            this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 33, false);
            this.setDirty(this.lastPos);
            this.advancePos();
        } else {
            this.planes.setScreenCharAndAttr(this.lastPos, (char)cByte, this.lastAttr, false);
            this.setDirty(this.lastPos);
            if (this.guiInterface && !this.isInField(this.lastPos, false)) {
                this.planes.setUseGUI(this.lastPos, 0);
            }
            this.advancePos();
        }
    }

    protected void setEndingAttr(int cByte) {
        int attr = this.lastAttr;
        this.setAttr(cByte);
        this.lastAttr = attr;
    }

    protected void setAttr(int cByte) {
        this.lastAttr = cByte;
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', this.lastAttr, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        int pos = this.lastPos;
        while (this.planes.getCharAttr(this.lastPos) != this.lastAttr && !this.planes.isAttributePlace(this.lastPos)) {
            int g;
            this.planes.setScreenAttr(this.lastPos, this.lastAttr);
            if (this.guiInterface && !this.isInField(this.lastPos, false) && (g = this.planes.getWhichGUI(this.lastPos)) >= 9 && g <= 12) {
                this.planes.setUseGUI(this.lastPos, 0);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
        }
        this.lastPos = pos;
    }

    protected void setScreenCharAndAttr(char right, int colorAttr, boolean isAttr) {
        this.planes.setScreenCharAndAttr(this.lastPos, right, colorAttr, isAttr);
        this.setDirty(this.lastPos);
        this.advancePos();
    }

    protected void setScreenCharAndAttr(char right, int colorAttr, int whichGui, boolean isAttr) {
        this.planes.setScreenCharAndAttr(this.lastPos, right, colorAttr, isAttr);
        this.planes.setUseGUI(this.lastPos, whichGui);
        this.setDirty(this.lastPos);
        this.advancePos();
    }

    protected void updateDirty() {
        this.fireScreenChanged(1);
    }

    protected void setDirty(int pos) {
        int minr = Math.min(this.getRow(pos), this.getRow(this.dirtyScreen.x));
        int minc = Math.min(this.getCol(pos), this.getCol(this.dirtyScreen.x));
        int maxr = Math.max(this.getRow(pos), this.getRow(this.dirtyScreen.y));
        int maxc = Math.max(this.getCol(pos), this.getCol(this.dirtyScreen.y));
        int x1 = this.getPos(minr, minc);
        int x2 = this.getPos(maxr, maxc);
        this.dirtyScreen.setBounds(x1, x2, 0, 0);
    }

    private void resetDirty(int pos) {
        this.dirtyScreen.setBounds(pos, pos, 0, 0);
    }

    protected void advancePos() {
        this.changePos(1);
    }

    protected void changePos(int i) {
        this.lastPos += i;
        if (this.lastPos < 0) {
            this.lastPos = this.lenScreen + this.lastPos;
        }
        if (this.lastPos > this.lenScreen - 1) {
            this.lastPos -= this.lenScreen;
        }
    }

    protected void goHome() {
        if (this.pendingInsert && this.homePos > 0) {
            this.setCursor(this.getRow(this.homePos), this.getCol(this.homePos));
            this.isInField();
        } else if (!this.gotoField(1)) {
            this.homePos = this.getPos(1, 1);
            this.setCursor(1, 1);
            this.isInField(0, 0);
        } else {
            this.homePos = this.getPos(this.getCurrentRow(), this.getCurrentCol());
        }
    }

    protected void setPendingInsert(boolean flag, int icX, int icY) {
        this.pendingInsert = flag;
        if (this.pendingInsert) {
            this.homePos = this.getPos(icX, icY);
        }
        if (!this.isStatusErrorCode()) {
            this.setCursor(icX, icY);
        }
    }

    protected void setPendingInsert(boolean flag) {
        if (this.homePos != -1) {
            this.pendingInsert = flag;
        }
    }

    protected void setErrorLine(int line) {
        this.planes.setErrorLine(line);
    }

    protected int getErrorLine() {
        return this.planes.getErrorLine();
    }

    protected void saveErrorLine() {
        this.planes.saveErrorLine();
    }

    protected void restoreErrorLine() {
        if (this.planes.isErrorLineSaved()) {
            this.planes.restoreErrorLine();
            this.fireScreenChanged(1, this.planes.getErrorLine() - 1, 0, this.planes.getErrorLine() - 1, this.numCols - 1);
        }
    }

    protected void setStatus(byte attr, byte value, String s) {
        switch (attr) {
            case 1: {
                if (value == 1) {
                    this.oia.setInputInhibited(1, 1, s);
                    break;
                }
                this.oia.setInputInhibited(0, 2, s);
                break;
            }
            case 2: {
                if (value == 1) {
                    this.setPrehelpState(true, true, false);
                    this.oia.setInputInhibited(1, 10, s);
                    this.sessionVT.signalBell();
                    break;
                }
                this.oia.setInputInhibited(0, 2);
                this.setPrehelpState(false, true, true);
                this.homePos = this.saveHomePos;
                this.saveHomePos = 0;
                this.pendingInsert = false;
            }
        }
    }

    protected boolean isStatusErrorCode() {
        return this.oia.getLevel() == 10;
    }

    protected void clearAll() {
        this.lastAttr = 32;
        this.lastPos = 0;
        this.clearTable();
        this.clearScreen();
        this.planes.setScreenAttr(0, 32);
        this.oia.setInsertMode(false);
    }

    protected void clearTable() {
        this.oia.setKeyBoardLocked(true);
        this.screenFields.clearFFT();
        this.planes.initalizeFieldPlanes();
        this.pendingInsert = false;
        this.homePos = -1;
    }

    protected void clearGuiStuff() {
        for (int x = 0; x < this.lenScreen; ++x) {
            this.planes.setUseGUI(x, 0);
        }
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
    }

    protected void clearScreen() {
        this.planes.initalizePlanes();
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
        this.oia.clearScreen();
    }

    protected void restoreScreen() {
        this.lastAttr = 32;
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
        this.updateDirty();
    }

    private void fireScreenChanged(int which, int startRow, int startCol, int endRow, int endCol) {
        if (this.screenListeners != null) {
            Vector<ScreenListener> lc = new Vector<ScreenListener>(this.screenListeners);
            int size = lc.size();
            for (int i = 0; i < size; ++i) {
                ScreenListener target = lc.elementAt(i);
                target.onScreenChanged(1, startRow, startCol, endRow, endCol);
            }
        }
        this.dirtyScreen.setBounds(this.lenScreen, 0, 0, 0);
    }

    private synchronized void fireScreenChanged(int update) {
        if (this.dirtyScreen.x > this.dirtyScreen.y) {
            return;
        }
        this.fireScreenChanged(update, this.getRow(this.dirtyScreen.x), this.getCol(this.dirtyScreen.x), this.getRow(this.dirtyScreen.y), this.getCol(this.dirtyScreen.y));
    }

    private synchronized void fireCursorChanged(int update) {
        int startRow = this.getRow(this.lastPos);
        int startCol = this.getCol(this.lastPos);
        if (this.screenListeners != null) {
            Vector<ScreenListener> lc = new Vector<ScreenListener>(this.screenListeners);
            int len = lc.size();
            for (int i = 0; i < len; ++i) {
                ScreenListener target = lc.elementAt(i);
                target.onScreenChanged(update, startRow, startCol, startRow, startCol);
            }
        }
    }

    private void fireScreenSizeChanged() {
        if (this.screenListeners != null) {
            Vector<ScreenListener> lc = new Vector<ScreenListener>(this.screenListeners);
            int size = lc.size();
            for (int i = 0; i < size; ++i) {
                ScreenListener target = lc.elementAt(i);
                target.onScreenSizeChanged(this.numRows, this.numCols);
            }
        }
    }

    public final void updateScreen() {
        this.repaintScreen();
        this.setCursorActive(false);
        this.setCursorActive(true);
    }

    public void addScreenListener(ScreenListener listener) {
        if (this.screenListeners == null) {
            this.screenListeners = new Vector(3);
        }
        this.screenListeners.addElement(listener);
    }

    public void removeScreenListener(ScreenListener listener) {
        if (this.screenListeners == null) {
            return;
        }
        this.screenListeners.removeElement(listener);
    }

    public void repaintScreen() {
        this.setCursorOff();
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
        this.updateDirty();
        if (this.oia.getLevel() == 10) {
            this.oia.setInputInhibited(1, 10);
        }
        if (this.oia.getLevel() == 1) {
            this.oia.setInputInhibited(1, 1);
        }
        if (this.oia.isMessageWait()) {
            this.oia.setMessageLightOn();
        }
        this.setCursorOn();
    }

    public char[] getCharacters() {
        return this.planes.screen;
    }
}

