/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import org.tn5250j.framework.tn5250.Screen5250;

public class ScreenField {
    int startPos = 0;
    int endPos = 0;
    boolean mdt = false;
    protected boolean checkCanSend;
    protected boolean rightAdjd;
    protected boolean manditoried;
    boolean canSend = true;
    int attr = 0;
    int length = 0;
    int ffw1 = 0;
    int ffw2 = 0;
    int fcw1 = 0;
    int fcw2 = 0;
    int cursorPos = 0;
    Screen5250 s;
    int cursorProg = 0;
    int fieldId = 0;
    ScreenField next = null;
    ScreenField prev = null;
    boolean isSelectionField;
    int selectionFieldType;
    int selectionIndex;
    int selectionPos;

    protected ScreenField(Screen5250 s) {
        this.s = s;
    }

    protected ScreenField setField(int attr, int len, int ffw1, int ffw2, int fcw1, int fcw2) {
        return this.setField(attr, this.s.getCurrentRow() - 1, this.s.getCurrentCol() - 1, len, ffw1, ffw2, fcw1, fcw2);
    }

    protected ScreenField setField(int attr, int row, int col, int len, int ffw1, int ffw2, int fcw1, int fcw2) {
        this.startPos = row * this.s.getColumns() + col;
        this.endPos = this.startPos + this.length - 1;
        this.cursorProg = 0;
        this.fieldId = 0;
        this.length = len;
        this.endPos = this.startPos + this.length - 1;
        this.attr = attr;
        this.setFFWs(ffw1, ffw2);
        this.setFCWs(fcw1, fcw2);
        this.next = null;
        this.prev = null;
        return this;
    }

    public int getAttr() {
        return this.attr;
    }

    public int getHighlightedAttr() {
        return this.fcw2 & 0xF | 0x20;
    }

    public int getLength() {
        return this.length;
    }

    protected boolean setFFWs(int ffw1, int ffw2) {
        this.ffw1 = ffw1;
        this.ffw2 = ffw2;
        int adj = this.getAdjustment();
        if (adj > 0) {
            this.checkCanSend = true;
            switch (adj) {
                case 5: 
                case 6: {
                    this.rightAdjd = false;
                    break;
                }
                case 7: {
                    this.manditoried = false;
                }
            }
        }
        this.mdt = (ffw1 & 8) == 8;
        return this.mdt;
    }

    public int getFFW1() {
        return this.ffw1;
    }

    public int getFFW2() {
        return this.ffw2;
    }

    protected void setFCWs(int fcw1, int fcw2) {
        this.fcw1 = fcw1;
        this.fcw2 = fcw2;
        if (fcw1 == 136) {
            this.cursorProg = fcw2;
        }
    }

    public int getFCW1() {
        return this.fcw1;
    }

    public int getFCW2() {
        return this.fcw2;
    }

    public int getFieldLength() {
        return this.length;
    }

    public int getCursorProgression() {
        return this.cursorProg;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    protected void setFieldId(int fi) {
        this.fieldId = fi;
    }

    public int getCursorRow() {
        return this.cursorPos / this.s.getColumns();
    }

    public int getCursorCol() {
        return this.cursorPos % this.s.getColumns();
    }

    protected void changePos(int i) {
        this.cursorPos += i;
    }

    protected String getText() {
        StringBuffer text = new StringBuffer();
        this.getKeyPos(this.endPos);
        int x = this.length;
        text.setLength(x);
        while (x-- > 0) {
            if (this.s.planes.isAttributePlace(this.cursorPos)) {
                text.setCharAt(x, (char)(65280 + this.s.planes.getCharAttr(this.cursorPos)));
            } else {
                text.setCharAt(x, this.s.planes.getChar(this.cursorPos));
            }
            this.changePos(-1);
        }
        if (this.isContinued() && this.isContinuedFirst()) {
            ScreenField sf = this;
            do {
                sf = sf.next;
                text.append(sf.getText());
            } while (!sf.isContinuedLast());
            Object var3_3 = null;
        }
        return text.toString();
    }

    public String getString() {
        StringBuffer text = new StringBuffer();
        this.getKeyPos(this.endPos);
        int x = this.length;
        text.setLength(x);
        while (x-- > 0) {
            if (this.s.planes.isAttributePlace(this.cursorPos)) {
                text.setCharAt(x, (char)(65280 + this.s.planes.getCharAttr(this.cursorPos)));
            } else if (this.s.planes.getChar(this.cursorPos) < ' ') {
                text.setCharAt(x, ' ');
            } else {
                text.setCharAt(x, this.s.planes.getChar(this.cursorPos));
            }
            this.changePos(-1);
        }
        if (this.isContinued() && this.isContinuedFirst()) {
            ScreenField sf = this;
            do {
                sf = sf.next;
                text.append(sf.getString());
            } while (!sf.isContinuedLast());
            Object var3_3 = null;
        }
        return text.toString();
    }

    public void setFieldChar(char c) {
        int x = this.length;
        this.cursorPos = this.startPos;
        while (x-- > 0) {
            this.s.planes.setChar(this.cursorPos, c);
            this.changePos(1);
        }
    }

    public void setFieldChar(int lastPos, char c) {
        int x = this.endPos - lastPos + 1;
        this.cursorPos = lastPos;
        while (x-- > 0) {
            this.s.planes.setChar(this.cursorPos, c);
            this.s.setDirty(this.cursorPos);
            this.changePos(1);
        }
    }

    protected void setRightAdjusted() {
        this.rightAdjd = true;
    }

    protected void setManditoryEntered() {
        this.manditoried = true;
    }

    protected void resetMDT() {
        this.mdt = false;
    }

    protected void setMDT() {
        if (this.isContinued() && !this.isContinuedFirst()) {
            ScreenField sf = this.prev;
            while (sf.isContinued() && !sf.isContinuedFirst()) {
                sf = sf.prev;
            }
            sf.setMDT();
            Object var1_1 = null;
        } else {
            this.mdt = true;
        }
    }

    public boolean isBypassField() {
        return (this.ffw1 & 0x20) == 32;
    }

    public int getAdjustment() {
        return this.ffw2 & 7;
    }

    public boolean isFER() {
        return (this.ffw2 & 0x40) == 64;
    }

    public boolean isMandatoryEnter() {
        return (this.ffw2 & 8) == 8;
    }

    public boolean isToUpper() {
        return (this.ffw2 & 0x20) == 32;
    }

    public int getFieldShift() {
        return this.ffw1 & 7;
    }

    public boolean isHiglightedEntry() {
        return this.fcw1 == 137;
    }

    public boolean isAutoEnter() {
        return (this.ffw2 & 0x80) == 128;
    }

    public boolean isSignedNumeric() {
        return this.getFieldShift() == 7;
    }

    public boolean isRightToLeft() {
        return this.getFieldShift() == 4;
    }

    public boolean isNumeric() {
        return this.getFieldShift() == 3;
    }

    public boolean isDupEnabled() {
        return (this.ffw1 & 0x10) == 16;
    }

    public boolean isContinued() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 >= 1 && this.fcw2 <= 3;
    }

    public boolean isContinuedFirst() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 == 1;
    }

    public boolean isContinuedMiddle() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 == 3;
    }

    public boolean isContinuedLast() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 == 2;
    }

    protected boolean isCanSend() {
        int adj = this.getAdjustment();
        if (this.isFER() && this.cursorPos > this.endPos) {
            return true;
        }
        if (this.isSignedNumeric() && this.cursorPos < this.endPos - 1) {
            return false;
        }
        if (adj > 0) {
            switch (adj) {
                case 5: 
                case 6: {
                    return this.rightAdjd;
                }
                case 7: {
                    return this.manditoried;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isSelectionField() {
        return this.isSelectionField;
    }

    public void setSelectionFieldInfo(int type, int index, int position) {
        this.selectionFieldType = type;
        this.selectionIndex = index;
        this.selectionPos = position;
        this.isSelectionField = true;
    }

    protected int getKeyPos(int row1, int col1) {
        int x = row1 * this.s.getColumns() + col1;
        int y = x - this.startPos();
        this.cursorPos = x;
        return y;
    }

    protected int getKeyPos(int pos) {
        int y = pos - this.startPos();
        this.cursorPos = pos;
        return y;
    }

    public int getCurrentPos() {
        return this.cursorPos;
    }

    public boolean withinField(int pos) {
        return pos >= this.startPos && pos <= this.endPos;
    }

    public int startPos() {
        return this.startPos;
    }

    public int startRow() {
        return this.startPos / this.s.getColumns();
    }

    public int startCol() {
        return this.startPos % this.s.getColumns();
    }

    public int endPos() {
        return this.endPos;
    }

    public void setString(String text) {
        int n = this.cursorPos = this.isRightToLeft() ? this.endPos - text.length() + 1 : this.startPos;
        if (this.isRightToLeft()) {
            text = new StringBuilder(text).reverse().toString();
        }
        int textLen = text.length();
        for (int x = 0; x < this.length; ++x) {
            char tc = x < textLen ? (char)text.charAt(x) : (char)' ';
            this.s.getPlanes().setChar(this.cursorPos, tc);
            this.changePos(1);
        }
        this.setMDT();
        this.s.getScreenFields().setMasterMDT();
    }

    public String toString() {
        int fcw = (this.fcw1 & 0xFF) << 8 | this.fcw2 & 0xFF;
        return "startRow = " + this.startRow() + " startCol = " + this.startCol() + " length = " + this.length + " ffw1 = (0x" + Integer.toHexString(this.ffw1) + ") ffw2 = (0x" + Integer.toHexString(this.ffw2) + ") fcw1 = (0x" + Integer.toHexString(this.fcw1) + ") fcw2 = (0x" + Integer.toHexString(this.fcw2) + ") fcw = (" + Integer.toBinaryString(fcw) + ") fcw hex = (0x" + Integer.toHexString(fcw) + ") is bypass field = " + this.isBypassField() + ") is autoenter = " + this.isAutoEnter() + ") is manditoryenter = " + this.isMandatoryEnter() + ") is field exit required = " + this.isFER() + ") is Numeric = " + this.isNumeric() + ") is Signed Numeric = " + this.isSignedNumeric() + ") is cursor progression = " + (this.fcw1 == 136) + ") next progression field = " + this.fcw2 + ") field id " + this.fieldId + " continued edit field = " + this.isContinued() + " first continued edit field = " + this.isContinuedFirst() + " middle continued edit field = " + this.isContinuedMiddle() + " last continued edit field = " + this.isContinuedLast() + " mdt = " + this.mdt;
    }
}

