/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.ByteArrayOutputStream;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenField;

public class ScreenFields {
    private ScreenField[] screenFields;
    private ScreenField currentField;
    private ScreenField saveCurrent;
    private int sizeFields;
    private boolean cpfExists;
    private int nextField;
    private int fieldIds;
    private Screen5250 screen;
    private boolean masterMDT;
    protected boolean currentModified;

    public ScreenFields(Screen5250 s) {
        this.screen = s;
        this.screenFields = new ScreenField[256];
    }

    protected void clearFFT() {
        this.fieldIds = 0;
        this.nextField = 0;
        this.sizeFields = 0;
        this.cpfExists = false;
        this.currentField = null;
        this.masterMDT = false;
    }

    protected boolean existsAtPos(int lastPos) {
        ScreenField sf = null;
        for (int x = 0; x < this.sizeFields; ++x) {
            sf = this.screenFields[x];
            if (lastPos != sf.startPos()) continue;
            this.currentField = sf;
            this.currentModified = false;
            return true;
        }
        return false;
    }

    public boolean isMasterMDT() {
        return this.masterMDT;
    }

    protected void setMasterMDT() {
        this.masterMDT = true;
    }

    public boolean isCurrentField() {
        return this.currentField == null;
    }

    public boolean isCurrentFieldFER() {
        return this.currentField.isFER();
    }

    public boolean isCurrentFieldDupEnabled() {
        return this.currentField.isDupEnabled();
    }

    public boolean isCurrentFieldToUpper() {
        return this.currentField.isToUpper();
    }

    public boolean isCurrentFieldBypassField() {
        return this.currentField.isBypassField();
    }

    public boolean isCurrentFieldHighlightedEntry() {
        if (this.currentField != null) {
            return this.currentField.isHiglightedEntry();
        }
        return false;
    }

    public boolean isCurrentFieldAutoEnter() {
        return this.currentField.isAutoEnter();
    }

    public boolean withinCurrentField(int pos) {
        return this.currentField.withinField(pos);
    }

    public boolean isCurrentFieldContinued() {
        return this.currentField.isContinued();
    }

    public boolean isCurrentFieldContinuedFirst() {
        return this.currentField.isContinuedFirst();
    }

    public boolean isCurrentFieldContinuedMiddle() {
        return this.currentField.isContinuedMiddle();
    }

    public boolean isCurrentFieldContinuedLast() {
        return this.currentField.isContinuedLast();
    }

    public boolean isCurrentFieldModified() {
        return this.currentModified;
    }

    public boolean isCanSendAid() {
        return this.currentField == null || this.currentField.getAdjustment() <= 0 && !this.currentField.isSignedNumeric() || !this.currentModified || !this.isInField() || this.currentField.isCanSend();
    }

    protected void saveCurrentField() {
        this.saveCurrent = this.currentField;
    }

    protected void restoreCurrentField() {
        this.currentField = this.saveCurrent;
    }

    protected void setCurrentField(ScreenField sf) {
        this.currentField = sf;
    }

    protected void setCurrentFieldMDT() {
        this.currentField.setMDT();
        this.currentModified = true;
        this.masterMDT = true;
    }

    protected void setCurrentFieldFFWs(int ffw1, int ffw2) {
        this.masterMDT = this.currentField.setFFWs(ffw1, ffw2);
    }

    protected ScreenField setField(int attr, int row, int col, int len, int ffw1, int ffw2, int fcw1, int fcw2) {
        ScreenField sf = null;
        this.screenFields[this.nextField] = new ScreenField(this.screen);
        this.screenFields[this.nextField].setField(attr, row, col, len, ffw1, ffw2, fcw1, fcw2);
        sf = this.screenFields[this.nextField++];
        ++this.sizeFields;
        sf.setFieldId(++this.fieldIds);
        if (fcw1 == 136) {
            this.cpfExists = true;
        }
        if (this.currentField != null) {
            this.currentField.next = sf;
            sf.prev = this.currentField;
        }
        this.currentField = sf;
        if (!this.masterMDT) {
            this.masterMDT = this.currentField.mdt;
        }
        this.currentModified = false;
        return this.currentField;
    }

    public ScreenField getField(int index) {
        return this.screenFields[index];
    }

    public ScreenField getCurrentField() {
        return this.currentField;
    }

    public int getCurrentFieldPos() {
        return this.currentField.getCurrentPos();
    }

    protected int getCurrentFieldShift() {
        return this.currentField.getFieldShift();
    }

    public String getCurrentFieldText() {
        return this.currentField.getText();
    }

    public int getCurrentFieldHighlightedAttr() {
        return this.currentField.getHighlightedAttr();
    }

    public int getSize() {
        return this.sizeFields;
    }

    public int getFieldCount() {
        return this.sizeFields;
    }

    protected boolean isInField(int pos) {
        return this.isInField(pos, true);
    }

    protected boolean isInField() {
        return this.isInField(this.screen.getLastPos(), true);
    }

    protected boolean isInField(int pos, boolean chgToField) {
        for (int x = 0; x < this.sizeFields; ++x) {
            ScreenField sf = this.screenFields[x];
            if (!sf.withinField(pos)) continue;
            if (chgToField) {
                if (!this.currentField.equals(sf)) {
                    this.currentModified = false;
                }
                this.currentField = sf;
            }
            return true;
        }
        return false;
    }

    public ScreenField findByString(String targetString, int startPos, int length, int dir, boolean ignoreCase) {
        return this.findByPosition(startPos);
    }

    public ScreenField findByPosition(int targetPosition) {
        ScreenField sf = null;
        for (int x = 0; x < this.sizeFields; ++x) {
            sf = this.screenFields[x];
            if (!sf.withinField(targetPosition)) continue;
            return sf;
        }
        return null;
    }

    public ScreenField findByPosition(int row, int col) {
        return this.findByPosition(this.screen.getPos(row, col));
    }

    public ScreenField[] getFields() {
        ScreenField[] fields = new ScreenField[this.sizeFields];
        for (int x = 0; x < this.sizeFields; ++x) {
            fields[x] = this.screenFields[x];
        }
        return fields;
    }

    public ScreenField getFirstInputField() {
        if (this.sizeFields <= 0) {
            return null;
        }
        int f = 0;
        ScreenField sf = this.screenFields[f];
        while (sf.isBypassField() && f++ < this.sizeFields) {
            sf = this.screenFields[f];
        }
        if (sf.isBypassField()) {
            return null;
        }
        return sf;
    }

    public void gotoFieldNext() {
        int lastPos = this.screen.getLastPos();
        if (this.currentField == null && this.sizeFields != 0 && !this.isInField(lastPos, true)) {
            int pos = lastPos;
            this.screen.setCursorOff();
            this.screen.advancePos();
            lastPos = this.screen.getLastPos();
            while (!this.isInField() && pos != lastPos) {
                this.screen.advancePos();
            }
            this.screen.setCursorOn();
        }
        if (this.currentField == null) {
            return;
        }
        ScreenField sf = this.currentField;
        if (!sf.withinField(lastPos)) {
            this.screen.setCursorOff();
            if (this.sizeFields > 0) {
                int pos = lastPos;
                int savPos = lastPos;
                boolean done = false;
                do {
                    this.screen.advancePos();
                    lastPos = this.screen.getLastPos();
                    if (!this.isInField(lastPos) && pos != lastPos || this.currentField.isBypassField()) continue;
                    this.screen.gotoField(this.currentField);
                    done = true;
                } while (!done && lastPos != savPos);
            }
            this.currentModified = false;
            this.screen.setCursorOn();
        } else {
            if (!this.cpfExists) {
                while ((sf = sf.next) != null && sf.isBypassField()) {
                }
            } else {
                int f = 0;
                int cp = sf.getCursorProgression();
                if (cp == 0) {
                    while ((sf = sf.next) != null && sf.isBypassField()) {
                    }
                } else {
                    ScreenField sf1 = null;
                    boolean found = false;
                    while (!found && f < this.sizeFields) {
                        if ((sf1 = this.screenFields[f++]).getFieldId() != cp) continue;
                        found = true;
                    }
                    if (found) {
                        sf = sf1;
                    } else {
                        while ((sf = sf.next) != null && sf.isBypassField()) {
                        }
                    }
                    sf1 = null;
                }
            }
            if (sf == null) {
                this.screen.gotoField(1);
            } else {
                this.currentField = sf;
                this.screen.gotoField(this.currentField);
            }
            this.currentModified = false;
        }
    }

    public void gotoFieldPrev() {
        ScreenField sf = this.currentField;
        int lastPos = this.screen.getLastPos();
        if (!sf.withinField(lastPos)) {
            this.screen.setCursorOff();
            if (this.sizeFields > 0) {
                int pos = lastPos;
                int savPos = lastPos;
                boolean done = false;
                do {
                    this.screen.changePos(-1);
                    lastPos = this.screen.getLastPos();
                    if (!this.isInField(lastPos) && pos != lastPos || this.currentField.isBypassField()) continue;
                    this.screen.gotoField(this.currentField);
                    done = true;
                } while (!done && lastPos != savPos);
            }
            this.screen.setCursorOn();
        } else {
            if (sf.startPos() == lastPos) {
                if (!this.cpfExists) {
                    while ((sf = sf.prev) != null && sf.isBypassField()) {
                    }
                } else {
                    int f = 0;
                    int cp = sf.getFieldId();
                    ScreenField sf1 = null;
                    boolean found = false;
                    while (!found && f < this.sizeFields) {
                        if ((sf1 = this.screenFields[f++]).getCursorProgression() != cp) continue;
                        found = true;
                    }
                    if (found) {
                        sf = sf1;
                    } else {
                        while ((sf = sf.prev) != null && sf.isBypassField()) {
                        }
                    }
                    sf1 = null;
                }
            }
            if (sf == null) {
                int size = this.sizeFields;
                sf = this.screenFields[size - 1];
                while (sf.isBypassField() && size-- > 0) {
                    sf = this.screenFields[size];
                }
            }
            this.currentField = sf;
            this.currentModified = false;
            this.screen.gotoField(this.currentField);
        }
    }

    protected void readFormatTable(ByteArrayOutputStream baosp, int readType, ICodePage codePage) {
        boolean isSigned = false;
        if (this.masterMDT) {
            StringBuffer sb = new StringBuffer();
            for (int x = 0; x < this.sizeFields; ++x) {
                int len3;
                isSigned = false;
                ScreenField sf = this.screenFields[x];
                if (!sf.mdt && readType != 66) continue;
                sb.setLength(0);
                sb.append(sf.getText());
                if (readType == 82 || readType == -125) {
                    int len = sb.length() - 1;
                    while (!(len < 0 || sb.charAt(len) >= ' ' && sb.charAt(len) < '\uff20' || sb.charAt(len) == '\u001c' && sf.isDupEnabled())) {
                        sb.deleteCharAt(len--);
                    }
                }
                if (sf.isSignedNumeric() && sb.length() > 0 && sb.charAt(sb.length() - 1) == '-') {
                    isSigned = true;
                    sb.setLength(sb.length() - 1);
                }
                if ((len3 = sb.length()) <= 0 && readType != 82 && readType != -125) continue;
                if (readType == 82 || readType == -125) {
                    baosp.write(17);
                    if (sf.isSelectionField()) {
                        baosp.write(this.screen.getRow(sf.selectionPos) + 1);
                        baosp.write(this.screen.getCol(sf.selectionPos) + 1);
                    } else {
                        baosp.write(sf.startRow() + 1);
                        baosp.write(sf.startCol() + 1);
                    }
                }
                if (sf.isSelectionField()) {
                    baosp.write(0);
                    baosp.write(sf.selectionIndex + 31);
                    continue;
                }
                for (int k = 0; k < len3; ++k) {
                    char c = sb.charAt(k);
                    if (c < ' ' || c >= '\uff20') {
                        if (c >= '\uff20' && c <= '\uff3f') {
                            baosp.write(c - 65280);
                            continue;
                        }
                        if (c == '\u001c') {
                            baosp.write(c);
                            continue;
                        }
                        baosp.write(codePage.uni2ebcdic(' '));
                        continue;
                    }
                    if (isSigned && k == len3 - 1) {
                        baosp.write(0xD0 | 0xF & c);
                        continue;
                    }
                    baosp.write(codePage.uni2ebcdic(c));
                }
            }
        }
    }
}

