/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.util.Properties;
import org.tn5250j.ExternalProgramConfig;
import org.tn5250j.framework.tn5250.Screen5250;

public class ScreenPlanes {
    private final Screen5250 scr;
    private int screenSize;
    private int numRows;
    private int numCols;
    private int errorLineNum;
    private static final int initAttr = 32;
    private static final char initChar = '\u0000';
    protected char[] screen;
    private char[] screenAttr;
    private char[] screenGUI;
    private char[] screenIsAttr;
    private char[] fieldExtended;
    private char[] screenField;
    private char[] screenColor;
    protected char[] screenExtended;
    private char[] screenIsChanged;
    private char[] initArray;
    private char[] errorLine;
    private char[] errorLineAttr;
    private char[] errorLineIsAttr;
    private char[] errorLineGui;

    public ScreenPlanes(Screen5250 s5250, int size) {
        this.scr = s5250;
        this.setSize(size);
    }

    protected void setSize(int newSize) {
        this.screenSize = newSize;
        this.numCols = 80;
        switch (newSize) {
            case 24: {
                this.numRows = 24;
                break;
            }
            case 27: {
                this.numRows = 27;
                this.numCols = 132;
            }
        }
        this.setErrorLine(this.numRows);
        this.screenSize = this.numRows * this.numCols;
        this.screen = new char[this.screenSize];
        this.screenAttr = new char[this.screenSize];
        this.screenIsAttr = new char[this.screenSize];
        this.screenGUI = new char[this.screenSize];
        this.screenColor = new char[this.screenSize];
        this.screenExtended = new char[this.screenSize];
        this.fieldExtended = new char[this.screenSize];
        this.screenIsChanged = new char[this.screenSize];
        this.screenField = new char[this.screenSize];
        this.initArray = new char[this.screenSize];
        this.initalizePlanes();
    }

    protected void setErrorLine(int line) {
        this.errorLineNum = line == 0 || line > this.numRows ? this.numRows : line;
    }

    protected int getErrorLine() {
        return this.errorLineNum;
    }

    protected void saveErrorLine() {
        if (this.errorLine == null) {
            this.errorLine = new char[this.numCols];
            this.errorLineAttr = new char[this.numCols];
            this.errorLineIsAttr = new char[this.numCols];
            this.errorLineGui = new char[this.numCols];
            int r = this.scr.getPos(this.errorLineNum - 1, 0);
            for (int x = 0; x < this.numCols; ++x) {
                this.errorLine[x] = this.screen[r + x];
                this.errorLineAttr[x] = this.screenAttr[r + x];
                this.errorLineIsAttr[x] = this.screenIsAttr[r + x];
                this.errorLineGui[x] = this.screenGUI[r + x];
            }
        }
    }

    protected void restoreErrorLine() {
        if (this.errorLine != null) {
            int r = this.scr.getPos(this.errorLineNum - 1, 0);
            for (int x = 0; x < this.numCols - 1; ++x) {
                this.setScreenCharAndAttr(r + x, this.errorLine[x], this.errorLineAttr[x], this.errorLineIsAttr[x] == '1');
                this.screenGUI[x] = this.errorLineGui[x];
            }
            this.errorLine = null;
            this.errorLineAttr = null;
            this.errorLineIsAttr = null;
            this.errorLineGui = null;
        }
    }

    protected boolean isErrorLineSaved() {
        return this.errorLine != null;
    }

    protected void setScreenCharAndAttr(int pos, char c, int attr, boolean isAttr) {
        this.screen[pos] = c;
        this.screenAttr[pos] = (char)attr;
        this.disperseAttribute(pos, attr);
        this.screenIsAttr[pos] = isAttr ? (char)'\u0001' : '\u0000';
        this.screenGUI[pos] = '\u0000';
    }

    protected void setScreenAttr(int pos, int attr, boolean isAttr) {
        this.screenAttr[pos] = (char)attr;
        this.screenIsAttr[pos] = isAttr ? (char)'\u0001' : '\u0000';
        this.disperseAttribute(pos, attr);
        this.screenGUI[pos] = '\u0000';
    }

    protected void setScreenAttr(int pos, int attr) {
        this.screenAttr[pos] = (char)attr;
        this.disperseAttribute(pos, attr);
    }

    protected void setScreenFieldAttr(int pos, int attr) {
        this.screenField[pos] = (char)attr;
    }

    protected final void setChar(int pos, char c) {
        this.screenIsChanged[pos] = this.screen[pos] == c ? 48 : 49;
        this.screen[pos] = c;
        if (this.screenIsAttr[pos] == '\u0001') {
            this.setScreenCharAndAttr(pos, c, 32, false);
        }
    }

    protected final char getChar(int pos) {
        return this.screen[pos];
    }

    protected final int getCharAttr(int pos) {
        return this.screenAttr[pos];
    }

    protected final boolean isAttributePlace(int pos) {
        return this.screenIsAttr[pos] == '\u0001';
    }

    public final void setUseGUI(int pos, int which) {
        this.screenIsChanged[pos] = this.screenGUI[pos] == which ? 48 : 49;
        this.screenGUI[pos] = (char)which;
    }

    private void disperseAttribute(int pos, int attr) {
        int c = 0;
        int cs = 0;
        int ul = 0;
        int nd = 0;
        if (attr == 0) {
            return;
        }
        switch (attr) {
            case 32: {
                c = 2;
                break;
            }
            case 33: {
                c = 512;
                break;
            }
            case 34: {
                c = 7;
                break;
            }
            case 35: {
                c = 1792;
                break;
            }
            case 36: {
                c = 2;
                ul = 8;
                break;
            }
            case 37: {
                c = 512;
                ul = 8;
                break;
            }
            case 38: {
                c = 7;
                ul = 8;
                break;
            }
            case 39: {
                nd = 1;
                break;
            }
            case 40: 
            case 42: {
                c = 4;
                break;
            }
            case 41: 
            case 43: {
                c = 1024;
                break;
            }
            case 44: 
            case 46: {
                c = 4;
                ul = 8;
                break;
            }
            case 45: {
                c = 1024;
                ul = 8;
                break;
            }
            case 47: {
                nd = 1;
                break;
            }
            case 48: {
                c = 3;
                cs = 2;
                break;
            }
            case 49: {
                c = 768;
                cs = 2;
                break;
            }
            case 50: {
                c = 6;
                cs = 2;
                break;
            }
            case 51: {
                c = 1536;
                cs = 2;
                break;
            }
            case 52: {
                c = 3;
                ul = 8;
                break;
            }
            case 53: {
                c = 768;
                ul = 8;
                break;
            }
            case 54: {
                c = 6;
                ul = 8;
                break;
            }
            case 55: {
                nd = 1;
                break;
            }
            case 56: {
                c = 5;
                break;
            }
            case 57: {
                c = 1280;
                break;
            }
            case 58: {
                c = 1;
                break;
            }
            case 59: {
                c = 256;
                break;
            }
            case 60: {
                c = 5;
                ul = 8;
                break;
            }
            case 61: {
                c = 1280;
                ul = 8;
                break;
            }
            case 62: {
                c = 1;
                ul = 8;
                break;
            }
            case 63: {
                nd = 1;
                cs = 2;
                break;
            }
            default: {
                c = 6;
            }
        }
        this.screenColor[pos] = c;
        this.screenExtended[pos] = (char)(ul | cs | nd);
    }

    protected void initalizePlanes() {
        int c = 2;
        for (int y = 0; y < this.screenSize; ++y) {
            this.screenAttr[y] = 32;
            this.screenColor[y] = c;
        }
        System.arraycopy(this.initArray, 0, this.screen, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenGUI, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenIsAttr, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenExtended, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.fieldExtended, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenField, 0, this.screenSize);
    }

    protected void initalizeFieldPlanes() {
        System.arraycopy(this.initArray, 0, this.fieldExtended, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenField, 0, this.screenSize);
    }

    protected final int getWhichGUI(int pos) {
        return this.screenGUI[pos];
    }

    protected final boolean isChanged(int pos) {
        return this.screenIsChanged[pos] != '\u0000';
    }

    protected final boolean isUseGui(int pos) {
        return this.screenGUI[pos] != '\u0000';
    }

    protected synchronized char[] getPlaneData(int from, int to, int plane) {
        int len = to - from;
        char[] planeChars = new char[len + 1];
        switch (plane) {
            case 1: {
                System.arraycopy(this.screen, from, planeChars, 0, len);
                break;
            }
            case 7: {
                System.arraycopy(this.screenAttr, from, planeChars, 0, len);
                break;
            }
            case 2: {
                System.arraycopy(this.screenColor, from, planeChars, 0, len);
                break;
            }
            case 4: {
                System.arraycopy(this.screenExtended, from, planeChars, 0, len);
                break;
            }
            case 5: {
                System.arraycopy(this.screenGUI, from, planeChars, 0, len);
                break;
            }
            case 3: {
                System.arraycopy(this.screenField, from, planeChars, 0, len);
                break;
            }
            case 8: {
                System.arraycopy(this.screenIsAttr, from, planeChars, 0, len);
                break;
            }
            default: {
                System.arraycopy(this.screen, from, planeChars, 0, len);
            }
        }
        return planeChars;
    }

    private int convertPosToRow(int pos) {
        return pos / this.numCols + 1;
    }

    private int convertPosToColumn(int pos) {
        return pos % this.numCols + 1;
    }

    private int convertRowColToPos(int row, int col) {
        return (row - 1) * this.numCols + col - 1;
    }

    public synchronized int GetScreen(char[] buffer, int bufferLength, int plane) {
        return this.GetScreen(buffer, bufferLength, 0, this.screenSize, plane);
    }

    public synchronized int GetScreen(char[] buffer, int bufferLength, int from, int length, int plane) {
        char[] pd;
        if (buffer == null) {
            return 0;
        }
        int min = Math.min(Math.min(buffer.length, bufferLength), this.screenSize);
        if (from + min > this.screenSize) {
            min = this.screenSize - from;
        }
        if ((pd = this.getPlaneData(from, from + min, plane)) != null) {
            System.arraycopy(pd, 0, buffer, 0, min);
            return pd.length;
        }
        return 0;
    }

    public synchronized int GetScreen(char[] buffer, int bufferLength, int row, int col, int length, int plane) {
        return this.GetScreen(buffer, bufferLength, this.convertRowColToPos(row, col), length, plane);
    }

    protected int GetScreenRect(char[] buffer, int bufferLength, int startPos, int endPos, int plane) {
        int startRow = this.convertPosToRow(startPos);
        int startCol = this.convertPosToColumn(startPos);
        int endRow = this.convertPosToRow(endPos);
        int endCol = this.convertPosToColumn(endPos);
        return this.GetScreenRect(buffer, bufferLength, startRow, startCol, endRow, endCol, plane);
    }

    protected int GetScreenRect(char[] buffer, int bufferLength, int startRow, int startCol, int endRow, int endCol, int plane) {
        int numRows;
        int numCols;
        int numBytes = 0;
        if (startRow > endRow) {
            int r = startRow;
            startRow = endRow;
            endRow = r;
        }
        if (startCol > endCol) {
            int c = startCol;
            startCol = endCol;
            endCol = c;
        }
        if ((numCols = endCol - startCol + 1) * (numRows = endRow - startRow + 1) <= bufferLength) {
            char[] cb = new char[numCols + 1];
            int charOffset = 0;
            int bytes = 0;
            int row = startRow;
            while (row <= endRow) {
                bytes = this.GetScreen(cb, cb.length, row, startCol, numCols, plane);
                if (bytes != 0) {
                    System.arraycopy(cb, 0, buffer, charOffset, numCols);
                }
                ++row;
                charOffset += numCols;
                numBytes += bytes;
            }
        }
        return numBytes;
    }

    protected boolean checkHotSpots() {
        Screen5250 s = this.scr;
        int lenScreen = this.scr.getScreenLength();
        boolean hs = false;
        boolean retHS = false;
        StringBuffer hsMore = s.getHSMore();
        StringBuffer hsBottom = s.getHSBottom();
        for (int x = 0; x < lenScreen; ++x) {
            block39: {
                Properties etnProps;
                String count;
                block40: {
                    block37: {
                        block38: {
                            boolean mFlag;
                            int io;
                            int row;
                            int ns;
                            int stop;
                            int os;
                            hs = false;
                            if (s.isInField(x, false)) continue;
                            if (x > 0 && this.screen[x] == 'F' && this.screen[x + 1] >= '0' && this.screen[x + 1] <= '9' && this.screen[x - 1] <= ' ' && (this.screenExtended[x] & '\u0001') == 0) {
                                if (this.screen[x + 2] >= '0' && this.screen[x + 2] <= '9' && (this.screen[x + 3] == '=' || this.screen[x + 3] == '-' || this.screen[x + 3] == '/')) {
                                    hs = true;
                                } else if (this.screen[x + 2] == '=' || this.screen[x + 3] == '-' || this.screen[x + 3] == '/') {
                                    hs = true;
                                }
                                if (hs) {
                                    this.screenGUI[x] = 13;
                                    int ns2 = 0;
                                    int row2 = x / this.numCols;
                                    while (ns2 < 2 && ++x / this.numCols == row2) {
                                        ns2 = this.screen[x] <= ' ' ? ++ns2 : 0;
                                        if (ns2 >= 2) continue;
                                        this.screenGUI[x] = 15;
                                    }
                                    while (this.screen[--x] <= ' ') {
                                        this.screenGUI[x] = '\u0000';
                                    }
                                    this.screenGUI[x] = 14;
                                }
                            }
                            if (!hs && x > 0 && x < lenScreen - 2 && this.screen[x] == '.' && this.screenGUI[x] == '\u0000' && (this.screenExtended[x] & 8) == 0 && (this.screenExtended[x] & '\u0001') == 0) {
                                os = 0;
                                os = this.isOption(this.screen, x, lenScreen, 2, 3, '.');
                                if (os > 0) {
                                    hs = true;
                                    stop = x;
                                    ns = 0;
                                    row = stop / this.numCols;
                                    while (++stop / this.numCols == row && (this.screen[stop] >= ' ' || this.screen[stop] == '\u0000')) {
                                        ns = this.screen[stop] <= ' ' ? ++ns : 0;
                                        if (this.screen[stop] == '.') {
                                            io = 0;
                                            io = this.isOption(this.screen, stop, lenScreen, 2, 3, '.');
                                            if (io > 0) {
                                                stop = io;
                                                break;
                                            }
                                        }
                                        if (ns <= 3) continue;
                                    }
                                    this.screenGUI[++os] = 13;
                                    s.setDirty(os);
                                    while (++os < stop) {
                                        this.screenGUI[os] = 15;
                                        s.setDirty(os);
                                    }
                                    while (this.screen[--stop] <= ' ') {
                                        this.screenGUI[stop] = '\u0000';
                                        s.setDirty(stop);
                                    }
                                    this.screenGUI[stop] = 14;
                                    s.setDirty(stop);
                                }
                            }
                            if (!hs && x > 0 && x < lenScreen - 2 && this.screen[x] == '=' && this.screenGUI[x] == '\u0000' && (this.screenExtended[x] & 8) == 0 && (this.screenExtended[x] & '\u0001') == 0) {
                                os = 0;
                                os = this.isOption(this.screen, x, lenScreen, 2, 2, '=');
                                if (os > 0) {
                                    hs = true;
                                    stop = x;
                                    ns = 0;
                                    row = stop / this.numCols;
                                    while (++stop / this.numCols == row && this.screen[stop] >= ' ') {
                                        ns = this.screen[stop] == ' ' ? ++ns : 0;
                                        if (this.screen[stop] == '=') {
                                            io = 0;
                                            io = this.isOption(this.screen, stop, lenScreen, 2, 2, '=');
                                            if (io > 0) {
                                                stop = io;
                                                break;
                                            }
                                        }
                                        if (ns <= 2) continue;
                                    }
                                    this.screenGUI[++os] = 13;
                                    s.setDirty(os);
                                    while (++os < stop) {
                                        this.screenGUI[os] = 15;
                                        s.setDirty(os);
                                    }
                                    while (this.screen[--stop] <= ' ') {
                                        this.screenGUI[stop] = '\u0000';
                                        s.setDirty(stop);
                                    }
                                    this.screenGUI[stop] = 14;
                                    s.setDirty(stop);
                                }
                            }
                            if (!hs && x > 2 && x < lenScreen - hsMore.length() && this.screen[x] == hsMore.charAt(0) && this.screen[x - 1] <= ' ' && this.screen[x - 2] <= ' ' && this.screenGUI[x] == '\u0000' && (this.screenExtended[x] & '\u0001') == 0) {
                                mFlag = true;
                                int ms = hsMore.length();
                                int mc = 0;
                                while (++mc < ms) {
                                    if (this.screen[x + mc] == hsMore.charAt(mc)) continue;
                                    mFlag = false;
                                    break;
                                }
                                if (mFlag) {
                                    hs = true;
                                    this.screenGUI[x] = 21;
                                    while (--ms > 0) {
                                        this.screenGUI[++x] = 23;
                                    }
                                    this.screenGUI[x] = 22;
                                }
                            }
                            if (!hs && x > 2 && x < lenScreen - hsBottom.length() && this.screen[x] == hsBottom.charAt(0) && this.screen[x - 1] <= ' ' && this.screen[x - 2] <= ' ' && this.screenGUI[x] == '\u0000' && (this.screenExtended[x] & '\u0001') == 0) {
                                mFlag = true;
                                int bs = hsBottom.length();
                                int bc = 0;
                                while (++bc < bs) {
                                    if (this.screen[x + bc] == hsBottom.charAt(bc)) continue;
                                    mFlag = false;
                                    break;
                                }
                                if (mFlag) {
                                    hs = true;
                                    this.screenGUI[x] = 17;
                                    while (--bs > 0) {
                                        this.screenGUI[++x] = 19;
                                    }
                                    this.screenGUI[x] = 18;
                                }
                            }
                            if (hs || x <= 0 || x >= lenScreen - 7 || Character.toLowerCase(this.screen[x]) != 'h' || this.screen[x - 1] > ' ' || this.screenGUI[x] != '\u0000' || (this.screenExtended[x] & '\u0001') != 0) break block37;
                            if (Character.toLowerCase(this.screen[x + 1]) != 't' || Character.toLowerCase(this.screen[x + 2]) != 't' || Character.toLowerCase(this.screen[x + 3]) != 'p' || this.screen[x + 4] != ':' || this.screen[x + 5] != '/' || this.screen[x + 6] != '/') break block38;
                            hs = true;
                            this.screenGUI[x] = 25;
                            while (this.screen[++x] > ' ') {
                                this.screenGUI[x] = 27;
                            }
                            this.screenGUI[--x] = 26;
                            break block39;
                        }
                        if (Character.toLowerCase(this.screen[x + 1]) != 't' || Character.toLowerCase(this.screen[x + 2]) != 't' || Character.toLowerCase(this.screen[x + 3]) != 'p' || Character.toLowerCase(this.screen[x + 4]) != 's' || this.screen[x + 5] != ':' || this.screen[x + 6] != '/' || this.screen[x + 7] != '/') break block39;
                        hs = true;
                        this.screenGUI[x] = 25;
                        while (this.screen[++x] > ' ') {
                            this.screenGUI[x] = 27;
                        }
                        this.screenGUI[--x] = 26;
                        break block39;
                    }
                    if (hs || x <= 0 || x >= lenScreen - 7 || Character.toLowerCase(this.screen[x]) != 'm' || this.screen[x - 1] > ' ' || this.screenGUI[x] != '\u0000' || (this.screenExtended[x] & '\u0001') != 0) break block40;
                    if (Character.toLowerCase(this.screen[x + 1]) != 'a' || Character.toLowerCase(this.screen[x + 2]) != 'i' || Character.toLowerCase(this.screen[x + 3]) != 'l' || Character.toLowerCase(this.screen[x + 4]) != 't' || Character.toLowerCase(this.screen[x + 5]) != 'o' || this.screen[x + 6] != ':') break block39;
                    hs = true;
                    this.screenGUI[x] = 25;
                    while (this.screen[++x] > ' ') {
                        this.screenGUI[x] = 27;
                    }
                    this.screenGUI[--x] = 26;
                    break block39;
                }
                if (!hs && x > 0 && x < lenScreen - 7 && this.screen[x - 1] <= ' ' && this.screenGUI[x] == '\u0000' && (this.screenExtended[x] & '\u0001') == 0 && (count = (etnProps = ExternalProgramConfig.getInstance().getEtnPgmProps()).getProperty("etn.pgm.support.total.num")) != null && count.length() > 0) {
                    int total = Integer.parseInt(count);
                    for (int i = 1; i <= total; ++i) {
                        String program = etnProps.getProperty("etn.pgm." + i + ".command.name");
                        String key = "";
                        if (x + program.length() >= this.screen.length) break;
                        for (int j = 0; j <= program.length(); ++j) {
                            key = key + this.screen[x + j];
                        }
                        if (!key.toLowerCase().equals(program.toLowerCase() + ":")) continue;
                        hs = true;
                        this.screenGUI[x] = 25;
                        while (this.screen[++x] > ' ') {
                            this.screenGUI[x] = 27;
                        }
                        this.screenGUI[--x] = 26;
                        break;
                    }
                }
            }
            if (retHS || !hs) continue;
            retHS = true;
        }
        return retHS;
    }

    private int isOption(char[] screen, int x, int lenScreen, int numPref, int numSuff, char suff) {
        boolean hs = true;
        int sp = x;
        int os = 0;
        while (--sp >= 0 && screen[sp] <= ' ') {
            if (x - sp <= numPref && screen[sp] != suff && screen[sp] != '.' && screen[sp] != '*') continue;
            hs = false;
            break;
        }
        os = sp;
        while (hs && --os > 0 && screen[os] > ' ') {
            if (sp - os < numPref && screen[os] != suff && screen[os] != '.' && screen[os] != '*') continue;
            hs = false;
            break;
        }
        if (sp - os > 1 && !Character.isDigit(screen[os + 1])) {
            hs = false;
        }
        if (Character.isDigit(screen[(sp = x) + 1])) {
            hs = false;
        }
        while (hs && (++sp < lenScreen && screen[sp] <= ' ' || screen[sp] == suff)) {
            if (sp - x < numSuff && screen[sp] != suff && screen[sp] != '.' && screen[sp] != '*') continue;
            hs = false;
            break;
        }
        if (hs && !Character.isLetterOrDigit(screen[sp])) {
            hs = false;
        }
        if (hs) {
            return os;
        }
        return -1;
    }
}

