/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

public class Stream5250 {
    public static final int OPCODE_OFFSET = 9;
    public int streamSize;
    public int opCode;
    public int dataStart;
    public int pos;
    public byte[] buffer;

    public Stream5250(byte[] abyte0) {
        this.buffer = abyte0;
        this.streamSize = (abyte0[0] & 0xFF) << 8 | abyte0[1] & 0xFF;
        this.opCode = abyte0[9];
        this.pos = this.dataStart = 6 + abyte0[6];
    }

    public Stream5250() {
        this.buffer = null;
        this.streamSize = 0;
        this.opCode = 0;
        this.pos = this.dataStart = 0;
    }

    public void initialize(byte[] abyte0) {
        this.buffer = abyte0;
        this.streamSize = (abyte0[0] & 0xFF) << 8 | abyte0[1] & 0xFF;
        this.opCode = abyte0[9];
        this.pos = this.dataStart = 6 + abyte0[6];
    }

    public final int getOpCode() {
        return this.opCode;
    }

    public final byte getNextByte() throws Exception {
        if (this.buffer == null || this.pos > this.buffer.length) {
            throw new Exception("Buffer length exceeded: " + this.pos);
        }
        return this.buffer[this.pos++];
    }

    public final void setPrevByte() throws Exception {
        if (this.pos == 0) {
            throw new Exception("Index equals zero.");
        }
        --this.pos;
    }

    public final int getCurrentPos() {
        return this.pos;
    }

    public final byte getByteOffset(int off) throws Exception {
        if (this.buffer == null || this.pos + off > this.buffer.length) {
            throw new Exception("Buffer length exceeded: " + this.pos);
        }
        return this.buffer[this.pos + off];
    }

    public final boolean size() {
        return this.pos >= this.streamSize;
    }

    public final boolean hasNext() {
        return this.pos < this.streamSize;
    }

    public final byte[] getSegment() throws Exception {
        int length = (this.buffer[this.pos] & 0xFF) << 8 | this.buffer[this.pos + 1] & 0xFF;
        byte[] segment = new byte[length];
        this.getSegment(segment, length, true);
        return segment;
    }

    public final void getSegment(byte[] segment, int length, boolean adjustPos) throws Exception {
        if (this.pos + length > this.buffer.length) {
            throw new Exception("Buffer length exceeded: start " + this.pos + " length " + length);
        }
        System.arraycopy(this.buffer, this.pos, segment, 0, length);
        if (adjustPos) {
            this.pos += length;
        }
    }
}

