/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.util.ArrayList;
import java.util.List;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class WTDSFParser {
    private Screen5250 screen52;
    private tnvt vt;
    private ICodePage codePage;
    int pos;
    byte[] segment;
    int length;
    boolean error;
    boolean guiStructsExist;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private final List<Window> guiStructs = new ArrayList<Window>(3);
    private final List<ChoiceField> choices = new ArrayList<ChoiceField>(3);

    WTDSFParser(tnvt vt) {
        this.vt = vt;
        this.screen52 = vt.screen52;
        this.codePage = vt.codePage;
    }

    protected void addChoiceField(int row, int col, int fldRow, int fldCol, String text) {
        ChoiceField cf = new ChoiceField(row, col, fldRow, fldCol);
        cf.fieldId = this.screen52.getScreenFields().getCurrentField().getFieldId();
        this.choices.add(cf);
    }

    protected boolean isGuisExists() {
        return this.guiStructsExist;
    }

    protected byte[] getSegmentAtPos(int pos) {
        int len = this.guiStructs.size();
        for (int x = 0; x < len; ++x) {
            Window w = this.guiStructs.get(x);
            if (w.pos != pos) continue;
            return w.window;
        }
        return null;
    }

    protected void clearGuiStructs() {
        this.guiStructs.clear();
    }

    protected boolean parseWriteToDisplayStructuredField(byte[] seg) {
        this.error = false;
        boolean done = false;
        boolean windowDefined = false;
        this.pos = 0;
        this.segment = seg;
        this.length = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
        while (!done) {
            int s = this.segment[this.pos++] & 0xFF;
            block0 : switch (s) {
                case 217: {
                    switch (this.segment[this.pos++]) {
                        case 80: {
                            this.defineSelectionField(this.length);
                            done = true;
                            break block0;
                        }
                        case 81: {
                            this.guiStructs.add(new Window(this.segment, this.screen52.getLastPos()));
                            boolean cr = false;
                            byte rows = 0;
                            byte cols = 0;
                            if ((this.segment[this.pos++] & 0x80) == 128) {
                                cr = true;
                            }
                            ++this.pos;
                            ++this.pos;
                            rows = this.segment[this.pos++];
                            cols = this.segment[this.pos++];
                            this.length -= 9;
                            if (this.length == 0) {
                                done = true;
                                this.createWindow(rows, cols, 1, true, 32, 58, 46, 46, 46, 58, 58, 58, 46, 58);
                                windowDefined = true;
                                break block0;
                            }
                            int ml = 0;
                            byte type = 0;
                            int lastPos = this.screen52.getLastPos();
                            byte mAttr = 0;
                            byte cAttr = 0;
                            block17: while (this.length > 0) {
                                ml = this.segment[this.pos++] & 0xFF;
                                this.length -= ml;
                                type = this.segment[this.pos++];
                                switch (type) {
                                    case 1: {
                                        boolean gui = false;
                                        if ((this.segment[this.pos++] & 0x80) == 128) {
                                            gui = true;
                                        }
                                        mAttr = this.segment[this.pos++];
                                        cAttr = this.segment[this.pos++];
                                        int ul = 46;
                                        int upper = 46;
                                        int ur = 46;
                                        int left = 58;
                                        int right = 58;
                                        int ll = 58;
                                        int bottom = 46;
                                        int lr = 58;
                                        if (ml > 5) {
                                            if ((ul = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                ul = 46;
                                            }
                                            if ((upper = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                upper = 46;
                                            }
                                            if ((ur = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                ur = 46;
                                            }
                                            if ((left = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                left = 58;
                                            }
                                            if ((right = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                right = 58;
                                            }
                                            if ((ll = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                ll = 58;
                                            }
                                            if ((bottom = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                bottom = 46;
                                            }
                                            if ((lr = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                lr = 58;
                                            }
                                        }
                                        this.createWindow(rows, cols, type, gui, mAttr, cAttr, ul, upper, ur, left, right, ll, bottom, lr);
                                        windowDefined = true;
                                        continue block17;
                                    }
                                    case 16: {
                                        if (!windowDefined) {
                                            this.guiStructs.add(new Window(this.segment, this.screen52.getLastPos()));
                                            this.createWindow(rows, cols, 1, true, 32, 58, 46, 46, 46, 58, 58, 58, 46, 58);
                                            windowDefined = true;
                                        }
                                        byte orientation = this.segment[this.pos++];
                                        mAttr = this.segment[this.pos++];
                                        cAttr = this.segment[this.pos++];
                                        ++this.pos;
                                        StringBuffer hfBuffer = new StringBuffer(ml -= 6);
                                        while (ml-- > 0) {
                                            hfBuffer.append(this.codePage.ebcdic2uni(this.segment[this.pos++]));
                                        }
                                        this.log.debug(" orientation " + Integer.toBinaryString(orientation) + " mAttr " + mAttr + " cAttr " + cAttr + " Header/Footer " + hfBuffer);
                                        this.screen52.writeWindowTitle(lastPos, rows, cols, orientation, mAttr, cAttr, hfBuffer);
                                        continue block17;
                                    }
                                }
                                this.log.warn("Invalid Window minor structure");
                                this.length = 0;
                                done = true;
                            }
                            done = true;
                            break block0;
                        }
                        case 83: {
                            int sblen = 15;
                            byte sbflag = this.segment[this.pos++];
                            ++this.pos;
                            int totalRowScrollable = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int totalColScrollable = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int sliderRowPos = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int sliderColPos = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            byte sliderRC = this.segment[this.pos++];
                            this.screen52.createScrollBar(sbflag, totalRowScrollable, totalColScrollable, sliderRowPos, sliderColPos, sliderRC);
                            this.length -= 15;
                            done = true;
                            break block0;
                        }
                        case 91: {
                            ++this.pos;
                            ++this.pos;
                            done = true;
                            break block0;
                        }
                        case 95: {
                            this.log.info("remove all gui contructs");
                            this.clearGuiStructs();
                            this.guiStructsExist = false;
                            int len = 4;
                            byte d = 0;
                            this.length -= s;
                            while (--len > 0) {
                                d = this.segment[this.pos++];
                            }
                            this.screen52.clearGuiStuff();
                            this.screen52.clearTable();
                            done = true;
                            break block0;
                        }
                        case 89: {
                            this.log.info(" remove window at " + this.screen52.getCurrentPos());
                            done = true;
                            break block0;
                        }
                        case 96: {
                            int len = 6;
                            byte d = 0;
                            this.length -= 9;
                            while (--len > 0) {
                                d = this.segment[this.pos++];
                            }
                            if (this.length > 0) {
                                len = (this.segment[this.pos++] & 0xFF) << 8;
                                while (--len > 0) {
                                    d = this.segment[this.pos++];
                                }
                            }
                            done = true;
                            break block0;
                        }
                    }
                    this.vt.sendNegResponse(16, 3, 1, 1, "invalid wtd structured field sub command " + (this.pos - 1));
                    this.error = true;
                    break;
                }
                default: {
                    this.vt.sendNegResponse(16, 3, 1, 1, "invalid wtd structured field command " + (this.pos - 1));
                    this.error = true;
                }
            }
            if (!this.error) continue;
            done = true;
        }
        return this.error;
    }

    protected void createWindow(int depth, int width, int type, boolean gui, int monoAttr, int colorAttr, int ul, int upper, int ur, int left, int right, int ll, int bottom, int lr) {
        int lastPos = this.screen52.getLastPos();
        int numCols = this.screen52.getColumns();
        int c = this.screen52.getCol(lastPos);
        int w = 0;
        w = ++width;
        char initChar = '\u0000';
        int initAttr = 32;
        this.screen52.setScreenCharAndAttr(initChar, initAttr, true);
        if (gui) {
            this.screen52.setScreenCharAndAttr((char)ul, colorAttr, 1, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)ul, colorAttr, false);
        }
        while (w-- >= 0) {
            if (gui) {
                this.screen52.setScreenCharAndAttr((char)upper, colorAttr, 2, false);
                continue;
            }
            this.screen52.setScreenCharAndAttr((char)upper, colorAttr, false);
        }
        if (gui) {
            this.screen52.setScreenCharAndAttr((char)ur, colorAttr, 3, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)ur, colorAttr, false);
        }
        this.screen52.setScreenCharAndAttr(initChar, initAttr, true);
        lastPos = (this.screen52.getRow(lastPos) + 1) * numCols + c;
        this.screen52.goto_XY(lastPos);
        while (depth-- > 0) {
            this.screen52.setScreenCharAndAttr(initChar, initAttr, true);
            if (gui) {
                this.screen52.setScreenCharAndAttr((char)left, colorAttr, 4, false);
            } else {
                this.screen52.setScreenCharAndAttr((char)left, colorAttr, false);
            }
            w = width - 2;
            this.screen52.setScreenCharAndAttr(initChar, initAttr, 0, true);
            while (w-- >= 0) {
                this.screen52.setScreenCharAndAttr(initChar, initAttr, 0, false);
            }
            this.screen52.setScreenCharAndAttr(initChar, initAttr, 0, true);
            if (gui) {
                this.screen52.setScreenCharAndAttr((char)right, colorAttr, 5, false);
            } else {
                this.screen52.setScreenCharAndAttr((char)right, colorAttr, false);
            }
            this.screen52.setScreenCharAndAttr(initChar, initAttr, true);
            lastPos = (this.screen52.getRow(lastPos) + 1) * numCols + c;
            this.screen52.goto_XY(lastPos);
        }
        this.screen52.setScreenCharAndAttr(initChar, initAttr, true);
        if (gui) {
            this.screen52.setScreenCharAndAttr((char)ll, colorAttr, 6, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)ll, colorAttr, false);
        }
        w = width;
        while (w-- >= 0) {
            if (gui) {
                this.screen52.setScreenCharAndAttr((char)bottom, colorAttr, 7, false);
                continue;
            }
            this.screen52.setScreenCharAndAttr((char)bottom, colorAttr, false);
        }
        if (gui) {
            this.screen52.setScreenCharAndAttr((char)lr, colorAttr, 8, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)lr, colorAttr, false);
        }
        this.screen52.setScreenCharAndAttr(initChar, initAttr, true);
    }

    private void defineSelectionField(int majLen) {
        try {
            byte flag1 = this.segment[this.pos++];
            byte flag2 = this.segment[this.pos++];
            byte flag3 = this.segment[this.pos++];
            byte typeSelection = this.segment[this.pos++];
            byte guiDevice = this.segment[this.pos++];
            byte withMnemonic = this.segment[this.pos++];
            byte noMnemonic = this.segment[this.pos++];
            ++this.pos;
            ++this.pos;
            byte cols = this.segment[this.pos++];
            byte rows = this.segment[this.pos++];
            byte maxColChoice = this.segment[this.pos++];
            byte padding = this.segment[this.pos++];
            byte numSepChar = this.segment[this.pos++];
            byte ctySepChar = this.segment[this.pos++];
            byte cancelAID = this.segment[this.pos++];
            int cnt = 0;
            int minLen = 0;
            majLen -= 21;
            this.log.debug(" row: " + this.screen52.getCurrentRow() + " col: " + this.screen52.getCurrentCol() + " type " + typeSelection + " gui " + guiDevice + " withMnemonic " + Integer.toHexString(withMnemonic & 0xF0) + " noMnemonic " + Integer.toHexString(noMnemonic & 0xF0) + " noMnemonic " + Integer.toBinaryString(noMnemonic) + " noMnemonicType " + Integer.toBinaryString(noMnemonic & 0xF0) + " noMnemonicSel " + Integer.toBinaryString(noMnemonic & 0xF) + " maxcols " + maxColChoice + " cols " + cols + " rows " + rows);
            byte rowCtr = 0;
            byte colCtr = 0;
            int chcRowStart = this.screen52.getCurrentRow();
            int chcColStart = this.screen52.getCurrentCol();
            int chcRow = chcRowStart;
            int chcCol = chcColStart;
            int chcPos = this.screen52.getPos(chcRow - 1, chcCol);
            int colAvail = 32;
            int colSelAvail = 32;
            int fld = 0;
            block6: do {
                minLen = this.segment[this.pos++];
                byte minType = this.segment[this.pos++];
                switch (minType) {
                    case 1: {
                        byte flagCP1 = this.segment[this.pos++];
                        ++this.pos;
                        colSelAvail = this.segment[this.pos++];
                        ++this.pos;
                        byte colSelCur = this.segment[this.pos++];
                        ++this.pos;
                        byte colSelNotAvail = this.segment[this.pos++];
                        ++this.pos;
                        colAvail = this.segment[this.pos++];
                        ++this.pos;
                        byte colSel = this.segment[this.pos++];
                        ++this.pos;
                        byte colNotAvail = this.segment[this.pos++];
                        ++this.pos;
                        byte colInd = this.segment[this.pos++];
                        ++this.pos;
                        byte colNotAvailInd = this.segment[this.pos++];
                        break;
                    }
                    case 16: {
                        cnt = 5;
                        byte flagCT1 = this.segment[this.pos++];
                        byte flagCT2 = this.segment[this.pos++];
                        byte flagCT3 = this.segment[this.pos++];
                        int mnemOffset = 0;
                        boolean aid = false;
                        boolean selected = false;
                        if ((flagCT1 & 0x40) == 64) {
                            this.log.debug(" selected ");
                            selected = true;
                        }
                        if ((flagCT1 & 8) == 8) {
                            this.log.debug(" mnemOffset " + mnemOffset);
                            mnemOffset = this.segment[this.pos++];
                            ++cnt;
                        }
                        if ((flagCT1 & 4) == 4) {
                            aid = true;
                            this.log.debug(" aidKey " + aid);
                        }
                        if ((flagCT1 & 1) == 1) {
                            this.log.debug(" single digit ");
                            ++this.pos;
                            ++cnt;
                        }
                        if ((flagCT1 & 2) == 2) {
                            this.log.debug(" double digit ");
                            ++this.pos;
                            ++cnt;
                        }
                        String s = "";
                        byte byte0 = 0;
                        ++fld;
                        this.screen52.setCursor(chcRowStart, chcColStart);
                        if ((flagCT1 & 0x80) != 128) {
                            this.screen52.addField(38, 1, 0, 0, 0, 0);
                            this.screen52.getScreenFields().getCurrentField().setFieldChar('.');
                            this.screen52.getScreenFields().getCurrentField().setSelectionFieldInfo(17, fld, chcPos);
                            this.screen52.setCursor(chcRowStart, chcColStart + 3);
                            while (cnt < minLen) {
                                byte0 = this.segment[this.pos++];
                                s = s + this.vt.codePage.ebcdic2uni(byte0);
                                this.screen52.setChar(this.vt.codePage.ebcdic2uni(byte0));
                                ++cnt;
                            }
                            this.addChoiceField(chcRowStart, chcColStart, chcRow, chcCol, s);
                        }
                        this.log.debug(s + " selected " + selected);
                        if (++colCtr >= maxColChoice) {
                            colCtr = 0;
                            chcColStart = chcCol;
                            chcRowStart = chcRow + ++rowCtr;
                            if (rowCtr <= rows) continue block6;
                            chcRowStart = chcRow;
                            rowCtr = 0;
                            chcColStart = chcColStart + 3 + cols + padding;
                            break;
                        }
                        chcColStart = chcColStart + padding + cols + 3;
                        break;
                    }
                    default: {
                        for (cnt = 2; cnt < minLen; ++cnt) {
                            ++this.pos;
                        }
                    }
                }
            } while ((majLen -= minLen) > 0);
        }
        catch (Exception exc) {
            this.log.warn(" defineSelectionField :", exc);
            exc.printStackTrace();
        }
    }

    protected class Window {
        byte[] window;
        int pos;

        Window(byte[] seg, int pos) {
            this.window = seg;
            this.pos = pos;
            WTDSFParser.this.guiStructsExist = true;
        }
    }

    protected class ChoiceField {
        int x;
        int y;
        int row;
        int col;
        int width;
        int height;
        char mnemonic;
        int fieldId;
        int selectIndex;

        ChoiceField(int row, int col, int fldRow, int fldCol) {
            this.x = row;
            this.y = col;
            this.row = fldRow;
            this.col = fldCol;
        }
    }
}

