/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.SSLSocket;
import javax.swing.SwingUtilities;
import org.tn5250j.Session5250;
import org.tn5250j.encoding.CharMappings;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.DataStreamProducer;
import org.tn5250j.framework.tn5250.KbdTypesCodePages;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenField;
import org.tn5250j.framework.tn5250.ScreenPlanes;
import org.tn5250j.framework.tn5250.Stream5250;
import org.tn5250j.framework.tn5250.WTDSFParser;
import org.tn5250j.framework.transport.SocketConnector;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public final class tnvt
implements Runnable {
    private static final byte IAC = -1;
    private static final byte DONT = -2;
    private static final byte DO = -3;
    private static final byte WONT = -4;
    private static final byte WILL = -5;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte EOR = -17;
    private static final byte TERMINAL_TYPE = 24;
    private static final byte OPT_END_OF_RECORD = 25;
    private static final byte TRANSMIT_BINARY = 0;
    private static final byte QUAL_IS = 0;
    private static final byte TIMING_MARK = 6;
    private static final byte NEW_ENVIRONMENT = 39;
    private static final byte IS = 0;
    private static final byte SEND = 1;
    private static final byte INFO = 2;
    private static final byte VAR = 0;
    private static final byte VALUE = 1;
    private static final byte NEGOTIATE_ESC = 2;
    private static final byte USERVAR = 3;
    private static final byte ESC = 4;
    private static final int PCCMD_MAX_LENGTH = 123;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private Socket sock;
    private BufferedInputStream bin;
    private BufferedOutputStream bout;
    private final BlockingQueue<Object> dsq = new ArrayBlockingQueue<Object>(25);
    private Stream5250 bk;
    private DataStreamProducer producer;
    protected Screen5250 screen52;
    private boolean waitingForInput;
    private Thread me;
    private Thread pthread;
    private int readType;
    private boolean enhanced = true;
    private Session5250 controller;
    private boolean cursorOn = false;
    private String session = "";
    private int port = 23;
    private boolean connected = false;
    private boolean support132 = true;
    private ByteArrayOutputStream baosp = null;
    private ByteArrayOutputStream baosrsp = null;
    private int devSeq = -1;
    private String devName;
    private String devNameUsed;
    private KbdTypesCodePages kbdTypesCodePage;
    private boolean scan;
    private static int STRSCAN = 1;
    private boolean strpccmd;
    private String user;
    private String password;
    private String library;
    private String initialMenu;
    private String program;
    private boolean keepTrucking = true;
    private boolean pendingUnlock = false;
    private boolean[] dataIncluded;
    protected ICodePage codePage;
    private boolean firstScreen;
    private String sslType;
    private WTDSFParser sfParser;

    public tnvt(Session5250 session, Screen5250 screen52, boolean type, boolean support132) {
        this.controller = session;
        if (this.log.isInfoEnabled()) {
            this.log.info(" new session -> " + this.controller.getSessionName());
        }
        this.enhanced = type;
        this.support132 = support132;
        this.setCodePage("37");
        this.screen52 = screen52;
        this.dataIncluded = new boolean[24];
        if (System.getProperties().containsKey("SESSION_CONNECT_USER")) {
            this.user = System.getProperties().getProperty("SESSION_CONNECT_USER");
            if (System.getProperties().containsKey("SESSION_CONNECT_PASSWORD")) {
                this.password = System.getProperties().getProperty("SESSION_CONNECT_PASSWORD");
            }
            if (System.getProperties().containsKey("SESSION_CONNECT_LIBRARY")) {
                this.library = System.getProperties().getProperty("SESSION_CONNECT_LIBRARY");
            }
            if (System.getProperties().containsKey("SESSION_CONNECT_MENU")) {
                this.initialMenu = System.getProperties().getProperty("SESSION_CONNECT_MENU");
            }
            if (System.getProperties().containsKey("SESSION_CONNECT_PROGRAM")) {
                this.program = System.getProperties().getProperty("SESSION_CONNECT_PROGRAM");
            }
        }
        this.baosp = new ByteArrayOutputStream();
        this.baosrsp = new ByteArrayOutputStream();
    }

    public String getHostName() {
        return this.session;
    }

    public void setSSLType(String type) {
        this.sslType = type;
    }

    public void setDeviceName(String name) {
        this.devName = name;
    }

    public String getDeviceName() {
        return this.devName;
    }

    public String getAllocatedDeviceName() {
        return this.devNameUsed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSslSocket() {
        return this.connected && this.sock != null && this.sock instanceof SSLSocket;
    }

    public final void setProxy(String proxyHost, String proxyPort) {
        Properties systemProperties = System.getProperties();
        systemProperties.put("socksProxySet", "true");
        systemProperties.put("socksProxyHost", proxyHost);
        systemProperties.put("socksProxyPort", proxyPort);
        System.setProperties(systemProperties);
        this.log.info(" socks set ");
    }

    public final boolean connect() {
        return this.connect(this.session, this.port);
    }

    public final boolean connect(String s, int port) {
        Properties props = this.controller.getConnectionProperties();
        if (this.user == null && props.containsKey("SESSION_CONNECT_USER")) {
            this.user = props.getProperty("SESSION_CONNECT_USER");
            this.log.info(" user -> " + this.user + " " + this.controller.getSessionName());
            if (props.containsKey("SESSION_CONNECT_PASSWORD")) {
                this.password = props.getProperty("SESSION_CONNECT_PASSWORD");
            }
            if (props.containsKey("SESSION_CONNECT_LIBRARY")) {
                this.library = props.getProperty("SESSION_CONNECT_LIBRARY");
            }
            if (props.containsKey("SESSION_CONNECT_MENU")) {
                this.initialMenu = props.getProperty("SESSION_CONNECT_MENU");
            }
            if (props.containsKey("SESSION_CONNECT_PROGRAM")) {
                this.program = props.getProperty("SESSION_CONNECT_PROGRAM");
            }
        }
        try {
            byte[] abyte0;
            this.session = s;
            this.port = port;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tnvt.this.screen52.getOIA().setInputInhibited(1, 1, "X - Connecting");
                    }
                });
            }
            catch (Exception exc) {
                this.log.warn("setStatus(ON) " + exc.getMessage());
            }
            SocketConnector sc = new SocketConnector();
            if (this.sslType != null) {
                sc.setSSLType(this.sslType);
            }
            this.sock = sc.createSocket(s, port);
            if (this.sock == null) {
                this.log.warn("I did not get a socket");
                this.disconnect();
                return false;
            }
            this.connected = true;
            this.sock.setKeepAlive(true);
            this.sock.setTcpNoDelay(true);
            this.sock.setSoLinger(false, 0);
            InputStream in = this.sock.getInputStream();
            OutputStream out = this.sock.getOutputStream();
            this.bin = new BufferedInputStream(in, 8192);
            this.bout = new BufferedOutputStream(out);
            while (this.negotiate(abyte0 = this.readNegotiations())) {
            }
            try {
                this.screen52.setCursorActive(false);
            }
            catch (Exception excc) {
                this.log.warn("setCursorOff " + excc.getMessage());
            }
            this.producer = new DataStreamProducer(this, this.bin, this.dsq, abyte0);
            this.pthread = new Thread(this.producer);
            this.pthread.setPriority(5);
            this.pthread.start();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tnvt.this.screen52.getOIA().setInputInhibited(0, 1);
                    }
                });
            }
            catch (Exception exc) {
                this.log.warn("setStatus(OFF) " + exc.getMessage());
            }
            this.keepTrucking = true;
            this.me = new Thread(this);
            this.me.start();
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                exception.printStackTrace();
            }
            this.log.warn("connect() " + exception.getMessage());
            if (this.sock == null) {
                this.log.warn("I did not get a socket");
            }
            this.disconnect();
            return false;
        }
        return true;
    }

    public final boolean disconnect() {
        if (!this.connected) {
            this.screen52.getOIA().setInputInhibited(1, 1, "X - Disconnected");
            return false;
        }
        if (this.me != null && this.me.isAlive()) {
            this.me.interrupt();
            this.keepTrucking = false;
            this.pthread.interrupt();
        }
        this.screen52.getOIA().setInputInhibited(1, 1, "X - Disconnected");
        this.screen52.getOIA().setKeyBoardLocked(false);
        this.pendingUnlock = false;
        try {
            if (this.sock != null) {
                this.log.info("Closing socket");
                this.sock.close();
            }
            if (this.bin != null) {
                this.bin.close();
            }
            if (this.bout != null) {
                this.bout.close();
            }
            this.connected = false;
            this.firstScreen = false;
            this.screen52.goto_XY(0);
            this.screen52.setCursorActive(false);
            this.screen52.clearAll();
            this.screen52.restoreScreen();
            this.controller.fireSessionChanged(0);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage());
            this.connected = false;
            this.devSeq = -1;
            return false;
        }
        this.devSeq = -1;
        return true;
    }

    private final ByteArrayOutputStream appendByteStream(byte[] abyte0) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        for (int i = 0; i < abyte0.length; ++i) {
            bytearrayoutputstream.write(abyte0[i]);
            if (abyte0[i] != -1) continue;
            bytearrayoutputstream.write(-1);
        }
        return bytearrayoutputstream;
    }

    private final byte[] readNegotiations() throws IOException {
        int i = this.bin.read();
        if (i < 0) {
            throw new IOException("Connection closed.");
        }
        int j = this.bin.available();
        byte[] abyte0 = new byte[j + 1];
        abyte0[0] = (byte)i;
        this.bin.read(abyte0, 1, j);
        return abyte0;
    }

    private final void writeByte(byte[] abyte0) throws IOException {
        this.bout.write(abyte0);
        this.bout.flush();
    }

    public final void sendHeartBeat() throws IOException {
        byte[] b = new byte[]{-1, -15};
        this.bout.write(b);
        this.bout.flush();
    }

    private final void readImmediate(int readType) {
        if (this.screen52.isStatusErrorCode()) {
            this.screen52.restoreErrorLine();
            this.screen52.setStatus((byte)2, (byte)2, null);
        }
        if (!this.enhanced) {
            this.screen52.setCursorActive(false);
        }
        this.screen52.getOIA().setInputInhibited(1, 1);
        this.screen52.getOIA().setKeyBoardLocked(true);
        this.pendingUnlock = false;
        this.screen52.getScreenFields().readFormatTable(this.baosp, readType, this.codePage);
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
            this.baosp.reset();
        }
        this.baosp.reset();
    }

    public final boolean sendAidKey(int aid) {
        if (this.screen52.isStatusErrorCode()) {
            this.screen52.restoreErrorLine();
            this.screen52.setStatus((byte)2, (byte)2, null);
        }
        if (!this.enhanced) {
            this.screen52.setCursorActive(false);
        }
        this.screen52.getOIA().setInputInhibited(1, 1);
        this.screen52.getOIA().setKeyBoardLocked(true);
        this.pendingUnlock = false;
        this.baosp.write(this.screen52.getCurrentRow());
        this.baosp.write(this.screen52.getCurrentCol());
        this.baosp.write(aid);
        if (this.dataIncluded(aid)) {
            this.screen52.getScreenFields().readFormatTable(this.baosp, this.readType, this.codePage);
        }
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
            this.baosp.reset();
            return false;
        }
        this.baosp.reset();
        return true;
    }

    private boolean dataIncluded(int aid) {
        switch (aid) {
            case 49: {
                return !this.dataIncluded[0];
            }
            case 50: {
                return !this.dataIncluded[1];
            }
            case 51: {
                return !this.dataIncluded[2];
            }
            case 52: {
                return !this.dataIncluded[3];
            }
            case 53: {
                return !this.dataIncluded[4];
            }
            case 54: {
                return !this.dataIncluded[5];
            }
            case 55: {
                return !this.dataIncluded[6];
            }
            case 56: {
                return !this.dataIncluded[7];
            }
            case 57: {
                return !this.dataIncluded[8];
            }
            case 58: {
                return !this.dataIncluded[9];
            }
            case 59: {
                return !this.dataIncluded[10];
            }
            case 60: {
                return !this.dataIncluded[11];
            }
            case 177: {
                return !this.dataIncluded[12];
            }
            case 178: {
                return !this.dataIncluded[13];
            }
            case 179: {
                return !this.dataIncluded[14];
            }
            case 180: {
                return !this.dataIncluded[15];
            }
            case 181: {
                return !this.dataIncluded[16];
            }
            case 182: {
                return !this.dataIncluded[17];
            }
            case 183: {
                return !this.dataIncluded[18];
            }
            case 184: {
                return !this.dataIncluded[19];
            }
            case 185: {
                return !this.dataIncluded[20];
            }
            case 186: {
                return !this.dataIncluded[21];
            }
            case 187: {
                return !this.dataIncluded[22];
            }
            case 188: {
                return !this.dataIncluded[23];
            }
        }
        return true;
    }

    public final void sendHelpRequest() {
        this.baosp.write(this.screen52.getCurrentRow());
        this.baosp.write(this.screen52.getCurrentCol());
        this.baosp.write(243);
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
        this.baosp.reset();
    }

    public final void sendAttentionKey() {
        try {
            this.writeGDS(64, 0, null);
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
    }

    public final void systemRequest() {
        String sysreq = this.controller.showSystemRequest();
        this.systemRequest(sysreq);
    }

    public final void systemRequest(char sr) {
        this.systemRequest(Character.toString(sr));
    }

    public final void systemRequest(String sr) {
        byte[] bytes = null;
        if (sr != null && sr.length() > 0) {
            if (sr.charAt(0) == '2') {
                this.dsq.clear();
            }
            int l = sr.length();
            for (int i = 0; i < l; ++i) {
                this.baosp.write(this.codePage.uni2ebcdic(sr.charAt(i)));
            }
            bytes = this.baosp.toByteArray();
        }
        try {
            this.writeGDS(4, 0, bytes);
        }
        catch (IOException ioe) {
            this.log.info(ioe.getMessage());
        }
        this.baosp.reset();
    }

    public final void cancelInvite() {
        this.screen52.getOIA().setInputInhibited(1, 1);
        try {
            this.writeGDS(0, 10, null);
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
    }

    public final void hostPrint(int aid) {
        if (this.screen52.isStatusErrorCode()) {
            this.screen52.restoreErrorLine();
            this.screen52.setStatus((byte)2, (byte)2, null);
        }
        this.screen52.setCursorActive(false);
        this.screen52.getOIA().setInputInhibited(1, 1);
        this.baosp.write(this.screen52.getCurrentRow());
        this.baosp.write(this.screen52.getCurrentCol());
        this.baosp.write(246);
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
        this.baosp.reset();
    }

    public final void toggleDebug() {
        this.producer.toggleDebug(this.codePage);
    }

    private final void writeGDS(int flags, int opcode, byte[] abyte0) throws IOException {
        if (this.bout == null) {
            return;
        }
        int length = abyte0 != null ? abyte0.length + 10 : 10;
        this.baosrsp.write(length >> 8);
        this.baosrsp.write(length & 0xFF);
        this.baosrsp.write(18);
        this.baosrsp.write(160);
        this.baosrsp.write(0);
        this.baosrsp.write(0);
        this.baosrsp.write(4);
        this.baosrsp.write(flags);
        this.baosrsp.write(0);
        this.baosrsp.write(opcode);
        if (abyte0 != null) {
            this.baosrsp.write(abyte0, 0, abyte0.length);
        }
        this.baosrsp = this.appendByteStream(this.baosrsp.toByteArray());
        this.baosrsp.write(-1);
        this.baosrsp.write(-17);
        this.baosrsp.writeTo(this.bout);
        this.bout.flush();
        this.baosrsp.reset();
    }

    protected final int getOpCode() {
        return this.bk.getOpCode();
    }

    protected boolean[] getActiveAidKeys() {
        boolean[] aids = new boolean[this.dataIncluded.length];
        System.arraycopy(this.dataIncluded, 0, aids, 0, this.dataIncluded.length);
        return aids;
    }

    private final void setInvited() {
        this.log.debug("invited");
        if (!this.screen52.isStatusErrorCode()) {
            this.screen52.getOIA().setInputInhibited(0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strpccmd() {
        try {
            int str = 11;
            int offset = str + 1;
            ScreenPlanes planes = this.screen52.getPlanes();
            char c = planes.getChar(str);
            boolean waitFor = c != 'a';
            StringBuilder command = new StringBuilder();
            for (int i = offset; i < offset + 123; ++i) {
                c = planes.getChar(i);
                if (Character.isISOControl(c)) {
                    c = ' ';
                }
                command.append(c);
            }
            this.run(command.toString().trim(), waitFor);
        }
        finally {
            this.strpccmd = false;
            this.screen52.sendKeys(KeyMnemonic.ENTER);
        }
    }

    private void run(String cmd, boolean waitFor) {
        try {
            this.log.debug("RUN cmd = " + cmd);
            this.log.debug("RUN wait = " + waitFor);
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(cmd);
            if (waitFor) {
                int result = p.waitFor();
                this.log.debug("RUN result = " + result);
            }
        }
        catch (Throwable t) {
            this.log.error(t);
        }
    }

    public void setScanningEnabled(boolean scan) {
        this.scan = scan;
    }

    public boolean isScanningEnabled() {
        return this.scan;
    }

    private void scan() {
        ScreenPlanes planes = this.screen52.getPlanes();
        if (planes.getChar(STRSCAN) == '#' && planes.getChar(STRSCAN + 1) == '!' && planes.getChar(STRSCAN + 2) != ' ') {
            try {
                this.parseCommand();
            }
            catch (Throwable t) {
                this.log.info("Exec cmd: " + t.getMessage());
                t.printStackTrace();
            }
        }
    }

    private void parseCommand() {
        int s;
        char[] screen = this.screen52.getScreenAsAllChars();
        for (int i = s = STRSCAN + 2; i < screen.length; ++i) {
            if (screen[i] != ' ') continue;
            String command = new String(screen, s, i - s);
            String remainder = new String(screen, i + 1, screen.length - (i + 1));
            this.controller.fireScanned(command, remainder);
            break;
        }
    }

    @Override
    public void run() {
        if (this.enhanced) {
            this.sfParser = new WTDSFParser(this);
        }
        this.bk = new Stream5250();
        while (this.keepTrucking) {
            try {
                this.bk.initialize((byte[])this.dsq.take());
            }
            catch (InterruptedException ie) {
                this.log.warn("   vt thread interrupted and stopping ");
                this.keepTrucking = false;
                continue;
            }
            Thread.yield();
            this.screen52.setCursorActive(false);
            if (this.bk == null) continue;
            switch (this.bk.getOpCode()) {
                case 0: {
                    this.log.debug("No operation");
                    break;
                }
                case 1: {
                    this.log.debug("Invite Operation");
                    this.parseIncoming();
                    this.pendingUnlock = true;
                    this.cursorOn = true;
                    this.setInvited();
                    break;
                }
                case 2: {
                    this.log.debug("Output Only");
                    this.parseIncoming();
                    this.screen52.updateDirty();
                    break;
                }
                case 3: {
                    this.log.debug("Put/Get Operation");
                    this.parseIncoming();
                    this.setInvited();
                    if (this.firstScreen) break;
                    this.firstScreen = true;
                    this.controller.fireSessionChanged(1);
                    break;
                }
                case 4: {
                    this.log.debug("Save Screen Operation");
                    this.parseIncoming();
                    break;
                }
                case 5: {
                    this.log.debug("Restore Screen Operation");
                    this.parseIncoming();
                    break;
                }
                case 6: {
                    this.log.debug("Read Immediate");
                    this.sendAidKey(0);
                    break;
                }
                case 7: {
                    this.log.debug("Reserved");
                    break;
                }
                case 8: {
                    this.log.debug("Read Screen Operation");
                    try {
                        this.readScreen();
                    }
                    catch (IOException ex) {
                        this.log.warn(ex.getMessage());
                    }
                    break;
                }
                case 9: {
                    this.log.debug("Reserved");
                    break;
                }
                case 10: {
                    this.log.debug("Cancel Invite Operation");
                    this.cancelInvite();
                    break;
                }
                case 11: {
                    this.log.debug("Turn on message light");
                    this.screen52.getOIA().setMessageLightOn();
                    this.screen52.setCursorActive(true);
                    break;
                }
                case 12: {
                    this.log.debug("Turn off Message light");
                    this.screen52.getOIA().setMessageLightOff();
                    this.screen52.setCursorActive(true);
                    break;
                }
            }
            if (this.screen52.isUsingGuiInterface()) {
                this.screen52.drawFields();
            }
            try {
                if (!this.strpccmd) {
                    this.screen52.updateDirty();
                } else {
                    this.strpccmd();
                }
            }
            catch (RuntimeException e) {
                this.log.warn("tnvt.run: ", e);
            }
            if (this.pendingUnlock && !this.screen52.isStatusErrorCode()) {
                this.screen52.getOIA().setKeyBoardLocked(false);
                this.pendingUnlock = false;
            }
            if (this.cursorOn && !this.screen52.getOIA().isKeyBoardLocked()) {
                this.screen52.setCursorActive(true);
                this.cursorOn = false;
            }
            Thread.yield();
        }
    }

    private final void readScreen() throws IOException {
        int rows = this.screen52.getRows();
        int cols = this.screen52.getColumns();
        byte[] screenArray = new byte[rows * cols];
        this.fillScreenArray(screenArray);
        this.writeGDS(0, 0, screenArray);
    }

    private final void fillScreenArray(byte[] sa) {
        int lastAttr = 32;
        int sac = 0;
        ScreenPlanes planes = this.screen52.planes;
        for (int i = 0; i < sa.length; ++i) {
            if (planes.isAttributePlace(i)) {
                lastAttr = planes.getCharAttr(i);
                sa[sac++] = (byte)lastAttr;
                continue;
            }
            if (planes.getCharAttr(i) != lastAttr) {
                lastAttr = planes.getCharAttr(i);
                --sac;
                sac = Math.max(sac, 0);
                sa[sac++] = (byte)lastAttr;
            }
            char ch = planes.getChar(i);
            byte byteCh = (byte)ch;
            if (this.isDataUnicode(ch)) {
                byteCh = this.codePage.uni2ebcdic(ch);
            }
            sa[Math.min((int)sac++, (int)(sa.length - 1))] = byteCh;
        }
    }

    private byte[] createRegenerationBuffer(int len) throws IOException {
        int la = 32;
        int sac = 0;
        ScreenPlanes planes = this.screen52.planes;
        byte[] sa = new byte[len];
        try {
            boolean guiExists = this.sfParser != null && this.sfParser.isGuisExists();
            for (int i = 0; i < len; ++i) {
                byte[] guiSeg;
                if (guiExists && (guiSeg = this.sfParser.getSegmentAtPos(i)) != null) {
                    byte[] gsa = new byte[sa.length + guiSeg.length + 2];
                    System.arraycopy(sa, 0, gsa, 0, sa.length);
                    System.arraycopy(guiSeg, 0, gsa, sac + 2, guiSeg.length);
                    sa = new byte[gsa.length];
                    System.arraycopy(gsa, 0, sa, 0, gsa.length);
                    sa[sac++] = 4;
                    sa[sac++] = 17;
                    sac += guiSeg.length;
                }
                if (planes.isAttributePlace(i)) {
                    la = planes.getCharAttr(i);
                    sa[sac++] = (byte)la;
                    continue;
                }
                if (planes.getCharAttr(i) != la) {
                    la = planes.getCharAttr(i);
                    --sac;
                    sac = Math.max(sac, 0);
                    sa[sac++] = (byte)la;
                }
                char ch = planes.getChar(i);
                byte byteCh = (byte)ch;
                if (this.isDataUnicode(ch)) {
                    byteCh = this.codePage.uni2ebcdic(ch);
                }
                sa[Math.min((int)sac++, (int)(len - 1))] = byteCh;
            }
        }
        catch (Exception e) {
            this.log.warn("Error, while filling the screen array. TN5250j will continue to operate, but screen may be displayed wrong.", e);
        }
        return sa;
    }

    public final void saveScreen() throws IOException {
        ByteArrayOutputStream sc = new ByteArrayOutputStream();
        sc.write(new byte[]{4, 18, 0, 0});
        sc.write((byte)this.screen52.getRows());
        sc.write((byte)this.screen52.getColumns());
        int cp = this.screen52.getCurrentPos();
        sc.write((byte)(cp >> 8 & 0xFF));
        sc.write((byte)(cp & 0xFF));
        sc.write((byte)(this.screen52.homePos >> 8 & 0xFF));
        sc.write((byte)(this.screen52.homePos & 0xFF));
        sc.write(this.createRegenerationBuffer(this.screen52.getRows() * this.screen52.getColumns()));
        int sizeFields = this.screen52.getScreenFields().getSize();
        sc.write((byte)(sizeFields >> 8 & 0xFF));
        sc.write((byte)(sizeFields & 0xFF));
        if (sizeFields > 0) {
            int s = this.screen52.getScreenFields().getSize();
            for (int x = 0; x < s; ++x) {
                ScreenField sf = this.screen52.getScreenFields().getField(x);
                sc.write((byte)sf.getAttr());
                int sp = sf.startPos();
                sc.write((byte)(sp >> 8 & 0xFF));
                sc.write((byte)(sp & 0xFF));
                if (sf.mdt) {
                    sc.write(1);
                } else {
                    sc.write(0);
                }
                sc.write((byte)(sf.getLength() >> 8 & 0xFF));
                sc.write((byte)(sf.getLength() & 0xFF));
                sc.write((byte)sf.getFFW1() & 0xFF);
                sc.write((byte)sf.getFFW2() & 0xFF);
                sc.write((byte)sf.getFCW1() & 0xFF);
                sc.write((byte)sf.getFCW2() & 0xFF);
                this.log.debug("Saved ");
                this.log.debug(sf.toString());
            }
        }
        try {
            this.writeGDS(0, 3, sc.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
        this.log.debug("Save Screen end ");
    }

    public final void restoreScreen() throws IOException {
        int which = 0;
        ScreenPlanes planes = this.screen52.planes;
        try {
            this.log.debug("Restore ");
            this.bk.getNextByte();
            this.bk.getNextByte();
            int rows = this.bk.getNextByte() & 0xFF;
            int cols = this.bk.getNextByte() & 0xFF;
            int pos = this.bk.getNextByte() << 8 & 0xFF00;
            pos |= this.bk.getNextByte() & 0xFF;
            int hPos = this.bk.getNextByte() << 8 & 0xFF00;
            hPos |= this.bk.getNextByte() & 0xFF;
            if (rows != this.screen52.getRows()) {
                this.screen52.setRowsCols(rows, cols);
            }
            this.screen52.clearAll();
            if (this.sfParser != null && this.sfParser.isGuisExists()) {
                this.sfParser.clearGuiStructs();
            }
            int b = 32;
            int la = 32;
            int len = rows * cols;
            for (int y = 0; y < len; ++y) {
                b = this.bk.getNextByte();
                if (b == 4) {
                    this.log.info(" gui restored at " + y + " - " + this.screen52.getRow(y) + "," + this.screen52.getCol(y));
                    byte command = this.bk.getNextByte();
                    byte[] seg = this.bk.getSegment();
                    if (seg.length > 0) {
                        this.screen52.goto_XY(y);
                        this.sfParser.parseWriteToDisplayStructuredField(seg);
                    }
                    --y;
                    continue;
                }
                if (planes.isUseGui(y)) continue;
                if (this.isAttribute(b)) {
                    planes.setScreenCharAndAttr(y, planes.getChar(y), b, true);
                    la = b;
                    continue;
                }
                char ch = (char)b;
                if (this.isDataEBCDIC(b)) {
                    ch = this.codePage.ebcdic2uni(b);
                }
                planes.setScreenCharAndAttr(y, ch, la, false);
            }
            int numFields = this.bk.getNextByte() << 8 & 0xFF00;
            this.log.debug("number of fields " + (numFields |= this.bk.getNextByte() & 0xFF));
            if (numFields > 0) {
                byte attr = 0;
                int fPos = 0;
                int fLen = 0;
                byte ffw1 = 0;
                byte ffw2 = 0;
                byte fcw1 = 0;
                byte fcw2 = 0;
                boolean mdt = false;
                ScreenField sf = null;
                for (int x = 0; x < numFields; ++x) {
                    attr = this.bk.getNextByte();
                    fPos = this.bk.getNextByte() << 8 & 0xFF00;
                    fPos |= this.bk.getNextByte() & 0xFF;
                    mdt = this.bk.getNextByte() == 1;
                    fLen = this.bk.getNextByte() << 8 & 0xFF00;
                    ffw1 = this.bk.getNextByte();
                    ffw2 = this.bk.getNextByte();
                    fcw1 = this.bk.getNextByte();
                    fcw2 = this.bk.getNextByte();
                    sf = this.screen52.getScreenFields().setField(attr, this.screen52.getRow(fPos), this.screen52.getCol(fPos), fLen |= this.bk.getNextByte() & 0xFF, ffw1, ffw2, fcw1, fcw2);
                    while (fLen-- > 0) {
                        planes.setScreenFieldAttr(fPos++, ffw1);
                    }
                    if (mdt) {
                        sf.setMDT();
                        this.screen52.getScreenFields().setMasterMDT();
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("/nRestored ");
                    this.log.debug(sf.toString());
                }
            }
            if (this.screen52.isUsingGuiInterface()) {
                this.screen52.drawFields();
            }
            this.screen52.restoreScreen();
            this.screen52.setPendingInsert(true, this.screen52.getRow(pos + cols), this.screen52.getCol(pos + cols));
            this.screen52.goto_XY(pos - 1);
            this.screen52.isInField();
        }
        catch (Exception e) {
            this.log.warn("error restoring screen " + which + " with " + e.getMessage());
        }
    }

    public final boolean waitingForInput() {
        return this.waitingForInput;
    }

    private void parseIncoming() {
        boolean done = false;
        boolean error = false;
        try {
            while (this.bk.hasNext() && !done) {
                byte b = this.bk.getNextByte();
                switch (b) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.log.debug("save screen partial");
                        this.saveScreen();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 7: {
                        this.controller.signalBell();
                        this.bk.getNextByte();
                        this.bk.getNextByte();
                        break;
                    }
                    case 17: {
                        error = this.writeToDisplay(true);
                        if (!this.scan) break;
                        this.scan();
                        break;
                    }
                    case 13: 
                    case 18: {
                        this.log.debug("restore screen partial");
                        this.restoreScreen();
                        break;
                    }
                    case 32: {
                        byte param = this.bk.getNextByte();
                        if (param != 0) {
                            this.log.debug(" clear unit alternate error " + Integer.toHexString(param));
                            this.sendNegResponse(16, 3, 1, 5, " clear unit alternate not supported");
                            done = true;
                            break;
                        }
                        if (this.screen52.getRows() != 27) {
                            this.screen52.setRowsCols(27, 132);
                        }
                        this.screen52.clearAll();
                        if (this.sfParser == null || !this.sfParser.isGuisExists()) break;
                        this.sfParser.clearGuiStructs();
                        break;
                    }
                    case 33: {
                        this.writeErrorCode();
                        error = this.writeToDisplay(false);
                        break;
                    }
                    case 34: {
                        this.writeErrorCodeToWindow();
                        error = this.writeToDisplay(false);
                        break;
                    }
                    case 98: 
                    case 102: {
                        this.readScreen();
                        break;
                    }
                    case 64: {
                        if (this.screen52.getRows() != 24) {
                            this.screen52.setRowsCols(24, 80);
                        }
                        this.screen52.clearAll();
                        if (this.sfParser == null || !this.sfParser.isGuisExists()) break;
                        this.sfParser.clearGuiStructs();
                        break;
                    }
                    case 80: {
                        this.screen52.clearTable();
                        break;
                    }
                    case 66: 
                    case 82: {
                        this.bk.getNextByte();
                        this.bk.getNextByte();
                        this.readType = b;
                        this.screen52.goHome();
                        this.waitingForInput = true;
                        this.pendingUnlock = true;
                        break;
                    }
                    case -125: {
                        this.readType = b;
                        this.readImmediate(this.readType);
                        break;
                    }
                    case -13: {
                        this.writeStructuredField();
                        break;
                    }
                    case 35: {
                        byte updown = this.bk.getNextByte();
                        byte topline = this.bk.getNextByte();
                        byte bottomline = this.bk.getNextByte();
                        this.screen52.rollScreen(updown, topline, bottomline);
                        break;
                    }
                    default: {
                        done = true;
                        this.sendNegResponse(16, 3, 1, 1, "parseIncoming");
                    }
                }
                if (!error) continue;
                done = true;
            }
        }
        catch (Exception exc) {
            this.log.warn("incoming " + exc.getMessage());
        }
    }

    protected void sendNegResponse(int cat, int modifier, int uByte1, int uByte2, String from) {
        try {
            int os = this.bk.getByteOffset(-1) & 0xF0;
            int cp = this.bk.getCurrentPos() - 1;
            this.log.info("invalid " + from + " command " + os + " at pos " + cp);
        }
        catch (Exception e) {
            this.log.warn("Send Negative Response error " + e.getMessage());
        }
        this.baosp.write(cat);
        this.baosp.write(modifier);
        this.baosp.write(uByte1);
        this.baosp.write(uByte2);
        try {
            this.writeGDS(128, 0, this.baosp.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
        this.baosp.reset();
    }

    public void sendNegResponse2(int ec) {
        this.screen52.setPrehelpState(true, true, false);
        this.baosp.write(0);
        this.baosp.write(ec);
        try {
            this.writeGDS(1, 0, this.baosp.toByteArray());
        }
        catch (IOException ioe) {
            this.log.warn(ioe.getMessage());
        }
        this.baosp.reset();
    }

    private boolean writeToDisplay(boolean controlsExist) {
        boolean error = false;
        boolean done = false;
        byte control1 = 0;
        int saRows = this.screen52.getRows();
        int saCols = this.screen52.getColumns();
        try {
            if (controlsExist) {
                byte control0 = this.bk.getNextByte();
                control1 = this.bk.getNextByte();
                this.processCC0(control0);
            }
            while (this.bk.hasNext() && !done) {
                byte bytebk = this.bk.getNextByte();
                switch (bytebk) {
                    case 1: {
                        this.log.debug("SOH - Start of Header Order");
                        error = this.processSOH();
                        break;
                    }
                    case 2: {
                        this.log.debug("RA - Repeat to address");
                        int row = this.screen52.getCurrentRow();
                        int col = this.screen52.getCurrentCol();
                        byte toRow = this.bk.getNextByte();
                        int toCol = this.bk.getNextByte() & 0xFF;
                        if (toRow >= row) {
                            char repeat = this.bk.getNextByte();
                            if (row == 1 && col == 2 && toRow == this.screen52.getRows() && toCol == this.screen52.getColumns()) {
                                this.screen52.clearScreen();
                                break;
                            }
                            if (repeat != '\u0000') {
                                repeat = this.codePage.ebcdic2uni(repeat);
                            }
                            int times = toRow * this.screen52.getColumns() + toCol - (row * this.screen52.getColumns() + col);
                            while (times-- >= 0) {
                                this.screen52.setChar(repeat);
                            }
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 35, " RA invalid");
                        error = true;
                        break;
                    }
                    case 3: {
                        this.log.debug("EA - Erase to address");
                        int EArow = this.screen52.getCurrentRow();
                        int EAcol = this.screen52.getCurrentCol();
                        byte toEARow = this.bk.getNextByte();
                        int toEACol = this.bk.getNextByte() & 0xFF;
                        int EALength = this.bk.getNextByte() & 0xFF;
                        while (--EALength > 0) {
                            this.bk.getNextByte();
                        }
                        int EAAttr = 0;
                        if (EArow == 1 && EAcol == 2 && toEARow == this.screen52.getRows() && toEACol == this.screen52.getColumns()) {
                            this.screen52.clearScreen();
                            break;
                        }
                        int times = toEARow * this.screen52.getColumns() + toEACol - (EArow * this.screen52.getColumns() + EAcol);
                        while (times-- >= 0) {
                            this.screen52.setChar(EAAttr);
                        }
                        break;
                    }
                    case 4: {
                        this.log.debug("Command - Escape");
                        done = true;
                        break;
                    }
                    case 16: {
                        this.log.debug("TD - Transparent Data");
                        int j = (this.bk.getNextByte() & 0xFF) << 8 | this.bk.getNextByte() & 0xFF;
                        break;
                    }
                    case 17: {
                        this.log.debug("SBA - set buffer address order (row column)");
                        byte saRow = this.bk.getNextByte();
                        int saCol = this.bk.getNextByte() & 0xFF;
                        if (saRow <= this.screen52.getRows() && saCol <= this.screen52.getColumns()) {
                            this.screen52.setCursor(saRow, saCol);
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 34, "invalid row/col order saRow = " + saRow + " saRows = " + this.screen52.getRows() + " saCol = " + saCol);
                        error = true;
                        break;
                    }
                    case 18: {
                        this.log.debug("WEA - Extended Attribute");
                        this.bk.getNextByte();
                        this.bk.getNextByte();
                        break;
                    }
                    case 19: {
                        this.log.debug("IC - Insert Cursor");
                        byte icX = this.bk.getNextByte();
                        int icY = this.bk.getNextByte() & 0xFF;
                        if (icX <= saRows && icY <= saCols) {
                            this.log.debug(" IC " + icX + " " + icY);
                            this.screen52.setPendingInsert(true, icX, icY);
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 34, " IC/IM position invalid ");
                        error = true;
                        break;
                    }
                    case 20: {
                        this.log.debug("MC - Move Cursor");
                        byte imcX = this.bk.getNextByte();
                        int imcY = this.bk.getNextByte() & 0xFF;
                        if (imcX <= saRows && imcY <= saCols) {
                            this.log.debug(" MC " + imcX + " " + imcY);
                            this.screen52.setPendingInsert(false, imcX, imcY);
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 34, " IC/IM position invalid ");
                        error = true;
                        break;
                    }
                    case 21: {
                        this.log.debug("WTDSF - Write To Display Structured Field order");
                        byte[] seg = this.bk.getSegment();
                        error = this.sfParser.parseWriteToDisplayStructuredField(seg);
                        break;
                    }
                    case 29: {
                        int attr;
                        this.log.debug("SF - Start of Field");
                        int fcw1 = 0;
                        int fcw2 = 0;
                        int ffw1 = 0;
                        int ffw0 = this.bk.getNextByte() & 0xFF;
                        if ((ffw0 & 0x40) == 64) {
                            ffw1 = this.bk.getNextByte() & 0xFF;
                            fcw1 = this.bk.getNextByte() & 0xFF;
                            if (fcw1 == 129) {
                                this.bk.getNextByte();
                                fcw1 = this.bk.getNextByte() & 0xFF;
                            }
                            if (!this.isAttribute(fcw1)) {
                                fcw2 = this.bk.getNextByte() & 0xFF;
                                attr = this.bk.getNextByte() & 0xFF;
                                while (!this.isAttribute(attr)) {
                                    this.log.info(Integer.toHexString(fcw1) + " " + Integer.toHexString(fcw2) + " ");
                                    this.log.info(Integer.toHexString(attr) + " " + Integer.toHexString(this.bk.getNextByte() & 0xFF));
                                    attr = this.bk.getNextByte() & 0xFF;
                                }
                            } else {
                                attr = fcw1;
                                fcw1 = 0;
                            }
                        } else {
                            attr = ffw0;
                        }
                        int fLength = (this.bk.getNextByte() & 0xFF) << 8 | this.bk.getNextByte() & 0xFF;
                        this.screen52.addField(attr, fLength, ffw0, ffw1, fcw1, fcw2);
                        break;
                    }
                    case -128: {
                        int i;
                        this.log.debug("STRPCCMD got a -128 command at " + this.screen52.getCurrentPos());
                        StringBuilder value = new StringBuilder();
                        int[] pco = new int[9];
                        int[] pcoOk = new int[]{252, 215, 195, 214, 64, 131, 128, 161, 128};
                        for (i = 0; i < 9; ++i) {
                            byte b = this.bk.getNextByte();
                            pco[i] = b & 0xFF;
                            char c = this.codePage.ebcdic2uni(b);
                            value.append(c);
                        }
                        if (Arrays.equals(pco, pcoOk)) {
                            this.strpccmd = true;
                        }
                        for (i = 0; i < 9; ++i) {
                            this.bk.setPrevByte();
                        }
                    }
                    default: {
                        byte byte0 = this.bk.getByteOffset(-1);
                        if (this.isAttribute(byte0)) {
                            this.screen52.setAttr(byte0);
                            break;
                        }
                        if (!this.screen52.isStatusErrorCode()) {
                            if (!this.isDataEBCDIC(byte0)) {
                                this.screen52.setChar(byte0);
                                break;
                            }
                            this.screen52.setChar(this.codePage.ebcdic2uni(byte0));
                            break;
                        }
                        if (byte0 == 0) {
                            this.screen52.setChar(byte0);
                            break;
                        }
                        this.screen52.setChar(this.codePage.ebcdic2uni(byte0));
                    }
                }
                if (!error) continue;
                done = true;
            }
        }
        catch (Exception e) {
            this.log.warn("write to display " + e.getMessage(), e);
        }
        this.processCC1(control1);
        return error;
    }

    private boolean processSOH() throws Exception {
        byte l = this.bk.getNextByte();
        this.log.debug(" byte 0 " + l);
        if (l > 0 && l <= 7) {
            this.bk.getNextByte();
            this.bk.getNextByte();
            this.bk.getNextByte();
            this.screen52.clearTable();
            if (l <= 3) {
                return false;
            }
            this.screen52.setErrorLine(this.bk.getNextByte());
            byte byte1 = 0;
            if (l >= 5) {
                byte1 = this.bk.getNextByte();
                this.dataIncluded[23] = (byte1 & 0x80) == 128;
                this.dataIncluded[22] = (byte1 & 0x40) == 64;
                this.dataIncluded[21] = (byte1 & 0x20) == 32;
                this.dataIncluded[20] = (byte1 & 0x10) == 16;
                this.dataIncluded[19] = (byte1 & 8) == 8;
                this.dataIncluded[18] = (byte1 & 4) == 4;
                this.dataIncluded[17] = (byte1 & 2) == 2;
                boolean bl = this.dataIncluded[16] = (byte1 & 1) == 1;
            }
            if (l >= 6) {
                byte1 = this.bk.getNextByte();
                this.dataIncluded[15] = (byte1 & 0x80) == 128;
                this.dataIncluded[14] = (byte1 & 0x40) == 64;
                this.dataIncluded[13] = (byte1 & 0x20) == 32;
                this.dataIncluded[12] = (byte1 & 0x10) == 16;
                this.dataIncluded[11] = (byte1 & 8) == 8;
                this.dataIncluded[10] = (byte1 & 4) == 4;
                this.dataIncluded[9] = (byte1 & 2) == 2;
                boolean bl = this.dataIncluded[8] = (byte1 & 1) == 1;
            }
            if (l >= 7) {
                byte1 = this.bk.getNextByte();
                this.dataIncluded[7] = (byte1 & 0x80) == 128;
                this.dataIncluded[6] = (byte1 & 0x40) == 64;
                this.dataIncluded[5] = (byte1 & 0x20) == 32;
                this.dataIncluded[4] = (byte1 & 0x10) == 16;
                this.dataIncluded[3] = (byte1 & 8) == 8;
                this.dataIncluded[2] = (byte1 & 4) == 4;
                this.dataIncluded[1] = (byte1 & 2) == 2;
                this.dataIncluded[0] = (byte1 & 1) == 1;
            }
            return false;
        }
        this.sendNegResponse(16, 5, 1, 43, "invalid SOH length");
        return true;
    }

    private void processCC0(byte byte0) {
        this.log.debug(" Control byte0 " + Integer.toBinaryString(byte0 & 0xFF));
        boolean lockKeyboard = true;
        boolean resetMDT = false;
        boolean resetMDTAll = false;
        boolean nullMDT = false;
        boolean nullAll = false;
        if ((byte0 & 0xE0) == 0) {
            lockKeyboard = false;
        }
        switch (byte0 & 0xE0) {
            case 64: {
                resetMDT = true;
                break;
            }
            case 96: {
                resetMDTAll = true;
                break;
            }
            case 128: {
                nullMDT = true;
                break;
            }
            case 160: {
                resetMDT = true;
                nullAll = true;
                break;
            }
            case 192: {
                resetMDT = true;
                nullMDT = true;
                break;
            }
            case 224: {
                resetMDTAll = true;
                nullAll = true;
            }
        }
        if (lockKeyboard) {
            this.screen52.getOIA().setKeyBoardLocked(true);
            this.pendingUnlock = false;
        } else {
            this.pendingUnlock = false;
        }
        if (resetMDT || resetMDTAll || nullMDT || nullAll) {
            int f = this.screen52.getScreenFields().getSize();
            for (int x = 0; x < f; ++x) {
                ScreenField sf = this.screen52.getScreenFields().getField(x);
                if (!sf.isBypassField() && (nullMDT && sf.mdt || nullAll)) {
                    sf.setFieldChar('\u0000');
                    this.screen52.drawField(sf);
                }
                if (!resetMDTAll && (!resetMDT || sf.isBypassField())) continue;
                sf.resetMDT();
            }
        }
    }

    private void processCC1(byte byte1) {
        this.log.debug(" Control byte1 " + Integer.toBinaryString(byte1 & 0xFF));
        if ((byte1 & 4) == 4) {
            this.controller.signalBell();
        }
        if ((byte1 & 2) == 2) {
            this.screen52.getOIA().setMessageLightOff();
        }
        if ((byte1 & 1) == 1) {
            this.screen52.getOIA().setMessageLightOn();
        }
        if ((byte1 & 1) == 1 && (byte1 & 2) == 2) {
            this.screen52.getOIA().setMessageLightOn();
        }
        if ((byte1 & 0x20) == 32 && (byte1 & 8) == 0) {
            this.screen52.setPendingInsert(false);
            this.log.debug(" WTD position no move");
        } else {
            this.screen52.setPendingInsert(true);
            this.log.debug(" WTD position move to home" + this.screen52.homePos + " row " + this.screen52.getRow(this.screen52.homePos) + " col " + this.screen52.getCol(this.screen52.homePos));
        }
        if ((byte1 & 0x20) == 32 && this.enhanced) {
            this.cursorOn = true;
        }
        if (!this.screen52.isStatusErrorCode() && (byte1 & 8) == 8) {
            this.cursorOn = true;
        }
        if ((byte1 & 0x20) == 32 && (byte1 & 8) == 0) {
            this.screen52.setPendingInsert(false, 1, 1);
        }
    }

    private boolean isAttribute(int byte0) {
        int byte1 = byte0 & 0xFF;
        return (byte1 & 0xE0) == 32;
    }

    private boolean isDataEBCDIC(int byte0) {
        int byte1 = byte0 & 0xFF;
        return byte1 >= 64 && byte1 < 255;
    }

    private boolean isDataUnicode(int data) {
        return (data < 0 || data >= 32) && data != 65535;
    }

    private void writeStructuredField() {
        boolean done = false;
        try {
            int length = (this.bk.getNextByte() & 0xFF) << 8 | this.bk.getNextByte() & 0xFF;
            block8: while (this.bk.hasNext() && !done) {
                switch (this.bk.getNextByte()) {
                    case -39: {
                        switch (this.bk.getNextByte()) {
                            case 112: {
                                this.bk.getNextByte();
                                this.sendQueryResponse();
                                continue block8;
                            }
                        }
                        this.log.debug("invalid structured field sub command " + this.bk.getByteOffset(-1));
                        continue block8;
                    }
                }
                this.log.debug("invalid structured field command " + this.bk.getByteOffset(-1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void writeErrorCode() throws Exception {
        this.screen52.setCursor(this.screen52.getErrorLine(), 1);
        this.screen52.setStatus((byte)2, (byte)1, null);
        this.screen52.saveErrorLine();
        this.cursorOn = true;
    }

    private final void writeErrorCodeToWindow() throws Exception {
        int fromCol = this.bk.getNextByte() & 0xFF;
        int toCol = this.bk.getNextByte() & 0xFF;
        this.screen52.setCursor(this.screen52.getErrorLine(), fromCol);
        this.screen52.setStatus((byte)2, (byte)1, null);
        this.screen52.saveErrorLine();
        this.cursorOn = true;
    }

    private final void sendQueryResponse() throws IOException {
        this.log.info("sending query response");
        byte[] abyte0 = new byte[64];
        abyte0[0] = 0;
        abyte0[1] = 0;
        abyte0[2] = -120;
        if (this.enhanced) {
            abyte0[3] = 0;
            abyte0[4] = 64;
        } else {
            abyte0[3] = 0;
            abyte0[4] = 58;
        }
        abyte0[5] = -39;
        abyte0[6] = 112;
        abyte0[7] = -128;
        abyte0[8] = 6;
        abyte0[9] = 0;
        abyte0[10] = 1;
        abyte0[11] = 1;
        abyte0[12] = 0;
        abyte0[13] = 0;
        abyte0[14] = 0;
        abyte0[15] = 0;
        abyte0[16] = 0;
        abyte0[17] = 0;
        abyte0[18] = 0;
        abyte0[19] = 0;
        abyte0[20] = 0;
        abyte0[21] = 0;
        abyte0[22] = 0;
        abyte0[23] = 0;
        abyte0[24] = 0;
        abyte0[25] = 0;
        abyte0[26] = 0;
        abyte0[27] = 0;
        abyte0[28] = 0;
        abyte0[29] = 1;
        abyte0[30] = this.codePage.uni2ebcdic('5');
        abyte0[31] = this.codePage.uni2ebcdic('2');
        abyte0[32] = this.codePage.uni2ebcdic('5');
        abyte0[33] = this.codePage.uni2ebcdic('1');
        abyte0[34] = this.codePage.uni2ebcdic('0');
        abyte0[35] = this.codePage.uni2ebcdic('1');
        abyte0[36] = this.codePage.uni2ebcdic('1');
        abyte0[37] = 2;
        abyte0[38] = 0;
        abyte0[39] = 0;
        abyte0[40] = 0;
        abyte0[41] = 36;
        abyte0[42] = 36;
        abyte0[43] = 0;
        abyte0[44] = 1;
        abyte0[45] = 0;
        abyte0[46] = 0;
        abyte0[47] = 0;
        abyte0[48] = 0;
        abyte0[49] = 1;
        abyte0[50] = 17;
        abyte0[51] = 0;
        abyte0[52] = 0;
        if (this.enhanced) {
            abyte0[53] = 7;
            this.log.info("enhanced options");
        } else {
            abyte0[53] = 0;
        }
        abyte0[54] = 24;
        abyte0[54] = 8;
        abyte0[55] = 0;
        abyte0[56] = 0;
        abyte0[57] = 0;
        abyte0[58] = 0;
        abyte0[59] = 0;
        abyte0[60] = 0;
        abyte0[61] = 0;
        abyte0[62] = 0;
        abyte0[63] = 0;
        this.writeGDS(0, 0, abyte0);
        abyte0 = null;
    }

    protected final boolean negotiate(byte[] abyte0) throws IOException {
        int i = 0;
        if (abyte0[i] == -1) {
            block16: while (i < abyte0.length && abyte0[i++] == -1) {
                switch (abyte0[i++]) {
                    default: {
                        continue block16;
                    }
                    case -3: {
                        if (i < abyte0.length) {
                            switch (abyte0[i]) {
                                case 24: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(24);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 25: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(25);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 0: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(0);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 6: {
                                    this.log.debug("Timing Mark Received and notifying the server that we will not do it.");
                                    this.baosp.write(-1);
                                    this.baosp.write(-4);
                                    this.baosp.write(6);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 39: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(39);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                default: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-4);
                                    this.baosp.write(abyte0[i]);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                }
                            }
                        }
                        ++i;
                        continue block16;
                    }
                    case -5: {
                        switch (abyte0[i]) {
                            case 25: {
                                this.baosp.write(-1);
                                this.baosp.write(-3);
                                this.baosp.write(25);
                                this.writeByte(this.baosp.toByteArray());
                                this.baosp.reset();
                                break;
                            }
                            case 0: {
                                this.baosp.write(-1);
                                this.baosp.write(-3);
                                this.baosp.write(0);
                                this.writeByte(this.baosp.toByteArray());
                                this.baosp.reset();
                            }
                        }
                        ++i;
                        continue block16;
                    }
                    case -6: 
                }
                if (abyte0[i] == 39 && abyte0[i + 1] == 1) {
                    this.negNewEnvironment();
                    while (++i < abyte0.length && abyte0[i + 1] != -1) {
                    }
                }
                if (abyte0[i] == 24 && abyte0[i + 1] == 1) {
                    this.baosp.write(-1);
                    this.baosp.write(-6);
                    this.baosp.write(24);
                    this.baosp.write(0);
                    if (!this.support132) {
                        this.baosp.write("IBM-3179-2".getBytes());
                    } else {
                        this.baosp.write("IBM-3477-FC".getBytes());
                    }
                    this.baosp.write(-1);
                    this.baosp.write(-16);
                    this.writeByte(this.baosp.toByteArray());
                    this.baosp.reset();
                    ++i;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void negNewEnvironment() throws IOException {
        this.baosp.write(-1);
        this.baosp.write(-6);
        this.baosp.write(39);
        this.baosp.write(0);
        if (this.kbdTypesCodePage != null) {
            this.baosp.write(3);
            this.baosp.write("KBDTYPE".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.kbdTypesCodePage.kbdType.getBytes());
            this.baosp.write(3);
            this.baosp.write("CODEPAGE".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.kbdTypesCodePage.codepage.getBytes());
            this.baosp.write(3);
            this.baosp.write("CHARSET".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.kbdTypesCodePage.charset.getBytes());
        }
        if (this.devName != null) {
            this.baosp.write(3);
            this.baosp.write("DEVNAME".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.negDeviceName().getBytes());
        }
        if (this.user != null) {
            this.baosp.write(0);
            this.baosp.write("USER".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.user.getBytes());
            if (this.password != null) {
                this.baosp.write(3);
                this.baosp.write("IBMRSEED".getBytes());
                this.baosp.write(1);
                this.baosp.write(2);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(3);
                this.baosp.write("IBMSUBSPW".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.password.getBytes());
            }
            if (this.library != null) {
                this.baosp.write(3);
                this.baosp.write("IBMCURLIB".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.library.getBytes());
            }
            if (this.initialMenu != null) {
                this.baosp.write(3);
                this.baosp.write("IBMIMENU".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.initialMenu.getBytes());
            }
            if (this.program != null) {
                this.baosp.write(3);
                this.baosp.write("IBMPROGRAM".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.program.getBytes());
            }
        }
        this.baosp.write(-1);
        this.baosp.write(-16);
        this.writeByte(this.baosp.toByteArray());
        this.baosp.reset();
    }

    private String negDeviceName() {
        if (this.devSeq++ == -1) {
            this.devNameUsed = this.devName;
            return this.devName;
        }
        StringBuilder sb = new StringBuilder(this.devName + this.devSeq);
        int ei = 1;
        while (sb.length() > 10) {
            sb.setLength(0);
            sb.append(this.devName.substring(0, this.devName.length() - ei++));
            sb.append(this.devSeq);
        }
        this.devNameUsed = sb.toString();
        return this.devNameUsed;
    }

    public final void setCodePage(String cp) {
        this.codePage = CharMappings.getCodePage(cp);
        cp = cp.toLowerCase();
        for (KbdTypesCodePages kbdtyp : KbdTypesCodePages.values()) {
            if (!("cp" + kbdtyp.codepage).equals(cp) && !kbdtyp.ccsid.equals(cp)) continue;
            this.kbdTypesCodePage = kbdtyp;
            break;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Choosed keyboard mapping " + this.kbdTypesCodePage.toString() + " for code page " + cp);
        }
    }

    public final ICodePage getCodePage() {
        return this.codePage;
    }

    public void signalBell() {
        this.controller.signalBell();
    }
}

