/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.transport.SSL;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class X509CertificateTrustManager
implements X509TrustManager {
    KeyStore ks = null;
    TrustManager[] trustManagers;

    public X509CertificateTrustManager(TrustManager[] managers, KeyStore keyStore) {
        this.trustManagers = managers;
        this.ks = keyStore;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String type) throws CertificateException {
        throw new SecurityException("checkClientTrusted unsupported");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String type) throws CertificateException {
        try {
            for (int i = 0; i < this.trustManagers.length; ++i) {
                if (!(this.trustManagers[i] instanceof X509TrustManager)) continue;
                ((X509TrustManager)this.trustManagers[i]).checkServerTrusted(chain, type);
            }
            return;
        }
        catch (CertificateException ce) {
            X509Certificate cert = chain[0];
            String certInfo = "Version: " + cert.getVersion() + "\n";
            certInfo = certInfo.concat("Serial Number: " + cert.getSerialNumber() + "\n");
            certInfo = certInfo.concat("Signature Algorithm: " + cert.getSigAlgName() + "\n");
            certInfo = certInfo.concat("Issuer: " + cert.getIssuerDN().getName() + "\n");
            certInfo = certInfo.concat("Valid From: " + cert.getNotBefore() + "\n");
            certInfo = certInfo.concat("Valid To: " + cert.getNotAfter() + "\n");
            certInfo = certInfo.concat("Subject DN: " + cert.getSubjectDN().getName() + "\n");
            certInfo = certInfo.concat("Public Key: " + cert.getPublicKey().getFormat() + "\n");
            int accept = JOptionPane.showConfirmDialog(null, certInfo, "Accept Certificate", 0);
            if (accept != 0) {
                throw new CertificateException("Certificate Not Accepted");
            }
            return;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(10);
        for (int i = 0; i < this.trustManagers.length; ++i) {
            if (!(this.trustManagers[i] instanceof X509TrustManager)) continue;
            list.addAll(Arrays.asList(((X509TrustManager)this.trustManagers[i]).getAcceptedIssuers()));
        }
        X509Certificate[] acceptedIssuers = new X509Certificate[list.size()];
        acceptedIssuers = list.toArray(acceptedIssuers);
        return acceptedIssuers;
    }
}

