/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.transport;

import java.net.Socket;
import org.tn5250j.framework.transport.SSLInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SocketConnector {
    String sslType = null;
    TN5250jLogger logger = TN5250jLogFactory.getLogger(this.getClass());

    public void setSSLType(String type) {
        this.sslType = type;
    }

    public Socket createSocket(String destination, int port) {
        Socket socket = null;
        Exception ex = null;
        if (this.sslType == null || this.sslType.trim().length() == 0 || this.sslType.toUpperCase().equals("NONE")) {
            this.logger.info("Creating Plain Socket");
            try {
                socket = new Socket(destination, port);
            }
            catch (Exception e) {
                ex = e;
            }
        } else {
            this.logger.info("Creating SSL [" + this.sslType + "] Socket");
            SSLInterface sslIf = null;
            String sslImplClassName = "org.tn5250j.framework.transport.SSL.SSLImplementation";
            try {
                Class<?> c = Class.forName(sslImplClassName);
                sslIf = (SSLInterface)c.newInstance();
            }
            catch (Exception e) {
                ex = new Exception("Failed to create SSLInterface Instance. Message is [" + e.getMessage() + "]");
            }
            if (sslIf != null) {
                sslIf.init(this.sslType);
                socket = sslIf.createSSLSocket(destination, port);
            }
        }
        if (ex != null) {
            this.logger.error(ex);
        }
        if (socket == null) {
            this.logger.warn("No socket was created");
        }
        return socket;
    }
}

