/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.Image;
import java.util.List;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

class AppleApplicationTools {
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    AppleApplicationTools() {
    }

    boolean tryToSetDockIconImages(List<Image> images) {
        return this.tryToSetDockIconImage(images.get(images.size() - 1));
    }

    private boolean tryToSetDockIconImage(Image image) {
        if (this.isAppleEnvironment()) {
            try {
                Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
                Object application = applicationClass.getMethod("getApplication", new Class[0]).invoke(applicationClass, new Object[0]);
                applicationClass.getMethod("setDockIconImage", Image.class).invoke(application, image);
                return true;
            }
            catch (Exception e) {
                this.log.debug("Skipping to set application dock icon for Mac OS X, because didn't found 'com.apple.eawt.Application' class.", e);
            }
        }
        return false;
    }

    private boolean isAppleEnvironment() {
        try {
            Class.forName("com.apple.eawt.Application");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

