/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionListener;
import org.tn5250j.event.TabClosedListener;
import org.tn5250j.tools.LangTool;

public final class ButtonTabComponent
extends JPanel
implements SessionListener {
    private static final long serialVersionUID = 1L;
    private final JTabbedPane pane;
    private List<TabClosedListener> closeListeners;
    private final JLabel label;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(JTabbedPane pane) {
        super(new BorderLayout(0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        this.label = new TabLabel();
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.add((Component)this.label, "Center");
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        button.setHorizontalAlignment(11);
        this.add((Component)button, "East");
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("indexForTitle".equals(evt.getPropertyName())) {
                    ButtonTabComponent.this.label.revalidate();
                    ButtonTabComponent.this.label.repaint();
                }
            }
        });
    }

    @Override
    public void onSessionChanged(SessionChangeEvent changeEvent) {
        if (changeEvent.getState() == 1) {
            this.label.setEnabled(true);
            this.label.setToolTipText(LangTool.getString("ss.state.connected"));
            this.setToolTipText(LangTool.getString("ss.state.connected"));
        } else {
            this.label.setEnabled(false);
            this.label.setToolTipText(LangTool.getString("ss.state.disconnected"));
            this.setToolTipText(LangTool.getString("ss.state.disconnected"));
        }
    }

    public synchronized void addTabCloseListener(TabClosedListener listener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<TabClosedListener>(3);
        }
        this.closeListeners.add(listener);
    }

    public synchronized void removeTabCloseListener(TabClosedListener listener) {
        if (this.closeListeners == null) {
            return;
        }
        this.closeListeners.remove(listener);
    }

    protected void fireTabClosed(int tabToClose) {
        if (this.closeListeners != null) {
            int size = this.closeListeners.size();
            for (int i = 0; i < size; ++i) {
                TabClosedListener target = this.closeListeners.get(i);
                target.onTabClosed(tabToClose);
            }
        }
    }

    private final class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText(LangTool.getString("popup.close"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                ButtonTabComponent.this.fireTabClosed(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }

    private final class TabLabel
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        public TabLabel() {
            this.addMouseListener(this);
        }

        @Override
        public String getText() {
            int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                return ButtonTabComponent.this.pane.getTitleAt(i);
            }
            return null;
        }

        @Override
        public Icon getIcon() {
            int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                return ButtonTabComponent.this.pane.getIconAt(i);
            }
            return null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.actionSelectTab();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.actionSelectTab();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void actionSelectTab() {
            int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                ButtonTabComponent.this.pane.setSelectedIndex(i);
            }
        }
    }
}

