/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.tools.LangTool;

public class HexCharMapDialog {
    private final DefaultListModel hexListModel;
    private final JList hexList;
    private final Component parent;

    public HexCharMapDialog(Component parent, ICodePage codepage) {
        assert (codepage != null) : new IllegalArgumentException("A codepage is needed!");
        this.parent = parent;
        Collator collator = Collator.getInstance();
        CollationKey key = null;
        TreeSet<CollationKey> set = new TreeSet<CollationKey>();
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < 256; ++x) {
            char ac = codepage.ebcdic2uni(x);
            if (Character.isISOControl(ac)) continue;
            sb.setLength(0);
            if (Integer.toHexString(ac).length() == 1) {
                sb.append("0x0" + Integer.toHexString(ac).toUpperCase());
            } else {
                sb.append("0x" + Integer.toHexString(ac).toUpperCase());
            }
            sb.append(" - " + ac);
            key = collator.getCollationKey(sb.toString());
            set.add(key);
        }
        Iterator iterator = set.iterator();
        this.hexListModel = new DefaultListModel();
        while (iterator.hasNext()) {
            CollationKey keyc = (CollationKey)iterator.next();
            this.hexListModel.addElement(keyc.getSourceString());
        }
        this.hexList = new JList(this.hexListModel);
        this.hexList.setSelectionMode(0);
        this.hexList.setSelectedIndex(0);
    }

    public String showModal() {
        JScrollPane listScrollPane = new JScrollPane(this.hexList);
        listScrollPane.setVerticalScrollBarPolicy(22);
        listScrollPane.setSize(40, 100);
        JPanel srp = new JPanel();
        srp.setLayout(new BorderLayout());
        srp.add((Component)listScrollPane, "Center");
        Object[] options = new String[]{LangTool.getString("hm.optInsert"), LangTool.getString("hm.optCancel")};
        int result = JOptionPane.showOptionDialog(this.parent, new Object[]{srp}, LangTool.getString("hm.title"), -1, 1, null, options, options[0]);
        if (result == 0) {
            String selval = (String)this.hexList.getSelectedValue();
            return selval.substring(selval.length() - 1);
        }
        return null;
    }
}

