/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.tn5250j.gui.SortHeaderRenderer;
import org.tn5250j.gui.SortTableModel;

public class JSortTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private int sortedColumnIndex = -1;
    private boolean sortedColumnAscending = true;

    public JSortTable(SortTableModel model) {
        super(model);
        this.initSortHeader();
    }

    private void initSortHeader() {
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortHeaderRenderer());
        header.addMouseListener(this);
    }

    int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        TableColumnModel colModel = this.getColumnModel();
        int index = colModel.getColumnIndexAtX(event.getX());
        int modelIndex = colModel.getColumn(index).getModelIndex();
        SortTableModel model = (SortTableModel)this.getModel();
        if (model.isSortable(modelIndex)) {
            if (this.sortedColumnIndex == index) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = index;
            model.sortColumn(modelIndex, this.sortedColumnAscending);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

