/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.keyboard.KeyboardHandler;
import org.tn5250j.keyboard.actions.AttributesAction;
import org.tn5250j.keyboard.actions.CloseAction;
import org.tn5250j.keyboard.actions.CopyAction;
import org.tn5250j.keyboard.actions.DebugAction;
import org.tn5250j.keyboard.actions.DispMsgsAction;
import org.tn5250j.keyboard.actions.EmailAction;
import org.tn5250j.keyboard.actions.GuiAction;
import org.tn5250j.keyboard.actions.HotspotsAction;
import org.tn5250j.keyboard.actions.JumpNextAction;
import org.tn5250j.keyboard.actions.JumpPrevAction;
import org.tn5250j.keyboard.actions.NewSessionAction;
import org.tn5250j.keyboard.actions.OpenSameAction;
import org.tn5250j.keyboard.actions.PasteAction;
import org.tn5250j.keyboard.actions.PrintAction;
import org.tn5250j.keyboard.actions.QuickEmailAction;
import org.tn5250j.keyboard.actions.RulerAction;
import org.tn5250j.keyboard.actions.RunScriptAction;
import org.tn5250j.keyboard.actions.SpoolWorkAction;
import org.tn5250j.keyboard.actions.ToggleConnectionAction;
import org.tn5250j.keyboard.actions.TransferAction;

class DefaultKeyboardHandler
extends KeyboardHandler {
    DefaultKeyboardHandler(Session5250 session) {
        super(session);
    }

    @Override
    public boolean isKeyStrokeDefined(String accelKey) {
        return KeyMapper.isKeyStrokeDefined(accelKey);
    }

    @Override
    public KeyStroke getKeyStroke(String accelKey) {
        return KeyMapper.getKeyStroke(accelKey);
    }

    protected void displayInfo(KeyEvent e, String s) {
        char c = e.getKeyChar();
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiers();
        String charString = Character.isISOControl(c) ? "key character = (an unprintable control character)" : "key character = '" + c + "'";
        String keyCodeString = "key code = " + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ")";
        if (keyCode == 257) {
            keyCodeString = keyCodeString + " previous candidate ";
        }
        if (keyCode == 134 || keyCode == 136 || keyCode == 129 || keyCode == 133 || keyCode == 130) {
            keyCodeString = keyCodeString + " dead key ";
        }
        String modString = "modifiers = " + modifiers;
        String tmpString = KeyEvent.getKeyModifiersText(modifiers);
        modString = tmpString.length() > 0 ? modString + " (" + tmpString + ")" : modString + " (no modifiers)";
        String isString = "isKeys = isActionKey (" + e.isActionKey() + ") isAltDown (" + e.isAltDown() + ") isAltGraphDown (" + e.isAltGraphDown() + ") isAltGraphDownLinux (" + this.isAltGr + ") isControlDown (" + e.isControlDown() + ") isMetaDown (" + e.isMetaDown() + ") isShiftDown (" + e.isShiftDown() + ")";
        String newline = "\n";
        System.out.println(s + newline + "    " + charString + newline + "    " + keyCodeString + newline + "    " + modString + newline + "    " + isString + newline);
    }

    @Override
    void initKeyBindings() {
        if (this.session.getGUI() == null) {
            return;
        }
        SessionPanel sessionGui = this.session.getGUI();
        new NewSessionAction(sessionGui, this.keyMap);
        new ToggleConnectionAction(sessionGui, this.keyMap);
        new JumpNextAction(sessionGui, this.keyMap);
        new JumpPrevAction(sessionGui, this.keyMap);
        new HotspotsAction(sessionGui, this.keyMap);
        new GuiAction(sessionGui, this.keyMap);
        new DispMsgsAction(sessionGui, this.keyMap);
        new AttributesAction(sessionGui, this.keyMap);
        new PrintAction(sessionGui, this.keyMap);
        new RulerAction(sessionGui, this.keyMap);
        new CloseAction(sessionGui, this.keyMap);
        new TransferAction(sessionGui, this.keyMap);
        new EmailAction(sessionGui, this.keyMap);
        new RunScriptAction(sessionGui, this.keyMap);
        new DebugAction(sessionGui, this.keyMap);
        new CopyAction(sessionGui, this.keyMap);
        new PasteAction(sessionGui, this.keyMap);
        new SpoolWorkAction(sessionGui, this.keyMap);
        new QuickEmailAction(sessionGui, this.keyMap);
        new OpenSameAction(sessionGui, this.keyMap);
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        switch (evt.getID()) {
            case 400: {
                this.processVTKeyTyped(evt);
                break;
            }
            case 401: {
                this.processVTKeyPressed(evt);
                break;
            }
            case 402: {
                this.processVTKeyReleased(evt);
            }
        }
    }

    private void processVTKeyPressed(KeyEvent e) {
        this.keyProcessed = true;
        int keyCode = e.getKeyCode();
        if (this.isLinux && keyCode == 65406) {
            this.isAltGr = true;
        }
        if (keyCode == 20 || keyCode == 16 || keyCode == 18 || keyCode == 65406) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), false);
        if (this.emulatorAction(ks, e)) {
            return;
        }
        this.lastKeyStroke = this.isLinux ? KeyMapper.getKeyStrokeText(e, this.isAltGr) : KeyMapper.getKeyStrokeText(e);
        if (this.lastKeyStroke != null && !this.lastKeyStroke.equals("null")) {
            if (this.lastKeyStroke.startsWith("[") || this.lastKeyStroke.length() == 1) {
                this.screen.sendKeys(this.lastKeyStroke);
                if (this.recording) {
                    this.recordBuffer.append(this.lastKeyStroke);
                }
            } else {
                this.session.getGUI().executeMacro(this.lastKeyStroke);
            }
            if (this.lastKeyStroke.startsWith("[mark") && (this.lastKeyStroke.equals("[markleft]") || this.lastKeyStroke.equals("[markright]") || this.lastKeyStroke.equals("[markup]") || this.lastKeyStroke.equals("[markdown]"))) {
                this.session.getGUI().doKeyBoundArea(e, this.lastKeyStroke);
            }
        } else {
            this.keyProcessed = false;
        }
        if (this.keyProcessed) {
            e.consume();
        }
    }

    private void processVTKeyTyped(KeyEvent e) {
        char kc = e.getKeyChar();
        if (this.isLinux ? (!Character.isLetter(kc) && kc != '\u20ac' || e.getModifiers() != 0 && e.getModifiers() != 1) && (Character.isISOControl(kc) || this.keyProcessed) : Character.isISOControl(kc) || this.keyProcessed) {
            return;
        }
        if (!this.session.isConnected()) {
            return;
        }
        this.screen.sendKeys(Character.toString(kc));
        if (this.recording) {
            this.recordBuffer.append(kc);
        }
        this.keyProcessed = true;
        e.consume();
    }

    private void processVTKeyReleased(KeyEvent e) {
        if (this.isLinux && e.getKeyCode() == 65406) {
            this.isAltGr = false;
        }
        if (Character.isISOControl(e.getKeyChar()) || this.keyProcessed || e.isConsumed()) {
            return;
        }
        String s = KeyMapper.getKeyStrokeText(e);
        if (s != null) {
            if (s.startsWith("[")) {
                this.screen.sendKeys(s);
                if (this.recording) {
                    this.recordBuffer.append(s);
                }
            } else {
                this.session.getGUI().executeMacro(s);
            }
        } else {
            this.keyProcessed = false;
        }
        if (this.keyProcessed) {
            e.consume();
        }
    }
}

