/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.KeyStroke;
import org.tn5250j.event.KeyChangeListener;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyStroker;
import org.tn5250j.tools.LangTool;

public class KeyMapper {
    private static HashMap<KeyStroker, String> mappedKeys;
    private static KeyStroker workStroke;
    private static String lastKeyMnemonic;
    private static Vector<KeyChangeListener> listeners;

    public static void init() {
        if (mappedKeys != null) {
            return;
        }
        mappedKeys = new HashMap(60);
        workStroke = new KeyStroker(0, false, false, false, false, 1);
        Properties keys = ConfigureFactory.getInstance().getProperties("keymap");
        if (!KeyMapper.containsProperties(keys)) {
            mappedKeys.put(new KeyStroker(10, false, false, false, false, 1), "[enter]");
            mappedKeys.put(new KeyStroker(10, false, false, false, false, 4), "[enter].alt2");
            mappedKeys.put(new KeyStroker(8, false, false, false, false, 1), "[backspace]");
            mappedKeys.put(new KeyStroker(9, false, false, false, false, 1), "[tab]");
            mappedKeys.put(new KeyStroker(9, true, false, false, false, 1), "[backtab]");
            mappedKeys.put(new KeyStroker(127, false, false, false, false, 1), "[delete]");
            mappedKeys.put(new KeyStroker(155, false, false, false, false, 1), "[insert]");
            mappedKeys.put(new KeyStroker(19, false, false, false, false, 1), "[clear]");
            mappedKeys.put(new KeyStroker(17, false, true, false, false, 2), "[reset]");
            mappedKeys.put(new KeyStroker(27, false, false, false, false, 1), "[sysreq]");
            mappedKeys.put(new KeyStroker(35, false, false, false, false, 1), "[eof]");
            mappedKeys.put(new KeyStroker(36, false, false, false, false, 1), "[home]");
            mappedKeys.put(new KeyStroker(39, false, false, false, false, 1), "[right]");
            mappedKeys.put(new KeyStroker(39, false, false, true, false, 1), "[nextword]");
            mappedKeys.put(new KeyStroker(37, false, false, false, false, 1), "[left]");
            mappedKeys.put(new KeyStroker(37, false, false, true, false, 1), "[prevword]");
            mappedKeys.put(new KeyStroker(38, false, false, false, false, 1), "[up]");
            mappedKeys.put(new KeyStroker(40, false, false, false, false, 1), "[down]");
            mappedKeys.put(new KeyStroker(34, false, false, false, false, 1), "[pgdown]");
            mappedKeys.put(new KeyStroker(33, false, false, false, false, 1), "[pgup]");
            mappedKeys.put(new KeyStroker(96, false, false, false, false, 1), "[keypad0]");
            mappedKeys.put(new KeyStroker(97, false, false, false, false, 1), "[keypad1]");
            mappedKeys.put(new KeyStroker(98, false, false, false, false, 1), "[keypad2]");
            mappedKeys.put(new KeyStroker(99, false, false, false, false, 1), "[keypad3]");
            mappedKeys.put(new KeyStroker(100, false, false, false, false, 1), "[keypad4]");
            mappedKeys.put(new KeyStroker(101, false, false, false, false, 1), "[keypad5]");
            mappedKeys.put(new KeyStroker(102, false, false, false, false, 1), "[keypad6]");
            mappedKeys.put(new KeyStroker(103, false, false, false, false, 1), "[keypad7]");
            mappedKeys.put(new KeyStroker(104, false, false, false, false, 1), "[keypad8]");
            mappedKeys.put(new KeyStroker(105, false, false, false, false, 1), "[keypad9]");
            mappedKeys.put(new KeyStroker(109, false, false, false, false, 1), "[field-]");
            mappedKeys.put(new KeyStroker(107, false, false, false, false, 1), "[field+]");
            mappedKeys.put(new KeyStroker(112, false, false, false, false, 1), "[pf1]");
            mappedKeys.put(new KeyStroker(113, false, false, false, false, 1), "[pf2]");
            mappedKeys.put(new KeyStroker(114, false, false, false, false, 1), "[pf3]");
            mappedKeys.put(new KeyStroker(115, false, false, false, false, 1), "[pf4]");
            mappedKeys.put(new KeyStroker(116, false, false, false, false, 1), "[pf5]");
            mappedKeys.put(new KeyStroker(117, false, false, false, false, 1), "[pf6]");
            mappedKeys.put(new KeyStroker(118, false, false, false, false, 1), "[pf7]");
            mappedKeys.put(new KeyStroker(119, false, false, false, false, 1), "[pf8]");
            mappedKeys.put(new KeyStroker(120, false, false, false, false, 1), "[pf9]");
            mappedKeys.put(new KeyStroker(121, false, false, false, false, 1), "[pf10]");
            mappedKeys.put(new KeyStroker(122, false, false, false, false, 1), "[pf11]");
            mappedKeys.put(new KeyStroker(123, false, false, false, false, 1), "[pf12]");
            mappedKeys.put(new KeyStroker(112, true, false, false, false, 1), "[pf13]");
            mappedKeys.put(new KeyStroker(113, true, false, false, false, 1), "[pf14]");
            mappedKeys.put(new KeyStroker(114, true, false, false, false, 1), "[pf15]");
            mappedKeys.put(new KeyStroker(115, true, false, false, false, 1), "[pf16]");
            mappedKeys.put(new KeyStroker(116, true, false, false, false, 1), "[pf17]");
            mappedKeys.put(new KeyStroker(117, true, false, false, false, 1), "[pf18]");
            mappedKeys.put(new KeyStroker(118, true, false, false, false, 1), "[pf19]");
            mappedKeys.put(new KeyStroker(119, true, false, false, false, 1), "[pf20]");
            mappedKeys.put(new KeyStroker(120, true, false, false, false, 1), "[pf21]");
            mappedKeys.put(new KeyStroker(121, true, false, false, false, 1), "[pf22]");
            mappedKeys.put(new KeyStroker(122, true, false, false, false, 1), "[pf23]");
            mappedKeys.put(new KeyStroker(123, true, false, false, false, 1), "[pf24]");
            mappedKeys.put(new KeyStroker(112, false, false, true, false, 1), "[help]");
            mappedKeys.put(new KeyStroker(72, false, false, true, false, 1), "[hostprint]");
            mappedKeys.put(new KeyStroker(67, false, true, false, false, 1), "[copy]");
            mappedKeys.put(new KeyStroker(86, false, false, true, false, 1), "[paste]");
            mappedKeys.put(new KeyStroker(39, true, false, false, false, 1), "[markright]");
            mappedKeys.put(new KeyStroker(37, true, false, false, false, 1), "[markleft]");
            mappedKeys.put(new KeyStroker(38, true, false, false, false, 1), "[markup]");
            mappedKeys.put(new KeyStroker(40, true, false, false, false, 1), "[markdown]");
            mappedKeys.put(new KeyStroker(155, true, false, false, false, 1), "[dupfield]");
            mappedKeys.put(new KeyStroker(17, true, true, false, false, 1), "[newline]");
            mappedKeys.put(new KeyStroker(34, false, false, true, false, 1), "[jumpnext]");
            mappedKeys.put(new KeyStroker(33, false, false, true, false, 1), "[jumpprev]");
            KeyMapper.saveKeyMap();
        } else {
            KeyMapper.setKeyMap(keys);
        }
    }

    private static boolean containsProperties(Properties keystrokes) {
        return keystrokes != null && keystrokes.size() > 0;
    }

    private static void parseKeyStrokes(Properties keystrokes) {
        String theStringList = "";
        String theKey = "";
        Enumeration<?> ke = keystrokes.propertyNames();
        while (ke.hasMoreElements()) {
            theKey = (String)ke.nextElement();
            if (OptionAccessFactory.getInstance().isRestrictedOption(theKey)) continue;
            theStringList = keystrokes.getProperty(theKey);
            int kc = 0;
            boolean is = false;
            boolean ic = false;
            boolean ia = false;
            boolean iag = false;
            int location = 1;
            StringTokenizer tokenizer = new StringTokenizer(theStringList, ",");
            kc = Integer.parseInt(tokenizer.nextToken());
            is = tokenizer.nextToken().equals("true");
            ic = tokenizer.nextToken().equals("true");
            ia = tokenizer.nextToken().equals("true");
            if (tokenizer.hasMoreTokens()) {
                iag = tokenizer.nextToken().equals("true");
                if (tokenizer.hasMoreTokens()) {
                    location = Integer.parseInt(tokenizer.nextToken());
                }
            }
            mappedKeys.put(new KeyStroker(kc, is, ic, ia, iag, location), theKey);
        }
    }

    protected static void setKeyMap(Properties keystrokes) {
        KeyMapper.parseKeyStrokes(keystrokes);
    }

    public static final boolean isEqualLast(KeyEvent ke) {
        return workStroke.equals(ke);
    }

    public static final void saveKeyMap() {
        Properties map = ConfigureFactory.getInstance().getProperties("keymap");
        map.clear();
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            map.put(i.next(), ks.toString());
        }
        ConfigureFactory.getInstance().saveSettings("keymap", "------ Key Map key=keycode,isShiftDown,isControlDown,isAltDown,isAltGrDown,location --------");
    }

    public static final String getKeyStrokeText(KeyEvent ke) {
        return KeyMapper.getKeyStrokeText(ke, false);
    }

    public static final String getKeyStrokeText(KeyEvent ke, boolean isAltGr) {
        if (!workStroke.equals(ke, isAltGr)) {
            workStroke.setAttributes(ke, isAltGr);
            lastKeyMnemonic = mappedKeys.get(workStroke);
        }
        if (lastKeyMnemonic != null && lastKeyMnemonic.endsWith(".alt2")) {
            lastKeyMnemonic = lastKeyMnemonic.substring(0, lastKeyMnemonic.indexOf(".alt2"));
        }
        return lastKeyMnemonic;
    }

    public static final String getKeyStrokeMnemonic(KeyEvent ke) {
        return KeyMapper.getKeyStrokeMnemonic(ke, false);
    }

    public static final String getKeyStrokeMnemonic(KeyEvent ke, boolean isAltGr) {
        workStroke.setAttributes(ke, isAltGr);
        String keyMnemonic = mappedKeys.get(workStroke);
        if (keyMnemonic != null && keyMnemonic.endsWith(".alt2")) {
            keyMnemonic = keyMnemonic.substring(0, keyMnemonic.indexOf(".alt2"));
        }
        return keyMnemonic;
    }

    public static final int getKeyStrokeCode() {
        return workStroke.hashCode();
    }

    public static final String getKeyStrokeDesc(String which) {
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            return ks.getKeyStrokeDesc();
        }
        return LangTool.getString("key.dead");
    }

    public static final KeyStroker getKeyStroker(String which) {
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            return ks;
        }
        return null;
    }

    public static final boolean isKeyStrokeDefined(String which) {
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isKeyStrokeDefined(KeyEvent ke) {
        return KeyMapper.isKeyStrokeDefined(ke, false);
    }

    public static final boolean isKeyStrokeDefined(KeyEvent ke, boolean isAltGr) {
        workStroke.setAttributes(ke, isAltGr);
        return null != mappedKeys.get(workStroke);
    }

    public static final KeyStroke getKeyStroke(String which) {
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            int mask = 0;
            if (ks.isShiftDown()) {
                mask |= 1;
            }
            if (ks.isControlDown()) {
                mask |= 2;
            }
            if (ks.isAltDown()) {
                mask |= 8;
            }
            if (ks.isAltGrDown()) {
                mask |= 0x20;
            }
            return KeyStroke.getKeyStroke(ks.getKeyCode(), mask);
        }
        return KeyStroke.getKeyStroke(0, 0);
    }

    public static final void removeKeyStroke(String which) {
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            mappedKeys.remove(ks);
            return;
        }
    }

    public static final void setKeyStroke(String which, KeyEvent ke) {
        if (ke == null) {
            return;
        }
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            mappedKeys.remove(ks);
            mappedKeys.put(new KeyStroker(ke), keyVal);
            return;
        }
        mappedKeys.put(new KeyStroker(ke), which);
    }

    public static final void setKeyStroke(String which, KeyEvent ke, boolean isAltGr) {
        if (ke == null) {
            return;
        }
        Collection<String> v = mappedKeys.values();
        Set<KeyStroker> o = mappedKeys.keySet();
        Iterator<KeyStroker> k = o.iterator();
        Iterator<String> i = v.iterator();
        while (k.hasNext()) {
            KeyStroker ks = k.next();
            String keyVal = i.next();
            if (!keyVal.equals(which)) continue;
            mappedKeys.remove(ks);
            mappedKeys.put(new KeyStroker(ke, isAltGr), keyVal);
            return;
        }
        mappedKeys.put(new KeyStroker(ke, isAltGr), which);
    }

    public static final HashMap<KeyStroker, String> getKeyMap() {
        return mappedKeys;
    }

    public static synchronized void addKeyChangeListener(KeyChangeListener listener) {
        if (listeners == null) {
            listeners = new Vector(3);
        }
        listeners.addElement(listener);
    }

    public synchronized void removeKeyChangeListener(KeyChangeListener listener) {
        if (listeners == null) {
            return;
        }
        listeners.removeElement(listener);
    }

    public static void fireKeyChangeEvent() {
        if (listeners != null) {
            int size = listeners.size();
            for (int i = 0; i < size; ++i) {
                KeyChangeListener target = listeners.elementAt(i);
                target.onKeyChanged();
            }
        }
    }
}

