/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.util.Arrays;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.tools.LangTool;

public class KeyMnemonicResolver {
    public int findMnemonicValue(String mnemonicStr) {
        for (KeyMnemonic mnemonic : KeyMnemonic.values()) {
            if (!mnemonic.mnemonic.equals(mnemonicStr)) continue;
            return mnemonic.value;
        }
        return 0;
    }

    public KeyMnemonic findMnemonic(String mnemonicStr) {
        for (KeyMnemonic mnemonic : KeyMnemonic.values()) {
            if (!mnemonic.mnemonic.equals(mnemonicStr)) continue;
            return mnemonic;
        }
        return null;
    }

    public String[] getMnemonics() {
        String[] result = new String[KeyMnemonic.values().length];
        int i = 0;
        for (KeyMnemonic keyMnemonic : KeyMnemonic.values()) {
            result[i++] = keyMnemonic.mnemonic;
        }
        return result;
    }

    public String[] getMnemonicsSorted() {
        Object[] mnemonics = this.getMnemonics();
        Arrays.sort(mnemonics);
        return mnemonics;
    }

    public String[] getMnemonicDescriptions() {
        KeyMnemonic[] mnemonicData = KeyMnemonic.values();
        String[] result = new String[KeyMnemonic.values().length];
        int i = 0;
        for (KeyMnemonic mnemonic : mnemonicData) {
            result[i++] = this.getDescription(mnemonic);
        }
        return result;
    }

    public String getDescription(KeyMnemonic mnemonic) {
        return LangTool.getString("key." + mnemonic.mnemonic);
    }
}

