/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.util.ArrayList;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.KeyMnemonicResolver;

public class KeyMnemonicSerializer {
    private final KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();

    public String serialize(KeyMnemonic[] keyMnemonics) {
        StringBuilder sb = new StringBuilder();
        if (keyMnemonics != null) {
            for (int i = 0; i < keyMnemonics.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(keyMnemonics[i].mnemonic);
            }
        }
        return sb.toString();
    }

    public KeyMnemonic[] deserialize(String keypadMnemonics) {
        if (keypadMnemonics == null) {
            return new KeyMnemonic[0];
        }
        String[] parts = keypadMnemonics.split(",");
        ArrayList<KeyMnemonic> result = new ArrayList<KeyMnemonic>();
        for (String part : parts) {
            KeyMnemonic mnemonic = this.keyMnemonicResolver.findMnemonic(part.trim());
            if (mnemonic == null) continue;
            result.add(mnemonic);
        }
        return result.toArray(new KeyMnemonic[result.size()]);
    }
}

