/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyEvent;

public class KeyStroker {
    protected int location;
    private int keyCode;
    private boolean isShiftDown;
    private boolean isControlDown;
    private boolean isAltDown;
    private boolean isAltGrDown;
    private int hashCode;
    public static final String altSuffix = ".alt2";
    public static final int KEY_LOCATION_UNKNOWN = 0;
    public static final int KEY_LOCATION_STANDARD = 1;
    public static final int KEY_LOCATION_LEFT = 2;
    public static final int KEY_LOCATION_RIGHT = 3;
    public static final int KEY_LOCATION_NUMPAD = 4;

    public KeyStroker(KeyEvent ke) {
        this.keyCode = ke.getKeyCode();
        this.isShiftDown = ke.isShiftDown();
        this.isControlDown = ke.isControlDown();
        this.isAltDown = ke.isAltDown();
        this.isAltGrDown = ke.isAltGraphDown();
        this.location = ke.getKeyLocation();
        this.hashCode = this.keyCode + (this.isShiftDown ? 1 : 0) + (this.isControlDown ? 1 : 0) + (this.isAltDown ? 1 : 0) + (this.isAltGrDown ? 1 : 0) + this.location;
    }

    public KeyStroker(KeyEvent ke, boolean isAltGrDown) {
        this.keyCode = ke.getKeyCode();
        this.isShiftDown = ke.isShiftDown();
        this.isControlDown = ke.isControlDown();
        this.isAltDown = ke.isAltDown();
        this.isAltGrDown = isAltGrDown;
        this.location = ke.getKeyLocation();
        this.hashCode = this.keyCode + (this.isShiftDown ? 1 : 0) + (this.isControlDown ? 1 : 0) + (this.isAltDown ? 1 : 0) + (isAltGrDown ? 1 : 0) + this.location;
    }

    public KeyStroker(int keyCode, boolean isShiftDown, boolean isControlDown, boolean isAltDown, boolean isAltGrDown, int location) {
        this.keyCode = keyCode;
        this.isShiftDown = isShiftDown;
        this.isControlDown = isControlDown;
        this.isAltDown = isAltDown;
        this.isAltGrDown = isAltGrDown;
        this.location = location;
        this.hashCode = keyCode + (isShiftDown ? 1 : 0) + (isControlDown ? 1 : 0) + (isAltDown ? 1 : 0) + (isAltGrDown ? 1 : 0) + location;
    }

    public void setAttributes(KeyEvent ke, boolean isAltGr) {
        this.keyCode = ke.getKeyCode();
        this.isShiftDown = ke.isShiftDown();
        this.isControlDown = ke.isControlDown();
        this.isAltDown = ke.isAltDown();
        this.isAltGrDown = isAltGr;
        this.location = ke.getKeyLocation();
        this.hashCode = this.keyCode + (this.isShiftDown ? 1 : 0) + (this.isControlDown ? 1 : 0) + (this.isAltDown ? 1 : 0) + (this.isAltGrDown ? 1 : 0) + this.location;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isShiftDown() {
        return this.isShiftDown;
    }

    public boolean isControlDown() {
        return this.isControlDown;
    }

    public boolean isAltDown() {
        return this.isAltDown;
    }

    public boolean isAltGrDown() {
        return this.isAltGrDown;
    }

    public int getLocation() {
        return this.location;
    }

    public boolean equals(KeyEvent ke) {
        return this.keyCode == ke.getKeyCode() && this.isShiftDown == ke.isShiftDown() && this.isControlDown == ke.isControlDown() && this.isAltDown == ke.isAltDown() && this.isAltGrDown == ke.isAltGraphDown() && this.location == ke.getKeyLocation();
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyStroker) {
            KeyStroker ks = (KeyStroker)obj;
            return ks.keyCode == this.keyCode && ks.isShiftDown == this.isShiftDown && ks.isControlDown == this.isControlDown && ks.isAltDown == this.isAltDown && ks.isAltGrDown == this.isAltGrDown && ks.location == this.location;
        }
        return false;
    }

    public boolean equals(KeyEvent ke, boolean altGrDown) {
        return this.keyCode == ke.getKeyCode() && this.isShiftDown == ke.isShiftDown() && this.isControlDown == ke.isControlDown() && this.isAltDown == ke.isAltDown() && this.isAltGrDown == altGrDown && this.location == ke.getKeyLocation();
    }

    public boolean equals(Object obj, boolean altGrDown) {
        KeyStroker ks = (KeyStroker)obj;
        return ks.keyCode == this.keyCode && ks.isShiftDown == this.isShiftDown && ks.isControlDown == this.isControlDown && ks.isAltDown == this.isAltDown && ks.isAltGrDown == altGrDown && ks.location == this.location;
    }

    public String toString() {
        return new String(this.keyCode + "," + (this.isShiftDown ? "true" : "false") + "," + (this.isControlDown ? "true" : "false") + "," + (this.isAltDown ? "true" : "false") + "," + (this.isAltGrDown ? "true" : "false") + "," + this.location);
    }

    public String getKeyStrokeDesc() {
        return (this.isShiftDown ? "Shift + " : "") + (this.isControlDown ? "Ctrl + " : "") + (this.isAltDown ? "Alt + " : "") + (this.isAltGrDown ? "Alt-Gr + " : "") + KeyEvent.getKeyText(this.keyCode);
    }

    public int getKeyCode() {
        return this.keyCode;
    }
}

